#ifndef RPMPYTHON_HEADER
#define RPMPYTHON_HEADER

/** \ingroup py_c
 * \file python/header-py.h
 */

/** \name Type: _rpm.hdr */
/*@{*/

/** \ingroup py_c
 */
typedef struct hdrObject_s hdrObject;

/** \ingroup py_c
 */
/*@unchecked@*/
extern PyTypeObject hdr_Type;

/** \ingroup py_c
 */
extern PyObject * pyrpmError;

__BEGIN_DECLS
/** \ingroup py_c
 */
hdrObject * hdr_Wrap(Header h)
	/*@*/;

/** \ingroup py_c
 */
Header hdrGetHeader(hdrObject * h)
	/*@*/;

/** \ingroup py_c
 */
long tagNumFromPyObject (PyObject *item)
	/*@*/;

/** \ingroup py_c
 */
PyObject * labelCompare (PyObject * self, PyObject * args)
	/*@*/;

/** \ingroup py_c
 */
PyObject * versionCompare (PyObject * self, PyObject * args, PyObject * kwds)
	/*@*/;

/** \ingroup py_c
 */
PyObject * rpmMergeHeadersFromFD(PyObject * self, PyObject * args, PyObject * kwds)
	/*@*/;

/** \ingroup py_c
 */
int rpmMergeHeaders(PyObject * list, FD_t fd, int matchTag)
	/*@*/;

/** \ingroup py_c
 */
PyObject * rpmHeaderFromFile(PyObject * self, PyObject * args, PyObject * kwds)
	/*@*/;

/** \ingroup py_c
 */
PyObject * rpmHeaderFromFD(PyObject * self, PyObject * args, PyObject * kwds)
	/*@*/;

/** \ingroup py_c
 */
PyObject * rpmSingleHeaderFromFD(PyObject * self, PyObject * args, PyObject * kwds)
	/*@*/;

/** \ingroup py_c
 */
PyObject * rpmReadHeaders (FD_t fd)
	/*@*/;

/** \ingroup py_c
 */
PyObject * rhnLoad(PyObject * self, PyObject * args, PyObject * kwds)
	/*@*/;

/** \ingroup py_c
 */
PyObject * hdrLoad(PyObject * self, PyObject * args, PyObject * kwds)
	/*@*/;

__END_DECLS
/*@}*/

#endif
