/* File automatically generate by ./rpmh2tbl
 * Olivier Thauvin <thauvin at aerov.jussieu.fr>
 * Parsed files:
 * ../lib/cpio.h
 * ../lib/fs.h
 * ../lib/fsm.h
 * ../lib/genpgp.h
 * ../lib/manifest.h
 * ../lib/misc.h
 * ../lib/psm.h
 * ../lib/rpm4compat.h
 * ../lib/rpmal.h
 * ../lib/rpmcli.h
 * ../lib/rpmdpkg.h
 * ../lib/rpmds.h
 * ../lib/rpmevr.h
 * ../lib/rpmfc.h
 * ../lib/rpmfi.h
 * ../lib/rpmgi.h
 * ../lib/rpmlib.h
 * ../lib/rpmlock.h
 * ../lib/rpmluaext.h
 * ../lib/rpmns.h
 * ../lib/rpmps.h
 * ../lib/rpmsx.h
 * ../lib/rpmte.h
 * ../lib/rpmts.h
 * ../lib/rpmversion.h
 * ../lib/tar.h
 * ../build/buildio.h
 * ../build/rpmbuild.h
 * ../build/rpmspec.h
 * ../rpmdb/db_emu.h
 * ../rpmdb/fprint.h
 * ../rpmdb/header_internal.h
 * ../rpmdb/legacy.h
 * ../rpmdb/pkgio.h
 * ../rpmdb/rpmdb.h
 * ../rpmdb/rpmtag.h
 * ../rpmdb/rpmwf.h
 * ../rpmdb/signature.h
 * ../rpmio/LzmaDecode.h
 * ../rpmio/argv.h
 * ../rpmio/envvar.h
 * ../rpmio/fts.h
 * ../rpmio/gengpg.h
 * ../rpmio/html-parse.h
 * ../rpmio/md2.h
 * ../rpmio/md4.h
 * ../rpmio/mire.h
 * ../rpmio/rmd128.h
 * ../rpmio/rmd160.h
 * ../rpmio/rmd256.h
 * ../rpmio/rmd320.h
 * ../rpmio/rpmbc.h
 * ../rpmio/rpmcb.h
 * ../rpmio/rpmdav.h
 * ../rpmio/rpmgc.h
 * ../rpmio/rpmhash.h
 * ../rpmio/rpmhook.h
 * ../rpmio/rpmio-stub.h
 * ../rpmio/rpmio.h
 * ../rpmio/rpmio_internal.h
 * ../rpmio/rpmlog.h
 * ../rpmio/rpmlua.h
 * ../rpmio/rpmmacro.h
 * ../rpmio/rpmmg.h
 * ../rpmio/rpmnss.h
 * ../rpmio/rpmpgp.h
 * ../rpmio/rpmsq.h
 * ../rpmio/rpmssl.h
 * ../rpmio/rpmsw.h
 * ../rpmio/rpmurl.h
 * ../rpmio/rpmxar.h
 * ../rpmio/salsa10.h
 * ../rpmio/salsa20.h
 * ../rpmio/sha224.h
 * ../rpmio/stringbuf.h
 * ../rpmio/tiger.h
 * ../rpmio/ugid.h
 * ../misc/err.h
 * ../misc/error.h
 * ../misc/fnmatch.h
 * ../misc/glob.h
 */

#include "system.h"
#define RPMCONSTANT_INTERNAL
#include "rpmconstant.h"
 

/* From rpmcli.h
 * prefix tag: VERIFY_
 * table: rpmVerifyFlags */
static const struct rpmconstant_s rpmVerifyFlagsctbl[] = {
#ifdef H_RPMCLI
	{ "VERIFY_DEFAULT", VERIFY_DEFAULT }, /*!< */
	{ "VERIFY_FDIGEST", VERIFY_FDIGEST }, 
	{ "VERIFY_SIZE", VERIFY_SIZE }, 
	{ "VERIFY_LINKTO", VERIFY_LINKTO }, 
	{ "VERIFY_USER", VERIFY_USER }, 
	{ "VERIFY_GROUP", VERIFY_GROUP }, 
	{ "VERIFY_MTIME", VERIFY_MTIME }, 
	{ "VERIFY_MODE", VERIFY_MODE }, 
	{ "VERIFY_RDEV", VERIFY_RDEV }, 
	{ "VERIFY_CONTEXTS", VERIFY_CONTEXTS }, 
	{ "VERIFY_FILES", VERIFY_FILES }, 
	{ "VERIFY_DEPS", VERIFY_DEPS }, 
	{ "VERIFY_SCRIPT", VERIFY_SCRIPT }, 
	{ "VERIFY_DIGEST", VERIFY_DIGEST }, 
	{ "VERIFY_SIGNATURE", VERIFY_SIGNATURE }, 
	{ "VERIFY_PATCHES", VERIFY_PATCHES }, 
	{ "VERIFY_HDRCHK", VERIFY_HDRCHK }, 
	{ "VERIFY_FOR_LIST", VERIFY_FOR_LIST }, 
	{ "VERIFY_FOR_STATE", VERIFY_FOR_STATE }, 
	{ "VERIFY_FOR_DOCS", VERIFY_FOR_DOCS }, 
	{ "VERIFY_FOR_CONFIG", VERIFY_FOR_CONFIG }, 
	{ "VERIFY_FOR_DUMPFILES", VERIFY_FOR_DUMPFILES }, 
	{ "VERIFY_ATTRS", VERIFY_ATTRS }, 
	{ "VERIFY_ALL", VERIFY_ALL }, 
#endif /* H_RPMCLI */
	{ NULL, 0 } /* NULL terminated (rpmVerifyFlags) */
};
const struct rpmconstant_s * rpmVerifyFlagsctable = rpmVerifyFlagsctbl;


/* From rpmcli.h
 * prefix tag: RPMSIGN_
 * table: rpmSignFlags */
static const struct rpmconstant_s rpmSignFlagsctbl[] = {
#ifdef H_RPMCLI
	{ "RPMSIGN_NONE", RPMSIGN_NONE }, 
	{ "RPMSIGN_CHK_SIGNATURE", RPMSIGN_CHK_SIGNATURE }, /*!< from --checksig */
	{ "RPMSIGN_NEW_SIGNATURE", RPMSIGN_NEW_SIGNATURE }, /*!< from --resign */
	{ "RPMSIGN_ADD_SIGNATURE", RPMSIGN_ADD_SIGNATURE }, /*!< from --addsign */
	{ "RPMSIGN_DEL_SIGNATURE", RPMSIGN_DEL_SIGNATURE }, /*!< from --delsign */
	{ "RPMSIGN_IMPORT_PUBKEY", RPMSIGN_IMPORT_PUBKEY }, /*!< from --import */
#endif /* H_RPMCLI */
	{ NULL, 0 } /* NULL terminated (rpmSignFlags) */
};
const struct rpmconstant_s * rpmSignFlagsctable = rpmSignFlagsctbl;


/* From rpmlib.h
 * prefix tag: RPM_MACHTABLE_
 * table: rpm_machtable */
static const struct rpmconstant_s rpm_machtablectbl[] = {
#ifdef H_RPMLIB
	{ "RPM_MACHTABLE_INSTARCH", RPM_MACHTABLE_INSTARCH }, /*!< Install platform architecture. */
	{ "RPM_MACHTABLE_INSTOS", RPM_MACHTABLE_INSTOS }, /*!< Install platform operating system. */
	{ "RPM_MACHTABLE_BUILDARCH", RPM_MACHTABLE_BUILDARCH }, /*!< Build platform architecture. */
	{ "RPM_MACHTABLE_BUILDOS", RPM_MACHTABLE_BUILDOS }, /*!< Build platform operating system. */
	{ "RPM_MACHTABLE_COUNT", RPM_MACHTABLE_COUNT }, /*!< No. of arch/os tables. */
#endif /* H_RPMLIB */
	{ NULL, 0 } /* NULL terminated (rpm_machtable) */
};
const struct rpmconstant_s * rpm_machtablectable = rpm_machtablectbl;


/* From rpmlib.h
 * prefix tag: RPMRC_
 * table: rpmRC */
static const struct rpmconstant_s rpmRCctbl[] = {
#ifdef H_RPMLIB
	{ "RPMRC_OK", RPMRC_OK }, /*!< Generic success code */
	{ "RPMRC_NOTFOUND", RPMRC_NOTFOUND }, /*!< Generic not found code. */
	{ "RPMRC_FAIL", RPMRC_FAIL }, /*!< Generic failure code. */
	{ "RPMRC_NOTTRUSTED", RPMRC_NOTTRUSTED }, /*!< Signature is OK, but key is not trusted. */
	{ "RPMRC_NOKEY", RPMRC_NOKEY }, /*!< Public key is unavailable. */
#endif /* H_RPMLIB */
	{ NULL, 0 } /* NULL terminated (rpmRC) */
};
const struct rpmconstant_s * rpmRCctable = rpmRCctbl;


/* From rpmps.h
 * prefix tag: RPMPROB_
 * table: rpmProblemType */
static const struct rpmconstant_s rpmProblemTypectbl[] = {
#ifdef H_RPMPS
	{ "RPMPROB_FILTER_NONE", RPMPROB_FILTER_NONE }, 
	{ "RPMPROB_FILTER_IGNOREOS", RPMPROB_FILTER_IGNOREOS }, 
	{ "RPMPROB_FILTER_IGNOREARCH", RPMPROB_FILTER_IGNOREARCH }, 
	{ "RPMPROB_FILTER_REPLACEPKG", RPMPROB_FILTER_REPLACEPKG }, 
	{ "RPMPROB_FILTER_FORCERELOCATE", RPMPROB_FILTER_FORCERELOCATE }, 
	{ "RPMPROB_FILTER_REPLACENEWFILES", RPMPROB_FILTER_REPLACENEWFILES }, 
	{ "RPMPROB_FILTER_REPLACEOLDFILES", RPMPROB_FILTER_REPLACEOLDFILES }, 
	{ "RPMPROB_FILTER_OLDPACKAGE", RPMPROB_FILTER_OLDPACKAGE }, 
	{ "RPMPROB_FILTER_DISKSPACE", RPMPROB_FILTER_DISKSPACE }, 
	{ "RPMPROB_FILTER_DISKNODES", RPMPROB_FILTER_DISKNODES }, 
	{ "RPMPROB_BADARCH", RPMPROB_BADARCH }, /*!< (unused) package ... is for a different architecture */
	{ "RPMPROB_BADOS", RPMPROB_BADOS }, /*!< (unused) package ... is for a different operating system */
	{ "RPMPROB_PKG_INSTALLED", RPMPROB_PKG_INSTALLED }, /*!< package ... is already installed */
	{ "RPMPROB_BADRELOCATE", RPMPROB_BADRELOCATE }, /*!< path ... is not relocatable for package ... */
	{ "RPMPROB_REQUIRES", RPMPROB_REQUIRES }, /*!< package ... has unsatisfied Requires: ... */
	{ "RPMPROB_CONFLICT", RPMPROB_CONFLICT }, /*!< package ... has unsatisfied Conflicts: ... */
	{ "RPMPROB_NEW_FILE_CONFLICT", RPMPROB_NEW_FILE_CONFLICT }, /*!< file ... conflicts between attemped installs of ... */
	{ "RPMPROB_FILE_CONFLICT", RPMPROB_FILE_CONFLICT }, /*!< file ... from install of ... conflicts with file from package ... */
	{ "RPMPROB_OLDPACKAGE", RPMPROB_OLDPACKAGE }, /*!< package ... (which is newer than ...) is already installed */
	{ "RPMPROB_DISKSPACE", RPMPROB_DISKSPACE }, /*!< installing package ... needs ... on the ... filesystem */
	{ "RPMPROB_DISKNODES", RPMPROB_DISKNODES }, /*!< installing package ... needs ... on the ... filesystem */
	{ "RPMPROB_RDONLY", RPMPROB_RDONLY }, /*!< installing package ... on ... rdonly filesystem */
	{ "RPMPROB_BADPRETRANS", RPMPROB_BADPRETRANS }, /*!< (unimplemented) */
	{ "RPMPROB_BADPLATFORM", RPMPROB_BADPLATFORM }, /*!< package ... is for a different platform */
	{ "RPMPROB_NOREPACKAGE", RPMPROB_NOREPACKAGE }, /*!< re-packaged package ... is missing */
#endif /* H_RPMPS */
	{ NULL, 0 } /* NULL terminated (rpmProblemType) */
};
const struct rpmconstant_s * rpmProblemTypectable = rpmProblemTypectbl;


/* From rpmte.h
 * prefix tag: TR_
 * table: rpmElementType */
static const struct rpmconstant_s rpmElementTypectbl[] = {
#ifdef H_RPMTE
	{ "TR_ADDED", TR_ADDED }, 
	{ "TR_REMOVED", TR_REMOVED }, 
#endif /* H_RPMTE */
	{ NULL, 0 } /* NULL terminated (rpmElementType) */
};
const struct rpmconstant_s * rpmElementTypectable = rpmElementTypectbl;


/* From rpmts.h
 * prefix tag: RPMTS_OP_
 * table: rpmtsOpX */
static const struct rpmconstant_s rpmtsOpXctbl[] = {
#ifdef H_RPMTS
	{ "RPMTS_OP_TOTAL", RPMTS_OP_TOTAL }, 
	{ "RPMTS_OP_CHECK", RPMTS_OP_CHECK }, 
	{ "RPMTS_OP_ORDER", RPMTS_OP_ORDER }, 
	{ "RPMTS_OP_FINGERPRINT", RPMTS_OP_FINGERPRINT }, 
	{ "RPMTS_OP_REPACKAGE", RPMTS_OP_REPACKAGE }, 
	{ "RPMTS_OP_INSTALL", RPMTS_OP_INSTALL }, 
	{ "RPMTS_OP_ERASE", RPMTS_OP_ERASE }, 
	{ "RPMTS_OP_SCRIPTLETS", RPMTS_OP_SCRIPTLETS }, 
	{ "RPMTS_OP_COMPRESS", RPMTS_OP_COMPRESS }, 
	{ "RPMTS_OP_UNCOMPRESS", RPMTS_OP_UNCOMPRESS }, 
	{ "RPMTS_OP_DIGEST", RPMTS_OP_DIGEST }, 
	{ "RPMTS_OP_SIGNATURE", RPMTS_OP_SIGNATURE }, 
	{ "RPMTS_OP_DBADD", RPMTS_OP_DBADD }, 
	{ "RPMTS_OP_DBREMOVE", RPMTS_OP_DBREMOVE }, 
	{ "RPMTS_OP_DBGET", RPMTS_OP_DBGET }, 
	{ "RPMTS_OP_DBPUT", RPMTS_OP_DBPUT }, 
	{ "RPMTS_OP_DBDEL", RPMTS_OP_DBDEL }, 
	{ "RPMTS_OP_READHDR", RPMTS_OP_READHDR }, 
	{ "RPMTS_OP_HDRLOAD", RPMTS_OP_HDRLOAD }, 
	{ "RPMTS_OP_HDRGET", RPMTS_OP_HDRGET }, 
	{ "RPMTS_OP_DEBUG", RPMTS_OP_DEBUG }, 
	{ "RPMTS_OP_MAX", RPMTS_OP_MAX }, 
#endif /* H_RPMTS */
	{ NULL, 0 } /* NULL terminated (rpmtsOpX) */
};
const struct rpmconstant_s * rpmtsOpXctable = rpmtsOpXctbl;


/* From rpmts.h
 * prefix tag: RPMTRANS_TYPE_
 * table: rpmtsType */
static const struct rpmconstant_s rpmtsTypectbl[] = {
#ifdef H_RPMTS
	{ "RPMTRANS_TYPE_NORMAL", RPMTRANS_TYPE_NORMAL }, 
	{ "RPMTRANS_TYPE_ROLLBACK", RPMTRANS_TYPE_ROLLBACK }, 
	{ "RPMTRANS_TYPE_AUTOROLLBACK", RPMTRANS_TYPE_AUTOROLLBACK }, 
#endif /* H_RPMTS */
	{ NULL, 0 } /* NULL terminated (rpmtsType) */
};
const struct rpmconstant_s * rpmtsTypectable = rpmtsTypectbl;


/* From rpmbuild.h
 * prefix tag: RPMBUILD_
 * table: rpmBuildFlags */
static const struct rpmconstant_s rpmBuildFlagsctbl[] = {
#ifdef _H_RPMBUILD_
	{ "RPMBUILD_NONE", RPMBUILD_NONE }, 
	{ "RPMBUILD_PREP", RPMBUILD_PREP }, 
	{ "RPMBUILD_BUILD", RPMBUILD_BUILD }, 
	{ "RPMBUILD_INSTALL", RPMBUILD_INSTALL }, 
	{ "RPMBUILD_CHECK", RPMBUILD_CHECK }, 
	{ "RPMBUILD_CLEAN", RPMBUILD_CLEAN }, 
	{ "RPMBUILD_FILECHECK", RPMBUILD_FILECHECK }, 
	{ "RPMBUILD_PACKAGESOURCE", RPMBUILD_PACKAGESOURCE }, 
	{ "RPMBUILD_PACKAGEBINARY", RPMBUILD_PACKAGEBINARY }, 
	{ "RPMBUILD_RMSOURCE", RPMBUILD_RMSOURCE }, 
	{ "RPMBUILD_RMBUILD", RPMBUILD_RMBUILD }, 
	{ "RPMBUILD_STRINGBUF", RPMBUILD_STRINGBUF }, 
	{ "RPMBUILD_TRACK", RPMBUILD_TRACK }, 
	{ "RPMBUILD_RMSPEC", RPMBUILD_RMSPEC }, 
	{ "RPMBUILD_FETCHSOURCE", RPMBUILD_FETCHSOURCE }, 
#endif /* _H_RPMBUILD_ */
	{ NULL, 0 } /* NULL terminated (rpmBuildFlags) */
};
const struct rpmconstant_s * rpmBuildFlagsctable = rpmBuildFlagsctbl;


/* From rpmbuild.h
 * prefix tag: PART_
 * table: rpmParseState */
static const struct rpmconstant_s rpmParseStatectbl[] = {
#ifdef _H_RPMBUILD_
	{ "PART_SUBNAME", PART_SUBNAME }, 
	{ "PART_NAME", PART_NAME }, 
	{ "PART_BASE", PART_BASE }, 
	{ "PART_NONE", PART_NONE }, /*!< */
	{ "PART_PREAMBLE", PART_PREAMBLE }, /*!< */
	{ "PART_PREP", PART_PREP }, /*!< */
	{ "PART_BUILD", PART_BUILD }, /*!< */
	{ "PART_INSTALL", PART_INSTALL }, /*!< */
	{ "PART_CHECK", PART_CHECK }, /*!< */
	{ "PART_CLEAN", PART_CLEAN }, /*!< */
	{ "PART_FILES", PART_FILES }, /*!< */
	{ "PART_PRE", PART_PRE }, /*!< */
	{ "PART_POST", PART_POST }, /*!< */
	{ "PART_PREUN", PART_PREUN }, /*!< */
	{ "PART_POSTUN", PART_POSTUN }, /*!< */
	{ "PART_PRETRANS", PART_PRETRANS }, /*!< */
	{ "PART_POSTTRANS", PART_POSTTRANS }, /*!< */
	{ "PART_DESCRIPTION", PART_DESCRIPTION }, /*!< */
	{ "PART_CHANGELOG", PART_CHANGELOG }, /*!< */
	{ "PART_TRIGGERIN", PART_TRIGGERIN }, /*!< */
	{ "PART_TRIGGERUN", PART_TRIGGERUN }, /*!< */
	{ "PART_VERIFYSCRIPT", PART_VERIFYSCRIPT }, /*!< */
	{ "PART_BUILDARCHITECTURES", PART_BUILDARCHITECTURES }, /*!< */
	{ "PART_TRIGGERPOSTUN", PART_TRIGGERPOSTUN }, /*!< */
	{ "PART_TRIGGERPREIN", PART_TRIGGERPREIN }, /*!< */
	{ "PART_SANITYCHECK", PART_SANITYCHECK }, /*!< */
	{ "PART_ARBITRARY", PART_ARBITRARY }, /*!< */
	{ "PART_LAST", PART_LAST }, /*!< */
#endif /* _H_RPMBUILD_ */
	{ NULL, 0 } /* NULL terminated (rpmParseState) */
};
const struct rpmconstant_s * rpmParseStatectable = rpmParseStatectbl;


/* From rpmtag.h
 * prefix tag: RPM_
 * table: rpmTagType */
static const struct rpmconstant_s rpmTagTypectbl[] = {
#ifdef H_RPMTAG
	{ "RPM_UINT8", RPM_UINT8_TYPE }, 
	{ "RPM_UINT16", RPM_UINT16_TYPE }, 
	{ "RPM_UINT32", RPM_UINT32_TYPE }, 
	{ "RPM_UINT64", RPM_UINT64_TYPE }, 
	{ "RPM_STRING", RPM_STRING_TYPE }, 
	{ "RPM_BIN", RPM_BIN_TYPE }, 
	{ "RPM_STRING_ARRAY", RPM_STRING_ARRAY_TYPE }, 
	{ "RPM_I18NSTRING", RPM_I18NSTRING_TYPE }, 
	{ "RPM_MIN", RPM_MIN_TYPE }, 
	{ "RPM_MAX", RPM_MAX_TYPE }, 
	{ "RPM_MASK", RPM_MASK_TYPE }, 
	{ "RPM_REGION", RPM_REGION_TYPE }, 
	{ "RPM_BIN_ARRAY", RPM_BIN_ARRAY_TYPE }, 
	{ "RPM_XREF", RPM_XREF_TYPE }, 
	{ "RPM_ANY_RETURN", RPM_ANY_RETURN_TYPE }, 
	{ "RPM_SCALAR_RETURN", RPM_SCALAR_RETURN_TYPE }, 
	{ "RPM_ARRAY_RETURN", RPM_ARRAY_RETURN_TYPE }, 
	{ "RPM_MAPPING_RETURN", RPM_MAPPING_RETURN_TYPE }, 
	{ "RPM_PROBE_RETURN", RPM_PROBE_RETURN_TYPE }, 
	{ "RPM_TREE_RETURN", RPM_TREE_RETURN_TYPE }, 
	{ "RPM_OPENPGP_RETURN", RPM_OPENPGP_RETURN_TYPE }, 
	{ "RPM_X509_RETURN", RPM_X509_RETURN_TYPE }, 
	{ "RPM_ASN1_RETURN", RPM_ASN1_RETURN_TYPE }, 
	{ "RPM_OPAQUE_RETURN", RPM_OPAQUE_RETURN_TYPE }, 
	{ "RPM_MASK_RETURN", RPM_MASK_RETURN_TYPE }, 
#endif /* H_RPMTAG */
	{ NULL, 0 } /* NULL terminated (rpmTagType) */
};
const struct rpmconstant_s * rpmTagTypectable = rpmTagTypectbl;


/* From rpmtag.h
 * prefix tag: RPMTAG_
 * table: rpmTag */
static const struct rpmconstant_s rpmTagctbl[] = {
#ifdef H_RPMTAG
	{ "RPMTAG_HEADERIMAGE", RPMTAG_HEADERIMAGE }, /*!< internal Current image. */
	{ "RPMTAG_HEADERSIGNATURES", RPMTAG_HEADERSIGNATURES }, /*!< internal Signatures. */
	{ "RPMTAG_HEADERIMMUTABLE", RPMTAG_HEADERIMMUTABLE }, /*!< x Original image. */
	{ "RPMTAG_HEADERREGIONS", RPMTAG_HEADERREGIONS }, /*!< internal Regions. */
	{ "RPMTAG_HEADERI18NTABLE", RPMTAG_HEADERI18NTABLE }, /*!< s[] I18N string locales. */
	{ "RPMTAG_SIG_BASE", RPMTAG_SIG_BASE }, 
	{ "RPMTAG_SIGSIZE", RPMTAG_SIGSIZE }, /* i */
	{ "RPMTAG_SIGLEMD5_1", RPMTAG_SIGLEMD5_1 }, /* internal - obsolete */
	{ "RPMTAG_SIGPGP", RPMTAG_SIGPGP }, /* x */
	{ "RPMTAG_SIGLEMD5_2", RPMTAG_SIGLEMD5_2 }, /* x internal - obsolete */
	{ "RPMTAG_SIGMD5", RPMTAG_SIGMD5 }, /* x */
	{ "RPMTAG_PKGID", RPMTAG_PKGID }, /* x */
	{ "RPMTAG_SIGGPG", RPMTAG_SIGGPG }, /* x */
	{ "RPMTAG_SIGPGP5", RPMTAG_SIGPGP5 }, /* internal - obsolete */
	{ "RPMTAG_BADSHA1_1", RPMTAG_BADSHA1_1 }, /* internal - obsolete */
	{ "RPMTAG_BADSHA1_2", RPMTAG_BADSHA1_2 }, /* internal - obsolete */
	{ "RPMTAG_PUBKEYS", RPMTAG_PUBKEYS }, /* s[] */
	{ "RPMTAG_DSAHEADER", RPMTAG_DSAHEADER }, /* x */
	{ "RPMTAG_RSAHEADER", RPMTAG_RSAHEADER }, /* x */
	{ "RPMTAG_SHA1HEADER", RPMTAG_SHA1HEADER }, /* s */
	{ "RPMTAG_HDRID", RPMTAG_HDRID }, /* s */
	{ "RPMTAG_NAME", RPMTAG_NAME }, /* s */
	{ "RPMTAG_N", RPMTAG_N }, /* s */
	{ "RPMTAG_VERSION", RPMTAG_VERSION }, /* s */
	{ "RPMTAG_V", RPMTAG_V }, /* s */
	{ "RPMTAG_RELEASE", RPMTAG_RELEASE }, /* s */
	{ "RPMTAG_R", RPMTAG_R }, /* s */
	{ "RPMTAG_EPOCH", RPMTAG_EPOCH }, /* i */
	{ "RPMTAG_E", RPMTAG_E }, /* i */
	{ "RPMTAG_SUMMARY", RPMTAG_SUMMARY }, /* s{} */
	{ "RPMTAG_DESCRIPTION", RPMTAG_DESCRIPTION }, /* s{} */
	{ "RPMTAG_BUILDTIME", RPMTAG_BUILDTIME }, /* i */
	{ "RPMTAG_BUILDHOST", RPMTAG_BUILDHOST }, /* s */
	{ "RPMTAG_INSTALLTIME", RPMTAG_INSTALLTIME }, /* i */
	{ "RPMTAG_SIZE", RPMTAG_SIZE }, /* i */
	{ "RPMTAG_DISTRIBUTION", RPMTAG_DISTRIBUTION }, /* s */
	{ "RPMTAG_VENDOR", RPMTAG_VENDOR }, /* s */
	{ "RPMTAG_GIF", RPMTAG_GIF }, /* x */
	{ "RPMTAG_XPM", RPMTAG_XPM }, /* x */
	{ "RPMTAG_LICENSE", RPMTAG_LICENSE }, /* s */
	{ "RPMTAG_PACKAGER", RPMTAG_PACKAGER }, /* s */
	{ "RPMTAG_GROUP", RPMTAG_GROUP }, /* s{} */
	{ "RPMTAG_CHANGELOG", RPMTAG_CHANGELOG }, /* s[] internal */
	{ "RPMTAG_SOURCE", RPMTAG_SOURCE }, /* s[] */
	{ "RPMTAG_PATCH", RPMTAG_PATCH }, /* s[] */
	{ "RPMTAG_URL", RPMTAG_URL }, /* s */
	{ "RPMTAG_OS", RPMTAG_OS }, /* s legacy used int */
	{ "RPMTAG_ARCH", RPMTAG_ARCH }, /* s legacy used int */
	{ "RPMTAG_PREIN", RPMTAG_PREIN }, /* s */
	{ "RPMTAG_POSTIN", RPMTAG_POSTIN }, /* s */
	{ "RPMTAG_PREUN", RPMTAG_PREUN }, /* s */
	{ "RPMTAG_POSTUN", RPMTAG_POSTUN }, /* s */
	{ "RPMTAG_OLDFILENAMES", RPMTAG_OLDFILENAMES }, /* s[] obsolete */
	{ "RPMTAG_FILESIZES", RPMTAG_FILESIZES }, /* i[] */
	{ "RPMTAG_FILESTATES", RPMTAG_FILESTATES }, /* c[] */
	{ "RPMTAG_FILEMODES", RPMTAG_FILEMODES }, /* h[] */
	{ "RPMTAG_FILEUIDS", RPMTAG_FILEUIDS }, /* i[] internal */
	{ "RPMTAG_FILEGIDS", RPMTAG_FILEGIDS }, /* i[] internal */
	{ "RPMTAG_FILERDEVS", RPMTAG_FILERDEVS }, /* h[] */
	{ "RPMTAG_FILEMTIMES", RPMTAG_FILEMTIMES }, /* i[] */
	{ "RPMTAG_FILEDIGESTS", RPMTAG_FILEDIGESTS }, /* s[] */
	{ "RPMTAG_FILEMD5S", RPMTAG_FILEMD5S }, /* s[] */
	{ "RPMTAG_FILELINKTOS", RPMTAG_FILELINKTOS }, /* s[] */
	{ "RPMTAG_FILEFLAGS", RPMTAG_FILEFLAGS }, /* i[] */
	{ "RPMTAG_ROOT", RPMTAG_ROOT }, /* internal - obsolete */
	{ "RPMTAG_FILEUSERNAME", RPMTAG_FILEUSERNAME }, /* s[] */
	{ "RPMTAG_FILEGROUPNAME", RPMTAG_FILEGROUPNAME }, /* s[] */
	{ "RPMTAG_EXCLUDE", RPMTAG_EXCLUDE }, /* internal - obsolete */
	{ "RPMTAG_EXCLUSIVE", RPMTAG_EXCLUSIVE }, /* internal - obsolete */
	{ "RPMTAG_ICON", RPMTAG_ICON }, /* x */
	{ "RPMTAG_SOURCERPM", RPMTAG_SOURCERPM }, /* s */
	{ "RPMTAG_FILEVERIFYFLAGS", RPMTAG_FILEVERIFYFLAGS }, /* i[] */
	{ "RPMTAG_ARCHIVESIZE", RPMTAG_ARCHIVESIZE }, /* i */
	{ "RPMTAG_PROVIDENAME", RPMTAG_PROVIDENAME }, /* s[] */
	{ "RPMTAG_PROVIDES", RPMTAG_PROVIDES }, /* s[] */
	{ "RPMTAG_P", RPMTAG_P }, /* s[] */
	{ "RPMTAG_REQUIREFLAGS", RPMTAG_REQUIREFLAGS }, /* i[] */
	{ "RPMTAG_REQUIRENAME", RPMTAG_REQUIRENAME }, /* s[] */
	{ "RPMTAG_REQUIRES", RPMTAG_REQUIRES }, /* s[] */
	{ "RPMTAG_REQUIREVERSION", RPMTAG_REQUIREVERSION }, /* s[] */
	{ "RPMTAG_NOSOURCE", RPMTAG_NOSOURCE }, /* i internal */
	{ "RPMTAG_NOPATCH", RPMTAG_NOPATCH }, /* i internal */
	{ "RPMTAG_CONFLICTFLAGS", RPMTAG_CONFLICTFLAGS }, /* i[] */
	{ "RPMTAG_CONFLICTNAME", RPMTAG_CONFLICTNAME }, /* s[] */
	{ "RPMTAG_CONFLICTS", RPMTAG_CONFLICTS }, /* s[] */
	{ "RPMTAG_C", RPMTAG_C }, /* s[] */
	{ "RPMTAG_CONFLICTVERSION", RPMTAG_CONFLICTVERSION }, /* s[] */
	{ "RPMTAG_DEFAULTPREFIX", RPMTAG_DEFAULTPREFIX }, /* s internal - deprecated */
	{ "RPMTAG_BUILDROOT", RPMTAG_BUILDROOT }, /* s internal */
	{ "RPMTAG_INSTALLPREFIX", RPMTAG_INSTALLPREFIX }, /* s internal - deprecated */
	{ "RPMTAG_EXCLUDEARCH", RPMTAG_EXCLUDEARCH }, /* s[] */
	{ "RPMTAG_EXCLUDEOS", RPMTAG_EXCLUDEOS }, /* s[] */
	{ "RPMTAG_EXCLUSIVEARCH", RPMTAG_EXCLUSIVEARCH }, /* s[] */
	{ "RPMTAG_EXCLUSIVEOS", RPMTAG_EXCLUSIVEOS }, /* s[] */
	{ "RPMTAG_AUTOREQPROV", RPMTAG_AUTOREQPROV }, /* s internal */
	{ "RPMTAG_RPMVERSION", RPMTAG_RPMVERSION }, /* s */
	{ "RPMTAG_TRIGGERSCRIPTS", RPMTAG_TRIGGERSCRIPTS }, /* s[] */
	{ "RPMTAG_TRIGGERNAME", RPMTAG_TRIGGERNAME }, /* s[] */
	{ "RPMTAG_TRIGGERVERSION", RPMTAG_TRIGGERVERSION }, /* s[] */
	{ "RPMTAG_TRIGGERFLAGS", RPMTAG_TRIGGERFLAGS }, /* i[] */
	{ "RPMTAG_TRIGGERINDEX", RPMTAG_TRIGGERINDEX }, /* i[] */
	{ "RPMTAG_VERIFYSCRIPT", RPMTAG_VERIFYSCRIPT }, /* s */
	{ "RPMTAG_CHANGELOGTIME", RPMTAG_CHANGELOGTIME }, /* i[] */
	{ "RPMTAG_CHANGELOGNAME", RPMTAG_CHANGELOGNAME }, /* s[] */
	{ "RPMTAG_CHANGELOGTEXT", RPMTAG_CHANGELOGTEXT }, /* s[] */
	{ "RPMTAG_BROKENMD5", RPMTAG_BROKENMD5 }, /* internal - obsolete */
	{ "RPMTAG_PREREQ", RPMTAG_PREREQ }, /* internal */
	{ "RPMTAG_PREINPROG", RPMTAG_PREINPROG }, /* s */
	{ "RPMTAG_POSTINPROG", RPMTAG_POSTINPROG }, /* s */
	{ "RPMTAG_PREUNPROG", RPMTAG_PREUNPROG }, /* s */
	{ "RPMTAG_POSTUNPROG", RPMTAG_POSTUNPROG }, /* s */
	{ "RPMTAG_BUILDARCHS", RPMTAG_BUILDARCHS }, /* s[] */
	{ "RPMTAG_OBSOLETENAME", RPMTAG_OBSOLETENAME }, /* s[] */
	{ "RPMTAG_OBSOLETES", RPMTAG_OBSOLETES }, /* s[] */
	{ "RPMTAG_O", RPMTAG_O }, /* s[] */
	{ "RPMTAG_VERIFYSCRIPTPROG", RPMTAG_VERIFYSCRIPTPROG }, /* s */
	{ "RPMTAG_TRIGGERSCRIPTPROG", RPMTAG_TRIGGERSCRIPTPROG }, /* s[] */
	{ "RPMTAG_DOCDIR", RPMTAG_DOCDIR }, /* internal */
	{ "RPMTAG_COOKIE", RPMTAG_COOKIE }, /* s */
	{ "RPMTAG_FILEDEVICES", RPMTAG_FILEDEVICES }, /* i[] */
	{ "RPMTAG_FILEINODES", RPMTAG_FILEINODES }, /* i[] */
	{ "RPMTAG_FILELANGS", RPMTAG_FILELANGS }, /* s[] */
	{ "RPMTAG_PREFIXES", RPMTAG_PREFIXES }, /* s[] */
	{ "RPMTAG_INSTPREFIXES", RPMTAG_INSTPREFIXES }, /* s[] */
	{ "RPMTAG_TRIGGERIN", RPMTAG_TRIGGERIN }, /* internal */
	{ "RPMTAG_TRIGGERUN", RPMTAG_TRIGGERUN }, /* internal */
	{ "RPMTAG_TRIGGERPOSTUN", RPMTAG_TRIGGERPOSTUN }, /* internal */
	{ "RPMTAG_AUTOREQ", RPMTAG_AUTOREQ }, /* internal */
	{ "RPMTAG_AUTOPROV", RPMTAG_AUTOPROV }, /* internal */
	{ "RPMTAG_CAPABILITY", RPMTAG_CAPABILITY }, /* i legacy - obsolete */
	{ "RPMTAG_SOURCEPACKAGE", RPMTAG_SOURCEPACKAGE }, /* i legacy - obsolete */
	{ "RPMTAG_OLDORIGFILENAMES", RPMTAG_OLDORIGFILENAMES }, /* internal - obsolete */
	{ "RPMTAG_BUILDPREREQ", RPMTAG_BUILDPREREQ }, /* internal */
	{ "RPMTAG_BUILDREQUIRES", RPMTAG_BUILDREQUIRES }, /* internal */
	{ "RPMTAG_BUILDCONFLICTS", RPMTAG_BUILDCONFLICTS }, /* internal */
	{ "RPMTAG_BUILDMACROS", RPMTAG_BUILDMACROS }, /* s[] srpms only */
	{ "RPMTAG_PROVIDEFLAGS", RPMTAG_PROVIDEFLAGS }, /* i[] */
	{ "RPMTAG_PROVIDEVERSION", RPMTAG_PROVIDEVERSION }, /* s[] */
	{ "RPMTAG_OBSOLETEFLAGS", RPMTAG_OBSOLETEFLAGS }, /* i[] */
	{ "RPMTAG_OBSOLETEVERSION", RPMTAG_OBSOLETEVERSION }, /* s[] */
	{ "RPMTAG_DIRINDEXES", RPMTAG_DIRINDEXES }, /* i[] */
	{ "RPMTAG_BASENAMES", RPMTAG_BASENAMES }, /* s[] */
	{ "RPMTAG_DIRNAMES", RPMTAG_DIRNAMES }, /* s[] */
	{ "RPMTAG_ORIGDIRINDEXES", RPMTAG_ORIGDIRINDEXES }, /* i[] relocation */
	{ "RPMTAG_ORIGBASENAMES", RPMTAG_ORIGBASENAMES }, /* s[] relocation */
	{ "RPMTAG_ORIGDIRNAMES", RPMTAG_ORIGDIRNAMES }, /* s[] relocation */
	{ "RPMTAG_OPTFLAGS", RPMTAG_OPTFLAGS }, /* s */
	{ "RPMTAG_DISTURL", RPMTAG_DISTURL }, /* s */
	{ "RPMTAG_PAYLOADFORMAT", RPMTAG_PAYLOADFORMAT }, /* s */
	{ "RPMTAG_PAYLOADCOMPRESSOR", RPMTAG_PAYLOADCOMPRESSOR }, /* s */
	{ "RPMTAG_PAYLOADFLAGS", RPMTAG_PAYLOADFLAGS }, /* s */
	{ "RPMTAG_INSTALLCOLOR", RPMTAG_INSTALLCOLOR }, /* i transaction color when installed */
	{ "RPMTAG_INSTALLTID", RPMTAG_INSTALLTID }, /* i */
	{ "RPMTAG_REMOVETID", RPMTAG_REMOVETID }, /* i */
	{ "RPMTAG_SHA1RHN", RPMTAG_SHA1RHN }, /* internal - obsolete */
	{ "RPMTAG_RHNPLATFORM", RPMTAG_RHNPLATFORM }, /* s deprecated */
	{ "RPMTAG_PLATFORM", RPMTAG_PLATFORM }, /* s */
	{ "RPMTAG_PATCHESNAME", RPMTAG_PATCHESNAME }, /* s[] deprecated placeholder (SuSE) */
	{ "RPMTAG_PATCHESFLAGS", RPMTAG_PATCHESFLAGS }, /* i[] deprecated placeholder (SuSE) */
	{ "RPMTAG_PATCHESVERSION", RPMTAG_PATCHESVERSION }, /* s[] deprecated placeholder (SuSE) */
	{ "RPMTAG_CACHECTIME", RPMTAG_CACHECTIME }, /* i rpmcache(8) only */
	{ "RPMTAG_CACHEPKGPATH", RPMTAG_CACHEPKGPATH }, /* s rpmcache(8) only */
	{ "RPMTAG_CACHEPKGSIZE", RPMTAG_CACHEPKGSIZE }, /* i rpmcache(8) only */
	{ "RPMTAG_CACHEPKGMTIME", RPMTAG_CACHEPKGMTIME }, /* i rpmcache(8) only */
	{ "RPMTAG_FILECOLORS", RPMTAG_FILECOLORS }, /* i[] */
	{ "RPMTAG_FILECLASS", RPMTAG_FILECLASS }, /* i[] */
	{ "RPMTAG_CLASSDICT", RPMTAG_CLASSDICT }, /* s[] */
	{ "RPMTAG_FILEDEPENDSX", RPMTAG_FILEDEPENDSX }, /* i[] */
	{ "RPMTAG_FILEDEPENDSN", RPMTAG_FILEDEPENDSN }, /* i[] */
	{ "RPMTAG_DEPENDSDICT", RPMTAG_DEPENDSDICT }, /* i[] */
	{ "RPMTAG_SOURCEPKGID", RPMTAG_SOURCEPKGID }, /* x */
	{ "RPMTAG_FILECONTEXTS", RPMTAG_FILECONTEXTS }, /* s[] */
	{ "RPMTAG_FSCONTEXTS", RPMTAG_FSCONTEXTS }, /* s[] extension */
	{ "RPMTAG_RECONTEXTS", RPMTAG_RECONTEXTS }, /* s[] extension */
	{ "RPMTAG_POLICIES", RPMTAG_POLICIES }, /* s[] selinux *.te policy file. */
	{ "RPMTAG_PRETRANS", RPMTAG_PRETRANS }, /* s */
	{ "RPMTAG_POSTTRANS", RPMTAG_POSTTRANS }, /* s */
	{ "RPMTAG_PRETRANSPROG", RPMTAG_PRETRANSPROG }, /* s */
	{ "RPMTAG_POSTTRANSPROG", RPMTAG_POSTTRANSPROG }, /* s */
	{ "RPMTAG_DISTTAG", RPMTAG_DISTTAG }, /* s */
	{ "RPMTAG_SUGGESTSNAME", RPMTAG_SUGGESTSNAME }, /* s[] extension */
	{ "RPMTAG_SUGGESTS", RPMTAG_SUGGESTS }, /* s[] */
	{ "RPMTAG_SUGGESTSVERSION", RPMTAG_SUGGESTSVERSION }, /* s[] extension */
	{ "RPMTAG_SUGGESTSFLAGS", RPMTAG_SUGGESTSFLAGS }, /* i[] extension */
	{ "RPMTAG_ENHANCESNAME", RPMTAG_ENHANCESNAME }, /* s[] extension placeholder */
	{ "RPMTAG_ENHANCES", RPMTAG_ENHANCES }, /* s[] */
	{ "RPMTAG_ENHANCESVERSION", RPMTAG_ENHANCESVERSION }, /* s[] extension placeholder */
	{ "RPMTAG_ENHANCESFLAGS", RPMTAG_ENHANCESFLAGS }, /* i[] extension placeholder */
	{ "RPMTAG_PRIORITY", RPMTAG_PRIORITY }, /* i[] extension placeholder */
	{ "RPMTAG_CVSID", RPMTAG_CVSID }, /* s */
	{ "RPMTAG_SVNID", RPMTAG_SVNID }, /* s */
	{ "RPMTAG_BLINKPKGID", RPMTAG_BLINKPKGID }, /* s[] */
	{ "RPMTAG_BLINKHDRID", RPMTAG_BLINKHDRID }, /* s[] */
	{ "RPMTAG_BLINKNEVRA", RPMTAG_BLINKNEVRA }, /* s[] */
	{ "RPMTAG_FLINKPKGID", RPMTAG_FLINKPKGID }, /* s[] */
	{ "RPMTAG_FLINKHDRID", RPMTAG_FLINKHDRID }, /* s[] */
	{ "RPMTAG_FLINKNEVRA", RPMTAG_FLINKNEVRA }, /* s[] */
	{ "RPMTAG_PACKAGEORIGIN", RPMTAG_PACKAGEORIGIN }, /* s */
	{ "RPMTAG_TRIGGERPREIN", RPMTAG_TRIGGERPREIN }, /* internal */
	{ "RPMTAG_BUILDSUGGESTS", RPMTAG_BUILDSUGGESTS }, /* internal */
	{ "RPMTAG_BUILDENHANCES", RPMTAG_BUILDENHANCES }, /* internal */
	{ "RPMTAG_SCRIPTSTATES", RPMTAG_SCRIPTSTATES }, /* i[] scriptlet exit codes */
	{ "RPMTAG_SCRIPTMETRICS", RPMTAG_SCRIPTMETRICS }, /* i[] scriptlet execution times */
	{ "RPMTAG_BUILDCPUCLOCK", RPMTAG_BUILDCPUCLOCK }, /* i */
	{ "RPMTAG_FILEDIGESTALGOS", RPMTAG_FILEDIGESTALGOS }, /* i[] */
	{ "RPMTAG_VARIANTS", RPMTAG_VARIANTS }, /* s[] */
	{ "RPMTAG_XMAJOR", RPMTAG_XMAJOR }, /* i */
	{ "RPMTAG_XMINOR", RPMTAG_XMINOR }, /* i */
	{ "RPMTAG_REPOTAG", RPMTAG_REPOTAG }, /* s */
	{ "RPMTAG_KEYWORDS", RPMTAG_KEYWORDS }, /* s[] */
	{ "RPMTAG_BUILDPLATFORMS", RPMTAG_BUILDPLATFORMS }, /* s[] */
	{ "RPMTAG_PACKAGECOLOR", RPMTAG_PACKAGECOLOR }, /* i */
	{ "RPMTAG_PACKAGEPREFCOLOR", RPMTAG_PACKAGEPREFCOLOR }, /* i (unimplemented) */
	{ "RPMTAG_XATTRSDICT", RPMTAG_XATTRSDICT }, /* s[] (unimplemented) */
	{ "RPMTAG_FILEXATTRSX", RPMTAG_FILEXATTRSX }, /* i[] (unimplemented) */
	{ "RPMTAG_DEPATTRSDICT", RPMTAG_DEPATTRSDICT }, /* s[] (unimplemented) */
	{ "RPMTAG_CONFLICTATTRSX", RPMTAG_CONFLICTATTRSX }, /* i[] (unimplemented) */
	{ "RPMTAG_OBSOLETEATTRSX", RPMTAG_OBSOLETEATTRSX }, /* i[] (unimplemented) */
	{ "RPMTAG_PROVIDEATTRSX", RPMTAG_PROVIDEATTRSX }, /* i[] (unimplemented) */
	{ "RPMTAG_REQUIREATTRSX", RPMTAG_REQUIREATTRSX }, /* i[] (unimplemented) */
	{ "RPMTAG_BUILDPROVIDES", RPMTAG_BUILDPROVIDES }, /* internal */
	{ "RPMTAG_BUILDOBSOLETES", RPMTAG_BUILDOBSOLETES }, /* internal */
	{ "RPMTAG_DBINSTANCE", RPMTAG_DBINSTANCE }, /* i */
	{ "RPMTAG_NVRA", RPMTAG_NVRA }, /* s */
	{ "RPMTAG_FILEPATHS", RPMTAG_FILEPATHS }, /* s[] */
	{ "RPMTAG_ORIGPATHS", RPMTAG_ORIGPATHS }, /* s[] */
	{ "RPMTAG_RPMLIBVERSION", RPMTAG_RPMLIBVERSION }, /* i */
	{ "RPMTAG_RPMLIBTIMESTAMP", RPMTAG_RPMLIBTIMESTAMP }, /* i */
	{ "RPMTAG_RPMLIBVENDOR", RPMTAG_RPMLIBVENDOR }, /* i */
	{ "RPMTAG_CLASS", RPMTAG_CLASS }, /* s */
	{ "RPMTAG_TRACK", RPMTAG_TRACK }, /* s internal arbitrary */
	{ "RPMTAG_TRACKPROG", RPMTAG_TRACKPROG }, /* s internal arbitrary */
	{ "RPMTAG_SANITYCHECK", RPMTAG_SANITYCHECK }, /* s */
	{ "RPMTAG_SANITYCHECKPROG", RPMTAG_SANITYCHECKPROG }, /* s */
	{ "RPMTAG_FIRSTFREE_TAG", RPMTAG_FIRSTFREE_TAG }, /*!< internal */
	{ "RPMTAG_EXTERNAL_TAG", RPMTAG_EXTERNAL_TAG }, 
#endif /* H_RPMTAG */
	{ NULL, 0 } /* NULL terminated (rpmTag) */
};
const struct rpmconstant_s * rpmTagctable = rpmTagctbl;


/* From rpmlog.h
 * prefix tag: RPMLOG_
 * table: rpmlog */
static const struct rpmconstant_s rpmlogctbl[] = {
#ifdef H_RPMLOG
	{ "RPMLOG_EMERG", RPMLOG_EMERG }, /*!< system is unusable */
	{ "RPMLOG_ALERT", RPMLOG_ALERT }, /*!< action must be taken immediately */
	{ "RPMLOG_CRIT", RPMLOG_CRIT }, /*!< critical conditions */
	{ "RPMLOG_ERR", RPMLOG_ERR }, /*!< error conditions */
	{ "RPMLOG_WARNING", RPMLOG_WARNING }, /*!< warning conditions */
	{ "RPMLOG_NOTICE", RPMLOG_NOTICE }, /*!< normal but significant condition */
	{ "RPMLOG_INFO", RPMLOG_INFO }, /*!< informational */
	{ "RPMLOG_DEBUG", RPMLOG_DEBUG }, /*!< debug-level messages */
	{ "RPMLOG_PRIMASK", RPMLOG_PRIMASK }, /* mask to extract priority part (internal) */
	{ "RPMLOG_KERN", RPMLOG_KERN }, 
	{ "RPMLOG_USER", RPMLOG_USER }, 
	{ "RPMLOG_MAIL", RPMLOG_MAIL }, 
	{ "RPMLOG_DAEMON", RPMLOG_DAEMON }, 
	{ "RPMLOG_AUTH", RPMLOG_AUTH }, 
	{ "RPMLOG_SYSLOG", RPMLOG_SYSLOG }, 
	{ "RPMLOG_LPR", RPMLOG_LPR }, 
	{ "RPMLOG_NEWS", RPMLOG_NEWS }, 
	{ "RPMLOG_UUCP", RPMLOG_UUCP }, 
	{ "RPMLOG_CRON", RPMLOG_CRON }, 
	{ "RPMLOG_AUTHPRIV", RPMLOG_AUTHPRIV }, 
	{ "RPMLOG_FTP", RPMLOG_FTP }, 
	{ "RPMLOG_LOCAL0", RPMLOG_LOCAL0 }, 
	{ "RPMLOG_LOCAL1", RPMLOG_LOCAL1 }, 
	{ "RPMLOG_LOCAL2", RPMLOG_LOCAL2 }, 
	{ "RPMLOG_LOCAL3", RPMLOG_LOCAL3 }, 
	{ "RPMLOG_LOCAL4", RPMLOG_LOCAL4 }, 
	{ "RPMLOG_LOCAL5", RPMLOG_LOCAL5 }, 
	{ "RPMLOG_LOCAL6", RPMLOG_LOCAL6 }, 
	{ "RPMLOG_LOCAL7", RPMLOG_LOCAL7 }, 
	{ "RPMLOG_NFACILITIES", RPMLOG_NFACILITIES }, /*!< current number of facilities */
	{ "RPMLOG_ERRMSG", RPMLOG_ERRMSG }, 
	{ "RPMLOG_FACMASK", RPMLOG_FACMASK }, /*!< mask to extract facility part */
	{ "RPMLOG_ODELAY", RPMLOG_ODELAY }, /*!< delay open until first syslog() (default) */
	{ "RPMLOG_NDELAY", RPMLOG_NDELAY }, /*!< don't delay open */
	{ "RPMLOG_PID", RPMLOG_PID }, /*!< log the pid with each message */
	{ "RPMLOG_CONS", RPMLOG_CONS }, /*!< log on the console if errors in sending */
	{ "RPMLOG_NOWAIT", RPMLOG_NOWAIT }, /*!< don't wait for console forks: DEPRECATED */
	{ "RPMLOG_PERROR", RPMLOG_PERROR }, /*!< log to stderr as well */
	{ "RPMLOG_DEFAULT", RPMLOG_DEFAULT }, /*!< perform default logging */
	{ "RPMLOG_EXIT", RPMLOG_EXIT }, /*!< exit after logging */
#endif /* H_RPMLOG */
	{ NULL, 0 } /* NULL terminated (rpmlog) */
};
const struct rpmconstant_s * rpmlogctable = rpmlogctbl;


/* From rpmmacro.h
 * prefix tag: RMIL_
 * table: rpmMacrosContext */
static const struct rpmconstant_s rpmMacrosContextctbl[] = {
#ifdef _H_MACRO_
	{ "RMIL_DEFAULT", RMIL_DEFAULT }, 
	{ "RMIL_MACROFILES", RMIL_MACROFILES }, 
	{ "RMIL_RPMRC", RMIL_RPMRC }, 
	{ "RMIL_CMDLINE", RMIL_CMDLINE }, 
	{ "RMIL_TARBALL", RMIL_TARBALL }, 
	{ "RMIL_SPEC", RMIL_SPEC }, 
	{ "RMIL_OLDSPEC", RMIL_OLDSPEC }, 
	{ "RMIL_GLOBAL", RMIL_GLOBAL }, 
#endif /* _H_MACRO_ */
	{ NULL, 0 } /* NULL terminated (rpmMacrosContext) */
};
const struct rpmconstant_s * rpmMacrosContextctable = rpmMacrosContextctbl;

static const struct rpmconstantlist_s rpmconstanttp[] = {
	{ (void *)rpmBuildFlagsctbl, "rpmbuildflags", "RPMBUILD_" },
	{ (void *)rpmElementTypectbl, "rpmelementtype", "TR_" },
	{ (void *)rpmMacrosContextctbl, "rpmmacroscontext", "RMIL_" },
	{ (void *)rpmParseStatectbl, "rpmparsestate", "PART_" },
	{ (void *)rpmProblemTypectbl, "rpmproblemtype", "RPMPROB_" },
	{ (void *)rpmRCctbl, "rpmrc", "RPMRC_" },
	{ (void *)rpmSignFlagsctbl, "rpmsignflags", "RPMSIGN_" },
	{ (void *)rpmTagctbl, "rpmtag", "RPMTAG_" },
	{ (void *)rpmTagTypectbl, "rpmtagtype", "RPM_" },
	{ (void *)rpmVerifyFlagsctbl, "rpmverifyflags", "VERIFY_" },
	{ (void *)rpm_machtablectbl, "rpm_machtable", "RPM_MACHTABLE_" },
	{ (void *)rpmlogctbl, "rpmlog", "RPMLOG_" },
	{ (void *)rpmtsOpXctbl, "rpmtsopx", "RPMTS_OP_" },
	{ (void *)rpmtsTypectbl, "rpmtstype", "RPMTRANS_TYPE_" },
	{ (void *) NULL, NULL, NULL } /* NULL terminated */
};
const struct rpmconstantlist_s * rpmconstanttype = rpmconstanttp;
const int rpmconstanttypesize = sizeof(rpmconstanttp) / sizeof(rpmconstanttp[0]) -1;
