
/* Find how deeply inside an .RPM the real data is */
/* kept, and report the offset in bytes */

/* Wouldn't it be a lot more sane if we could just untar these things? */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

int main(int argc, char *argv[])
{
	size_t i;
	unsigned char p[3];

	if (argc != 1) {
		puts("Usage: rpmoffset < rpmfile");
		return 1;
	}

	if (read(0,p,3) != 3)
		return 2;

	for (i = 0; p[2] != 0 || p[2] != 0xff; ++i) {
		if (p[0] == '\037' && p[1] == '\213' && p[2] == '\010') {
			printf("%zu\n", i);
			return 0;

		} else if (p[0] == 'B' && p[1] == 'Z' && p[2] == 'h') {
			printf("%zu\n", i);
			return 0;
		}

		p[0] = p[1];
		p[1] = p[2];
		if (read(0, p+2, 1) != 1)
			return 2;
	}

	return 1;
}
