/*
 * RProjectFile.hpp
 *
 * Copyright (C) 2009-12 by RStudio, Inc.
 *
 * Unless you have received this program directly from RStudio pursuant
 * to the terms of a commercial license agreement with RStudio, then
 * this program is licensed to you under the terms of version 3 of the
 * GNU Affero General Public License. This program is distributed WITHOUT
 * ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF NON-INFRINGEMENT,
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Please refer to the
 * AGPL (http://www.gnu.org/licenses/agpl-3.0.txt) for more details.
 *
 */

#ifndef CORE_R_UTIL_R_PROJECT_FILE_HPP
#define CORE_R_UTIL_R_PROJECT_FILE_HPP

#include <string>
#include <iosfwd>

#include <core/r_util/RVersionInfo.hpp>

namespace rstudio {
namespace core {

class Error;
class FilePath;

namespace r_util {

enum YesNoAskValue
{
   DefaultValue = 0,
   YesValue = 1,
   NoValue = 2,
   AskValue = 3
};

extern const int kLineEndingsUseDefault;

extern const char * const kBuildTypeNone;
extern const char * const kBuildTypePackage;
extern const char * const kBuildTypeMakefile;
extern const char * const kBuildTypeWebsite;
extern const char * const kBuildTypeCustom;

std::ostream& operator << (std::ostream& stream, const YesNoAskValue& val);

struct RProjectBuildDefaults
{
   RProjectBuildDefaults()
      : useDevtools(true)
   {
   }
   bool useDevtools;
};

struct RProjectConfig
{
   RProjectConfig()
      : version(1.0),
        rVersion(kRVersionDefault),
        saveWorkspace(DefaultValue),
        restoreWorkspace(DefaultValue),
        alwaysSaveHistory(DefaultValue),
        enableCodeIndexing(true),
        useSpacesForTab(true),
        numSpacesForTab(2),
        autoAppendNewline(false),
        stripTrailingWhitespace(false),
        lineEndings(kLineEndingsUseDefault),
        encoding(),
        defaultSweaveEngine(),
        defaultLatexProgram(),
        rootDocument(),
        buildType(),
        packagePath(),
        packageInstallArgs(),
        packageBuildArgs(),
        packageBuildBinaryArgs(),
        packageCheckArgs(),
        packageRoxygenize(),
        packageUseDevtools(false),
        makefilePath(),
        websitePath(),
        customScriptPath(),
        tutorialPath(),
        quitChildProcessesOnExit(DefaultValue),
        defaultOpenDocs()
   {
   }

   double version;
   RVersionInfo rVersion;
   int saveWorkspace;
   int restoreWorkspace;
   int alwaysSaveHistory;
   bool enableCodeIndexing;
   bool useSpacesForTab;
   int numSpacesForTab;
   bool autoAppendNewline;
   bool stripTrailingWhitespace;
   int lineEndings;
   std::string encoding;
   std::string defaultSweaveEngine;
   std::string defaultLatexProgram;
   std::string rootDocument;
   std::string buildType;
   std::string packagePath;
   std::string packageInstallArgs;
   std::string packageBuildArgs;
   std::string packageBuildBinaryArgs;
   std::string packageCheckArgs;
   std::string packageRoxygenize;
   bool packageUseDevtools;
   std::string makefilePath;
   std::string websitePath;
   std::string customScriptPath;
   std::string tutorialPath;
   int quitChildProcessesOnExit;
   std::string defaultOpenDocs;
};

Error findProjectFile(FilePath filePath,
                      FilePath anchorPath,
                      FilePath* pProjPath);

Error findProjectConfig(FilePath filePath,
                        const FilePath& anchorPath,
                        RProjectConfig* pConfig);

Error readProjectFile(const FilePath& projectFilePath,
                      RProjectConfig* pConfig,
                      std::string* pUserErrMsg);

Error readProjectFile(const FilePath& projectFilePath,
                      const RProjectConfig& defaultConfig,
                      const RProjectBuildDefaults& buildDefaults,
                      RProjectConfig* pConfig,
                      bool* pProvidedDefaults,
                      std::string* pUserErrMsg);

Error writeProjectFile(const FilePath& projectFilePath,
                       const RProjectBuildDefaults& buildDefaults,
                       const RProjectConfig& config);

FilePath projectFromDirectory(const FilePath& directoryPath);

// update the package install args default (only if it is set to
// the previous default value)
bool updateSetPackageInstallArgsDefault(RProjectConfig* pConfig);

// indicate whether the given directory is an R Markdown website
bool isWebsiteDirectory(const FilePath& projectDir);

} // namespace r_util
} // namespace core 
} // namespace rstudio


#endif // CORE_R_UTIL_R_PROJECT_FILE_HPP

