Object.assign(window.search, {"doc_urls":["what-is-rustdoc.html#what-is-rustdoc","what-is-rustdoc.html#basic-usage","what-is-rustdoc.html#configuring-rustdoc","what-is-rustdoc.html#using-rustdoc-with-cargo","what-is-rustdoc.html#outer-and-inner-documentation","what-is-rustdoc.html#using-standalone-markdown-files","what-is-rustdoc.html#summary","how-to-write-documentation.html#how-to-write-documentation","how-to-write-documentation.html#getting-started","how-to-write-documentation.html#documenting-components","how-to-write-documentation.html#markdown","how-to-write-documentation.html#strikethrough","how-to-write-documentation.html#footnotes","how-to-write-documentation.html#tables","how-to-write-documentation.html#task-lists","how-to-write-documentation.html#smart-punctuation","what-to-include.html#what-to-include-and-exclude","what-to-include.html#examples","what-to-include.html#what-to-exclude","what-to-include.html#customizing-the-output","command-line-arguments.html#command-line-arguments","command-line-arguments.html#-h--help-help","command-line-arguments.html#-v--version-version-information","command-line-arguments.html#-v--verbose-more-verbose-output","command-line-arguments.html#-o--output-output-path","command-line-arguments.html#--crate-name-controlling-the-name-of-the-crate","command-line-arguments.html#--document-private-items-show-items-that-are-not-public","command-line-arguments.html#-l--library-path-where-to-look-for-dependencies","command-line-arguments.html#--cfg-passing-configuration-flags","command-line-arguments.html#--extern-specify-a-dependencys-location","command-line-arguments.html#-c--codegen-pass-codegen-options-to-rustc","command-line-arguments.html#--test-run-code-examples-as-tests","command-line-arguments.html#--test-args-pass-options-to-test-runner","command-line-arguments.html#--target-generate-documentation-for-the-specified-target-triple","command-line-arguments.html#--default-theme-set-the-default-theme","command-line-arguments.html#--markdown-css-include-more-css-files-when-rendering-markdown","command-line-arguments.html#--html-in-header-include-more-html-in","command-line-arguments.html#--html-before-content-include-more-html-before-the-content","command-line-arguments.html#--html-after-content-include-more-html-after-the-content","command-line-arguments.html#--markdown-playground-url-control-the-location-of-the-playground","command-line-arguments.html#--markdown-no-toc-dont-generate-a-table-of-contents","command-line-arguments.html#-e--extend-css-extend-rustdocs-css","command-line-arguments.html#--sysroot-override-the-system-root","command-line-arguments.html#--edition-control-the-edition-of-docs-and-doctests","command-line-arguments.html#--theme-add-a-theme-to-the-documentation-output","command-line-arguments.html#--check-theme-verify-custom-themes-against-the-default-theme","command-line-arguments.html#--crate-version-control-the-crate-version","command-line-arguments.html#path-load-command-line-flags-from-a-path","command-line-arguments.html#--passes-add-more-rustdoc-passes","command-line-arguments.html#--no-defaults-dont-run-default-passes","command-line-arguments.html#-r--input-format-input-format","the-doc-attribute.html#the-doc-attribute","the-doc-attribute.html#at-the-crate-level","the-doc-attribute.html#html_favicon_url","the-doc-attribute.html#html_logo_url","the-doc-attribute.html#html_playground_url","the-doc-attribute.html#issue_tracker_base_url","the-doc-attribute.html#html_root_url","the-doc-attribute.html#html_no_source","the-doc-attribute.html#testno_crate_inject","the-doc-attribute.html#testattr","the-doc-attribute.html#at-the-item-level","the-doc-attribute.html#docno_inlinedocinline","the-doc-attribute.html#dochidden","the-doc-attribute.html#docprimitive","documentation-tests.html#documentation-tests","documentation-tests.html#passing-or-failing-a-doctest","documentation-tests.html#pre-processing-examples","documentation-tests.html#hiding-portions-of-the-example","documentation-tests.html#using--in-doc-tests","documentation-tests.html#documenting-macros","documentation-tests.html#attributes","documentation-tests.html#syntax-reference","documentation-tests.html#include-items-only-when-collecting-doctests","linking-to-items-by-name.html#linking-to-items-by-name","linking-to-items-by-name.html#valid-links","linking-to-items-by-name.html#namespaces-and-disambiguators","linking-to-items-by-name.html#warnings-re-exports-and-scoping","lints.html#lints","lints.html#broken_intra_doc_links","lints.html#private_intra_doc_links","lints.html#missing_docs","lints.html#missing_crate_level_docs","lints.html#missing_doc_code_examples","lints.html#private_doc_tests","lints.html#invalid_codeblock_attributes","lints.html#invalid_html_tags","lints.html#invalid_rust_codeblocks","lints.html#bare_urls","advanced-features.html#advanced-features","advanced-features.html#cfgdoc-documenting-platform-specific-or-feature-specific-information","advanced-features.html#interactions-between-platform-specific-docs","advanced-features.html#add-aliases-for-an-item-in-documentation-search","unstable-features.html#unstable-features","unstable-features.html#nightly-gated-functionality","unstable-features.html#error-numbers-for-compile-fail-doctests","unstable-features.html#extensions-to-the-doc-attribute","unstable-features.html#doccfg-recording-what-platforms-or-features-are-required-for-code-to-be-present","unstable-features.html#adding-your-trait-to-the-notable-traits-dialog","unstable-features.html#exclude-certain-dependencies-from-documentation","unstable-features.html#unstable-command-line-arguments","unstable-features.html#--markdown-before-content-include-rendered-markdown-before-the-content","unstable-features.html#--markdown-after-content-include-rendered-markdown-after-the-content","unstable-features.html#--playground-url-control-the-location-of-the-playground","unstable-features.html#--sort-modules-by-appearance-control-how-items-on-module-pages-are-sorted","unstable-features.html#--resource-suffix-modifying-the-name-of-cssjavascript-in-crate-docs","unstable-features.html#--display-warnings-display-warnings-when-documenting-or-running-documentation-tests","unstable-features.html#--extern-html-root-url-control-how-rustdoc-links-to-non-local-crates","unstable-features.html#-z-force-unstable-if-unmarked","unstable-features.html#--index-page-provide-a-top-level-landing-page-for-docs","unstable-features.html#--enable-index-page-generate-a-default-index-page-for-docs","unstable-features.html#--static-root-path-control-how-static-files-are-loaded-in-html-output","unstable-features.html#--persist-doctests-persist-doctest-executables-after-running","unstable-features.html#--show-coverage-calculate-the-percentage-of-items-with-documentation","unstable-features.html#-w--output-format-output-format","unstable-features.html#--enable-per-target-ignores-allow-ignore-foo-style-filters-for-doctests","unstable-features.html#--runtool---runtool-arg-program-to-run-tests-with-args-to-pass-to-it","unstable-features.html#--show-coverage-get-statistics-about-code-documentation-coverage","passes.html#passes","references.html#references","references.html#official","references.html#community"],"index":{"documentStore":{"docInfo":{"0":{"body":25,"breadcrumbs":2,"title":1},"1":{"body":57,"breadcrumbs":3,"title":2},"10":{"body":25,"breadcrumbs":3,"title":1},"100":{"body":32,"breadcrumbs":6,"title":4},"101":{"body":53,"breadcrumbs":10,"title":8},"102":{"body":49,"breadcrumbs":8,"title":6},"103":{"body":96,"breadcrumbs":7,"title":5},"104":{"body":37,"breadcrumbs":10,"title":8},"105":{"body":43,"breadcrumbs":9,"title":7},"106":{"body":43,"breadcrumbs":10,"title":8},"107":{"body":69,"breadcrumbs":12,"title":10},"108":{"body":41,"breadcrumbs":6,"title":4},"109":{"body":30,"breadcrumbs":10,"title":8},"11":{"body":25,"breadcrumbs":3,"title":1},"110":{"body":9,"breadcrumbs":10,"title":8},"111":{"body":70,"breadcrumbs":11,"title":9},"112":{"body":36,"breadcrumbs":8,"title":6},"113":{"body":110,"breadcrumbs":8,"title":6},"114":{"body":56,"breadcrumbs":7,"title":5},"115":{"body":81,"breadcrumbs":12,"title":10},"116":{"body":49,"breadcrumbs":10,"title":8},"117":{"body":79,"breadcrumbs":8,"title":6},"118":{"body":42,"breadcrumbs":2,"title":1},"119":{"body":12,"breadcrumbs":2,"title":1},"12":{"body":58,"breadcrumbs":3,"title":1},"120":{"body":17,"breadcrumbs":2,"title":1},"121":{"body":18,"breadcrumbs":2,"title":1},"13":{"body":36,"breadcrumbs":3,"title":1},"14":{"body":24,"breadcrumbs":4,"title":2},"15":{"body":21,"breadcrumbs":4,"title":2},"16":{"body":108,"breadcrumbs":4,"title":2},"17":{"body":116,"breadcrumbs":3,"title":1},"18":{"body":40,"breadcrumbs":3,"title":1},"19":{"body":53,"breadcrumbs":4,"title":2},"2":{"body":90,"breadcrumbs":3,"title":2},"20":{"body":5,"breadcrumbs":6,"title":3},"21":{"body":27,"breadcrumbs":6,"title":3},"22":{"body":18,"breadcrumbs":7,"title":4},"23":{"body":50,"breadcrumbs":8,"title":5},"24":{"body":26,"breadcrumbs":7,"title":4},"25":{"body":25,"breadcrumbs":8,"title":5},"26":{"body":40,"breadcrumbs":9,"title":6},"27":{"body":34,"breadcrumbs":8,"title":5},"28":{"body":23,"breadcrumbs":7,"title":4},"29":{"body":28,"breadcrumbs":7,"title":4},"3":{"body":75,"breadcrumbs":4,"title":3},"30":{"body":91,"breadcrumbs":9,"title":6},"31":{"body":19,"breadcrumbs":8,"title":5},"32":{"body":24,"breadcrumbs":9,"title":6},"33":{"body":28,"breadcrumbs":9,"title":6},"34":{"body":54,"breadcrumbs":8,"title":5},"35":{"body":31,"breadcrumbs":11,"title":8},"36":{"body":22,"breadcrumbs":8,"title":5},"37":{"body":30,"breadcrumbs":11,"title":8},"38":{"body":27,"breadcrumbs":9,"title":6},"39":{"body":23,"breadcrumbs":9,"title":6},"4":{"body":52,"breadcrumbs":4,"title":3},"40":{"body":20,"breadcrumbs":9,"title":6},"41":{"body":30,"breadcrumbs":9,"title":6},"42":{"body":17,"breadcrumbs":7,"title":4},"43":{"body":33,"breadcrumbs":8,"title":5},"44":{"body":47,"breadcrumbs":8,"title":5},"45":{"body":59,"breadcrumbs":11,"title":8},"46":{"body":27,"breadcrumbs":8,"title":5},"47":{"body":29,"breadcrumbs":9,"title":6},"48":{"body":7,"breadcrumbs":8,"title":5},"49":{"body":7,"breadcrumbs":8,"title":5},"5":{"body":46,"breadcrumbs":5,"title":4},"50":{"body":24,"breadcrumbs":8,"title":5},"51":{"body":120,"breadcrumbs":4,"title":2},"52":{"body":6,"breadcrumbs":4,"title":2},"53":{"body":22,"breadcrumbs":3,"title":1},"54":{"body":26,"breadcrumbs":3,"title":1},"55":{"body":25,"breadcrumbs":3,"title":1},"56":{"body":28,"breadcrumbs":3,"title":1},"57":{"body":50,"breadcrumbs":3,"title":1},"58":{"body":10,"breadcrumbs":3,"title":1},"59":{"body":12,"breadcrumbs":3,"title":1},"6":{"body":11,"breadcrumbs":2,"title":1},"60":{"body":16,"breadcrumbs":3,"title":1},"61":{"body":8,"breadcrumbs":4,"title":2},"62":{"body":153,"breadcrumbs":3,"title":1},"63":{"body":10,"breadcrumbs":3,"title":1},"64":{"body":19,"breadcrumbs":3,"title":1},"65":{"body":63,"breadcrumbs":4,"title":2},"66":{"body":37,"breadcrumbs":5,"title":3},"67":{"body":89,"breadcrumbs":5,"title":3},"68":{"body":227,"breadcrumbs":5,"title":3},"69":{"body":138,"breadcrumbs":5,"title":3},"7":{"body":64,"breadcrumbs":4,"title":2},"70":{"body":76,"breadcrumbs":4,"title":2},"71":{"body":132,"breadcrumbs":3,"title":1},"72":{"body":72,"breadcrumbs":4,"title":2},"73":{"body":158,"breadcrumbs":6,"title":4},"74":{"body":68,"breadcrumbs":6,"title":3},"75":{"body":84,"breadcrumbs":5,"title":2},"76":{"body":56,"breadcrumbs":5,"title":2},"77":{"body":113,"breadcrumbs":7,"title":4},"78":{"body":40,"breadcrumbs":2,"title":1},"79":{"body":79,"breadcrumbs":2,"title":1},"8":{"body":213,"breadcrumbs":4,"title":2},"80":{"body":90,"breadcrumbs":2,"title":1},"81":{"body":35,"breadcrumbs":2,"title":1},"82":{"body":49,"breadcrumbs":2,"title":1},"83":{"body":51,"breadcrumbs":2,"title":1},"84":{"body":37,"breadcrumbs":2,"title":1},"85":{"body":65,"breadcrumbs":2,"title":1},"86":{"body":51,"breadcrumbs":2,"title":1},"87":{"body":64,"breadcrumbs":2,"title":1},"88":{"body":44,"breadcrumbs":2,"title":1},"89":{"body":8,"breadcrumbs":4,"title":2},"9":{"body":227,"breadcrumbs":4,"title":2},"90":{"body":108,"breadcrumbs":9,"title":7},"91":{"body":99,"breadcrumbs":7,"title":5},"92":{"body":51,"breadcrumbs":7,"title":5},"93":{"body":44,"breadcrumbs":4,"title":2},"94":{"body":25,"breadcrumbs":5,"title":3},"95":{"body":66,"breadcrumbs":7,"title":5},"96":{"body":12,"breadcrumbs":5,"title":3},"97":{"body":110,"breadcrumbs":9,"title":7},"98":{"body":87,"breadcrumbs":7,"title":5},"99":{"body":82,"breadcrumbs":6,"title":4}},"docs":{"0":{"body":"The standard Rust distribution ships with a tool called rustdoc. Its job is to generate documentation for Rust projects. On a fundamental level, Rustdoc takes as an argument either a crate root or a Markdown file, and produces HTML, CSS, and JavaScript.","breadcrumbs":"What is rustdoc? » What is rustdoc?","id":"0","title":"What is rustdoc?"},"1":{"body":"Let's give it a try! Create a new project with Cargo: $ cargo new docs --lib\n$ cd docs In src/lib.rs, Cargo has generated some sample code. Delete it and replace it with this: /// foo is a function\nfn foo() {} Let's run rustdoc on our code. To do so, we can call it with the path to our crate root like this: $ rustdoc src/lib.rs This will create a new directory, doc, with a website inside! In our case, the main page is located in doc/lib/index.html. If you open that up in a web browser, you will see a page with a search bar, and \"Crate lib\" at the top, with no contents.","breadcrumbs":"What is rustdoc? » Basic usage","id":"1","title":"Basic usage"},"10":{"body":"rustdoc uses the CommonMark Markdown specification . You might be interested in taking a look at their website to see what's possible: CommonMark quick reference current spec In addition to the standard CommonMark syntax, rustdoc supports several extensions:","breadcrumbs":"How to write documentation » Markdown","id":"10","title":"Markdown"},"100":{"body":"These features are enabled by passing a command-line flag to Rustdoc, but the flags in question are themselves marked as unstable. To use any of these options, pass -Z unstable-options as well as the flag in question to Rustdoc on the command-line. To do this from Cargo, you can either use the RUSTDOCFLAGS environment variable or the cargo rustdoc command.","breadcrumbs":"Unstable features » Unstable command-line arguments","id":"100","title":"Unstable command-line arguments"},"101":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --markdown-before-content extra.md\n$ rustdoc README.md -Z unstable-options --markdown-before-content extra.md Just like --html-before-content, this allows you to insert extra content inside the <body> tag but before the other content rustdoc would normally produce in the rendered documentation. However, instead of directly inserting the file verbatim, rustdoc will pass the files through a Markdown renderer before inserting the result into the file.","breadcrumbs":"Unstable features » --markdown-before-content: include rendered Markdown before the content","id":"101","title":"--markdown-before-content: include rendered Markdown before the content"},"102":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --markdown-after-content extra.md\n$ rustdoc README.md -Z unstable-options --markdown-after-content extra.md Just like --html-after-content, this allows you to insert extra content before the </body> tag but after the other content rustdoc would normally produce in the rendered documentation. However, instead of directly inserting the file verbatim, rustdoc will pass the files through a Markdown renderer before inserting the result into the file.","breadcrumbs":"Unstable features » --markdown-after-content: include rendered Markdown after the content","id":"102","title":"--markdown-after-content: include rendered Markdown after the content"},"103":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --playground-url https://play.rust-lang.org/ When rendering a crate's docs, this flag gives the base URL of the Rust Playground, to use for generating Run buttons. Unlike --markdown-playground-url, this argument works for standalone Markdown files and Rust crates. This works the same way as adding #![doc(html_playground_url = \"url\")] to your crate root, as mentioned in the chapter about the #[doc] attribute . Please be aware that the official Rust Playground at https://play.rust-lang.org does not have every crate available, so if your examples require your crate, make sure the playground you provide has your crate available. If both --playground-url and --markdown-playground-url are present when rendering a standalone Markdown file, the URL given to --markdown-playground-url will take precedence. If both --playground-url and #![doc(html_playground_url = \"url\")] are present when rendering crate docs, the attribute will take precedence.","breadcrumbs":"Unstable features » --playground-url: control the location of the playground","id":"103","title":"--playground-url: control the location of the playground"},"104":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --sort-modules-by-appearance Ordinarily, when rustdoc prints items in module pages, it will sort them alphabetically (taking some consideration for their stability, and names that end in a number). Giving this flag to rustdoc will disable this sorting and instead make it print the items in the order they appear in the source.","breadcrumbs":"Unstable features » --sort-modules-by-appearance: control how items on module pages are sorted","id":"104","title":"--sort-modules-by-appearance: control how items on module pages are sorted"},"105":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --resource-suffix suf When rendering docs, rustdoc creates several CSS and JavaScript files as part of the output. Since all these files are linked from every page, changing where they are can be cumbersome if you need to specially cache them. This flag will rename all these files in the output to include the suffix in the filename. For example, light.css would become light-suf.css with the above command.","breadcrumbs":"Unstable features » --resource-suffix: modifying the name of CSS/JavaScript in crate docs","id":"105","title":"--resource-suffix: modifying the name of CSS/JavaScript in crate docs"},"106":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --display-warnings\n$ rustdoc --test src/lib.rs -Z unstable-options --display-warnings The intent behind this flag is to allow the user to see warnings that occur within their library or their documentation tests, which are usually suppressed. However, due to a bug , this flag doesn't 100% work as intended. See the linked issue for details.","breadcrumbs":"Unstable features » --display-warnings: display warnings when documenting or running documentation tests","id":"106","title":"--display-warnings: display warnings when documenting or running documentation tests"},"107":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --extern-html-root-url some-crate=https://example.com/some-crate/1.0.1 Ordinarily, when rustdoc wants to link to a type from a different crate, it looks in two places: docs that already exist in the output directory, or the #![doc(doc_html_root)] set in the other crate. However, if you want to link to docs that exist in neither of those places, you can use these flags to control that behavior. When the --extern-html-root-url flag is given with a name matching one of your dependencies, rustdoc use that URL for those docs. Keep in mind that if those docs exist in the output directory, those local docs will still override this flag.","breadcrumbs":"Unstable features » --extern-html-root-url: control how rustdoc links to non-local crates","id":"107","title":"--extern-html-root-url: control how rustdoc links to non-local crates"},"108":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z force-unstable-if-unmarked This is an internal flag intended for the standard library and compiler that applies an #[unstable] attribute to any dependent crate that doesn't have another stability attribute. This allows rustdoc to be able to generate documentation for the compiler crates and the standard library, as an equivalent command-line argument is provided to rustc when building those crates.","breadcrumbs":"Unstable features » -Z force-unstable-if-unmarked","id":"108","title":"-Z force-unstable-if-unmarked"},"109":{"body":"This feature allows you to generate an index-page with a given markdown file. A good example of it is the rust documentation index . With this, you'll have a page which you can custom as much as you want at the top of your crates. Using index-page option enables enable-index-page option as well.","breadcrumbs":"Unstable features » --index-page: provide a top-level landing page for docs","id":"109","title":"--index-page: provide a top-level landing page for docs"},"11":{"body":"Text may be rendered with a horizontal line through the center by wrapping the text with two tilde characters on each side: An example of ~~strikethrough text~~. This example will render as: An example of strikethrough text . This follows the GitHub Strikethrough extension .","breadcrumbs":"How to write documentation » Strikethrough","id":"11","title":"Strikethrough"},"110":{"body":"This feature allows the generation of a default index-page which lists the generated crates.","breadcrumbs":"Unstable features » --enable-index-page: generate a default index page for docs","id":"110","title":"--enable-index-page: generate a default index page for docs"},"111":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --static-root-path '/cache/' This flag controls how rustdoc links to its static files on HTML pages. If you're hosting a lot of crates' docs generated by the same version of rustdoc, you can use this flag to cache rustdoc's CSS, JavaScript, and font files in a single location, rather than duplicating it once per \"doc root\" (grouping of crate docs generated into the same output directory, like with cargo doc). Per-crate files like the search index will still load from the documentation root, but anything that gets renamed with --resource-suffix will load from the given path.","breadcrumbs":"Unstable features » --static-root-path: control how static files are loaded in HTML output","id":"111","title":"--static-root-path: control how static files are loaded in HTML output"},"112":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --test -Z unstable-options --persist-doctests target/rustdoctest This flag allows you to keep doctest executables around after they're compiled or run. Usually, rustdoc will immediately discard a compiled doctest after it's been tested, but with this option, you can keep those binaries around for farther testing.","breadcrumbs":"Unstable features » --persist-doctests: persist doctest executables after running","id":"112","title":"--persist-doctests: persist doctest executables after running"},"113":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --show-coverage If you want to determine how many items in your crate are documented, pass this flag to rustdoc. When it receives this flag, it will count the public items in your crate that have documentation, and print out the counts and a percentage instead of generating docs. Some methodology notes about what rustdoc counts in this metric: Rustdoc will only count items from your crate (i.e. items re-exported from other crates don't count). Docs written directly onto inherent impl blocks are not counted, even though their doc comments are displayed, because the common pattern in Rust code is to write all inherent methods into the same impl block. Items in a trait implementation are not counted, as those impls will inherit any docs from the trait itself. By default, only public items are counted. To count private items as well, pass --document-private-items at the same time. Public items that are not documented can be seen with the built-in missing_docs lint. Private items that are not documented can be seen with Clippy's missing_docs_in_private_items lint.","breadcrumbs":"Unstable features » --show-coverage: calculate the percentage of items with documentation","id":"113","title":"--show-coverage: calculate the percentage of items with documentation"},"114":{"body":"When using --show-coverage , passing --output-format json will display the coverage information in JSON format. For example, here is the JSON for a file with one documented item and one undocumented item: /// This item has documentation\npub fn foo() {} pub fn no_documentation() {} {\"no_std.rs\":{\"total\":3,\"with_docs\":1,\"total_examples\":3,\"with_examples\":0}} Note that the third item is the crate root, which in this case is undocumented. When not using --show-coverage, --output-format json emits documentation in the experimental JSON format . --output-format html has no effect, and is also accepted on stable toolchains.","breadcrumbs":"Unstable features » -w/--output-format: output format","id":"114","title":"-w/--output-format: output format"},"115":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -Z unstable-options --enable-per-target-ignores This flag allows you to tag doctests with compiletest style ignore-foo filters that prevent rustdoc from running that test if the target triple string contains foo. For example: ///```ignore-foo,ignore-bar\n///assert!(2 == 2);\n///```\nstruct Foo; This will not be run when the build target is super-awesome-foo or less-bar-awesome. If the flag is not enabled, then rustdoc will consume the filter, but do nothing with it, and the above example will be run for all targets. If you want to preserve backwards compatibility for older versions of rustdoc, you can use ///```ignore,ignore-foo\n///assert!(2 == 2);\n///```\nstruct Foo; In older versions, this will be ignored on all targets, but on newer versions ignore-gnu will override ignore.","breadcrumbs":"Unstable features » --enable-per-target-ignores: allow ignore-foo style filters for doctests","id":"115","title":"--enable-per-target-ignores: allow ignore-foo style filters for doctests"},"116":{"body":"Using these options looks like this: $ rustdoc src/lib.rs -Z unstable-options --runtool runner --runtool-arg --do-thing --runtool-arg --do-other-thing These options can be used to run the doctest under a program, and also pass arguments to that program. For example, if you want to run your doctests under valgrind you might run $ rustdoc src/lib.rs -Z unstable-options --runtool valgrind Another use case would be to run a test inside an emulator, or through a Virtual Machine.","breadcrumbs":"Unstable features » --runtool, --runtool-arg: program to run tests with; args to pass to it","id":"116","title":"--runtool, --runtool-arg: program to run tests with; args to pass to it"},"117":{"body":"This option allows you to get a nice overview over your code documentation coverage, including both doc-comments and code examples in the doc-comments. Example: $ rustdoc src/lib.rs -Z unstable-options --show-coverage\n+-------------------------------------+------------+------------+------------+------------+\n| File | Documented | Percentage | Examples | Percentage |\n+-------------------------------------+------------+------------+------------+------------+\n| lib.rs | 4 | 100.0% | 1 | 25.0% |\n+-------------------------------------+------------+------------+------------+------------+\n| Total | 4 | 100.0% | 1 | 25.0% |\n+-------------------------------------+------------+------------+------------+------------+ You can also use this option with the --output-format one: $ rustdoc src/lib.rs -Z unstable-options --show-coverage --output-format json\n{\"lib.rs\":{\"total\":4,\"with_docs\":4,\"total_examples\":4,\"with_examples\":1}} Calculating code examples follows these rules: These items aren't accounted by default: struct/union field enum variant constant static typedef If one of the previously listed items has a code example, then it'll be counted.","breadcrumbs":"Unstable features » --show-coverage: get statistics about code documentation coverage","id":"117","title":"--show-coverage: get statistics about code documentation coverage"},"118":{"body":"Rustdoc has a concept called \"passes\". These are transformations that rustdoc runs on your documentation before producing its final output. Customizing passes is deprecated . The available passes are not considered stable and may change in any release. In the past the most common use case for customizing passes was to omit the strip-private pass. You can do this more easily, and without risk of the pass being changed, by passing --document-private-items .","breadcrumbs":"Passes » Passes","id":"118","title":"Passes"},"119":{"body":"There are many great rustdoc references out there. If you know of other great resources, please submit a pull request!","breadcrumbs":"References » References","id":"119","title":"References"},"12":{"body":"A footnote generates a small numbered link in the text which when clicked takes the reader to the footnote text at the bottom of the item. The footnote label is written similarly to a link reference with a caret at the front. The footnote text is written like a link reference definition, with the text following the label. Example: This is an example of a footnote[^note]. [^note]: This text is the contents of the footnote, which will be rendered towards the bottom. This example will render as: This is an example of a footnote [1] . This text is the contents of the footnote, which will be rendered towards the bottom. The footnotes are automatically numbered based on the order the footnotes are written.","breadcrumbs":"How to write documentation » Footnotes","id":"12","title":"Footnotes"},"120":{"body":"Learn Rust Rust By Example Rust Reference RFC 1574: More API Documentation Conventions RFC 1946: Intra Rustdoc Links","breadcrumbs":"References » Official","id":"120","title":"Official"},"121":{"body":"API Guidelines Github tagged RFCs Github tagged issues RFC (stalled) front page styleguide Guide on how to write documenation for a Rust crate","breadcrumbs":"References » Community","id":"121","title":"Community"},"13":{"body":"Tables can be written using pipes and dashes to draw the rows and columns of the table. These will be translated to HTML table matching the shape. Example: | Header1 | Header2 |\n|---------|---------|\n| abc | def | This example will render similarly to this: Header1 Header2 abc def See the specification for the GitHub Tables extension for more details on the exact syntax supported.","breadcrumbs":"How to write documentation » Tables","id":"13","title":"Tables"},"14":{"body":"Task lists can be used as a checklist of items that have been completed. Example: - [x] Complete task\n- [ ] Incomplete task This will render as: Complete task Incomplete task See the specification for the task list extension for more details.","breadcrumbs":"How to write documentation » Task lists","id":"14","title":"Task lists"},"15":{"body":"Some ASCII punctuation sequences will be automatically turned into fancy Unicode characters: ASCII sequence Unicode -- – --- — ... … \" “ or ”, depending on context ' ‘ or ’, depending on context So, no need to manually enter those Unicode characters!","breadcrumbs":"How to write documentation » Smart punctuation","id":"15","title":"Smart punctuation"},"16":{"body":"It is easy to say everything must be documented in a project and often times that is correct, but how can we get there, and are there things that don't belong? At the top of the src/lib.rs or main.rs file in your binary project, include the following attribute: #![warn(missing_docs)] Now run cargo doc and examine the output. Here's a sample: Documenting docdemo v0.1.0 (/Users/username/docdemo)\nwarning: missing documentation for the crate --> src/main.rs:1:1 |\n1 | / #![warn(missing_docs)]\n2 | |\n3 | | fn main() {\n4 | | println!(\"Hello, world!\");\n5 | | } | |_^ |\nnote: the lint level is defined here --> src/main.rs:1:9 |\n1 | #![warn(missing_docs)] | ^^^^^^^^^^^^ warning: 1 warning emitted Finished dev [unoptimized + debuginfo] target(s) in 2.96s As a library author, adding the lint #![deny(missing_docs)] is a great way to ensure the project does not drift away from being documented well, and #![warn(missing_docs)] is a good way to move towards comprehensive documentation. In addition to docs, #![deny(missing_doc_code_examples)] ensures each function contains a usage example. In our example above, the warning is resolved by adding crate level documentation. There are more lints in the upcoming chapter Lints .","breadcrumbs":"What to include (and exclude) » What to include (and exclude)","id":"16","title":"What to include (and exclude)"},"17":{"body":"Of course this is contrived to be simple, but part of the power of documentation is showing code that is easy to follow, rather than being realistic. Docs often take shortcuts with error handling because examples can become complicated to follow with all the necessary set up required for a simple example. Async is a good example of this. In order to execute an async example, an executor needs to be available. Examples will often shortcut this, and leave users to figure out how to put the async code into their own runtime. It is preferred that unwrap() not be used inside an example, and some of the error handling components be hidden if they make the example too difficult to follow. /// Example\n/// ```rust\n/// let fourtytwo = \"42\".parse::<u32>()?;\n/// println!(\"{} + 10 = {}\", fourtytwo, fourtytwo+10);\n/// ``` When rustdoc wraps that in a main function, it will fail to compile because the ParseIntError trait is not implemented. In order to help both your audience and your test suite, this example needs some additional code: /// Example\n/// ```rust\n/// # main() -> Result<(), std::num::ParseIntError> {\n/// let fortytwo = \"42\".parse::<u32>()?;\n/// println!(\"{} + 10 = {}\", fortytwo, fortytwo+10);\n/// # Ok(())\n/// # }\n/// ``` The example is the same on the doc page, but has that extra information available to anyone trying to use your crate. More about tests in the upcoming Documentation tests chapter.","breadcrumbs":"What to include (and exclude) » Examples","id":"17","title":"Examples"},"18":{"body":"Certain parts of your public interface may be included by default in the output of rustdoc. The attribute #[doc(hidden)] can hide implementation details to encourage idiomatic use of the crate. For example, an internal macro! that makes the crate easier to implement can become a footgun for users when it appears in the public documentation. An internal Error type may exist, and impl details should be hidden, as detailed in the API Guidelines .","breadcrumbs":"What to include (and exclude) » What to Exclude","id":"18","title":"What to Exclude"},"19":{"body":"It is possible to pass a custom css file to rustdoc and style the documentation. rustdoc --extend-css custom.css src/lib.rs A good example of using this feature to create a dark theme is documented on this blog . Just remember, dark theme is already included in the rustdoc output by clicking on the paintbrush. Adding additional options to the themes are as easy as creating a custom theme .css file and using the following syntax: rustdoc --theme awesome.css src/lib.rs Here is an example of a new theme, Ayu .","breadcrumbs":"What to include (and exclude) » Customizing the output","id":"19","title":"Customizing the output"},"2":{"body":"There are two problems with this: first, why does it think that our package is named \"lib\"? Second, why does it not have any contents? The first problem is due to rustdoc trying to be helpful; like rustc, it assumes that our crate's name is the name of the file for the crate root. To fix this, we can pass in a command-line flag: $ rustdoc src/lib.rs --crate-name docs Now, doc/docs/index.html will be generated, and the page says \"Crate docs.\" For the second issue, it is because our function foo is not public; rustdoc defaults to generating documentation for only public functions. If we change our code... /// foo is a function\npub fn foo() {} ... and then re-run rustdoc: $ rustdoc src/lib.rs --crate-name docs We now have some generated documentation. Open up doc/docs/index.html and check it out! It should show a link to the foo function's page, which is located at doc/docs/fn.foo.html. On that page, you'll see the \"foo is a function\" we put inside the documentation comment in our crate.","breadcrumbs":"What is rustdoc? » Configuring rustdoc","id":"2","title":"Configuring rustdoc"},"20":{"body":"Here's the list of arguments you can pass to rustdoc:","breadcrumbs":"Command-line arguments » Command-line arguments","id":"20","title":"Command-line arguments"},"21":{"body":"Using this flag looks like this: $ rustdoc -h\n$ rustdoc --help This will show rustdoc's built-in help, which largely consists of a list of possible command-line flags. Some of rustdoc's flags are unstable; this page only shows stable options, --help will show them all.","breadcrumbs":"Command-line arguments » -h/--help: help","id":"21","title":"-h/--help: help"},"22":{"body":"Using this flag looks like this: $ rustdoc -V\n$ rustdoc --version This will show rustdoc's version, which will look something like this: rustdoc 1.17.0 (56124baa9 2017-04-24)","breadcrumbs":"Command-line arguments » -V/--version: version information","id":"22","title":"-V/--version: version information"},"23":{"body":"Using this flag looks like this: $ rustdoc -v src/lib.rs\n$ rustdoc --verbose src/lib.rs This enables \"verbose mode\", which means that more information will be written to standard out. What is written depends on the other flags you've passed in. For example, with --version: $ rustdoc --verbose --version\nrustdoc 1.17.0 (56124baa9 2017-04-24)\nbinary: rustdoc\ncommit-hash: hash\ncommit-date: date\nhost: host-triple\nrelease: 1.17.0\nLLVM version: 3.9","breadcrumbs":"Command-line arguments » -v/--verbose: more verbose output","id":"23","title":"-v/--verbose: more verbose output"},"24":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -o target/doc\n$ rustdoc src/lib.rs --output target/doc By default, rustdoc's output appears in a directory named doc in the current working directory. With this flag, it will place all output into the directory you specify.","breadcrumbs":"Command-line arguments » -o/--output: output path","id":"24","title":"-o/--output: output path"},"25":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --crate-name mycrate By default, rustdoc assumes that the name of your crate is the same name as the .rs file. --crate-name lets you override this assumption with whatever name you choose.","breadcrumbs":"Command-line arguments » --crate-name: controlling the name of the crate","id":"25","title":"--crate-name: controlling the name of the crate"},"26":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --document-private-items By default, rustdoc only documents items that are publicly reachable. pub fn public() {} // this item is public and will documented\nmod private { // this item is private and will not be documented pub fn unreachable() {} // this item is public, but unreachable, so it will not be documented\n} --document-private-items documents all items, even if they're not public.","breadcrumbs":"Command-line arguments » --document-private-items: Show items that are not public","id":"26","title":"--document-private-items: Show items that are not public"},"27":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -L target/debug/deps\n$ rustdoc src/lib.rs --library-path target/debug/deps If your crate has dependencies, rustdoc needs to know where to find them. Passing --library-path gives rustdoc a list of places to look for these dependencies. This flag takes any number of directories as its argument, and will use all of them when searching.","breadcrumbs":"Command-line arguments » -L/--library-path: where to look for dependencies","id":"27","title":"-L/--library-path: where to look for dependencies"},"28":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --cfg feature=\"foo\" This flag accepts the same values as rustc --cfg, and uses it to configure compilation. The example above uses feature, but any of the cfg values are acceptable.","breadcrumbs":"Command-line arguments » --cfg: passing configuration flags","id":"28","title":"--cfg: passing configuration flags"},"29":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --extern lazy-static=/path/to/lazy-static Similar to --library-path, --extern is about specifying the location of a dependency. --library-path provides directories to search in, --extern instead lets you specify exactly which dependency is located where.","breadcrumbs":"Command-line arguments » --extern: specify a dependency's location","id":"29","title":"--extern: specify a dependency's location"},"3":{"body":"Cargo also has integration with rustdoc to make it easier to generate docs. Instead of the rustdoc command, we could have done this: $ cargo doc Internally, this calls out to rustdoc like this: $ rustdoc --crate-name docs src/lib.rs -o <path>/docs/target/doc -L\ndependency=<path>/docs/target/debug/deps You can see this with cargo doc --verbose. It generates the correct --crate-name for us, as well as pointing to src/lib.rs. But what about those other arguments? -o controls the o utput of our docs. Instead of a top-level doc directory, notice that Cargo puts generated documentation under target. That is the idiomatic place for generated files in Cargo projects. -L flag helps rustdoc find the dependencies your code relies on. If our project used dependencies, we would get documentation for them as well!","breadcrumbs":"What is rustdoc? » Using rustdoc with Cargo","id":"3","title":"Using rustdoc with Cargo"},"30":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -C target_feature=+avx\n$ rustdoc src/lib.rs --codegen target_feature=+avx $ rustdoc --test src/lib.rs -C target_feature=+avx\n$ rustdoc --test src/lib.rs --codegen target_feature=+avx $ rustdoc --test README.md -C target_feature=+avx\n$ rustdoc --test README.md --codegen target_feature=+avx When rustdoc generates documentation, looks for documentation tests, or executes documentation tests, it needs to compile some rust code, at least part-way. This flag allows you to tell rustdoc to provide some extra codegen options to rustc when it runs these compilations. Most of the time, these options won't affect a regular documentation run, but if something depends on target features to be enabled, or documentation tests need to use some additional options, this flag allows you to affect that. The arguments to this flag are the same as those for the -C flag on rustc. Run rustc -C help to get the full list.","breadcrumbs":"Command-line arguments » -C/--codegen: pass codegen options to rustc","id":"30","title":"-C/--codegen: pass codegen options to rustc"},"31":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --test This flag will run your code examples as tests. For more, see the chapter on documentation tests . See also --test-args.","breadcrumbs":"Command-line arguments » --test: run code examples as tests","id":"31","title":"--test: run code examples as tests"},"32":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --test --test-args ignored This flag will pass options to the test runner when running documentation tests. For more, see the chapter on documentation tests . See also --test.","breadcrumbs":"Command-line arguments » --test-args: pass options to test runner","id":"32","title":"--test-args: pass options to test runner"},"33":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --target x86_64-pc-windows-gnu Similar to the --target flag for rustc, this generates documentation for a target triple that's different than your host triple. All of the usual caveats of cross-compiling code apply.","breadcrumbs":"Command-line arguments » --target: generate documentation for the specified target triple","id":"33","title":"--target: generate documentation for the specified target triple"},"34":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --default-theme=ayu Sets the default theme (for users whose browser has not remembered a previous theme selection from the on-page theme picker). The supplied value should be the lowercase version of the theme name. The set of available themes can be seen in the theme picker in the generated output. Note that the set of available themes - and their appearance - is not necessarily stable from one rustdoc version to the next. If the requested theme does not exist, the builtin default (currently light) is used instead.","breadcrumbs":"Command-line arguments » --default-theme: set the default theme","id":"34","title":"--default-theme: set the default theme"},"35":{"body":"Using this flag looks like this: $ rustdoc README.md --markdown-css foo.css When rendering Markdown files, this will create a <link> element in the <head> section of the generated HTML. For example, with the invocation above, <link rel=\"stylesheet\" type=\"text/css\" href=\"foo.css\"> will be added. When rendering Rust files, this flag is ignored.","breadcrumbs":"Command-line arguments » --markdown-css: include more CSS files when rendering markdown","id":"35","title":"--markdown-css: include more CSS files when rendering markdown"},"36":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --html-in-header header.html\n$ rustdoc README.md --html-in-header header.html This flag takes a list of files, and inserts them into the <head> section of the rendered documentation.","breadcrumbs":"Command-line arguments » --html-in-header: include more HTML in","id":"36","title":"--html-in-header: include more HTML in"},"37":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --html-before-content extra.html\n$ rustdoc README.md --html-before-content extra.html This flag takes a list of files, and inserts them inside the <body> tag but before the other content rustdoc would normally produce in the rendered documentation.","breadcrumbs":"Command-line arguments » --html-before-content: include more HTML before the content","id":"37","title":"--html-before-content: include more HTML before the content"},"38":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --html-after-content extra.html\n$ rustdoc README.md --html-after-content extra.html This flag takes a list of files, and inserts them before the </body> tag but after the other content rustdoc would normally produce in the rendered documentation.","breadcrumbs":"Command-line arguments » --html-after-content: include more HTML after the content","id":"38","title":"--html-after-content: include more HTML after the content"},"39":{"body":"Using this flag looks like this: $ rustdoc README.md --markdown-playground-url https://play.rust-lang.org/ When rendering a Markdown file, this flag gives the base URL of the Rust Playground, to use for generating Run buttons.","breadcrumbs":"Command-line arguments » --markdown-playground-url: control the location of the playground","id":"39","title":"--markdown-playground-url: control the location of the playground"},"4":{"body":"The /// syntax is used to document the item present after it. That's why it is called an outer documentation. There is another syntax: //!, which is used to document the item it is present inside. It is called an inner documentation. It is often used when documenting the entire crate, because nothing comes before it: it is the root of the crate. So in order to document an entire crate, you need to use //! syntax. For example: //! This is my first rust crate When used in the crate root, it documents the item it is inside, which is the crate itself. For more information about the //! syntax, see the Book .","breadcrumbs":"What is rustdoc? » Outer and inner documentation","id":"4","title":"Outer and inner documentation"},"40":{"body":"Using this flag looks like this: $ rustdoc README.md --markdown-no-toc When generating documentation from a Markdown file, by default, rustdoc will generate a table of contents. This flag suppresses that, and no TOC will be generated.","breadcrumbs":"Command-line arguments » --markdown-no-toc: don't generate a table of contents","id":"40","title":"--markdown-no-toc: don't generate a table of contents"},"41":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs -e extra.css\n$ rustdoc src/lib.rs --extend-css extra.css With this flag, the contents of the files you pass are included at the bottom of Rustdoc's theme.css file. While this flag is stable, the contents of theme.css are not, so be careful! Updates may break your theme extensions.","breadcrumbs":"Command-line arguments » -e/--extend-css: extend rustdoc's CSS","id":"41","title":"-e/--extend-css: extend rustdoc's CSS"},"42":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --sysroot /path/to/sysroot Similar to rustc --sysroot, this lets you change the sysroot rustdoc uses when compiling your code.","breadcrumbs":"Command-line arguments » --sysroot: override the system root","id":"42","title":"--sysroot: override the system root"},"43":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --edition 2018\n$ rustdoc --test src/lib.rs --edition 2018 This flag allows rustdoc to treat your rust code as the given edition. It will compile doctests with the given edition as well. As with rustc, the default edition that rustdoc will use is 2015 (the first edition).","breadcrumbs":"Command-line arguments » --edition: control the edition of docs and doctests","id":"43","title":"--edition: control the edition of docs and doctests"},"44":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --theme /path/to/your/custom-theme.css rustdoc's default output includes two themes: light (the default) and dark. This flag allows you to add custom themes to the output. Giving a CSS file to this flag adds it to your documentation as an additional theme choice. The theme's name is determined by its filename; a theme file named custom-theme.css will add a theme named custom-theme to the documentation.","breadcrumbs":"Command-line arguments » --theme: add a theme to the documentation output","id":"44","title":"--theme: add a theme to the documentation output"},"45":{"body":"Using this flag looks like this: $ rustdoc --check-theme /path/to/your/custom-theme.css While rustdoc's HTML output is more-or-less consistent between versions, there is no guarantee that a theme file will have the same effect. The --theme flag will still allow you to add the theme to your documentation, but to ensure that your theme works as expected, you can use this flag to verify that it implements the same CSS rules as the official light theme. --check-theme is a separate mode in rustdoc. When rustdoc sees the --check-theme flag, it discards all other flags and only performs the CSS rule comparison operation.","breadcrumbs":"Command-line arguments » --check-theme: verify custom themes against the default theme","id":"45","title":"--check-theme: verify custom themes against the default theme"},"46":{"body":"Using this flag looks like this: $ rustdoc src/lib.rs --crate-version 1.3.37 When rustdoc receives this flag, it will print an extra \"Version (version)\" into the sidebar of the crate root's docs. You can use this flag to differentiate between different versions of your library's documentation.","breadcrumbs":"Command-line arguments » --crate-version: control the crate version","id":"46","title":"--crate-version: control the crate version"},"47":{"body":"If you specify @path on the command-line, then it will open path and read command line options from it. These options are one per line; a blank line indicates an empty option. The file can use Unix or Windows style line endings, and must be encoded as UTF-8.","breadcrumbs":"Command-line arguments » @path: load command-line flags from a path","id":"47","title":"@path: load command-line flags from a path"},"48":{"body":"This flag is deprecated . For more details on passes, see the chapter on them .","breadcrumbs":"Command-line arguments » --passes: add more rustdoc passes","id":"48","title":"--passes: add more rustdoc passes"},"49":{"body":"This flag is deprecated . For more details on passes, see the chapter on them .","breadcrumbs":"Command-line arguments » --no-defaults: don't run default passes","id":"49","title":"--no-defaults: don't run default passes"},"5":{"body":"rustdoc can also generate HTML from standalone Markdown files. Let' s give it a try: create a README.md file with these contents: # Docs This is a project to test out `rustdoc`. [Here is a link!](https://www.rust-lang.org) ## Example ```rust\nfn foo() -> i32 { 1 + 1\n}\n``` And call rustdoc on it: $ rustdoc README.md You will find an HTML file in docs/doc/README.html generated from its Markdown contents. Cargo currently does not understand standalone Markdown files, unfortunately.","breadcrumbs":"What is rustdoc? » Using standalone Markdown files","id":"5","title":"Using standalone Markdown files"},"50":{"body":"This flag is deprecated and has no effect . Rustdoc only supports Rust source code and Markdown input formats. If the file ends in .md or .markdown, rustdoc treats it as a Markdown file. Otherwise, it assumes that the input file is Rust.","breadcrumbs":"Command-line arguments » -r/--input-format: input format","id":"50","title":"-r/--input-format: input format"},"51":{"body":"The #[doc] attribute lets you control various aspects of how rustdoc does its job. The most basic function of #[doc] is to handle the actual documentation text. That is, /// is syntax sugar for #[doc]. This means that these two are the same: /// This is a doc comment.\n#[doc = \" This is a doc comment.\"]\n# fn f() {} (Note the leading space in the attribute version.) In most cases, /// is easier to use than #[doc]. One case where the latter is easier is when generating documentation in macros; the collapse-docs pass will combine multiple #[doc] attributes into a single doc comment, letting you generate code like this: #[doc = \"This is\"]\n#[doc = \" a \"]\n#[doc = \"doc comment\"]\n# fn f() {} Which can feel more flexible. Note that this would generate this: #[doc = \"This is\\n a \\ndoc comment\"]\n# fn f() {} but given that docs are rendered via Markdown, it will remove these newlines. Another use case is for including external files as documentation: #[doc = include_str!(\"../README.md\")]\n# fn f() {} The doc attribute has more options though! These don't involve the text of the output, but instead, various aspects of the presentation of the output. We've split them into two kinds below: attributes that are useful at the crate level, and ones that are useful at the item level.","breadcrumbs":"The #[doc] attribute » The #[doc] attribute","id":"51","title":"The #[doc] attribute"},"52":{"body":"These options control how the docs look at a crate level.","breadcrumbs":"The #[doc] attribute » At the crate level","id":"52","title":"At the crate level"},"53":{"body":"This form of the doc attribute lets you control the favicon of your docs. #![doc(html_favicon_url = \"https://example.com/favicon.ico\")] This will put <link rel=\"shortcut icon\" href=\"{}\"> into your docs, where the string for the attribute goes into the {}. If you don't use this attribute, there will be no favicon.","breadcrumbs":"The #[doc] attribute » html_favicon_url","id":"53","title":"html_favicon_url"},"54":{"body":"This form of the doc attribute lets you control the logo in the upper left hand side of the docs. #![doc(html_logo_url = \"https://example.com/logo.jpg\")] This will put <a href='index.html'><img src='{}' alt='logo' width='100'></a> into your docs, where the string for the attribute goes into the {}. If you don't use this attribute, there will be no logo.","breadcrumbs":"The #[doc] attribute » html_logo_url","id":"54","title":"html_logo_url"},"55":{"body":"This form of the doc attribute lets you control where the \"run\" buttons on your documentation examples make requests to. #![doc(html_playground_url = \"https://playground.example.com/\")] Now, when you press \"run\", the button will make a request to this domain. If you don't use this attribute, there will be no run buttons.","breadcrumbs":"The #[doc] attribute » html_playground_url","id":"55","title":"html_playground_url"},"56":{"body":"This form of the doc attribute is mostly only useful for the standard library; When a feature is unstable, an issue number for tracking the feature must be given. rustdoc uses this number, plus the base URL given here, to link to the tracking issue. #![doc(issue_tracker_base_url = \"https://github.com/rust-lang/rust/issues/\")]","breadcrumbs":"The #[doc] attribute » issue_tracker_base_url","id":"56","title":"issue_tracker_base_url"},"57":{"body":"The #[doc(html_root_url = \"…\")] attribute value indicates the URL for generating links to external crates. When rustdoc needs to generate a link to an item in an external crate, it will first check if the extern crate has been documented locally on-disk, and if so link directly to it. Failing that, it will use the URL given by the --extern-html-root-url command-line flag if available. If that is not available, then it will use the html_root_url value in the extern crate if it is available. If that is not available, then the extern items will not be linked. #![doc(html_root_url = \"https://docs.rs/serde/1.0\")]","breadcrumbs":"The #[doc] attribute » html_root_url","id":"57","title":"html_root_url"},"58":{"body":"By default, rustdoc will include the source code of your program, with links to it in the docs. But if you include this: #![doc(html_no_source)] it will not.","breadcrumbs":"The #[doc] attribute » html_no_source","id":"58","title":"html_no_source"},"59":{"body":"By default, rustdoc will automatically add a line with extern crate my_crate; into each doctest. But if you include this: #![doc(test(no_crate_inject))] it will not.","breadcrumbs":"The #[doc] attribute » test(no_crate_inject)","id":"59","title":"test(no_crate_inject)"},"6":{"body":"This covers the simplest use-cases of rustdoc. The rest of this book will explain all of the options that rustdoc has, and how to use them.","breadcrumbs":"What is rustdoc? » Summary","id":"6","title":"Summary"},"60":{"body":"This form of the doc attribute allows you to add arbitrary attributes to all your doctests. For example, if you want your doctests to fail if they produce any warnings, you could add this: #![doc(test(attr(deny(warnings))))]","breadcrumbs":"The #[doc] attribute » test(attr(...))","id":"60","title":"test(attr(...))"},"61":{"body":"These forms of the #[doc] attribute are used on individual items, to control how they are documented.","breadcrumbs":"The #[doc] attribute » At the item level","id":"61","title":"At the item level"},"62":{"body":"These attributes are used on use statements, and control where the documentation shows up. For example, consider this Rust code: pub use bar::Bar; /// bar docs\npub mod bar { /// the docs for Bar pub struct Bar;\n}\n# fn main() {} The documentation will generate a \"Re-exports\" section, and say pub use bar::Bar;, where Bar is a link to its page. If we change the use line like this: #[doc(inline)]\npub use bar::Bar;\n# pub mod bar { pub struct Bar; }\n# fn main() {} Instead, Bar will appear in a Structs section, just like Bar was defined at the top level, rather than pub use'd. Let's change our original example, by making bar private: pub use bar::Bar; /// bar docs\nmod bar { /// the docs for Bar pub struct Bar;\n}\n# fn main() {} Here, because bar is not public, Bar wouldn't have its own page, so there's nowhere to link to. rustdoc will inline these definitions, and so we end up in the same case as the #[doc(inline)] above; Bar is in a Structs section, as if it were defined at the top level. If we add the no_inline form of the attribute: #[doc(no_inline)]\npub use bar::Bar; /// bar docs\nmod bar { /// the docs for Bar pub struct Bar;\n}\n# fn main() {} Now we'll have a Re-exports line, and Bar will not link to anywhere. One special case: In Rust 2018 and later, if you pub use one of your dependencies, rustdoc will not eagerly inline it as a module unless you add #[doc(inline)].","breadcrumbs":"The #[doc] attribute » #[doc(no_inline)]/#[doc(inline)]","id":"62","title":"#[doc(no_inline)]/#[doc(inline)]"},"63":{"body":"Any item annotated with #[doc(hidden)] will not appear in the documentation, unless the strip-hidden pass is removed.","breadcrumbs":"The #[doc] attribute » #[doc(hidden)]","id":"63","title":"#[doc(hidden)]"},"64":{"body":"Since primitive types are defined in the compiler, there's no place to attach documentation attributes. This attribute is used by the standard library to provide a way to generate documentation for primitive types.","breadcrumbs":"The #[doc] attribute » #[doc(primitive)]","id":"64","title":"#[doc(primitive)]"},"65":{"body":"rustdoc supports executing your documentation examples as tests. This makes sure that examples within your documentation are up to date and working. The basic idea is this: /// # Examples\n///\n/// ```\n/// let x = 5;\n/// ```\n# fn f() {} The triple backticks start and end code blocks. If this were in a file named foo.rs, running rustdoc --test foo.rs will extract this example, and then run it as a test. Please note that by default, if no language is set for the block code, rustdoc assumes it is Rust code. So the following: ```rust\nlet x = 5;\n``` is strictly equivalent to: ```\nlet x = 5;\n``` There's some subtlety though! Read on for more details.","breadcrumbs":"Documentation tests » Documentation tests","id":"65","title":"Documentation tests"},"66":{"body":"Like regular unit tests, regular doctests are considered to \"pass\" if they compile and run without panicking. So if you want to demonstrate that some computation gives a certain result, the assert! family of macros works the same as other Rust code: let foo = \"foo\";\nassert_eq!(foo, \"foo\"); This way, if the computation ever returns something different, the code panics and the doctest fails.","breadcrumbs":"Documentation tests » Passing or failing a doctest","id":"66","title":"Passing or failing a doctest"},"67":{"body":"In the example above, you'll note something strange: there's no main function! Forcing you to write main for every example, no matter how small, adds friction and clutters the output. So rustdoc processes your examples slightly before running them. Here's the full algorithm rustdoc uses to preprocess examples: Some common allow attributes are inserted, including unused_variables, unused_assignments, unused_mut, unused_attributes, and dead_code. Small examples often trigger these lints. Any attributes specified with #![doc(test(attr(...)))] are added. Any leading #![foo] attributes are left intact as crate attributes. If the example does not contain extern crate, and #![doc(test(no_crate_inject))] was not specified, then extern crate <mycrate>; is inserted (note the lack of #[macro_use]). Finally, if the example does not contain fn main, the remainder of the text is wrapped in fn main() { your_code }. For more about that caveat in rule 4, see \"Documenting Macros\" below.","breadcrumbs":"Documentation tests » Pre-processing examples","id":"67","title":"Pre-processing examples"},"68":{"body":"Sometimes, you need some setup code, or other things that would distract from your example, but are important to make the tests work. Consider an example block that looks like this: /// ```\n/// /// Some documentation.\n/// # fn foo() {} // this function will be hidden\n/// println!(\"Hello, World!\");\n/// ```\n# fn f() {} It will render like this: /// Some documentation.\n# fn foo() {}\nprintln!(\"Hello, World!\"); Yes, that's right: you can add lines that start with # , and they will be hidden from the output, but will be used when compiling your code. You can use this to your advantage. In this case, documentation comments need to apply to some kind of function, so if I want to show you just a documentation comment, I need to add a little function definition below it. At the same time, it's only there to satisfy the compiler, so hiding it makes the example more clear. You can use this technique to explain longer examples in detail, while still preserving the testability of your documentation. For example, imagine that we wanted to document this code: let x = 5;\nlet y = 6;\nprintln!(\"{}\", x + y); We might want the documentation to end up looking like this: First, we set x to five: let x = 5;\n# let y = 6;\n# println!(\"{}\", x + y); Next, we set y to six: # let x = 5;\nlet y = 6;\n# println!(\"{}\", x + y); Finally, we print the sum of x and y: # let x = 5;\n# let y = 6;\nprintln!(\"{}\", x + y); To keep each code block testable, we want the whole program in each block, but we don't want the reader to see every line every time. Here's what we put in our source code: First, we set `x` to five: ```\nlet x = 5;\n# let y = 6;\n# println!(\"{}\", x + y);\n``` Next, we set `y` to six: ```\n# let x = 5;\nlet y = 6;\n# println!(\"{}\", x + y);\n``` Finally, we print the sum of `x` and `y`: ```\n# let x = 5;\n# let y = 6;\nprintln!(\"{}\", x + y);\n``` By repeating all parts of the example, you can ensure that your example still compiles, while only showing the parts that are relevant to that part of your explanation. The #-hiding of lines can be prevented by using two consecutive hashes ##. This only needs to be done with the first # which would've otherwise caused hiding. If we have a string literal like the following, which has a line that starts with a #: let s = \"foo\n## bar # baz\"; We can document it by escaping the initial #: /// let s = \"foo\n/// ## bar # baz\";","breadcrumbs":"Documentation tests » Hiding portions of the example","id":"68","title":"Hiding portions of the example"},"69":{"body":"When writing an example, it is rarely useful to include a complete error handling, as it would add significant amounts of boilerplate code. Instead, you may want the following: /// ```\n/// use std::io;\n/// let mut input = String::new();\n/// io::stdin().read_line(&mut input)?;\n/// ```\n# fn f() {} The problem is that ? returns a Result<T, E> and test functions don't return anything, so this will give a mismatched types error. You can get around this limitation by manually adding a main that returns Result<T, E>, because Result<T, E> implements the Termination trait: /// A doc test using ?\n///\n/// ```\n/// use std::io;\n///\n/// fn main() -> io::Result<()> {\n/// let mut input = String::new();\n/// io::stdin().read_line(&mut input)?;\n/// Ok(())\n/// }\n/// ```\n# fn f() {} Together with the # from the section above, you arrive at a solution that appears to the reader as the initial idea but works with doc tests: /// ```\n/// use std::io;\n/// # fn main() -> io::Result<()> {\n/// let mut input = String::new();\n/// io::stdin().read_line(&mut input)?;\n/// # Ok(())\n/// # }\n/// ```\n# fn f() {} As of version 1.34.0, one can also omit the fn main(), but you will have to disambiguate the error type: /// ```\n/// use std::io;\n/// let mut input = String::new();\n/// io::stdin().read_line(&mut input)?;\n/// # Ok::<(), io::Error>(())\n/// ```\n# fn f() {} This is an unfortunate consequence of the ? operator adding an implicit conversion, so type inference fails because the type is not unique. Please note that you must write the (()) in one sequence without intermediate whitespace so that rustdoc understands you want an implicit Result-returning function.","breadcrumbs":"Documentation tests » Using ? in doc tests","id":"69","title":"Using ? in doc tests"},"7":{"body":"Good documentation is not natural. There are opposing goals that make writing good documentation difficult. It requires expertise in the subject but also writing to a novice perspective. Documentation therefore often glazes over implementation detail, or leaves readers with unanswered questions. There are a few tenets to Rust documentation that can help guide anyone through the process of documenting libraries so that everyone has an ample opportunity to use the code. This chapter covers not only how to write documentation but specifically how to write good documentation. It is important to be as clear as you can, and as complete as possible. As a rule of thumb: the more documentation you write for your crate the better. If an item is public then it should be documented.","breadcrumbs":"How to write documentation » How to write documentation","id":"7","title":"How to write documentation"},"70":{"body":"Here’s an example of documenting a macro: /// Panic with a given message unless an expression evaluates to true.\n///\n/// # Examples\n///\n/// ```\n/// # #[macro_use] extern crate foo;\n/// # fn main() {\n/// panic_unless!(1 + 1 == 2, “Math is broken.”);\n/// # }\n/// ```\n///\n/// ```should_panic\n/// # #[macro_use] extern crate foo;\n/// # fn main() {\n/// panic_unless!(true == false, “I’m broken.”);\n/// # }\n/// ```\n#[macro_export]\nmacro_rules! panic_unless { ($condition:expr, $($rest:expr),+) => ({ if ! $condition { panic!($($rest),+); } });\n}\n# fn main() {} You’ll note three things: we need to add our own extern crate line, so that we can add the #[macro_use] attribute. Second, we’ll need to add our own main() as well (for reasons discussed above). Finally, a judicious use of # to comment out those two things, so they don’t show up in the output.","breadcrumbs":"Documentation tests » Documenting macros","id":"70","title":"Documenting macros"},"71":{"body":"There are a few annotations that are useful to help rustdoc do the right thing when testing your code: /// ```ignore\n/// fn foo() {\n/// ```\n# fn foo() {} The ignore directive tells Rust to ignore your code. This is almost never what you want, as it's the most generic. Instead, consider annotating it with text if it's not code, or using #s to get a working example that only shows the part you care about. /// ```should_panic\n/// assert!(false);\n/// ```\n# fn foo() {} should_panic tells rustdoc that the code should compile correctly, but not actually pass as a test. /// ```no_run\n/// loop {\n/// println!(\"Hello, world\");\n/// }\n/// ```\n# fn foo() {} The no_run attribute will compile your code, but not run it. This is important for examples such as \"Here's how to retrieve a web page,\" which you would want to ensure compiles, but might be run in a test environment that has no network access. /// ```compile_fail\n/// let x = 5;\n/// x += 2; // shouldn't compile!\n/// ``` compile_fail tells rustdoc that the compilation should fail. If it compiles, then the test will fail. However please note that code failing with the current Rust release may work in a future release, as new features are added. /// Only runs on the 2018 edition.\n///\n/// ```edition2018\n/// let result: Result<i32, ParseIntError> = try {\n/// \"1\".parse::<i32>()?\n/// + \"2\".parse::<i32>()?\n/// + \"3\".parse::<i32>()?\n/// };\n/// ``` edition2018 tells rustdoc that the code sample should be compiled using the 2018 edition of Rust. Similarly, you can specify edition2015 to compile the code with the 2015 edition.","breadcrumbs":"Documentation tests » Attributes","id":"71","title":"Attributes"},"72":{"body":"The exact syntax for code blocks, including the edge cases, can be found in the Fenced Code Blocks section of the CommonMark specification. Rustdoc also accepts indented code blocks as an alternative to fenced code blocks: instead of surrounding your code with three backticks, you can indent each line by four or more spaces. let foo = \"foo\"; assert_eq!(foo, \"foo\"); These, too, are documented in the CommonMark specification, in the Indented Code Blocks section. However, it's preferable to use fenced code blocks over indented code blocks. Not only are fenced code blocks considered more idiomatic for Rust code, but there is no way to use directives such as ignore or should_panic with indented code blocks.","breadcrumbs":"Documentation tests » Syntax reference","id":"72","title":"Syntax reference"},"73":{"body":"Rustdoc's documentation tests can do some things that regular unit tests can't, so it can sometimes be useful to extend your doctests with samples that wouldn't otherwise need to be in documentation. To this end, Rustdoc allows you to have certain items only appear when it's collecting doctests, so you can utilize doctest functionality without forcing the test to appear in docs, or to find an arbitrary private item to include it on. When compiling a crate for use in doctests (with --test option), rustdoc will set #[cfg(doctest)]. Note that they will still link against only the public items of your crate; if you need to test private items, you need to write a unit test. In this example, we're adding doctests that we know won't compile, to verify that our struct can only take in valid data: /// We have a struct here. Remember it doesn't accept negative numbers!\npub struct MyStruct(pub usize); /// ```compile_fail\n/// let x = my_crate::MyStruct(-5);\n/// ```\n#[cfg(doctest)]\npub struct MyStructOnlyTakesUsize; Note that the struct MyStructOnlyTakesUsize here isn't actually part of your public crate API. The use of #[cfg(doctest)] makes sure that this struct only exists while rustdoc is collecting doctests. This means that its doctest is executed when --test is passed to rustdoc, but is hidden from the public documentation. Another possible use of #[cfg(doctest)] is to test doctests that are included in your README file without including it in your main documentation. For example, you could write this into your lib.rs to test your README as part of your doctests: #[doc = include_str!(\"../README.md\")]\n#[cfg(doctest)]\npub struct ReadmeDoctests; This will include your README as documentation on the hidden struct ReadmeDoctests, which will then be tested alongside the rest of your doctests.","breadcrumbs":"Documentation tests » Include items only when collecting doctests","id":"73","title":"Include items only when collecting doctests"},"74":{"body":"Rustdoc is capable of directly linking to other rustdoc pages using the path of the item as a link. This is referred to as an 'intra-doc link'. For example, in the following code all of the links will link to the rustdoc page for Bar: /// This struct is not [Bar]\npub struct Foo1; /// This struct is also not [bar](Bar)\npub struct Foo2; /// This struct is also not [bar][b]\n///\n/// [b]: Bar\npub struct Foo3; /// This struct is also not [`Bar`]\npub struct Foo4; /// This struct *is* [`Bar`]!\npub struct Bar; Unlike normal Markdown, [bar][Bar] syntax is also supported without needing a [Bar]: ... reference link. Backticks around the link will be stripped, so [`Option`] will correctly link to Option.","breadcrumbs":"Linking to items by name » Linking to items by name","id":"74","title":"Linking to items by name"},"75":{"body":"You can refer to anything in scope, and use paths, including Self, self, super, and crate. Associated items (functions, types, and constants) are supported, but not for blanket trait implementations . Rustdoc also supports linking to all primitives listed in the standard library documentation . You can also refer to items with generic parameters like Vec<T>. The link will resolve as if you had written [`Vec<T>`](Vec). Fully-qualified syntax (for example, <Vec as IntoIterator>::into_iter()) is not yet supported , however. use std::sync::mpsc::Receiver; /// This is a version of [`Receiver<T>`] with support for [`std::future`].\n///\n/// You can obtain a [`std::future::Future`] by calling [`Self::recv()`].\npub struct AsyncReceiver<T> { sender: Receiver<T>\n} impl<T> AsyncReceiver<T> { pub async fn recv() -> T { unimplemented!() }\n} Rustdoc allows using URL fragment specifiers, just like a normal link: /// This is a special implementation of [positional parameters].\n///\n/// [positional parameters]: std::fmt#formatting-parameters\nstruct MySpecialFormatter;","breadcrumbs":"Linking to items by name » Valid links","id":"75","title":"Valid links"},"76":{"body":"Paths in Rust have three namespaces: type, value, and macro. Item names must be unique within their namespace, but can overlap with items in other namespaces. In case of ambiguity, rustdoc will warn about the ambiguity and suggest a disambiguator. /// See also: [`Foo`](struct@Foo)\nstruct Bar; /// This is different from [`Foo`](fn@Foo)\nstruct Foo {} fn Foo() {} These prefixes will be stripped when displayed in the documentation, so [struct@Foo] will be rendered as Foo. You can also disambiguate for functions by adding () after the function name, or for macros by adding ! after the macro name: /// This is different from [`foo!`]\nfn foo() {} /// This is different from [`foo()`]\nmacro_rules! foo { () => {}\n}","breadcrumbs":"Linking to items by name » Namespaces and Disambiguators","id":"76","title":"Namespaces and Disambiguators"},"77":{"body":"Links are resolved in the scope of the module where the item is defined, even when the item is re-exported. If a link from another crate fails to resolve, no warning is given. mod inner { /// Link to [f()] pub struct S; pub fn f() {}\n}\npub use inner::S; // the link to `f` will still resolve correctly When re-exporting an item, rustdoc allows adding additional documentation to it. That additional documentation will be resolved in the scope of the re-export, not the original, allowing you to link to items in the new crate. The new links will still give a warning if they fail to resolve. /// See also [foo()]\npub use std::process::Command; pub fn foo() {} This is especially useful for proc-macros, which must always be defined in their own dedicated crate. Note: Because of how macro_rules! macros are scoped in Rust, the intra-doc links of a macro_rules! macro will be resolved relative to the crate root , as opposed to the module it is defined in. If links do not look 'sufficiently like' an intra-doc link, they will be ignored and no warning will be given, even if the link fails to resolve. For example, any link containing / or [] characters will be ignored.","breadcrumbs":"Linking to items by name » Warnings, re-exports, and scoping","id":"77","title":"Warnings, re-exports, and scoping"},"78":{"body":"rustdoc provides lints to help you writing and testing your documentation. You can use them like any other lints by doing this: #![allow(rustdoc::broken_intra_doc_links)] // allows the lint, no diagnostics will be reported\n#![warn(rustdoc::broken_intra_doc_links)] // warn if there are broken intra-doc links\n#![deny(rustdoc::broken_intra_doc_links)] // error if there are broken intra-doc links Note that, except for missing_docs, these lints are only available when running rustdoc, not rustc. Here is the list of the lints provided by rustdoc:","breadcrumbs":"Lints » Lints","id":"78","title":"Lints"},"79":{"body":"This lint warns by default . This lint detects when an intra-doc link fails to be resolved. For example: /// I want to link to [`Nonexistent`] but it doesn't exist!\npub fn foo() {} You'll get a warning saying: warning: unresolved link to `Nonexistent` --> test.rs:1:24 |\n1 | /// I want to link to [`Nonexistent`] but it doesn't exist! | ^^^^^^^^^^^^^ no item named `Nonexistent` in `test` It will also warn when there is an ambiguity and suggest how to disambiguate: /// [`Foo`]\npub fn function() {} pub enum Foo {} pub fn Foo(){} warning: `Foo` is both an enum and a function --> test.rs:1:6 |\n1 | /// [`Foo`] | ^^^^^ ambiguous link | = note: `#[warn(rustdoc::broken_intra_doc_links)]` on by default\nhelp: to link to the enum, prefix with the item type |\n1 | /// [`enum@Foo`] | ^^^^^^^^^^\nhelp: to link to the function, add parentheses |\n1 | /// [`Foo()`] | ^^^^^^^","breadcrumbs":"Lints » broken_intra_doc_links","id":"79","title":"broken_intra_doc_links"},"8":{"body":"Documenting a crate should begin with front-page documentation. As an example, the hashbrown crate level documentation summarizes the role of the crate, provides links to explain technical details, and explains why you would want to use the crate. After introducing the crate, it is important that the front-page gives an example of how to use the crate in a real world setting. Stick to the library's role in the example, but do so without shortcuts to benefit users who may copy and paste the example to get started. futures uses inline comments to explain line by line the complexities of using a Future , because a person's first exposure to rust's Future may be this example. The backtrace documentation walks through the whole process, explaining changes made to the Cargo.toml file, passing command line arguments to the compiler, and shows a quick example of backtrace in the wild. Finally, the front-page can eventually become a comprehensive reference how to use a crate, like regex . In this front page, all requirements are outlined, the edge cases shown, and practical examples provided. The front page goes on to show how to use regular expressions then concludes with crate features. Don't worry about comparing your crate, which is just beginning, to other more developed crates. To get the documentation to something more polished, start incrementally and put in an introduction, example, and features. Rome was not built in a day! The first lines within the lib.rs will compose the front-page, and they use a different convention than the rest of the rustdocs. Lines should start with //! which indicate module-level or crate-level documentation. Here's a quick example of the difference: //! Fast and easy queue abstraction.\n//!\n//! Provides an abstraction over a queue. When the abstraction is used\n//! there are these advantages:\n//! - Fast\n//! - [`Easy`]\n//!\n//! [`Easy`]: http://thatwaseasy.example.com /// This module makes it easy.\npub mod easy { /// Use the abstraction function to do this specific thing. pub fn abstraction() {} } Ideally, this first line of documentation is a sentence without highly technical details, but with a good description of where this crate fits within the rust ecosystem. Users should know whether this crate meets their use case after reading this line.","breadcrumbs":"How to write documentation » Getting Started","id":"8","title":"Getting Started"},"80":{"body":"This lint warns by default . This lint detects when intra-doc links from public to private items. For example: /// [private]\npub fn public() {}\nfn private() {} This gives a warning that the link will be broken when it appears in your documentation: warning: public documentation for `public` links to private item `private` --> priv.rs:1:6 |\n1 | /// [private] | ^^^^^^^ this item is private | = note: `#[warn(rustdoc::private_intra_doc_links)]` on by default = note: this link will resolve properly if you pass `--document-private-items` Note that this has different behavior depending on whether you pass --document-private-items or not! If you document private items, then it will still generate a link, despite the warning: warning: public documentation for `public` links to private item `private` --> priv.rs:1:6 |\n1 | /// [private] | ^^^^^^^ this item is private | = note: `#[warn(rustdoc::private_intra_doc_links)]` on by default = note: this link resolves only because you passed `--document-private-items`, but will break without","breadcrumbs":"Lints » private_intra_doc_links","id":"80","title":"private_intra_doc_links"},"81":{"body":"This lint is allowed by default . It detects items missing documentation. For example: #![warn(missing_docs)] pub fn undocumented() {}\n# fn main() {} The undocumented function will then have the following warning: warning: missing documentation for a function --> your-crate/lib.rs:3:1 | 3 | pub fn undocumented() {} | ^^^^^^^^^^^^^^^^^^^^^ Note that unlike other rustdoc lints, this lint is also available from rustc directly.","breadcrumbs":"Lints » missing_docs","id":"81","title":"missing_docs"},"82":{"body":"This lint is allowed by default . It detects if there is no documentation at the crate root. For example: #![warn(rustdoc::missing_crate_level_docs)] This will generate the following warning: warning: no documentation found for this crate's top-level module | = help: The following guide may be of use: https://doc.rust-lang.org/nightly/rustdoc/how-to-write-documentation.html This is currently \"allow\" by default, but it is intended to make this a warning in the future. This is intended as a means to introduce new users on how to document their crate by pointing them to some instructions on how to get started, without providing overwhelming warnings like missing_docs might.","breadcrumbs":"Lints » missing_crate_level_docs","id":"82","title":"missing_crate_level_docs"},"83":{"body":"This lint is allowed by default and is nightly-only . It detects when a documentation block is missing a code example. For example: #![warn(rustdoc::missing_doc_code_examples)] /// There is no code example!\npub fn no_code_example() {}\n# fn main() {} The no_code_example function will then have the following warning: warning: Missing code example in this documentation --> your-crate/lib.rs:3:1 |\nLL | /// There is no code example! | ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ To fix the lint, you need to add a code example into the documentation block: /// There is no code example!\n///\n/// ```\n/// println!(\"calling no_code_example...\");\n/// no_code_example();\n/// println!(\"we called no_code_example!\");\n/// ```\npub fn no_code_example() {}","breadcrumbs":"Lints » missing_doc_code_examples","id":"83","title":"missing_doc_code_examples"},"84":{"body":"This lint is allowed by default . It detects documentation tests when they are on a private item. For example: #![warn(rustdoc::private_doc_tests)] mod foo { /// private doc test /// /// ``` /// assert!(false); /// ``` fn bar() {}\n}\n# fn main() {} Which will give: warning: Documentation test in private item --> your-crate/lib.rs:4:1 | 4 | / /// private doc test 5 | | /// 6 | | /// ``` 7 | | /// assert!(false); 8 | | /// ``` | |___________^","breadcrumbs":"Lints » private_doc_tests","id":"84","title":"private_doc_tests"},"85":{"body":"This lint warns by default . It detects code block attributes in documentation examples that have potentially mis-typed values. For example: /// Example.\n///\n/// ```should-panic\n/// assert_eq!(1, 2);\n/// ```\npub fn foo() {} Which will give: warning: unknown attribute `should-panic`. Did you mean `should_panic`? --> src/lib.rs:1:1 |\n1 | / /// Example.\n2 | | ///\n3 | | /// ```should-panic\n4 | | /// assert_eq!(1, 2);\n5 | | /// ``` | |_______^ | = note: `#[warn(rustdoc::invalid_codeblock_attributes)]` on by default = help: the code block will either not be tested if not marked as a rust one or won't fail if it doesn't panic when running In the example above, the correct form is should_panic. This helps detect typo mistakes for some common attributes.","breadcrumbs":"Lints » invalid_codeblock_attributes","id":"85","title":"invalid_codeblock_attributes"},"86":{"body":"This lint is allowed by default and is nightly-only . It detects unclosed or invalid HTML tags. For example: #![warn(rustdoc::invalid_html_tags)] /// <h1>\n/// </script>\npub fn foo() {} Which will give: warning: unopened HTML tag `script` --> foo.rs:1:1 |\n1 | / /// <h1>\n2 | | /// </script> | |_____________^ | note: the lint level is defined here --> foo.rs:1:9 |\n1 | #![warn(rustdoc::invalid_html_tags)] | ^^^^^^^^^^^^^^^^^^^^^^^^^^ warning: unclosed HTML tag `h1` --> foo.rs:1:1 |\n1 | / /// <h1>\n2 | | /// </script> | |_____________^ warning: 2 warnings emitted","breadcrumbs":"Lints » invalid_html_tags","id":"86","title":"invalid_html_tags"},"87":{"body":"This lint warns by default . It detects Rust code blocks in documentation examples that are invalid (e.g. empty, not parsable as Rust). For example: /// Empty code blocks (with and without the `rust` marker):\n///\n/// ```rust\n/// ```\n///\n/// Invalid syntax in code blocks:\n///\n/// ```rust\n/// '<\n/// ```\npub fn foo() {} Which will give: warning: Rust code block is empty --> lint.rs:3:5 |\n3 | /// ```rust | _____^\n4 | | /// ``` | |_______^ | = note: `#[warn(rustdoc::invalid_rust_codeblocks)]` on by default warning: could not parse code block as Rust code --> lint.rs:8:5 |\n8 | /// ```rust | _____^\n9 | | /// '<\n10 | | /// ``` | |_______^ | = note: error from rustc: unterminated character literal","breadcrumbs":"Lints » invalid_rust_codeblocks","id":"87","title":"invalid_rust_codeblocks"},"88":{"body":"This lint is warn-by-default . It detects URLs which are not links. For example: /// http://example.org\n/// [http://example.net]\npub fn foo() {} Which will give: warning: this URL is not a hyperlink --> links.rs:1:5 |\n1 | /// http://example.org | ^^^^^^^^^^^^^^^^^^ help: use an automatic link instead: `<http://example.org>` | = note: `#[warn(rustdoc::bare_urls)]` on by default warning: this URL is not a hyperlink --> links.rs:3:6 |\n3 | /// [http://example.net] | ^^^^^^^^^^^^^^^^^^ help: use an automatic link instead: `<http://example.net>` warning: 2 warnings emitted","breadcrumbs":"Lints » bare_urls","id":"88","title":"bare_urls"},"89":{"body":"The features listed on this page fall outside the rest of the main categories.","breadcrumbs":"Advanced features » Advanced features","id":"89","title":"Advanced features"},"9":{"body":"Whether it is modules, structs, functions, or macros: the public API of all code should have documentation. Rarely does anyone complain about too much documentation! It is recommended that each item's documentation follows this basic structure: [short sentence explaining what it is] [more detailed explanation] [at least one code example that users can copy/paste to try it] [even more advanced explanations if necessary] This basic structure should be straightforward to follow when writing your documentation; while you might think that a code example is trivial, the examples are really important because they can help users understand what an item is, how it is used, and for what purpose it exists. Let's see an example coming from the standard library by taking a look at the std::env::args() function: Returns the arguments which this program was started with (normally passed\nvia the command line). The first element is traditionally the path of the executable, but it can be\nset to arbitrary text, and may not even exist. This means this property should\nnot be relied upon for security purposes. On Unix systems shell usually expands unquoted arguments with glob patterns\n(such as `*` and `?`). On Windows this is not done, and such arguments are\npassed as-is. # Panics The returned iterator will panic during iteration if any argument to the\nprocess is not valid unicode. If this is not desired,\nuse the [`args_os`] function instead. # Examples ```\nuse std::env; // Prints each argument on a separate line\nfor argument in env::args() { println!(\"{}\", argument);\n}\n``` [`args_os`]: ./fn.args_os.html Everything before the first empty line will be reused to describe the component in searches and module overviews. For example, the function std::env::args() above will be shown on the std::env module documentation. It is good practice to keep the summary to one line: concise writing is a goal of good documentation. Because the type system does a good job of defining what types a function passes and returns, there is no benefit of explicitly writing it into the documentation, especially since rustdoc adds hyper links to all types in the function signature. In the example above, a 'Panics' section explains when the code might abruptly exit, which can help the reader prevent reaching a panic. A panic section is recommended every time edge cases in your code can be reached if known. As you can see, it follows the structure detailed above: it starts with a short sentence explaining what the functions does, then it provides more information and finally provides a code example.","breadcrumbs":"How to write documentation » Documenting components","id":"9","title":"Documenting components"},"90":{"body":"For conditional compilation, Rustdoc treats your crate the same way the compiler does. Only things from the host target are available (or from the given --target if present), and everything else is \"filtered out\" from the crate. This can cause problems if your crate is providing different things on different targets and you want your documentation to reflect all the available items you provide. If you want to make sure an item is seen by Rustdoc regardless of what platform it's targeting, you can apply #[cfg(doc)] to it. Rustdoc sets this whenever it's building documentation, so anything that uses that flag will make it into documentation it generates. To apply this to an item with other #[cfg] filters on it, you can write something like #[cfg(any(windows, doc))]. This will preserve the item either when built normally on Windows, or when being documented anywhere. Please note that this cfg is not passed to doctests. Example: /// Token struct that can only be used on Windows.\n#[cfg(any(windows, doc))]\npub struct WindowsToken;\n/// Token struct that can only be used on Unix.\n#[cfg(any(unix, doc))]\npub struct UnixToken; Here, the respective tokens can only be used by dependent crates on their respective platforms, but they will both appear in documentation.","breadcrumbs":"Advanced features » #[cfg(doc)]: Documenting platform-specific or feature-specific information","id":"90","title":"#[cfg(doc)]: Documenting platform-specific or feature-specific information"},"91":{"body":"Rustdoc does not have a magic way to compile documentation 'as-if' you'd run it once for each platform (such a magic wand has been called the 'holy grail of rustdoc' ). Instead, it sees all of your code at once, the same way the Rust compiler would if you passed it --cfg doc. However, Rustdoc has a trick up its sleeve to handle platform-specific code if it does receive it. To document your crate, Rustdoc only needs to know the public signature of your functions. In particular, it doesn't have to know how any of your functions are implemented, so it ignores all type errors and name resolution errors with function bodies. Note that this does not work for anything outside a function body: since Rustdoc documents your types, it has to know what those types are! For example, this code will work regardless of the platform: pub fn f() { use std::os::windows::ffi::OsStrExt;\n} but this will not, because the unknown type is part of the function signature: pub fn f() -> std::os::windows::ffi::EncodeWide<'static> { unimplemented!()\n} For a more realistic example of code this allows, see the rustdoc test suite .","breadcrumbs":"Advanced features » Interactions between platform-specific docs","id":"91","title":"Interactions between platform-specific docs"},"92":{"body":"This feature allows you to add alias(es) to an item when using the rustdoc search through the doc(alias) attribute. Example: #[doc(alias = \"x\")]\n#[doc(alias = \"big\")]\npub struct BigX; Then, when looking for it through the rustdoc search, if you enter \"x\" or \"big\", search will show the BigX struct first. There are some limitations on the doc alias names though: you can't use \" or whitespace. You can add multiple aliases at the same time by using a list: #[doc(alias(\"x\", \"big\"))]\npub struct BigX;","breadcrumbs":"Advanced features » Add aliases for an item in documentation search","id":"92","title":"Add aliases for an item in documentation search"},"93":{"body":"Rustdoc is under active development, and like the Rust compiler, some features are only available on nightly releases. Some of these features are new and need some more testing before they're able to be released to the world at large, and some of them are tied to features in the Rust compiler that are unstable. Several features here require a matching #![feature(...)] attribute to enable, and thus are more fully documented in the Unstable Book . Those sections will link over there as necessary.","breadcrumbs":"Unstable features » Unstable features","id":"93","title":"Unstable features"},"94":{"body":"These features just require a nightly build to operate. Unlike the other features on this page, these don't need to be \"turned on\" with a command-line flag or a #![feature(...)] attribute in your crate. This can give them some subtle fallback modes when used on a stable release, so be careful!","breadcrumbs":"Unstable features » Nightly-gated functionality","id":"94","title":"Nightly-gated functionality"},"95":{"body":"As detailed in the chapter on documentation tests , you can add a compile_fail attribute to a doctest to state that the test should fail to compile. However, on nightly, you can optionally add an error number to state that a doctest should emit a specific error number: ```compile_fail,E0044\nextern { fn some_func<T>(x: T); }\n``` This is used by the error index to ensure that the samples that correspond to a given error number properly emit that error code. However, these error codes aren't guaranteed to be the only thing that a piece of code emits from version to version, so this is unlikely to be stabilized in the future. Attempting to use these error numbers on stable will result in the code sample being interpreted as plain text.","breadcrumbs":"Unstable features » Error numbers for compile-fail doctests","id":"95","title":"Error numbers for compile-fail doctests"},"96":{"body":"These features operate by extending the #[doc] attribute, and thus can be caught by the compiler and enabled with a #![feature(...)] attribute in your crate.","breadcrumbs":"Unstable features » Extensions to the #[doc] attribute","id":"96","title":"Extensions to the #[doc] attribute"},"97":{"body":"You can use #[doc(cfg(...))] to tell Rustdoc exactly which platform items appear on. This has two effects: doctests will only run on the appropriate platforms, and When Rustdoc renders documentation for that item, it will be accompanied by a banner explaining that the item is only available on certain platforms. #[doc(cfg)] is intended to be used alongside #[cfg(doc)] . For example, #[cfg(any(windows, doc))] will preserve the item either on Windows or during the documentation process. Then, adding a new attribute #[doc(cfg(windows))] will tell Rustdoc that the item is supposed to be used on Windows. For example: #![feature(doc_cfg)] /// Token struct that can only be used on Windows.\n#[cfg(any(windows, doc))]\n#[doc(cfg(windows))]\npub struct WindowsToken; /// Token struct that can only be used on Unix.\n#[cfg(any(unix, doc))]\n#[doc(cfg(unix))]\npub struct UnixToken; /// Token struct that is only available with the `serde` feature\n#[cfg(feature = \"serde\")]\n#[doc(cfg(feature = \"serde\"))]\n#[derive(serde::Deserialize)]\npub struct SerdeToken; In this sample, the tokens will only appear on their respective platforms, but they will both appear in documentation. #[doc(cfg(...))] was introduced to be used by the standard library and currently requires the #![feature(doc_cfg)] feature gate. For more information, see its chapter in the Unstable Book and its tracking issue .","breadcrumbs":"Unstable features » #[doc(cfg)]: Recording what platforms or features are required for code to be present","id":"97","title":"#[doc(cfg)]: Recording what platforms or features are required for code to be present"},"98":{"body":"Rustdoc keeps a list of a few traits that are believed to be \"fundamental\" to types that implement them. These traits are intended to be the primary interface for their implementers, and are often most of the API available to be documented on their types. For this reason, Rustdoc will track when a given type implements one of these traits and call special attention to it when a function returns one of these types. This is the \"Notable traits\" dialog, accessible as a circled i button next to the function, which, when clicked, shows the dialog. In the standard library, some of the traits that are part of this list are Iterator, Future, io::Read, and io::Write. However, rather than being implemented as a hard-coded list, these traits have a special marker attribute on them: #[doc(notable_trait)]. This means that you can apply this attribute to your own trait to include it in the \"Notable traits\" dialog in documentation. The #[doc(notable_trait)] attribute currently requires the #![feature(doc_notable_trait)] feature gate. For more information, see its chapter in the Unstable Book and its tracking issue .","breadcrumbs":"Unstable features » Adding your trait to the \"Notable traits\" dialog","id":"98","title":"Adding your trait to the \"Notable traits\" dialog"},"99":{"body":"The standard library uses several dependencies which, in turn, use several types and traits from the standard library. In addition, there are several compiler-internal crates that are not considered to be part of the official standard library, and thus would be a distraction to include in documentation. It's not enough to exclude their crate documentation, since information about trait implementations appears on the pages for both the type and the trait, which can be in different crates! To prevent internal types from being included in documentation, the standard library adds an attribute to their extern crate declarations: #[doc(masked)]. This causes Rustdoc to \"mask out\" types from these crates when building lists of trait implementations. The #[doc(masked)] attribute is intended to be used internally, and requires the #![feature(doc_masked)] feature gate. For more information, see its chapter in the Unstable Book and its tracking issue .","breadcrumbs":"Unstable features » Exclude certain dependencies from documentation","id":"99","title":"Exclude certain dependencies from documentation"}},"length":122,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{"4":{"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.0}}},"df":0,"docs":{}},"1":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"1":{"7":{".":{"0":{"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"3":{"7":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{".":{"0":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"106":{"tf":1.0}}},"df":2,"docs":{"17":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"5":{"7":{"4":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"4":{"6":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":10,"docs":{"117":{"tf":1.4142135623730951},"12":{"tf":1.0},"16":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"70":{"tf":1.0},"79":{"tf":2.0},"80":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.7320508075688772},"88":{"tf":1.0}}},"2":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"9":{"6":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"1":{"5":{"df":2,"docs":{"43":{"tf":1.0},"71":{"tf":1.0}}},"7":{"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.0}}},"8":{"df":3,"docs":{"43":{"tf":1.4142135623730951},"62":{"tf":1.0},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.0}}},"5":{".":{"0":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"115":{"tf":1.4142135623730951},"16":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"85":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772},"88":{"tf":1.0}}},"3":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"9":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":5,"docs":{"16":{"tf":1.0},"81":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}},"4":{"2":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"117":{"tf":1.4142135623730951},"16":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0}}},"5":{"6":{"1":{"2":{"4":{"b":{"a":{"a":{"9":{"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"16":{"tf":1.0},"65":{"tf":1.7320508075688772},"68":{"tf":2.6457513110645907},"71":{"tf":1.0},"73":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}},"6":{"df":2,"docs":{"68":{"tf":2.6457513110645907},"84":{"tf":1.0}}},"7":{"df":1,"docs":{"84":{"tf":1.0}}},"8":{"df":3,"docs":{"47":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}}},"9":{"df":1,"docs":{"87":{"tf":1.0}}},"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"85":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.0}}},"a":{"b":{"c":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":11,"docs":{"105":{"tf":1.0},"115":{"tf":1.0},"16":{"tf":1.0},"28":{"tf":1.0},"35":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"114":{"tf":1.0},"28":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"71":{"tf":1.0},"98":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"93":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"51":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":16,"docs":{"44":{"tf":2.0},"45":{"tf":1.0},"48":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.7320508075688772},"79":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.7320508075688772},"95":{"tf":1.4142135623730951},"99":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"30":{"tf":1.0},"44":{"tf":1.0},"77":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"df":12,"docs":{"103":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"35":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"89":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"68":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.0},"73":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}},"i":{"a":{"df":1,"docs":{"92":{"tf":1.0}},"s":{"(":{"df":1,"docs":{"92":{"tf":1.0}}},"df":1,"docs":{"92":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{":":{":":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":26,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.4142135623730951},"117":{"tf":1.0},"30":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"73":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"107":{"tf":1.0},"19":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"=":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"63":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"108":{"tf":1.0},"116":{"tf":1.0},"4":{"tf":1.0},"51":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"17":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"111":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"62":{"tf":1.0},"90":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":6,"docs":{"120":{"tf":1.0},"121":{"tf":1.0},"18":{"tf":1.0},"73":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":12,"docs":{"104":{"tf":1.7320508075688772},"18":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.4142135623730951},"80":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.7320508075688772},"99":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"108":{"tf":1.0},"33":{"tf":1.0},"68":{"tf":1.0},"90":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"60":{"tf":1.0},"73":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"117":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":3,"docs":{"116":{"tf":2.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951}},"s":{"_":{"df":0,"docs":{},"o":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"0":{"tf":1.0},"100":{"tf":1.0},"103":{"tf":1.0},"108":{"tf":1.0},"116":{"tf":1.0},"20":{"tf":1.4142135623730951},"27":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.6457513110645907}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"112":{"tf":1.4142135623730951},"69":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"2":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"71":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"1":{"df":1,"docs":{"85":{"tf":1.4142135623730951}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"66":{"tf":1.0},"72":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"66":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"2":{"tf":1.0},"25":{"tf":1.0},"50":{"tf":1.0},"65":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"17":{"tf":1.7320508075688772},"75":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":26,"docs":{"103":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":1.0},"51":{"tf":2.449489742783178},"53":{"tf":1.7320508075688772},"54":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"67":{"tf":2.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"85":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.7320508075688772},"97":{"tf":1.0},"98":{"tf":1.7320508075688772},"99":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"59":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":11,"docs":{"103":{"tf":1.4142135623730951},"118":{"tf":1.0},"17":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"57":{"tf":2.0},"78":{"tf":1.0},"81":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"103":{"tf":1.0}}},"y":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"115":{"tf":1.4142135623730951}},"e":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"u":{"df":1,"docs":{"19":{"tf":1.0}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"65":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"r":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"[":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":1,"docs":{"74":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"1":{"tf":1.0},"115":{"tf":1.4142135623730951},"62":{"tf":4.69041575982343},"68":{"tf":1.4142135623730951},"74":{"tf":2.6457513110645907},"76":{"tf":1.0},"84":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"103":{"tf":1.0},"12":{"tf":1.0},"39":{"tf":1.0},"56":{"tf":1.0}}},"i":{"c":{"df":4,"docs":{"1":{"tf":1.0},"51":{"tf":1.0},"65":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"z":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"df":1,"docs":{"74":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"105":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"8":{"tf":1.0}}}}},"df":7,"docs":{"118":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":9,"docs":{"101":{"tf":2.6457513110645907},"102":{"tf":1.4142135623730951},"118":{"tf":1.0},"37":{"tf":2.23606797749979},"38":{"tf":1.0},"4":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"107":{"tf":1.0},"80":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"106":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"98":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"16":{"tf":1.0}}}},"w":{"df":3,"docs":{"51":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"91":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"92":{"tf":1.7320508075688772}},"x":{"df":1,"docs":{"92":{"tf":1.7320508075688772}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"112":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"47":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":7,"docs":{"113":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"72":{"tf":3.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"87":{"tf":2.23606797749979}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":5,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"91":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"4":{"tf":1.0},"6":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"103":{"tf":1.4142135623730951},"117":{"tf":1.0},"17":{"tf":1.0},"79":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"12":{"tf":1.7320508075688772},"41":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"41":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":3,"docs":{"70":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"80":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"34":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"106":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"108":{"tf":1.0},"115":{"tf":1.0},"90":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":4,"docs":{"113":{"tf":1.0},"21":{"tf":1.0},"8":{"tf":1.0},"90":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"103":{"tf":1.0},"39":{"tf":1.0},"55":{"tf":1.7320508075688772},"98":{"tf":1.0}}}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"105":{"tf":1.0},"111":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"113":{"tf":1.0},"117":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":10,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"118":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"75":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0},"98":{"tf":1.0}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"73":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"41":{"tf":1.0},"71":{"tf":1.0},"94":{"tf":1.0}},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":6,"docs":{"1":{"tf":1.7320508075688772},"100":{"tf":1.4142135623730951},"111":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":2.449489742783178},"5":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":12,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"51":{"tf":1.7320508075688772},"6":{"tf":1.0},"62":{"tf":1.4142135623730951},"68":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}},"s":{"df":3,"docs":{"68":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":1,"docs":{"30":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"18":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"90":{"tf":1.0},"97":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"90":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"90":{"tf":1.4142135623730951},"97":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"28":{"tf":2.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":6,"docs":{"105":{"tf":1.0},"118":{"tf":1.4142135623730951},"2":{"tf":1.0},"42":{"tf":1.0},"62":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":12,"docs":{"103":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"15":{"tf":1.4142135623730951},"77":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"2":{"tf":1.0},"45":{"tf":2.0},"57":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"68":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"12":{"tf":1.0},"19":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":31,"docs":{"1":{"tf":1.4142135623730951},"113":{"tf":1.0},"117":{"tf":2.23606797749979},"17":{"tf":1.7320508075688772},"2":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"33":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"68":{"tf":2.23606797749979},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":2.8284271247461903},"72":{"tf":3.3166247903554},"74":{"tf":1.0},"83":{"tf":2.449489742783178},"85":{"tf":1.4142135623730951},"87":{"tf":2.449489742783178},"9":{"tf":2.449489742783178},"91":{"tf":2.0},"95":{"tf":2.0},"97":{"tf":1.0},"98":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":2.449489742783178}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":12,"docs":{"100":{"tf":2.0},"105":{"tf":1.0},"108":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.0},"47":{"tf":1.7320508075688772},"57":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"113":{"tf":1.0},"117":{"tf":1.4142135623730951},"2":{"tf":1.0},"51":{"tf":2.23606797749979},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"8":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"113":{"tf":1.0},"118":{"tf":1.0},"67":{"tf":1.0},"85":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"121":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":20,"docs":{"108":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"17":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.4142135623730951},"33":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.7320508075688772},"71":{"tf":2.8284271247461903},"73":{"tf":1.4142135623730951},"8":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"96":{"tf":1.0},"99":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{",":{"df":0,"docs":{},"e":{"0":{"0":{"4":{"4":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"95":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.7320508075688772},"69":{"tf":1.0},"7":{"tf":1.0}}},"x":{"df":1,"docs":{"8":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"17":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"s":{"df":1,"docs":{"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"16":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"70":{"tf":1.0},"90":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"28":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"69":{"tf":1.0}}}}},"i":{"d":{"df":7,"docs":{"118":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"45":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"117":{"tf":1.0},"75":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"115":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"115":{"tf":1.0},"16":{"tf":1.0},"67":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"1":{"tf":1.0},"101":{"tf":2.6457513110645907},"102":{"tf":2.6457513110645907},"12":{"tf":1.4142135623730951},"2":{"tf":1.0},"37":{"tf":2.23606797749979},"38":{"tf":2.23606797749979},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":16,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"107":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"25":{"tf":1.0},"3":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"120":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}},"y":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"16":{"tf":1.0},"3":{"tf":1.0},"85":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"113":{"tf":3.0},"117":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"113":{"tf":1.4142135623730951},"114":{"tf":1.7320508075688772},"117":{"tf":2.23606797749979}}}},"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":3,"docs":{"103":{"tf":1.0},"2":{"tf":1.0},"82":{"tf":1.0}}},"/":{"1":{".":{"0":{".":{"1":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"3":{":":{"1":{"df":2,"docs":{"81":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{":":{"1":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"107":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":38,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"103":{"tf":2.449489742783178},"105":{"tf":1.0},"107":{"tf":1.7320508075688772},"108":{"tf":1.7320508075688772},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.7320508075688772},"113":{"tf":2.0},"114":{"tf":1.0},"121":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":2.23606797749979},"25":{"tf":2.23606797749979},"27":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":2.449489742783178},"46":{"tf":2.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"57":{"tf":2.0},"59":{"tf":1.0},"67":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"75":{"tf":1.0},"77":{"tf":2.0},"8":{"tf":3.605551275463989},"82":{"tf":1.4142135623730951},"90":{"tf":2.0},"91":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"105":{"tf":1.0},"19":{"tf":1.4142135623730951},"35":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":8,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"111":{"tf":1.0},"19":{"tf":1.7320508075688772},"35":{"tf":1.7320508075688772},"41":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"105":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"5":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}},"df":5,"docs":{"109":{"tf":1.0},"118":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"44":{"tf":1.7320508075688772},"45":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"44":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"13":{"tf":1.0}}}},"t":{"a":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"65":{"tf":1.0}}}},"y":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":27,"docs":{"110":{"tf":1.4142135623730951},"113":{"tf":1.0},"117":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":2.23606797749979},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"49":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"13":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"16":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"77":{"tf":1.7320508075688772},"86":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{":":{":":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":12,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"15":{"tf":1.4142135623730951},"23":{"tf":1.0},"27":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"62":{"tf":1.0},"80":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"=":{"<":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{">":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":4,"docs":{"118":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":12,"docs":{"106":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":10,"docs":{"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"113":{"tf":1.0},"44":{"tf":1.0}}}}}}}},"v":{"df":1,"docs":{"16":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"8":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"98":{"tf":2.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"107":{"tf":1.0},"33":{"tf":1.0},"46":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"90":{"tf":1.4142135623730951},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"71":{"tf":1.0},"72":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"113":{"tf":1.0},"57":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":7,"docs":{"1":{"tf":1.0},"107":{"tf":1.4142135623730951},"111":{"tf":1.0},"24":{"tf":1.7320508075688772},"27":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"104":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":3,"docs":{"69":{"tf":1.0},"76":{"tf":1.7320508075688772},"79":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"112":{"tf":1.0},"45":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"57":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":4,"docs":{"106":{"tf":2.0},"113":{"tf":1.0},"114":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"68":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"o":{"c":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"92":{"tf":1.7320508075688772}},"s":{"(":{"\"":{"df":0,"docs":{},"x":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"97":{"tf":2.0}}}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"107":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"18":{"tf":1.0},"63":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"99":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}},"e":{")":{"]":{"/":{"#":{"[":{"d":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"59":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":40,"docs":{"1":{"tf":1.7320508075688772},"103":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"107":{"tf":2.23606797749979},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":2.0},"113":{"tf":2.0},"117":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"24":{"tf":1.0},"3":{"tf":2.449489742783178},"43":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":4.358898943540674},"52":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":2.449489742783178},"69":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.4142135623730951},"90":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772}},"s":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"112":{"tf":2.23606797749979},"115":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"73":{"tf":3.3166247903554},"90":{"tf":1.0},"95":{"tf":1.7320508075688772},"97":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"121":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":66,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"106":{"tf":1.7320508075688772},"108":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":2.449489742783178},"114":{"tf":1.7320508075688772},"117":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"120":{"tf":1.0},"16":{"tf":2.449489742783178},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"26":{"tf":2.8284271247461903},"3":{"tf":1.4142135623730951},"30":{"tf":2.23606797749979},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":2.8284271247461903},"40":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.7320508075688772},"55":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772},"67":{"tf":1.0},"68":{"tf":2.8284271247461903},"7":{"tf":3.1622776601683795},"70":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":2.23606797749979},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":2.6457513110645907},"80":{"tf":2.6457513110645907},"81":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":2.8284271247461903},"90":{"tf":2.449489742783178},"91":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951},"99":{"tf":2.0}}}}}}}},"df":1,"docs":{"78":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":6,"docs":{"106":{"tf":1.0},"108":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.4142135623730951},"85":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":12,"docs":{"113":{"tf":1.0},"16":{"tf":1.0},"40":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"3":{"tf":1.0},"68":{"tf":1.0},"9":{"tf":1.0}}},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"106":{"tf":1.0},"2":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"9":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":1,"docs":{"87":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":7,"docs":{"11":{"tf":1.0},"16":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.4142135623730951},"72":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":4,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"8":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"18":{"tf":1.0},"3":{"tf":1.0},"51":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"g":{"df":3,"docs":{"72":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":2.8284271247461903},"71":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"5":{"df":1,"docs":{"71":{"tf":1.0}}},"8":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"41":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"114":{"tf":1.0},"45":{"tf":1.0},"50":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"35":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"114":{"tf":1.0},"16":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"47":{"tf":1.0},"87":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"116":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"100":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.0},"115":{"tf":1.7320508075688772},"23":{"tf":1.0},"30":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":7,"docs":{"104":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"16":{"tf":1.4142135623730951},"45":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"95":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"92":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"m":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":2,"docs":{"117":{"tf":1.0},"79":{"tf":1.7320508075688772}}}},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"100":{"tf":1.0},"71":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"108":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"69":{"tf":1.7320508075688772},"78":{"tf":1.0},"87":{"tf":1.0},"91":{"tf":1.4142135623730951},"95":{"tf":2.8284271247461903}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"77":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"113":{"tf":1.0},"26":{"tf":1.0},"77":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"16":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"72":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":51,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.7320508075688772},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"117":{"tf":2.23606797749979},"12":{"tf":2.0},"120":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":3.4641016151377544},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"23":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.4142135623730951},"35":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":2.0},"67":{"tf":2.8284271247461903},"68":{"tf":2.8284271247461903},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":3.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":2.6457513110645907},"84":{"tf":1.0},"85":{"tf":2.23606797749979},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"9":{"tf":2.8284271247461903},"90":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"97":{"tf":1.4142135623730951}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"99":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"112":{"tf":1.4142135623730951},"17":{"tf":1.0},"30":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.0},"9":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"107":{"tf":1.7320508075688772},"18":{"tf":1.0},"34":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"6":{"tf":1.0},"68":{"tf":1.0},"8":{"tf":2.0},"9":{"tf":1.7320508075688772},"97":{"tf":1.0}}}},"n":{"df":2,"docs":{"68":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"113":{"tf":1.0},"62":{"tf":1.4142135623730951},"77":{"tf":2.0}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"70":{"tf":1.0},"8":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"19":{"tf":1.0},"41":{"tf":1.7320508075688772},"73":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"41":{"tf":1.0},"96":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":9,"docs":{"107":{"tf":1.7320508075688772},"29":{"tf":2.0},"51":{"tf":1.0},"57":{"tf":2.449489742783178},"59":{"tf":1.0},"67":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"95":{"tf":1.0},"99":{"tf":1.0}}}}},"r":{"a":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951}}}}}},"m":{"d":{"df":2,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":5,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"17":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":10,"docs":{"17":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":1.7320508075688772},"77":{"tf":1.7320508075688772},"79":{"tf":1.0},"85":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"89":{"tf":1.0}}},"s":{"df":1,"docs":{"70":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"112":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":6,"docs":{"51":{"tf":2.0},"65":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":2.0},"77":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":18,"docs":{"100":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"56":{"tf":1.4142135623730951},"71":{"tf":1.0},"8":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"90":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":2.449489742783178},"94":{"tf":1.7320508075688772},"96":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{"(":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"99":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"=":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"72":{"tf":2.0}}},"df":0,"docs":{}},"w":{"df":3,"docs":{"7":{"tf":1.0},"71":{"tf":1.0},"98":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":30,"docs":{"0":{"tf":1.0},"101":{"tf":1.7320508075688772},"102":{"tf":1.7320508075688772},"103":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"109":{"tf":1.0},"111":{"tf":2.0},"114":{"tf":1.0},"117":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":2.23606797749979},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"105":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":1.7320508075688772},"90":{"tf":1.4142135623730951}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"118":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"d":{"df":4,"docs":{"27":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"2":{"tf":1.4142135623730951},"4":{"tf":1.0},"43":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951},"92":{"tf":1.0}}}}},"t":{"df":1,"docs":{"8":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"x":{"df":2,"docs":{"2":{"tf":1.0},"83":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":48,"docs":{"100":{"tf":1.7320508075688772},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"107":{"tf":2.0},"108":{"tf":1.4142135623730951},"111":{"tf":1.7320508075688772},"112":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"115":{"tf":1.7320508075688772},"2":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":2.23606797749979},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"45":{"tf":2.23606797749979},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.0},"90":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":29,"docs":{"1":{"tf":1.0},"114":{"tf":1.4142135623730951},"16":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.4142135623730951},"5":{"tf":1.0},"51":{"tf":2.0},"62":{"tf":2.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"69":{"tf":2.6457513110645907},"70":{"tf":1.7320508075688772},"71":{"tf":2.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":14,"docs":{"11":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}},"o":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}},".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.4142135623730951}},"s":{":":{"1":{":":{"1":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}},"9":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"1":{"df":1,"docs":{"74":{"tf":1.0}}},"2":{"df":1,"docs":{"74":{"tf":1.0}}},"3":{"df":1,"docs":{"74":{"tf":1.0}}},"4":{"df":1,"docs":{"74":{"tf":1.0}}},"`":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":19,"docs":{"1":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":2.6457513110645907},"2":{"tf":2.23606797749979},"5":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.0},"68":{"tf":2.0},"70":{"tf":1.4142135623730951},"71":{"tf":2.0},"72":{"tf":1.7320508075688772},"76":{"tf":2.6457513110645907},"77":{"tf":1.4142135623730951},"79":{"tf":2.6457513110645907},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":3.1622776601683795}},"e":{"[":{"^":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"r":{"c":{"df":3,"docs":{"108":{"tf":1.4142135623730951},"67":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"114":{"tf":2.6457513110645907},"117":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772}}}},"df":8,"docs":{"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"85":{"tf":1.0}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"+":{"1":{"0":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"72":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"72":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"+":{"1":{"0":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"121":{"tf":1.0},"8":{"tf":2.449489742783178}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"30":{"tf":1.0},"67":{"tf":1.0}},"i":{"df":2,"docs":{"75":{"tf":1.0},"93":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"2":{"tf":1.0}}},"df":19,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":2.0},"51":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"8":{"tf":1.0},"81":{"tf":1.4142135623730951},"83":{"tf":1.0},"9":{"tf":2.6457513110645907},"91":{"tf":2.23606797749979},"94":{"tf":1.0},"98":{"tf":1.4142135623730951}}}}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"98":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"71":{"tf":1.0},"8":{"tf":1.7320508075688772},"82":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"94":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":27,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"103":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.7320508075688772},"111":{"tf":1.4142135623730951},"113":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":2.0},"30":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":2.0},"5":{"tf":1.4142135623730951},"51":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"62":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.0}}}}},"t":{"df":2,"docs":{"111":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":3,"docs":{"11":{"tf":1.0},"121":{"tf":1.4142135623730951},"13":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":18,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"94":{"tf":1.0}},"n":{"df":13,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"43":{"tf":1.4142135623730951},"51":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"70":{"tf":1.0},"77":{"tf":1.4142135623730951},"90":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":2,"docs":{"115":{"tf":1.0},"33":{"tf":1.0}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"53":{"tf":1.0},"54":{"tf":1.0},"8":{"tf":1.0}}},"o":{"d":{"df":7,"docs":{"109":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"91":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"16":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"45":{"tf":1.0},"95":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"121":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"121":{"tf":1.0},"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"1":{"df":1,"docs":{"86":{"tf":2.0}}},"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"54":{"tf":1.0}},"l":{"df":4,"docs":{"17":{"tf":1.4142135623730951},"51":{"tf":1.0},"69":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"98":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":2,"docs":{"23":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"df":1,"docs":{"21":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":2,"docs":{"35":{"tf":1.0},"36":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"1":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":13,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":2.23606797749979},"3":{"tf":1.0},"30":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"82":{"tf":1.0},"85":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":6,"docs":{"16":{"tf":1.0},"20":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0}}},"df":11,"docs":{"114":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"73":{"tf":1.4142135623730951},"78":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}},"’":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"68":{"tf":2.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"91":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"111":{"tf":1.0},"23":{"tf":1.4142135623730951},"33":{"tf":1.0},"90":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"=":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"'":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"'":{">":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"g":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":15,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"107":{"tf":1.7320508075688772},"111":{"tf":1.4142135623730951},"114":{"tf":1.0},"13":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.0},"37":{"tf":2.0},"38":{"tf":2.0},"45":{"tf":1.0},"5":{"tf":1.4142135623730951},"57":{"tf":1.0},"86":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"88":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"/":{"1":{".":{"0":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}}}}}}}},"i":{".":{"df":1,"docs":{"113":{"tf":1.0}}},"3":{"2":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":2,"docs":{"65":{"tf":1.0},"69":{"tf":1.0}},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"18":{"tf":1.0},"3":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"115":{"tf":2.8284271247461903},"32":{"tf":1.0},"35":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"77":{"tf":1.4142135623730951},"91":{"tf":1.0}},"e":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":2,"docs":{"113":{"tf":1.7320508075688772},"18":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"113":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"45":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.4142135623730951},"91":{"tf":1.0},"98":{"tf":2.0},"99":{"tf":1.4142135623730951}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"68":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":23,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"105":{"tf":1.0},"117":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":2.23606797749979},"75":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"!":{"(":{"\"":{".":{".":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":2,"docs":{"51":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":2.23606797749979}}}},"x":{"df":4,"docs":{"109":{"tf":2.23606797749979},"110":{"tf":1.7320508075688772},"111":{"tf":1.0},"95":{"tf":1.0}}}},"i":{"c":{"df":3,"docs":{"47":{"tf":1.0},"57":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":10,"docs":{"114":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"62":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"4":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"50":{"tf":2.0},"69":{"tf":2.8284271247461903}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"101":{"tf":1.7320508075688772},"102":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}},"i":{"d":{"df":7,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"116":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"a":{"d":{"df":15,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"113":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"34":{"tf":1.0},"51":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}},"n":{"d":{"df":6,"docs":{"106":{"tf":1.0},"108":{"tf":1.0},"82":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"f":{"a":{"c":{"df":2,"docs":{"18":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":4,"docs":{"108":{"tf":1.0},"18":{"tf":1.4142135623730951},"3":{"tf":1.0},"99":{"tf":1.7320508075688772}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{">":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"r":{"a":{"df":6,"docs":{"120":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":3,"docs":{"8":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.0}},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"87":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"86":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"o":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"98":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":7,"docs":{"106":{"tf":1.0},"121":{"tf":1.0},"2":{"tf":1.0},"56":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"'":{"df":7,"docs":{"112":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0},"90":{"tf":1.4142135623730951},"99":{"tf":1.0}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"117":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"9":{"tf":1.0}}},"df":27,"docs":{"104":{"tf":1.7320508075688772},"113":{"tf":3.3166247903554},"114":{"tf":2.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"26":{"tf":3.0},"4":{"tf":1.7320508075688772},"51":{"tf":1.0},"57":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"63":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":2.23606797749979},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":2.0},"79":{"tf":1.4142135623730951},"80":{"tf":3.0},"81":{"tf":1.0},"84":{"tf":1.4142135623730951},"9":{"tf":1.0},"90":{"tf":2.0},"92":{"tf":1.4142135623730951},"97":{"tf":2.23606797749979}}},"r":{"df":2,"docs":{"9":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"113":{"tf":1.0},"4":{"tf":1.0}}}}}}},"’":{"df":0,"docs":{},"m":{"df":1,"docs":{"70":{"tf":1.0}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"111":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"df":3,"docs":{"0":{"tf":1.0},"51":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"114":{"tf":2.23606797749979},"117":{"tf":1.0}}}}},"u":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":5,"docs":{"107":{"tf":1.0},"112":{"tf":1.4142135623730951},"68":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"51":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":5,"docs":{"119":{"tf":1.0},"27":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"91":{"tf":1.7320508075688772}},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":3,"docs":{"103":{"tf":1.4142135623730951},"39":{"tf":1.0},"5":{"tf":1.0}}}}}},"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"21":{"tf":1.0},"93":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":2,"docs":{"27":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":2,"docs":{"51":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"120":{"tf":1.0}}}},"v":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"54":{"tf":1.0},"67":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"115":{"tf":1.0},"45":{"tf":1.0}}}},"t":{"'":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"62":{"tf":1.0},"9":{"tf":1.0}}},"df":7,"docs":{"25":{"tf":1.0},"29":{"tf":1.0},"42":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":11,"docs":{"0":{"tf":1.0},"109":{"tf":1.0},"16":{"tf":1.4142135623730951},"3":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"82":{"tf":1.0},"86":{"tf":1.0}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":3,"docs":{"117":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0}},"s":{"\"":{":":{"df":0,"docs":{},"{":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"\"":{":":{"4":{",":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"\"":{":":{"4":{",":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"\"":{":":{"4":{",":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"\"":{":":{"1":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"106":{"tf":1.0},"108":{"tf":1.4142135623730951},"16":{"tf":1.0},"27":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"56":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"9":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.0}}},"y":{"'":{"df":2,"docs":{"46":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"105":{"tf":1.0}}}}},"df":0,"docs":{}},"df":4,"docs":{"105":{"tf":1.0},"34":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"69":{"tf":1.0},"92":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":16,"docs":{"100":{"tf":1.7320508075688772},"108":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"47":{"tf":2.449489742783178},"57":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.4142135623730951},"68":{"tf":2.0},"70":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":2.6457513110645907},"9":{"tf":2.0},"94":{"tf":1.0}}},"k":{"!":{"]":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":24,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.7320508075688772},"111":{"tf":1.0},"12":{"tf":1.7320508075688772},"120":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":2.0},"58":{"tf":1.0},"62":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":3.0},"75":{"tf":2.0},"77":{"tf":3.3166247903554},"78":{"tf":1.4142135623730951},"79":{"tf":2.6457513110645907},"8":{"tf":1.0},"80":{"tf":2.6457513110645907},"88":{"tf":1.7320508075688772},"9":{"tf":1.0},"93":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"5":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{":":{"6":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"3":{":":{"5":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{":":{"5":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":14,"docs":{"113":{"tf":1.4142135623730951},"16":{"tf":2.0},"67":{"tf":1.0},"78":{"tf":2.449489742783178},"79":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":16,"docs":{"110":{"tf":1.0},"117":{"tf":1.0},"14":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"98":{"tf":1.7320508075688772},"99":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"68":{"tf":1.0},"87":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"83":{"tf":1.0}},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.0}}}}},"o":{"a":{"d":{"df":2,"docs":{"111":{"tf":1.7320508075688772},"47":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"107":{"tf":1.4142135623730951},"57":{"tf":1.0}}},"t":{"df":6,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"111":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":1.7320508075688772},"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":45,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"68":{"tf":1.4142135623730951},"77":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.0}}},"p":{"df":1,"docs":{"71":{"tf":1.0}}}},"t":{"df":1,"docs":{"111":{"tf":1.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"116":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"70":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"67":{"tf":1.0},"70":{"tf":1.7320508075688772}}}}},"df":8,"docs":{"18":{"tf":1.0},"51":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"77":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"91":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":12,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"62":{"tf":2.0},"67":{"tf":2.0},"69":{"tf":2.0},"70":{"tf":2.0},"73":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":14,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.0},"55":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"113":{"tf":1.0},"119":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":13,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"101":{"tf":2.23606797749979},"102":{"tf":2.23606797749979},"103":{"tf":2.23606797749979},"109":{"tf":1.0},"35":{"tf":2.0},"39":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"5":{"tf":2.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"74":{"tf":1.0}}}}}},"df":2,"docs":{"100":{"tf":1.0},"85":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"87":{"tf":1.0},"98":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"99":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"107":{"tf":1.0},"13":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"70":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"d":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":7,"docs":{"23":{"tf":1.0},"51":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"103":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"113":{"tf":1.0}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":1,"docs":{"85":{"tf":1.0}},"n":{"d":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":3,"docs":{"16":{"tf":1.0},"81":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"113":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"d":{"df":5,"docs":{"26":{"tf":1.0},"62":{"tf":2.0},"77":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":3,"docs":{"23":{"tf":1.0},"45":{"tf":1.0},"94":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"105":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"104":{"tf":2.0},"62":{"tf":1.0},"77":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"82":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":30,"docs":{"118":{"tf":1.0},"120":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"51":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"109":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"51":{"tf":1.0},"92":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"69":{"tf":2.0}}}},"y":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":15,"docs":{"104":{"tf":1.0},"105":{"tf":1.0},"107":{"tf":1.0},"2":{"tf":2.23606797749979},"24":{"tf":1.0},"25":{"tf":2.6457513110645907},"3":{"tf":1.4142135623730951},"34":{"tf":1.0},"44":{"tf":1.7320508075688772},"65":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.7320508075688772},"79":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"76":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"17":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":15,"docs":{"105":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"4":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":2.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":1,"docs":{"73":{"tf":1.0}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}},"w":{"df":7,"docs":{"1":{"tf":1.7320508075688772},"19":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.4142135623730951},"82":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":3,"docs":{"34":{"tf":1.0},"68":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"83":{"tf":1.0},"86":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":2.449489742783178}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"t":{"d":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"\"":{":":{"df":0,"docs":{},"{":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"\"":{":":{"3":{",":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"\"":{":":{"1":{",":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"\"":{":":{"3":{",":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"\"":{":":{"0":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"107":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":2.0}}}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":8,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":23,"docs":{"113":{"tf":1.0},"114":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.0},"34":{"tf":1.0},"51":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":2.23606797749979},"81":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"h":{"df":2,"docs":{"115":{"tf":1.0},"4":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":4,"docs":{"16":{"tf":1.0},"2":{"tf":1.4142135623730951},"55":{"tf":1.0},"62":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"104":{"tf":1.0},"12":{"tf":1.4142135623730951},"27":{"tf":1.0},"56":{"tf":1.4142135623730951},"73":{"tf":1.0},"95":{"tf":2.23606797749979}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"24":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":4,"docs":{"103":{"tf":1.0},"120":{"tf":1.0},"45":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":2,"docs":{"17":{"tf":1.0},"69":{"tf":1.7320508075688772}}},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"118":{"tf":1.0},"69":{"tf":1.0}}}}},"n":{"c":{"df":2,"docs":{"111":{"tf":1.0},"91":{"tf":1.4142135623730951}}},"df":11,"docs":{"107":{"tf":1.0},"114":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"34":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"85":{"tf":1.0},"9":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"113":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"47":{"tf":1.0}}},"r":{"df":4,"docs":{"45":{"tf":1.0},"69":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"s":{"df":2,"docs":{"7":{"tf":1.0},"77":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":26,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"109":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":2.0},"117":{"tf":2.0},"19":{"tf":1.0},"21":{"tf":1.0},"30":{"tf":2.0},"32":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"104":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"4":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"104":{"tf":1.0},"107":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"62":{"tf":1.0},"77":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"50":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"113":{"tf":1.0},"119":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":18,"docs":{"105":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"114":{"tf":2.23606797749979},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":2.23606797749979},"34":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.0},"51":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"89":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"117":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"107":{"tf":1.0},"115":{"tf":1.0},"25":{"tf":1.0},"42":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"117":{"tf":1.0},"9":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":18,"docs":{"1":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.0},"109":{"tf":2.449489742783178},"110":{"tf":1.7320508075688772},"111":{"tf":1.0},"121":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.7320508075688772},"21":{"tf":1.0},"34":{"tf":1.0},"62":{"tf":1.4142135623730951},"71":{"tf":1.0},"74":{"tf":1.4142135623730951},"8":{"tf":2.449489742783178},"89":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"$":{"(":{"$":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"!":{"(":{"1":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"70":{"tf":1.0}}}}}}}}},"df":4,"docs":{"66":{"tf":1.0},"70":{"tf":1.0},"85":{"tf":2.0},"9":{"tf":2.23606797749979}},"k":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":2.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"87":{"tf":1.0}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"71":{"tf":1.0}}}}}}}}}}}},"t":{"df":10,"docs":{"105":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"30":{"tf":1.0},"68":{"tf":1.7320508075688772},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"91":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":28,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"116":{"tf":1.4142135623730951},"118":{"tf":2.8284271247461903},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.4142135623730951},"41":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.4142135623730951},"71":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772},"90":{"tf":1.0},"91":{"tf":1.0}}},"t":{"df":2,"docs":{"118":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"44":{"tf":1.0},"45":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},">":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":10,"docs":{"1":{"tf":1.0},"111":{"tf":1.7320508075688772},"24":{"tf":1.0},"27":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"47":{"tf":2.0},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"113":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":3,"docs":{"111":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"47":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":5,"docs":{"107":{"tf":1.4142135623730951},"24":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"90":{"tf":1.7320508075688772},"91":{"tf":2.0},"97":{"tf":2.23606797749979}}}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"103":{"tf":3.3166247903554},"39":{"tf":2.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":6,"docs":{"103":{"tf":1.0},"119":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"56":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"82":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"85":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"103":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":1,"docs":{"67":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"72":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"76":{"tf":1.0},"79":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"103":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"51":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":4,"docs":{"115":{"tf":1.0},"68":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0}}}}},"s":{"df":1,"docs":{"55":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"115":{"tf":1.0},"68":{"tf":1.0},"9":{"tf":1.0},"99":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"34":{"tf":1.0}},"s":{"df":1,"docs":{"117":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"98":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":1.4142135623730951},"75":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"104":{"tf":1.4142135623730951},"113":{"tf":1.0},"46":{"tf":1.0},"68":{"tf":1.4142135623730951},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":3,"docs":{"16":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}}},"w":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"17":{"tf":1.4142135623730951},"68":{"tf":2.6457513110645907},"9":{"tf":1.0}}}}}},"v":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"6":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"113":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"26":{"tf":2.23606797749979},"62":{"tf":1.0},"73":{"tf":1.4142135623730951},"80":{"tf":3.872983346207417},"84":{"tf":2.0}},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"80":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"69":{"tf":1.0},"90":{"tf":1.0}}}}}},"c":{"df":1,"docs":{"77":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"67":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"97":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":7,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"118":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"116":{"tf":1.7320508075688772},"58":{"tf":1.0},"68":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"16":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"80":{"tf":1.0},"95":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":11,"docs":{"103":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"64":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"82":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"b":{"df":21,"docs":{"114":{"tf":1.4142135623730951},"2":{"tf":1.0},"26":{"tf":1.4142135623730951},"62":{"tf":3.605551275463989},"73":{"tf":1.7320508075688772},"74":{"tf":2.23606797749979},"75":{"tf":1.4142135623730951},"77":{"tf":2.23606797749979},"79":{"tf":2.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"c":{"df":10,"docs":{"113":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"26":{"tf":2.23606797749979},"62":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.7320508075688772},"80":{"tf":2.449489742783178},"9":{"tf":1.0},"91":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"119":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}},"t":{"df":7,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"68":{"tf":1.0},"8":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"100":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"69":{"tf":1.0},"9":{"tf":1.0}}}}},"df":1,"docs":{"50":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"d":{"df":3,"docs":{"47":{"tf":1.0},"65":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"12":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}},"m":{"df":1,"docs":{"73":{"tf":1.7320508075688772}},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":10,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"30":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"91":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"70":{"tf":1.0},"98":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"113":{"tf":1.0},"46":{"tf":1.0},"91":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"r":{"d":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":4,"docs":{"113":{"tf":1.0},"2":{"tf":1.0},"62":{"tf":1.4142135623730951},"77":{"tf":2.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"10":{"tf":1.0},"119":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"120":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"90":{"tf":1.0},"91":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"30":{"tf":1.0},"66":{"tf":1.4142135623730951},"73":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"=":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"77":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"118":{"tf":1.0},"23":{"tf":1.0},"71":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"68":{"tf":1.0}}}},"i":{"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":3,"docs":{"19":{"tf":1.0},"34":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"51":{"tf":1.0},"63":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"105":{"tf":1.0},"111":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":17,"docs":{"101":{"tf":1.7320508075688772},"102":{"tf":1.7320508075688772},"103":{"tf":1.7320508075688772},"105":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"51":{"tf":1.0},"68":{"tf":1.0},"76":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"119":{"tf":1.0},"34":{"tf":1.0},"55":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"r":{"df":9,"docs":{"103":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"v":{"df":5,"docs":{"16":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":2.6457513110645907},"79":{"tf":1.0},"80":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"105":{"tf":1.4142135623730951},"111":{"tf":1.0},"119":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"90":{"tf":1.4142135623730951},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":4,"docs":{"6":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"69":{"tf":1.7320508075688772}}}},"df":7,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"17":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"95":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"66":{"tf":1.0},"69":{"tf":2.0},"9":{"tf":1.7320508075688772},"98":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}}},"f":{"c":{"df":2,"docs":{"120":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"68":{"tf":1.0},"71":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"118":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"46":{"tf":1.0}}},"df":12,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"103":{"tf":1.0},"107":{"tf":1.7320508075688772},"111":{"tf":2.0},"114":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.4142135623730951},"42":{"tf":1.0},"57":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0}}}},"w":{"df":1,"docs":{"13":{"tf":1.0}}}},"s":{"df":1,"docs":{"25":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":4,"docs":{"117":{"tf":1.0},"45":{"tf":1.4142135623730951},"67":{"tf":1.0},"7":{"tf":1.0}}}},"n":{"df":23,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.0},"112":{"tf":1.4142135623730951},"115":{"tf":1.7320508075688772},"116":{"tf":2.23606797749979},"118":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"30":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"39":{"tf":1.0},"49":{"tf":1.0},"55":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.7320508075688772},"78":{"tf":1.0},"85":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"116":{"tf":1.0},"32":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"116":{"tf":2.449489742783178}}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"8":{"tf":1.0}}},"c":{"df":10,"docs":{"108":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":2.0},"33":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"c":{"'":{"df":8,"docs":{"111":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"24":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.0},"73":{"tf":1.0}}},"df":84,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"100":{"tf":1.7320508075688772},"101":{"tf":2.0},"102":{"tf":2.0},"103":{"tf":1.0},"104":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"107":{"tf":2.0},"108":{"tf":1.4142135623730951},"111":{"tf":1.7320508075688772},"112":{"tf":1.4142135623730951},"113":{"tf":2.0},"115":{"tf":2.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"120":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":2.0},"2":{"tf":2.449489742783178},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":2.23606797749979},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":2.449489742783178},"30":{"tf":2.8284271247461903},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"43":{"tf":2.0},"44":{"tf":1.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"5":{"tf":2.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":2.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.7320508075688772},"8":{"tf":1.0},"81":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.7320508075688772},"91":{"tf":2.449489742783178},"92":{"tf":1.4142135623730951},"93":{"tf":1.0},"97":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"100":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":27,"docs":{"0":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"109":{"tf":1.0},"113":{"tf":1.0},"120":{"tf":1.7320508075688772},"121":{"tf":1.0},"17":{"tf":1.4142135623730951},"30":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":3.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":15,"docs":{"103":{"tf":1.0},"111":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"17":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"45":{"tf":1.4142135623730951},"51":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"79":{"tf":1.0}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"75":{"tf":1.0},"77":{"tf":2.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":2.0}}}}}}},"df":4,"docs":{"5":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.0},"77":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"1":{"tf":1.0},"111":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":2.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"2":{"tf":1.4142135623730951},"70":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"62":{"tf":1.7320508075688772},"69":{"tf":1.0},"72":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":22,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"106":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"4":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"n":{"df":3,"docs":{"113":{"tf":1.4142135623730951},"34":{"tf":1.0},"90":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"f":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"v":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"45":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"69":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":1,"docs":{"97":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"t":{"df":9,"docs":{"107":{"tf":1.0},"17":{"tf":1.0},"34":{"tf":2.0},"65":{"tf":1.0},"68":{"tf":2.0},"73":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"10":{"tf":1.0},"105":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.7320508075688772}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":4,"docs":{"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"85":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"df":15,"docs":{"113":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"117":{"tf":1.7320508075688772},"17":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"26":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.4142135623730951},"92":{"tf":1.0},"98":{"tf":1.0}},"n":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"11":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"9":{"tf":1.0},"91":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"29":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"111":{"tf":1.0},"51":{"tf":1.0}}}}},"x":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"91":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"22":{"tf":1.0},"30":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.0},"90":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"68":{"tf":1.0},"73":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":2.23606797749979}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"104":{"tf":1.0},"50":{"tf":1.0},"58":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"51":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"10":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"105":{"tf":1.0},"62":{"tf":1.0},"75":{"tf":1.0},"98":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{"df":9,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.4142135623730951},"8":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"95":{"tf":1.0}},"i":{"df":7,"docs":{"24":{"tf":1.0},"29":{"tf":1.7320508075688772},"33":{"tf":1.0},"47":{"tf":1.0},"67":{"tf":1.4142135623730951},"71":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":39,"docs":{"1":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":2.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0}},"s":{":":{"1":{":":{"1":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"1":{"df":1,"docs":{"16":{"tf":1.0}}},"9":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"95":{"tf":1.0}}}},"l":{"df":7,"docs":{"114":{"tf":1.0},"118":{"tf":1.0},"21":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"121":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772}}}}},"r":{"d":{"df":11,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"108":{"tf":1.4142135623730951},"23":{"tf":1.0},"56":{"tf":1.0},"64":{"tf":1.0},"75":{"tf":1.0},"9":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"8":{"tf":2.0},"82":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"i":{"c":{"=":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"111":{"tf":2.0},"117":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}}},"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"69":{"tf":2.0}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"<":{"'":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"c":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"107":{"tf":1.0},"111":{"tf":1.0},"45":{"tf":1.0},"68":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.4142135623730951},"80":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":2.0}}}}}}}}}}},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"69":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"115":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"68":{"tf":1.0}}}},"p":{"df":4,"docs":{"118":{"tf":1.0},"63":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"117":{"tf":1.0}}}}}}}},"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":11,"docs":{"115":{"tf":1.4142135623730951},"62":{"tf":2.449489742783178},"73":{"tf":2.8284271247461903},"74":{"tf":3.1622776601683795},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":2.0},"92":{"tf":1.7320508075688772},"97":{"tf":2.449489742783178}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"115":{"tf":1.4142135623730951},"19":{"tf":1.0},"47":{"tf":1.0}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"119":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"71":{"tf":1.0},"72":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0}}}},"df":0,"docs":{},"f":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"105":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"105":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":2,"docs":{"105":{"tf":1.7320508075688772},"111":{"tf":1.0}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"79":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"91":{"tf":1.0}}}},"m":{"df":1,"docs":{"68":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}},"i":{"df":2,"docs":{"6":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":1.0},"75":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"50":{"tf":1.0},"65":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":2.0}}}},"s":{"df":1,"docs":{"97":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"106":{"tf":1.0},"40":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"103":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.0},"90":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":9,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0},"4":{"tf":2.0},"51":{"tf":1.0},"72":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":2.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"42":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":2.23606797749979},"40":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":7,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"115":{"tf":1.0},"121":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"86":{"tf":1.7320508075688772}}},"k":{"df":0,"docs":{},"e":{"df":12,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"73":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":1,"docs":{"16":{"tf":1.0}}},"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"c":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"=":{"+":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"x":{"df":1,"docs":{"30":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":5,"docs":{"115":{"tf":2.449489742783178},"3":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":2.23606797749979},"90":{"tf":2.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"14":{"tf":2.6457513110645907}}}}},"df":2,"docs":{"75":{"tf":1.0},"95":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"30":{"tf":1.0},"71":{"tf":2.0},"97":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"2":{"4":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":23,"docs":{"106":{"tf":1.7320508075688772},"112":{"tf":1.7320508075688772},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"30":{"tf":2.6457513110645907},"31":{"tf":2.449489742783178},"32":{"tf":2.8284271247461903},"43":{"tf":1.0},"5":{"tf":1.0},"65":{"tf":2.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":2.0},"71":{"tf":2.0},"73":{"tf":3.1622776601683795},"78":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":2.0},"85":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":7,"docs":{"11":{"tf":2.0},"12":{"tf":2.449489742783178},"51":{"tf":1.4142135623730951},"67":{"tf":1.0},"71":{"tf":1.0},"9":{"tf":1.0},"95":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":3,"docs":{"33":{"tf":1.0},"4":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"44":{"tf":1.0}}},".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"41":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.0}}}}},"df":0,"docs":{}},"=":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"u":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}},"df":5,"docs":{"19":{"tf":2.449489742783178},"34":{"tf":3.1622776601683795},"41":{"tf":1.0},"44":{"tf":3.0},"45":{"tf":3.3166247903554}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"100":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":4,"docs":{"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"y":{"'":{"df":0,"docs":{},"r":{"df":3,"docs":{"112":{"tf":1.0},"26":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":9,"docs":{"116":{"tf":1.4142135623730951},"16":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"90":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"k":{"df":2,"docs":{"2":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":10,"docs":{"107":{"tf":2.0},"108":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"15":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"70":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"113":{"tf":1.0},"51":{"tf":1.0},"65":{"tf":1.0},"92":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":3,"docs":{"70":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"11":{"tf":1.0},"116":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"92":{"tf":1.4142135623730951}}}}}}},"u":{"df":3,"docs":{"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}},"m":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"93":{"tf":1.0}},"l":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":6,"docs":{"113":{"tf":1.0},"16":{"tf":1.0},"30":{"tf":1.0},"68":{"tf":1.4142135623730951},"9":{"tf":1.0},"92":{"tf":1.0}}}}},"o":{"c":{"df":1,"docs":{"40":{"tf":1.7320508075688772}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"90":{"tf":1.7320508075688772},"97":{"tf":2.0}}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"114":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"0":{"tf":1.0}}}},"p":{"df":6,"docs":{"1":{"tf":1.0},"109":{"tf":1.4142135623730951},"16":{"tf":1.0},"3":{"tf":1.0},"62":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":4,"docs":{"56":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"113":{"tf":1.4142135623730951},"17":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"98":{"tf":3.1622776601683795},"99":{"tf":2.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"43":{"tf":1.0},"50":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":6,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"5":{"tf":1.0},"71":{"tf":1.0},"9":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"115":{"tf":1.0},"23":{"tf":1.0},"33":{"tf":1.7320508075688772},"65":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"15":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":8,"docs":{"107":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.4142135623730951},"68":{"tf":1.0},"70":{"tf":1.0},"97":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"117":{"tf":1.0}}}}},"df":12,"docs":{"107":{"tf":1.0},"18":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":2.0},"75":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.7320508075688772},"91":{"tf":2.0},"98":{"tf":2.0},"99":{"tf":2.0}}},"o":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"116":{"tf":1.4142135623730951},"3":{"tf":1.0},"93":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"5":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":2,"docs":{"114":{"tf":1.4142135623730951},"81":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"5":{"tf":1.0},"69":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"15":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"75":{"tf":1.0},"91":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"69":{"tf":1.0},"76":{"tf":1.0}}}},"t":{"df":2,"docs":{"66":{"tf":1.0},"73":{"tf":1.4142135623730951}}},"x":{"df":4,"docs":{"47":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"90":{"tf":1.0},"97":{"tf":1.0}}}}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"85":{"tf":1.0},"91":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"62":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":5,"docs":{"103":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"108":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"86":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":21,"docs":{"100":{"tf":1.7320508075688772},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.7320508075688772},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"21":{"tf":1.0},"56":{"tf":1.0},"93":{"tf":1.7320508075688772},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"87":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":8,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"91":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"l":{"df":7,"docs":{"103":{"tf":3.3166247903554},"107":{"tf":2.0},"39":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"75":{"tf":1.0},"88":{"tf":1.7320508075688772}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"1":{"tf":1.0},"16":{"tf":1.0}}}},"df":87,"docs":{"10":{"tf":1.0},"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.7320508075688772},"108":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"117":{"tf":1.0},"118":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":2.23606797749979},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":2.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":3.0},"64":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":2.0},"69":{"tf":2.6457513110645907},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951},"73":{"tf":2.0},"74":{"tf":1.0},"75":{"tf":1.7320508075688772},"77":{"tf":1.7320508075688772},"78":{"tf":1.0},"8":{"tf":3.1622776601683795},"82":{"tf":1.0},"88":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772},"90":{"tf":2.0},"91":{"tf":1.0},"92":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":2.449489742783178},"99":{"tf":1.7320508075688772}},"e":{"'":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":7,"docs":{"106":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"34":{"tf":1.0},"8":{"tf":1.4142135623730951},"82":{"tf":1.0},"9":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"73":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"106":{"tf":1.0},"112":{"tf":1.0},"33":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"47":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"73":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"v":{"0":{".":{"1":{".":{"0":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"116":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"d":{"df":3,"docs":{"73":{"tf":1.0},"75":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":5,"docs":{"28":{"tf":1.4142135623730951},"34":{"tf":1.0},"57":{"tf":1.4142135623730951},"76":{"tf":1.0},"85":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"100":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951}},"e":{"c":{"<":{"df":0,"docs":{},"t":{">":{"`":{"]":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"75":{"tf":1.0}}}},"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"101":{"tf":1.0},"102":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"23":{"tf":2.23606797749979},"3":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"73":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":11,"docs":{"111":{"tf":1.0},"115":{"tf":1.7320508075688772},"22":{"tf":2.0},"23":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":2.449489742783178},"51":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}}},"i":{"a":{"df":2,"docs":{"51":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":13,"docs":{"107":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":2.23606797749979},"69":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"90":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"16":{"tf":2.0},"81":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"87":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":16,"docs":{"106":{"tf":2.23606797749979},"16":{"tf":2.0},"60":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":2.23606797749979},"80":{"tf":2.23606797749979},"81":{"tf":1.4142135623730951},"82":{"tf":2.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":2.0},"87":{"tf":1.7320508075688772},"88":{"tf":2.23606797749979}}}},"y":{"df":8,"docs":{"103":{"tf":1.0},"16":{"tf":1.4142135623730951},"30":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"72":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.4142135623730951}}}},"df":1,"docs":{"114":{"tf":1.0}},"e":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.0}}}},"r":{"df":1,"docs":{"73":{"tf":1.0}}},"v":{"df":1,"docs":{"51":{"tf":1.0}}}},"b":{"df":2,"docs":{"1":{"tf":1.0},"71":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"10":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"100":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.4142135623730951},"43":{"tf":1.0},"70":{"tf":1.0}}}},"’":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"90":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"8":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"69":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"68":{"tf":1.0},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"'":{"1":{"0":{"0":{"'":{">":{"<":{"/":{"a":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":5,"docs":{"33":{"tf":1.0},"47":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"90":{"tf":1.0},"97":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"106":{"tf":1.0},"65":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"118":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"73":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"k":{"df":10,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":1.0},"24":{"tf":1.0},"45":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951}}},"l":{"d":{"df":5,"docs":{"16":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"'":{"df":0,"docs":{},"v":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"62":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"11":{"tf":1.0},"17":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":10,"docs":{"113":{"tf":1.0},"121":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":2.449489742783178},"73":{"tf":1.4142135623730951},"78":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":1.7320508075688772},"90":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"113":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"23":{"tf":1.4142135623730951},"75":{"tf":1.0}}}}}}}}},"x":{"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"14":{"tf":1.0},"65":{"tf":1.7320508075688772},"68":{"tf":4.242640687119285},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"92":{"tf":1.4142135623730951}}},"y":{"df":1,"docs":{"68":{"tf":4.242640687119285}},"e":{"df":1,"docs":{"68":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"109":{"tf":1.0},"2":{"tf":1.0},"67":{"tf":1.0},"79":{"tf":1.0}}}},"r":{"df":1,"docs":{"111":{"tf":1.0}}},"v":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"’":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}},"z":{"df":15,"docs":{"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951}}}}},"breadcrumbs":{"root":{"0":{"4":{"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.0}}},"df":0,"docs":{}},"1":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"1":{"7":{".":{"0":{"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{".":{"3":{"7":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{".":{"0":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"106":{"tf":1.0}}},"df":2,"docs":{"17":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"5":{"7":{"4":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"4":{"6":{"df":1,"docs":{"120":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":10,"docs":{"117":{"tf":1.4142135623730951},"12":{"tf":1.0},"16":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"70":{"tf":1.0},"79":{"tf":2.0},"80":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.7320508075688772},"88":{"tf":1.0}}},"2":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"9":{"6":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"1":{"5":{"df":2,"docs":{"43":{"tf":1.0},"71":{"tf":1.0}}},"7":{"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.0}}},"8":{"df":3,"docs":{"43":{"tf":1.4142135623730951},"62":{"tf":1.0},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.0}}},"5":{".":{"0":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"115":{"tf":1.4142135623730951},"16":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"85":{"tf":1.7320508075688772},"86":{"tf":1.7320508075688772},"88":{"tf":1.0}}},"3":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},".":{"9":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":5,"docs":{"16":{"tf":1.0},"81":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}},"4":{"2":{"\"":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"117":{"tf":1.4142135623730951},"16":{"tf":1.0},"67":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":1.0}}},"5":{"6":{"1":{"2":{"4":{"b":{"a":{"a":{"9":{"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"16":{"tf":1.0},"65":{"tf":1.7320508075688772},"68":{"tf":2.6457513110645907},"71":{"tf":1.0},"73":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}},"6":{"df":2,"docs":{"68":{"tf":2.6457513110645907},"84":{"tf":1.0}}},"7":{"df":1,"docs":{"84":{"tf":1.0}}},"8":{"df":3,"docs":{"47":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.0}}},"9":{"df":1,"docs":{"87":{"tf":1.0}}},"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"85":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.0}}},"a":{"b":{"c":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":11,"docs":{"105":{"tf":1.0},"115":{"tf":1.0},"16":{"tf":1.0},"28":{"tf":1.0},"35":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"114":{"tf":1.0},"28":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"71":{"tf":1.0},"98":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"93":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"51":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":16,"docs":{"44":{"tf":2.23606797749979},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.7320508075688772},"79":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":2.0},"95":{"tf":1.4142135623730951},"99":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"30":{"tf":1.0},"44":{"tf":1.0},"77":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"df":12,"docs":{"103":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"35":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"71":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.4142135623730951}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":5,"docs":{"89":{"tf":1.7320508075688772},"9":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"68":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"73":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}},"i":{"a":{"df":1,"docs":{"92":{"tf":1.0}},"s":{"(":{"df":1,"docs":{"92":{"tf":1.0}}},"df":1,"docs":{"92":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{":":{":":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":26,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"106":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"112":{"tf":1.0},"115":{"tf":1.7320508075688772},"117":{"tf":1.0},"30":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"73":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"107":{"tf":1.0},"19":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"=":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"54":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"63":{"tf":1.0},"71":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"108":{"tf":1.0},"116":{"tf":1.0},"4":{"tf":1.0},"51":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"17":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"111":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"62":{"tf":1.0},"90":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":6,"docs":{"120":{"tf":1.0},"121":{"tf":1.0},"18":{"tf":1.0},"73":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":12,"docs":{"104":{"tf":2.0},"18":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.4142135623730951},"80":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.7320508075688772},"99":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"108":{"tf":1.0},"33":{"tf":1.0},"68":{"tf":1.0},"90":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"60":{"tf":1.0},"73":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"117":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":3,"docs":{"116":{"tf":2.449489742783178},"31":{"tf":1.0},"32":{"tf":1.7320508075688772}},"s":{"_":{"df":0,"docs":{},"o":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":39,"docs":{"0":{"tf":1.0},"100":{"tf":1.4142135623730951},"103":{"tf":1.0},"108":{"tf":1.0},"116":{"tf":1.0},"20":{"tf":2.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.6457513110645907}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"112":{"tf":1.4142135623730951},"69":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"2":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"71":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"1":{"df":1,"docs":{"85":{"tf":1.4142135623730951}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":2,"docs":{"66":{"tf":1.0},"72":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"66":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":4,"docs":{"2":{"tf":1.0},"25":{"tf":1.0},"50":{"tf":1.0},"65":{"tf":1.0}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"17":{"tf":1.7320508075688772},"75":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":30,"docs":{"103":{"tf":1.4142135623730951},"108":{"tf":1.4142135623730951},"16":{"tf":1.0},"18":{"tf":1.0},"51":{"tf":2.8284271247461903},"52":{"tf":1.0},"53":{"tf":2.0},"54":{"tf":2.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":1.7320508075688772},"63":{"tf":1.0},"64":{"tf":1.7320508075688772},"67":{"tf":2.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"85":{"tf":1.7320508075688772},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":2.0},"97":{"tf":1.0},"98":{"tf":1.7320508075688772},"99":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"59":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":11,"docs":{"103":{"tf":1.4142135623730951},"118":{"tf":1.0},"17":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"57":{"tf":2.0},"78":{"tf":1.0},"81":{"tf":1.0},"90":{"tf":1.4142135623730951},"93":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"103":{"tf":1.0}}},"y":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"115":{"tf":1.4142135623730951}},"e":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"u":{"df":1,"docs":{"19":{"tf":1.0}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"65":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"115":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"r":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"[":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":1,"docs":{"74":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"1":{"tf":1.0},"115":{"tf":1.4142135623730951},"62":{"tf":4.69041575982343},"68":{"tf":1.4142135623730951},"74":{"tf":2.6457513110645907},"76":{"tf":1.0},"84":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"103":{"tf":1.0},"12":{"tf":1.0},"39":{"tf":1.0},"56":{"tf":1.0}}},"i":{"c":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"51":{"tf":1.0},"65":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"z":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"df":1,"docs":{"74":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":4,"docs":{"105":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"8":{"tf":1.0}}}}},"df":7,"docs":{"118":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"90":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":9,"docs":{"101":{"tf":3.0},"102":{"tf":1.4142135623730951},"118":{"tf":1.0},"37":{"tf":2.6457513110645907},"38":{"tf":1.0},"4":{"tf":1.0},"67":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"107":{"tf":1.0},"80":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"106":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"98":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"16":{"tf":1.0}}}},"w":{"df":3,"docs":{"51":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"91":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"92":{"tf":1.7320508075688772}},"x":{"df":1,"docs":{"92":{"tf":1.7320508075688772}}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"112":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"47":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":7,"docs":{"113":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"72":{"tf":3.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"87":{"tf":2.23606797749979}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":5,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"91":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"4":{"tf":1.0},"6":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"103":{"tf":1.4142135623730951},"117":{"tf":1.0},"17":{"tf":1.0},"79":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"12":{"tf":1.7320508075688772},"41":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"41":{"tf":1.0},"80":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":3,"docs":{"70":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"80":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"34":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"106":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"108":{"tf":1.0},"115":{"tf":1.0},"90":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":4,"docs":{"113":{"tf":1.0},"21":{"tf":1.0},"8":{"tf":1.0},"90":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"103":{"tf":1.0},"39":{"tf":1.0},"55":{"tf":1.7320508075688772},"98":{"tf":1.0}}}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"105":{"tf":1.0},"111":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"113":{"tf":1.4142135623730951},"117":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":10,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"118":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"5":{"tf":1.0},"75":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0},"98":{"tf":1.0}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"73":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"41":{"tf":1.0},"71":{"tf":1.0},"94":{"tf":1.0}},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":6,"docs":{"1":{"tf":1.7320508075688772},"100":{"tf":1.4142135623730951},"111":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":2.6457513110645907},"5":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":12,"docs":{"1":{"tf":1.0},"114":{"tf":1.0},"116":{"tf":1.0},"118":{"tf":1.0},"51":{"tf":1.7320508075688772},"6":{"tf":1.0},"62":{"tf":1.4142135623730951},"68":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"89":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}}},"s":{"df":3,"docs":{"68":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":1,"docs":{"30":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"18":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"90":{"tf":1.0},"97":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"90":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"90":{"tf":1.7320508075688772},"97":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"28":{"tf":2.23606797749979},"90":{"tf":1.4142135623730951},"91":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":6,"docs":{"105":{"tf":1.0},"118":{"tf":1.4142135623730951},"2":{"tf":1.0},"42":{"tf":1.0},"62":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":12,"docs":{"103":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"7":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"15":{"tf":1.4142135623730951},"77":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"2":{"tf":1.0},"45":{"tf":2.23606797749979},"57":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"68":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"12":{"tf":1.0},"19":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":31,"docs":{"1":{"tf":1.4142135623730951},"113":{"tf":1.0},"117":{"tf":2.449489742783178},"17":{"tf":1.7320508075688772},"2":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"33":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.7320508075688772},"66":{"tf":1.4142135623730951},"68":{"tf":2.23606797749979},"69":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":2.8284271247461903},"72":{"tf":3.3166247903554},"74":{"tf":1.0},"83":{"tf":2.449489742783178},"85":{"tf":1.4142135623730951},"87":{"tf":2.449489742783178},"9":{"tf":2.449489742783178},"91":{"tf":2.0},"95":{"tf":2.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":2.8284271247461903}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":2.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":40,"docs":{"100":{"tf":2.23606797749979},"105":{"tf":1.0},"108":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":2.23606797749979},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"113":{"tf":1.0},"117":{"tf":1.4142135623730951},"2":{"tf":1.0},"51":{"tf":2.23606797749979},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"8":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"113":{"tf":1.0},"118":{"tf":1.0},"67":{"tf":1.0},"85":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"121":{"tf":1.4142135623730951}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"115":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":20,"docs":{"108":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"17":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.4142135623730951},"33":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.7320508075688772},"71":{"tf":2.8284271247461903},"73":{"tf":1.4142135623730951},"8":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772},"96":{"tf":1.0},"99":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{",":{"df":0,"docs":{},"e":{"0":{"0":{"4":{"4":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"95":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.7320508075688772},"69":{"tf":1.0},"7":{"tf":1.0}}},"x":{"df":1,"docs":{"8":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"17":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"s":{"df":1,"docs":{"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"16":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"118":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"70":{"tf":1.0},"90":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772}}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"69":{"tf":1.0}}}}},"i":{"d":{"df":7,"docs":{"118":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"45":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"117":{"tf":1.0},"75":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"115":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"115":{"tf":1.0},"16":{"tf":1.0},"67":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"1":{"tf":1.0},"101":{"tf":3.0},"102":{"tf":3.0},"12":{"tf":1.4142135623730951},"2":{"tf":1.0},"37":{"tf":2.6457513110645907},"38":{"tf":2.6457513110645907},"40":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":16,"docs":{"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"107":{"tf":1.7320508075688772},"111":{"tf":1.7320508075688772},"25":{"tf":1.4142135623730951},"3":{"tf":1.0},"39":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"120":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}},"y":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"16":{"tf":1.0},"3":{"tf":1.0},"85":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"71":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"113":{"tf":3.0},"117":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"113":{"tf":1.7320508075688772},"114":{"tf":1.7320508075688772},"117":{"tf":2.6457513110645907}}}},"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":3,"docs":{"103":{"tf":1.0},"2":{"tf":1.0},"82":{"tf":1.0}}},"/":{"1":{".":{"0":{".":{"1":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"3":{":":{"1":{"df":2,"docs":{"81":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{":":{"1":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"=":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"107":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":38,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"103":{"tf":2.449489742783178},"105":{"tf":1.4142135623730951},"107":{"tf":2.0},"108":{"tf":1.7320508075688772},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.7320508075688772},"113":{"tf":2.0},"114":{"tf":1.0},"121":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":2.23606797749979},"25":{"tf":2.6457513110645907},"27":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":2.449489742783178},"46":{"tf":2.449489742783178},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"57":{"tf":2.0},"59":{"tf":1.0},"67":{"tf":1.7320508075688772},"7":{"tf":1.0},"70":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"75":{"tf":1.0},"77":{"tf":2.0},"8":{"tf":3.605551275463989},"82":{"tf":1.4142135623730951},"90":{"tf":2.0},"91":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"105":{"tf":1.0},"19":{"tf":1.4142135623730951},"35":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":8,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"111":{"tf":1.0},"19":{"tf":1.7320508075688772},"35":{"tf":2.23606797749979},"41":{"tf":2.23606797749979},"44":{"tf":1.0},"45":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"105":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"24":{"tf":1.0},"34":{"tf":1.0},"5":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}},"df":5,"docs":{"109":{"tf":1.0},"118":{"tf":1.4142135623730951},"19":{"tf":2.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951}}}}}}}},"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"44":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"13":{"tf":1.0}}}},"t":{"a":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":2,"docs":{"23":{"tf":1.4142135623730951},"65":{"tf":1.0}}}},"y":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":27,"docs":{"110":{"tf":1.7320508075688772},"113":{"tf":1.0},"117":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":2.6457513110645907},"40":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"49":{"tf":2.0},"58":{"tf":1.0},"59":{"tf":1.0},"65":{"tf":1.0},"79":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"13":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"16":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"77":{"tf":1.7320508075688772},"86":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{":":{":":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":12,"docs":{"107":{"tf":1.0},"108":{"tf":1.0},"15":{"tf":1.4142135623730951},"23":{"tf":1.0},"27":{"tf":2.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"62":{"tf":1.0},"80":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"=":{"<":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{">":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":4,"docs":{"118":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":12,"docs":{"106":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":10,"docs":{"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"113":{"tf":1.0},"44":{"tf":1.0}}}}}}}},"v":{"df":1,"docs":{"16":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"8":{"tf":1.0},"93":{"tf":1.0}}}}}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"98":{"tf":2.23606797749979}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"107":{"tf":1.0},"33":{"tf":1.0},"46":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"90":{"tf":1.4142135623730951},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"71":{"tf":1.0},"72":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":6,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"113":{"tf":1.0},"57":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":7,"docs":{"1":{"tf":1.0},"107":{"tf":1.4142135623730951},"111":{"tf":1.0},"24":{"tf":1.7320508075688772},"27":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"104":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":3,"docs":{"69":{"tf":1.0},"76":{"tf":2.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"112":{"tf":1.0},"45":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"57":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":4,"docs":{"106":{"tf":2.449489742783178},"113":{"tf":1.0},"114":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"68":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"o":{"c":{"(":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"92":{"tf":1.7320508075688772}},"s":{"(":{"\"":{"df":0,"docs":{},"x":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"97":{"tf":2.23606797749979}}}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"107":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"18":{"tf":1.0},"63":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"99":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}},"e":{")":{"]":{"/":{"#":{"[":{"d":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"(":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"59":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":44,"docs":{"1":{"tf":1.7320508075688772},"103":{"tf":1.7320508075688772},"105":{"tf":1.7320508075688772},"107":{"tf":2.23606797749979},"109":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"111":{"tf":2.0},"113":{"tf":2.0},"117":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"24":{"tf":1.0},"3":{"tf":2.449489742783178},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"5":{"tf":1.0},"51":{"tf":4.58257569495584},"52":{"tf":1.4142135623730951},"53":{"tf":2.0},"54":{"tf":2.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":2.6457513110645907},"63":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":2.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.4142135623730951},"90":{"tf":1.7320508075688772},"91":{"tf":1.7320508075688772},"92":{"tf":1.0},"96":{"tf":1.7320508075688772},"97":{"tf":1.7320508075688772}},"s":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":11,"docs":{"112":{"tf":2.6457513110645907},"115":{"tf":1.7320508075688772},"116":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"66":{"tf":2.0},"73":{"tf":3.4641016151377544},"90":{"tf":1.0},"95":{"tf":2.0},"97":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"121":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":75,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"106":{"tf":2.23606797749979},"108":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.0},"111":{"tf":1.0},"113":{"tf":2.6457513110645907},"114":{"tf":1.7320508075688772},"117":{"tf":2.0},"118":{"tf":1.4142135623730951},"12":{"tf":1.0},"120":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":2.449489742783178},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"26":{"tf":3.0},"3":{"tf":1.4142135623730951},"30":{"tf":2.23606797749979},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":3.0},"40":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":1.0},"51":{"tf":1.7320508075688772},"55":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":2.23606797749979},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":3.0},"69":{"tf":1.0},"7":{"tf":3.4641016151377544},"70":{"tf":2.0},"71":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":2.449489742783178},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":2.8284271247461903},"80":{"tf":2.6457513110645907},"81":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"87":{"tf":1.0},"9":{"tf":3.1622776601683795},"90":{"tf":2.6457513110645907},"91":{"tf":1.7320508075688772},"92":{"tf":1.4142135623730951},"93":{"tf":1.0},"95":{"tf":1.0},"97":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951},"99":{"tf":2.23606797749979}}}}}}}},"df":1,"docs":{"78":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":6,"docs":{"106":{"tf":1.0},"108":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.4142135623730951},"85":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"'":{"df":0,"docs":{},"t":{"df":12,"docs":{"113":{"tf":1.0},"16":{"tf":1.0},"40":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"3":{"tf":1.0},"68":{"tf":1.0},"9":{"tf":1.0}}},"’":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"106":{"tf":1.0},"2":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"111":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"9":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":1,"docs":{"87":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":7,"docs":{"11":{"tf":1.0},"16":{"tf":1.0},"59":{"tf":1.0},"68":{"tf":1.4142135623730951},"72":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":4,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"8":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"18":{"tf":1.0},"3":{"tf":1.0},"51":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"118":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"g":{"df":3,"docs":{"72":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":3.1622776601683795},"71":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"5":{"df":1,"docs":{"71":{"tf":1.0}}},"8":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"41":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"114":{"tf":1.0},"45":{"tf":1.0},"50":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"35":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"114":{"tf":1.0},"16":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"47":{"tf":1.0},"87":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"116":{"tf":1.0}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"100":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"115":{"tf":2.0},"23":{"tf":1.0},"30":{"tf":1.0},"93":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":7,"docs":{"104":{"tf":1.0},"47":{"tf":1.0},"50":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"16":{"tf":1.4142135623730951},"45":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"95":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"92":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"m":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":2,"docs":{"117":{"tf":1.0},"79":{"tf":1.7320508075688772}}}},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"100":{"tf":1.0},"71":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"108":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"69":{"tf":1.7320508075688772},"78":{"tf":1.0},"87":{"tf":1.0},"91":{"tf":1.4142135623730951},"95":{"tf":3.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"77":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"113":{"tf":1.0},"26":{"tf":1.0},"77":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"16":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"72":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":51,"docs":{"103":{"tf":1.0},"105":{"tf":1.0},"109":{"tf":1.0},"11":{"tf":1.7320508075688772},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.0},"117":{"tf":2.23606797749979},"12":{"tf":2.0},"120":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":3.605551275463989},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"23":{"tf":1.0},"28":{"tf":1.0},"31":{"tf":1.7320508075688772},"35":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":2.0},"67":{"tf":3.0},"68":{"tf":3.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":3.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":2.6457513110645907},"84":{"tf":1.0},"85":{"tf":2.23606797749979},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"9":{"tf":2.8284271247461903},"90":{"tf":1.0},"91":{"tf":1.4142135623730951},"92":{"tf":1.0},"97":{"tf":1.4142135623730951}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":5,"docs":{"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"99":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"112":{"tf":1.7320508075688772},"17":{"tf":1.0},"30":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.0},"9":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"107":{"tf":1.7320508075688772},"18":{"tf":1.0},"34":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"6":{"tf":1.0},"68":{"tf":1.0},"8":{"tf":2.0},"9":{"tf":1.7320508075688772},"97":{"tf":1.0}}}},"n":{"df":2,"docs":{"68":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"113":{"tf":1.0},"62":{"tf":1.4142135623730951},"77":{"tf":2.23606797749979}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"70":{"tf":1.0},"8":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"19":{"tf":1.0},"41":{"tf":2.23606797749979},"73":{"tf":1.0},"96":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"41":{"tf":1.0},"96":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"n":{"df":9,"docs":{"107":{"tf":2.0},"29":{"tf":2.23606797749979},"51":{"tf":1.0},"57":{"tf":2.449489742783178},"59":{"tf":1.0},"67":{"tf":1.4142135623730951},"70":{"tf":1.7320508075688772},"95":{"tf":1.0},"99":{"tf":1.0}}}}},"r":{"a":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951}}}}}},"m":{"d":{"df":2,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":5,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"17":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":10,"docs":{"17":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.7320508075688772},"69":{"tf":1.0},"71":{"tf":1.7320508075688772},"77":{"tf":1.7320508075688772},"79":{"tf":1.0},"85":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"89":{"tf":1.0}}},"s":{"df":1,"docs":{"70":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"112":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":6,"docs":{"51":{"tf":2.0},"65":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":2.0},"77":{"tf":1.7320508075688772},"91":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":35,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"117":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"56":{"tf":1.4142135623730951},"71":{"tf":1.0},"8":{"tf":1.4142135623730951},"89":{"tf":2.0},"90":{"tf":1.7320508075688772},"91":{"tf":1.0},"92":{"tf":1.4142135623730951},"93":{"tf":2.8284271247461903},"94":{"tf":2.0},"95":{"tf":1.0},"96":{"tf":1.7320508075688772},"97":{"tf":2.23606797749979},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}},"e":{"(":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"99":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"=":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"72":{"tf":2.0}}},"df":0,"docs":{}},"w":{"df":3,"docs":{"7":{"tf":1.0},"71":{"tf":1.0},"98":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":30,"docs":{"0":{"tf":1.0},"101":{"tf":1.7320508075688772},"102":{"tf":1.7320508075688772},"103":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"109":{"tf":1.0},"111":{"tf":2.23606797749979},"114":{"tf":1.0},"117":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":2.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":2.449489742783178},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"105":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":2.0},"90":{"tf":1.4142135623730951}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"118":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"d":{"df":4,"docs":{"27":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"2":{"tf":1.4142135623730951},"4":{"tf":1.0},"43":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951},"92":{"tf":1.0}}}}},"t":{"df":1,"docs":{"8":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"x":{"df":2,"docs":{"2":{"tf":1.0},"83":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":48,"docs":{"100":{"tf":1.7320508075688772},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"107":{"tf":2.0},"108":{"tf":1.4142135623730951},"111":{"tf":1.7320508075688772},"112":{"tf":1.4142135623730951},"113":{"tf":1.7320508075688772},"115":{"tf":1.7320508075688772},"2":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":2.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":2.23606797749979},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"45":{"tf":2.23606797749979},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.0},"90":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{".":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":29,"docs":{"1":{"tf":1.0},"114":{"tf":1.4142135623730951},"16":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.4142135623730951},"5":{"tf":1.0},"51":{"tf":2.0},"62":{"tf":2.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.7320508075688772},"69":{"tf":2.6457513110645907},"70":{"tf":1.7320508075688772},"71":{"tf":2.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"8":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"91":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":14,"docs":{"11":{"tf":1.0},"117":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"111":{"tf":1.0}}}},"o":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}},".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.4142135623730951}},"s":{":":{"1":{":":{"1":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}},"9":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"1":{"df":1,"docs":{"74":{"tf":1.0}}},"2":{"df":1,"docs":{"74":{"tf":1.0}}},"3":{"df":1,"docs":{"74":{"tf":1.0}}},"4":{"df":1,"docs":{"74":{"tf":1.0}}},"`":{"]":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":19,"docs":{"1":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":2.8284271247461903},"2":{"tf":2.23606797749979},"5":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.0},"68":{"tf":2.0},"70":{"tf":1.4142135623730951},"71":{"tf":2.0},"72":{"tf":1.7320508075688772},"76":{"tf":2.6457513110645907},"77":{"tf":1.4142135623730951},"79":{"tf":2.6457513110645907},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":3.3166247903554}},"e":{"[":{"^":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"r":{"c":{"df":3,"docs":{"108":{"tf":1.7320508075688772},"67":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"114":{"tf":3.0},"117":{"tf":1.4142135623730951},"50":{"tf":2.23606797749979}}}},"df":8,"docs":{"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"85":{"tf":1.0}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"+":{"1":{"0":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"72":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"72":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"+":{"1":{"0":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"121":{"tf":1.0},"8":{"tf":2.449489742783178}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"30":{"tf":1.0},"67":{"tf":1.0}},"i":{"df":2,"docs":{"75":{"tf":1.0},"93":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"2":{"tf":1.0}}},"df":19,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":2.0},"51":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.7320508075688772},"69":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"8":{"tf":1.0},"81":{"tf":1.4142135623730951},"83":{"tf":1.0},"9":{"tf":2.6457513110645907},"91":{"tf":2.23606797749979},"94":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}}}}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"98":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"71":{"tf":1.0},"8":{"tf":1.7320508075688772},"82":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"94":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":27,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"103":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":2.0},"111":{"tf":1.4142135623730951},"113":{"tf":1.0},"12":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":2.0},"30":{"tf":1.0},"33":{"tf":1.7320508075688772},"34":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":2.23606797749979},"5":{"tf":1.4142135623730951},"51":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"62":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.0}}}}},"t":{"df":2,"docs":{"111":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":3,"docs":{"11":{"tf":1.0},"121":{"tf":1.4142135623730951},"13":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":18,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"27":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"94":{"tf":1.0}},"n":{"df":13,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.0},"43":{"tf":1.4142135623730951},"51":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"70":{"tf":1.0},"77":{"tf":1.4142135623730951},"90":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":2,"docs":{"115":{"tf":1.0},"33":{"tf":1.0}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"53":{"tf":1.0},"54":{"tf":1.0},"8":{"tf":1.0}}},"o":{"d":{"df":7,"docs":{"109":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"91":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"119":{"tf":1.4142135623730951},"16":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"111":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"45":{"tf":1.0},"95":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"121":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"121":{"tf":1.0},"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"1":{"df":1,"docs":{"86":{"tf":2.0}}},"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"54":{"tf":1.0}},"l":{"df":4,"docs":{"17":{"tf":1.4142135623730951},"51":{"tf":1.0},"69":{"tf":1.0},"91":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"98":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":2,"docs":{"23":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"df":1,"docs":{"21":{"tf":1.7320508075688772}},"e":{"a":{"d":{"df":2,"docs":{"35":{"tf":1.0},"36":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"1":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"df":1,"docs":{"36":{"tf":2.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":13,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":2.6457513110645907},"3":{"tf":1.0},"30":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"82":{"tf":1.0},"85":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":6,"docs":{"16":{"tf":1.0},"20":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0}}},"df":11,"docs":{"114":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"73":{"tf":1.4142135623730951},"78":{"tf":1.0},"86":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0}},"’":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"63":{"tf":1.0},"68":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"68":{"tf":2.23606797749979}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"91":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"111":{"tf":1.0},"23":{"tf":1.4142135623730951},"33":{"tf":1.0},"90":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"=":{"\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"'":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"'":{">":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"g":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}},"df":15,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"107":{"tf":2.0},"111":{"tf":1.7320508075688772},"114":{"tf":1.0},"13":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":2.449489742783178},"37":{"tf":2.449489742783178},"38":{"tf":2.449489742783178},"45":{"tf":1.0},"5":{"tf":1.4142135623730951},"57":{"tf":1.0},"86":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"88":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"/":{"1":{".":{"0":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}}}}}}}},"i":{".":{"df":1,"docs":{"113":{"tf":1.0}}},"3":{"2":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":2,"docs":{"65":{"tf":1.0},"69":{"tf":1.0}},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"18":{"tf":1.0},"3":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"115":{"tf":3.1622776601683795},"32":{"tf":1.0},"35":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"77":{"tf":1.4142135623730951},"91":{"tf":1.0}},"e":{",":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"112":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":2,"docs":{"113":{"tf":1.7320508075688772},"18":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"113":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"45":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.4142135623730951},"91":{"tf":1.0},"98":{"tf":2.0},"99":{"tf":1.4142135623730951}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"68":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":24,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"105":{"tf":1.0},"117":{"tf":1.0},"16":{"tf":2.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"41":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":2.449489742783178},"75":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"!":{"(":{"\"":{".":{".":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":2,"docs":{"51":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":2.23606797749979}}}},"x":{"df":4,"docs":{"109":{"tf":2.449489742783178},"110":{"tf":2.23606797749979},"111":{"tf":1.0},"95":{"tf":1.0}}}},"i":{"c":{"df":3,"docs":{"47":{"tf":1.0},"57":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":10,"docs":{"114":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"113":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"68":{"tf":1.0},"69":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"62":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"4":{"tf":1.7320508075688772},"77":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"50":{"tf":2.449489742783178},"69":{"tf":2.8284271247461903}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"101":{"tf":1.7320508075688772},"102":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"67":{"tf":1.4142135623730951}}}}},"i":{"d":{"df":7,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"116":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"a":{"d":{"df":15,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"113":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"34":{"tf":1.0},"51":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":1.4142135623730951},"9":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}},"n":{"d":{"df":6,"docs":{"106":{"tf":1.0},"108":{"tf":1.0},"82":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"106":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"f":{"a":{"c":{"df":2,"docs":{"18":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":4,"docs":{"108":{"tf":1.0},"18":{"tf":1.4142135623730951},"3":{"tf":1.0},"99":{"tf":1.7320508075688772}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{">":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"r":{"a":{"df":6,"docs":{"120":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":3,"docs":{"8":{"tf":1.0},"82":{"tf":1.0},"97":{"tf":1.0}},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"86":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"o":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"98":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":7,"docs":{"106":{"tf":1.0},"121":{"tf":1.0},"2":{"tf":1.0},"56":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"'":{"df":7,"docs":{"112":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0},"90":{"tf":1.4142135623730951},"99":{"tf":1.0}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"117":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"9":{"tf":1.0}}},"df":27,"docs":{"104":{"tf":2.0},"113":{"tf":3.4641016151377544},"114":{"tf":2.0},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"26":{"tf":3.3166247903554},"4":{"tf":1.7320508075688772},"51":{"tf":1.0},"57":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"63":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":2.449489742783178},"74":{"tf":2.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"77":{"tf":2.23606797749979},"79":{"tf":1.4142135623730951},"80":{"tf":3.0},"81":{"tf":1.0},"84":{"tf":1.4142135623730951},"9":{"tf":1.0},"90":{"tf":2.0},"92":{"tf":1.7320508075688772},"97":{"tf":2.23606797749979}}},"r":{"df":2,"docs":{"9":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":2,"docs":{"113":{"tf":1.0},"4":{"tf":1.0}}}}}}},"’":{"df":0,"docs":{},"m":{"df":1,"docs":{"70":{"tf":1.0}}}}},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"105":{"tf":1.0},"111":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"b":{"df":3,"docs":{"0":{"tf":1.0},"51":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"114":{"tf":2.23606797749979},"117":{"tf":1.0}}}}},"u":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":5,"docs":{"107":{"tf":1.0},"112":{"tf":1.4142135623730951},"68":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"51":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":5,"docs":{"119":{"tf":1.0},"27":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"91":{"tf":1.7320508075688772}},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"109":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":3,"docs":{"103":{"tf":1.4142135623730951},"39":{"tf":1.0},"5":{"tf":1.0}}}}}},"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"21":{"tf":1.0},"93":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":2,"docs":{"27":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951}},"e":{"a":{"d":{"df":2,"docs":{"51":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"120":{"tf":1.0}}}},"v":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"54":{"tf":1.0},"67":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"115":{"tf":1.0},"45":{"tf":1.0}}}},"t":{"'":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"62":{"tf":1.0},"9":{"tf":1.0}}},"df":7,"docs":{"25":{"tf":1.0},"29":{"tf":1.0},"42":{"tf":1.0},"51":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":11,"docs":{"0":{"tf":1.0},"109":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"3":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"82":{"tf":1.0},"86":{"tf":1.0}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":3,"docs":{"117":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0}},"s":{"\"":{":":{"df":0,"docs":{},"{":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"\"":{":":{"4":{",":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"\"":{":":{"4":{",":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"\"":{":":{"4":{",":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"\"":{":":{"1":{"df":1,"docs":{"117":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"106":{"tf":1.0},"108":{"tf":1.4142135623730951},"16":{"tf":1.0},"27":{"tf":2.0},"29":{"tf":1.4142135623730951},"56":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":1.0},"75":{"tf":1.0},"9":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.0}}},"y":{"'":{"df":2,"docs":{"46":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"105":{"tf":1.0}}}}},"df":0,"docs":{}},"df":4,"docs":{"105":{"tf":1.0},"34":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"69":{"tf":1.0},"92":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":44,"docs":{"100":{"tf":2.0},"108":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":2.8284271247461903},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"62":{"tf":1.4142135623730951},"68":{"tf":2.0},"70":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":2.6457513110645907},"9":{"tf":2.0},"94":{"tf":1.0}}},"k":{"!":{"]":{"(":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":25,"docs":{"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":2.0},"111":{"tf":1.0},"12":{"tf":1.7320508075688772},"120":{"tf":1.0},"2":{"tf":1.0},"35":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":2.0},"58":{"tf":1.0},"62":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":3.3166247903554},"75":{"tf":2.449489742783178},"76":{"tf":1.0},"77":{"tf":3.4641016151377544},"78":{"tf":1.4142135623730951},"79":{"tf":2.6457513110645907},"8":{"tf":1.0},"80":{"tf":2.6457513110645907},"88":{"tf":1.7320508075688772},"9":{"tf":1.0},"93":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"5":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{":":{"6":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"3":{":":{"5":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{":":{"5":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":14,"docs":{"113":{"tf":1.4142135623730951},"16":{"tf":2.0},"67":{"tf":1.0},"78":{"tf":2.8284271247461903},"79":{"tf":1.7320508075688772},"80":{"tf":1.7320508075688772},"81":{"tf":2.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":16,"docs":{"110":{"tf":1.0},"117":{"tf":1.0},"14":{"tf":2.0},"20":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"89":{"tf":1.0},"92":{"tf":1.0},"98":{"tf":1.7320508075688772},"99":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"68":{"tf":1.0},"87":{"tf":1.0}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"83":{"tf":1.0}},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"23":{"tf":1.0}}}}},"o":{"a":{"d":{"df":2,"docs":{"111":{"tf":2.0},"47":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"107":{"tf":1.7320508075688772},"57":{"tf":1.0}}},"t":{"df":6,"docs":{"1":{"tf":1.0},"103":{"tf":1.4142135623730951},"111":{"tf":1.0},"2":{"tf":1.0},"29":{"tf":2.0},"39":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":45,"docs":{"10":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.4142135623730951},"108":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0},"68":{"tf":1.4142135623730951},"77":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":1.0}}},"p":{"df":1,"docs":{"71":{"tf":1.0}}}},"t":{"df":1,"docs":{"111":{"tf":1.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"116":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"70":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"67":{"tf":1.0},"70":{"tf":1.7320508075688772}}}}},"df":8,"docs":{"18":{"tf":1.0},"51":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"77":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"91":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":12,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"62":{"tf":2.0},"67":{"tf":2.0},"69":{"tf":2.0},"70":{"tf":2.0},"73":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"89":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":14,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.0},"55":{"tf":1.4142135623730951},"62":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"90":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"113":{"tf":1.0},"119":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":13,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"101":{"tf":2.6457513110645907},"102":{"tf":2.6457513110645907},"103":{"tf":2.23606797749979},"109":{"tf":1.0},"35":{"tf":2.449489742783178},"39":{"tf":2.0},"40":{"tf":2.0},"5":{"tf":2.23606797749979},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"74":{"tf":1.0}}}}}},"df":2,"docs":{"100":{"tf":1.0},"85":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"87":{"tf":1.0},"98":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"99":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"107":{"tf":1.0},"13":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"70":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"d":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":7,"docs":{"23":{"tf":1.0},"51":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.0},"98":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"103":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"113":{"tf":1.0}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"113":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":1,"docs":{"85":{"tf":1.0}},"n":{"d":{"df":1,"docs":{"107":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":3,"docs":{"16":{"tf":1.0},"81":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"82":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"113":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"113":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"85":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"d":{"df":5,"docs":{"26":{"tf":1.0},"62":{"tf":2.0},"77":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":3,"docs":{"23":{"tf":1.0},"45":{"tf":1.0},"94":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"105":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"104":{"tf":2.449489742783178},"62":{"tf":1.0},"77":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"82":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":30,"docs":{"118":{"tf":1.0},"120":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"23":{"tf":1.7320508075688772},"31":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"4":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"51":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772},"91":{"tf":1.0},"93":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"109":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"51":{"tf":1.0},"92":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"69":{"tf":2.0}}}},"y":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"25":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":17,"docs":{"104":{"tf":1.0},"105":{"tf":1.4142135623730951},"107":{"tf":1.0},"2":{"tf":2.23606797749979},"24":{"tf":1.0},"25":{"tf":3.0},"3":{"tf":1.4142135623730951},"34":{"tf":1.0},"44":{"tf":1.7320508075688772},"65":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.0},"76":{"tf":2.0},"77":{"tf":1.0},"79":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"76":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"17":{"tf":1.0},"9":{"tf":1.0},"93":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":15,"docs":{"105":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"4":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":2.0},"70":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":1,"docs":{"73":{"tf":1.0}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}},"w":{"df":7,"docs":{"1":{"tf":1.7320508075688772},"19":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.4142135623730951},"82":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"t":{"df":3,"docs":{"34":{"tf":1.0},"68":{"tf":1.4142135623730951},"98":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"83":{"tf":1.0},"86":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.7320508075688772},"95":{"tf":1.0}}}}}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":2.449489742783178}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"114":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"t":{"d":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"\"":{":":{"df":0,"docs":{},"{":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"\"":{":":{"3":{",":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"\"":{":":{"1":{",":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"\"":{":":{"3":{",":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"\"":{":":{"0":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"107":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":2.0}}}}}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":8,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":23,"docs":{"113":{"tf":1.0},"114":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.0},"34":{"tf":1.0},"51":{"tf":1.4142135623730951},"65":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":2.23606797749979},"81":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0}}},"h":{"df":2,"docs":{"115":{"tf":1.0},"4":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":4,"docs":{"16":{"tf":1.0},"2":{"tf":1.4142135623730951},"55":{"tf":1.0},"62":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"104":{"tf":1.0},"12":{"tf":1.4142135623730951},"27":{"tf":1.0},"56":{"tf":1.4142135623730951},"73":{"tf":1.0},"95":{"tf":2.449489742783178}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"106":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"24":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":4,"docs":{"103":{"tf":1.0},"120":{"tf":1.4142135623730951},"45":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":2,"docs":{"17":{"tf":1.0},"69":{"tf":1.7320508075688772}}},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"118":{"tf":1.0},"69":{"tf":1.0}}}}},"n":{"c":{"df":2,"docs":{"111":{"tf":1.0},"91":{"tf":1.4142135623730951}}},"df":11,"docs":{"107":{"tf":1.0},"114":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"34":{"tf":1.0},"47":{"tf":1.0},"51":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"85":{"tf":1.0},"9":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"113":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"47":{"tf":1.0}}},"r":{"df":4,"docs":{"45":{"tf":1.0},"69":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"s":{"df":2,"docs":{"7":{"tf":1.0},"77":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":26,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"109":{"tf":1.4142135623730951},"111":{"tf":1.0},"112":{"tf":1.4142135623730951},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":2.0},"117":{"tf":2.0},"19":{"tf":1.0},"21":{"tf":1.0},"30":{"tf":2.23606797749979},"32":{"tf":1.7320508075688772},"47":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"104":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"4":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"104":{"tf":1.0},"107":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"62":{"tf":1.0},"77":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"50":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"113":{"tf":1.0},"119":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"70":{"tf":1.0},"90":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.7320508075688772}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":18,"docs":{"105":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"111":{"tf":1.7320508075688772},"114":{"tf":2.6457513110645907},"117":{"tf":1.4142135623730951},"118":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"24":{"tf":2.6457513110645907},"34":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"51":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"89":{"tf":1.0},"91":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"117":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"76":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"107":{"tf":1.0},"115":{"tf":1.0},"25":{"tf":1.0},"42":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":2,"docs":{"117":{"tf":1.0},"9":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":18,"docs":{"1":{"tf":1.4142135623730951},"104":{"tf":1.7320508075688772},"105":{"tf":1.0},"109":{"tf":2.8284271247461903},"110":{"tf":2.23606797749979},"111":{"tf":1.0},"121":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.7320508075688772},"21":{"tf":1.0},"34":{"tf":1.0},"62":{"tf":1.4142135623730951},"71":{"tf":1.0},"74":{"tf":1.4142135623730951},"8":{"tf":2.449489742783178},"89":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"$":{"(":{"$":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"!":{"(":{"1":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"70":{"tf":1.0}}}}}}}}},"df":4,"docs":{"66":{"tf":1.0},"70":{"tf":1.0},"85":{"tf":2.0},"9":{"tf":2.23606797749979}},"k":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":2.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"87":{"tf":1.0}},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"71":{"tf":1.0}}}}}}}}}}}},"t":{"df":10,"docs":{"105":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"30":{"tf":1.0},"68":{"tf":1.7320508075688772},"71":{"tf":1.0},"73":{"tf":1.4142135623730951},"91":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":28,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"116":{"tf":1.7320508075688772},"118":{"tf":3.1622776601683795},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"41":{"tf":1.0},"48":{"tf":2.23606797749979},"49":{"tf":1.7320508075688772},"51":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.7320508075688772},"71":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772},"90":{"tf":1.0},"91":{"tf":1.0}}},"t":{"df":2,"docs":{"118":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"/":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"44":{"tf":1.0},"45":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},">":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":10,"docs":{"1":{"tf":1.0},"111":{"tf":2.0},"24":{"tf":1.4142135623730951},"27":{"tf":2.0},"29":{"tf":1.4142135623730951},"47":{"tf":2.449489742783178},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"113":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"113":{"tf":1.7320508075688772},"117":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":3,"docs":{"111":{"tf":1.4142135623730951},"115":{"tf":1.7320508075688772},"47":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":2.23606797749979}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":5,"docs":{"107":{"tf":1.4142135623730951},"24":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"90":{"tf":2.0},"91":{"tf":2.23606797749979},"97":{"tf":2.449489742783178}}}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"103":{"tf":3.605551275463989},"39":{"tf":2.449489742783178}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":6,"docs":{"103":{"tf":1.0},"119":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"56":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"82":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"85":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"103":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":1,"docs":{"67":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"72":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"76":{"tf":1.0},"79":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"103":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"51":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"v":{"df":4,"docs":{"115":{"tf":1.0},"68":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0}}}}},"s":{"df":1,"docs":{"55":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"115":{"tf":1.0},"68":{"tf":1.0},"9":{"tf":1.0},"99":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"34":{"tf":1.0}},"s":{"df":1,"docs":{"117":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"98":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":1.4142135623730951},"75":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"104":{"tf":1.4142135623730951},"113":{"tf":1.0},"46":{"tf":1.0},"68":{"tf":1.4142135623730951},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":3,"docs":{"16":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}}},"w":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"17":{"tf":1.4142135623730951},"68":{"tf":2.6457513110645907},"9":{"tf":1.0}}}}}},"v":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"6":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"113":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"26":{"tf":2.449489742783178},"62":{"tf":1.0},"73":{"tf":1.4142135623730951},"80":{"tf":3.872983346207417},"84":{"tf":2.0}},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"2":{"tf":1.4142135623730951},"69":{"tf":1.0},"90":{"tf":1.0}}}}}},"c":{"df":1,"docs":{"77":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"67":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"97":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":7,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"118":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":4,"docs":{"116":{"tf":2.0},"58":{"tf":1.0},"68":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"16":{"tf":1.7320508075688772},"3":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"80":{"tf":1.0},"95":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":11,"docs":{"103":{"tf":1.0},"108":{"tf":1.0},"109":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"64":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"82":{"tf":1.0},"9":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"u":{"b":{"df":21,"docs":{"114":{"tf":1.4142135623730951},"2":{"tf":1.0},"26":{"tf":1.4142135623730951},"62":{"tf":3.605551275463989},"73":{"tf":1.7320508075688772},"74":{"tf":2.23606797749979},"75":{"tf":1.4142135623730951},"77":{"tf":2.23606797749979},"79":{"tf":2.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"90":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"92":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"c":{"df":10,"docs":{"113":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"26":{"tf":2.449489742783178},"62":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.7320508075688772},"80":{"tf":2.449489742783178},"9":{"tf":1.0},"91":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"119":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}},"t":{"df":7,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"68":{"tf":1.0},"8":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"100":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"69":{"tf":1.0},"9":{"tf":1.0}}}}},"df":1,"docs":{"50":{"tf":1.4142135623730951}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"d":{"df":3,"docs":{"47":{"tf":1.0},"65":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"12":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}},"m":{"df":1,"docs":{"73":{"tf":1.7320508075688772}},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":10,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"30":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"91":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"70":{"tf":1.0},"98":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"113":{"tf":1.0},"46":{"tf":1.0},"91":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"r":{"d":{"df":1,"docs":{"97":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":4,"docs":{"113":{"tf":1.0},"2":{"tf":1.0},"62":{"tf":1.4142135623730951},"77":{"tf":2.23606797749979}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"10":{"tf":1.0},"119":{"tf":2.0},"12":{"tf":1.4142135623730951},"120":{"tf":1.4142135623730951},"121":{"tf":1.0},"72":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"75":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"90":{"tf":1.0},"91":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"30":{"tf":1.0},"66":{"tf":1.4142135623730951},"73":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"=":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"77":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":5,"docs":{"118":{"tf":1.0},"23":{"tf":1.0},"71":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"94":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"68":{"tf":1.0}}}},"i":{"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":3,"docs":{"19":{"tf":1.0},"34":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"51":{"tf":1.0},"63":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"105":{"tf":1.0},"111":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":17,"docs":{"101":{"tf":2.0},"102":{"tf":2.0},"103":{"tf":1.7320508075688772},"105":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.0},"35":{"tf":2.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"51":{"tf":1.0},"68":{"tf":1.0},"76":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"119":{"tf":1.0},"34":{"tf":1.0},"55":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"r":{"df":9,"docs":{"103":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"v":{"df":5,"docs":{"16":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":2.6457513110645907},"79":{"tf":1.0},"80":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"105":{"tf":1.7320508075688772},"111":{"tf":1.0},"119":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"90":{"tf":1.4142135623730951},"97":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"df":4,"docs":{"6":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"89":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"69":{"tf":1.7320508075688772}}}},"df":7,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"17":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.0},"95":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"66":{"tf":1.0},"69":{"tf":2.0},"9":{"tf":1.7320508075688772},"98":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}}},"f":{"c":{"df":2,"docs":{"120":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"68":{"tf":1.0},"71":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"118":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"46":{"tf":1.0}}},"df":12,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"103":{"tf":1.0},"107":{"tf":2.0},"111":{"tf":2.23606797749979},"114":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"57":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.0}}}},"w":{"df":1,"docs":{"13":{"tf":1.0}}}},"s":{"df":1,"docs":{"25":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":4,"docs":{"117":{"tf":1.0},"45":{"tf":1.4142135623730951},"67":{"tf":1.0},"7":{"tf":1.0}}}},"n":{"df":23,"docs":{"1":{"tf":1.0},"103":{"tf":1.0},"106":{"tf":1.4142135623730951},"112":{"tf":1.7320508075688772},"115":{"tf":1.7320508075688772},"116":{"tf":2.449489742783178},"118":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"30":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"39":{"tf":1.0},"49":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.7320508075688772},"78":{"tf":1.0},"85":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"116":{"tf":1.0},"32":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"116":{"tf":2.8284271247461903}}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"8":{"tf":1.0}}},"c":{"df":10,"docs":{"108":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":2.23606797749979},"33":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"78":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"c":{"'":{"df":8,"docs":{"111":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"24":{"tf":1.0},"41":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":1.0},"73":{"tf":1.0}}},"df":85,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":1.7320508075688772},"10":{"tf":1.4142135623730951},"100":{"tf":1.7320508075688772},"101":{"tf":2.0},"102":{"tf":2.0},"103":{"tf":1.0},"104":{"tf":1.7320508075688772},"105":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"107":{"tf":2.23606797749979},"108":{"tf":1.4142135623730951},"111":{"tf":1.7320508075688772},"112":{"tf":1.4142135623730951},"113":{"tf":2.0},"115":{"tf":2.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"118":{"tf":1.4142135623730951},"119":{"tf":1.0},"120":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":2.0},"2":{"tf":2.8284271247461903},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":2.23606797749979},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":2.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":2.8284271247461903},"30":{"tf":2.8284271247461903},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"43":{"tf":2.0},"44":{"tf":1.0},"45":{"tf":1.7320508075688772},"46":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"5":{"tf":2.23606797749979},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"69":{"tf":1.0},"71":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":2.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.7320508075688772},"8":{"tf":1.0},"81":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.7320508075688772},"91":{"tf":2.449489742783178},"92":{"tf":1.4142135623730951},"93":{"tf":1.0},"97":{"tf":1.7320508075688772},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"100":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":27,"docs":{"0":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"109":{"tf":1.0},"113":{"tf":1.0},"120":{"tf":1.7320508075688772},"121":{"tf":1.0},"17":{"tf":1.4142135623730951},"30":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0},"85":{"tf":1.0},"87":{"tf":3.0},"91":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":15,"docs":{"103":{"tf":1.0},"111":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"17":{"tf":1.0},"25":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"45":{"tf":1.4142135623730951},"51":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"79":{"tf":1.0}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"75":{"tf":1.0},"77":{"tf":2.23606797749979}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"86":{"tf":2.0}}}}}}},"df":4,"docs":{"5":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.0},"77":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"1":{"tf":1.0},"111":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"9":{"tf":1.0},"92":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"2":{"tf":1.4142135623730951},"70":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"62":{"tf":1.7320508075688772},"69":{"tf":1.0},"72":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"93":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":22,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"106":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"4":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}},"n":{"df":3,"docs":{"113":{"tf":1.4142135623730951},"34":{"tf":1.0},"90":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"f":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"v":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"45":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"69":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":1,"docs":{"97":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"97":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"t":{"df":9,"docs":{"107":{"tf":1.0},"17":{"tf":1.0},"34":{"tf":2.23606797749979},"65":{"tf":1.0},"68":{"tf":2.0},"73":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"10":{"tf":1.0},"105":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.7320508075688772}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":4,"docs":{"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"85":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"df":15,"docs":{"113":{"tf":1.7320508075688772},"114":{"tf":1.4142135623730951},"117":{"tf":2.0},"17":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"26":{"tf":1.4142135623730951},"62":{"tf":1.0},"68":{"tf":1.4142135623730951},"70":{"tf":1.0},"71":{"tf":1.0},"8":{"tf":1.4142135623730951},"92":{"tf":1.0},"98":{"tf":1.0}},"n":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"11":{"tf":1.0},"54":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"9":{"tf":1.0},"91":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"29":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"111":{"tf":1.0},"51":{"tf":1.0}}}}},"x":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"91":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"<":{"df":0,"docs":{},"t":{">":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"95":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"22":{"tf":1.0},"30":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"8":{"tf":1.0},"90":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"68":{"tf":1.0},"73":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":2.6457513110645907}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"104":{"tf":1.0},"50":{"tf":1.0},"58":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"51":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"10":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"105":{"tf":1.0},"62":{"tf":1.0},"75":{"tf":1.0},"98":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{"df":9,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.4142135623730951},"8":{"tf":1.0},"90":{"tf":2.0},"91":{"tf":1.7320508075688772},"95":{"tf":1.0}},"i":{"df":7,"docs":{"24":{"tf":1.0},"29":{"tf":2.0},"33":{"tf":1.4142135623730951},"47":{"tf":1.0},"67":{"tf":1.4142135623730951},"71":{"tf":1.0},"75":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":39,"docs":{"1":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.0},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":2.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0}},"s":{":":{"1":{":":{"1":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"1":{"df":1,"docs":{"16":{"tf":1.0}}},"9":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"104":{"tf":1.0},"108":{"tf":1.0},"95":{"tf":1.0}}}},"l":{"df":7,"docs":{"114":{"tf":1.0},"118":{"tf":1.0},"21":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"121":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"5":{"tf":2.0}}}}},"r":{"d":{"df":11,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"108":{"tf":1.4142135623730951},"23":{"tf":1.0},"56":{"tf":1.0},"64":{"tf":1.0},"75":{"tf":1.0},"9":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"65":{"tf":1.0},"68":{"tf":1.4142135623730951},"8":{"tf":2.23606797749979},"82":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"i":{"c":{"=":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"111":{"tf":2.449489742783178},"117":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.4142135623730951}}}}}}},"d":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"#":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"69":{"tf":2.0}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"<":{"'":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"c":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"107":{"tf":1.0},"111":{"tf":1.0},"45":{"tf":1.0},"68":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.4142135623730951},"80":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":2.23606797749979}}}}}}}}}}},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"69":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"115":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"68":{"tf":1.0}}}},"p":{"df":4,"docs":{"118":{"tf":1.0},"63":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"117":{"tf":1.0}}}}}}}},"@":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":11,"docs":{"115":{"tf":1.4142135623730951},"62":{"tf":2.449489742783178},"73":{"tf":2.8284271247461903},"74":{"tf":3.1622776601683795},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"77":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":2.0},"92":{"tf":1.7320508075688772},"97":{"tf":2.449489742783178}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"115":{"tf":1.7320508075688772},"19":{"tf":1.0},"47":{"tf":1.0}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"121":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"119":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"71":{"tf":1.0},"72":{"tf":1.0},"9":{"tf":1.4142135623730951},"91":{"tf":1.0}}}},"df":0,"docs":{},"f":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"105":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"105":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":2,"docs":{"105":{"tf":2.0},"111":{"tf":1.0}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"79":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"91":{"tf":1.0}}}},"m":{"df":1,"docs":{"68":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}},"i":{"df":2,"docs":{"6":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"115":{"tf":1.0},"75":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"50":{"tf":1.0},"65":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":2.0}}}},"s":{"df":1,"docs":{"97":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"106":{"tf":1.0},"40":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"103":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.0},"90":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":9,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0},"4":{"tf":2.0},"51":{"tf":1.0},"72":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":2.23606797749979}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"42":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":2.449489742783178},"40":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":7,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"115":{"tf":1.0},"121":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.0},"86":{"tf":1.7320508075688772}}},"k":{"df":0,"docs":{},"e":{"df":12,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"73":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":1,"docs":{"16":{"tf":1.0}}},"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"c":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"=":{"+":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"x":{"df":1,"docs":{"30":{"tf":2.449489742783178}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":5,"docs":{"115":{"tf":2.6457513110645907},"3":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":2.6457513110645907},"90":{"tf":2.0}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"14":{"tf":2.8284271247461903}}}}},"df":2,"docs":{"75":{"tf":1.0},"95":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"30":{"tf":1.0},"71":{"tf":2.0},"97":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"1":{":":{"2":{"4":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"6":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":26,"docs":{"106":{"tf":2.0},"112":{"tf":1.7320508075688772},"115":{"tf":1.0},"116":{"tf":1.7320508075688772},"17":{"tf":1.7320508075688772},"30":{"tf":2.6457513110645907},"31":{"tf":2.8284271247461903},"32":{"tf":3.1622776601683795},"43":{"tf":1.0},"5":{"tf":1.0},"65":{"tf":2.449489742783178},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":2.449489742783178},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"72":{"tf":1.0},"73":{"tf":3.3166247903554},"78":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":2.0},"85":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":7,"docs":{"11":{"tf":2.0},"12":{"tf":2.449489742783178},"51":{"tf":1.4142135623730951},"67":{"tf":1.0},"71":{"tf":1.0},"9":{"tf":1.0},"95":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":3,"docs":{"33":{"tf":1.0},"4":{"tf":1.0},"68":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"44":{"tf":1.0}}},".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"41":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.0}}}}},"df":0,"docs":{}},"=":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"u":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}},"df":5,"docs":{"19":{"tf":2.449489742783178},"34":{"tf":3.4641016151377544},"41":{"tf":1.0},"44":{"tf":3.3166247903554},"45":{"tf":3.7416573867739413}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"100":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":4,"docs":{"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"y":{"'":{"df":0,"docs":{},"r":{"df":3,"docs":{"112":{"tf":1.0},"26":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":9,"docs":{"116":{"tf":1.4142135623730951},"16":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"90":{"tf":1.4142135623730951},"95":{"tf":1.0}}},"k":{"df":2,"docs":{"2":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"114":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":10,"docs":{"107":{"tf":2.0},"108":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"15":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"70":{"tf":1.0},"91":{"tf":1.0},"93":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"113":{"tf":1.0},"51":{"tf":1.0},"65":{"tf":1.0},"92":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":3,"docs":{"70":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"11":{"tf":1.0},"116":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"92":{"tf":1.4142135623730951}}}}}}},"u":{"df":3,"docs":{"93":{"tf":1.0},"96":{"tf":1.0},"99":{"tf":1.0}},"m":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"93":{"tf":1.0}},"l":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":6,"docs":{"113":{"tf":1.0},"16":{"tf":1.0},"30":{"tf":1.0},"68":{"tf":1.4142135623730951},"9":{"tf":1.0},"92":{"tf":1.0}}}}},"o":{"c":{"df":1,"docs":{"40":{"tf":2.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"90":{"tf":1.7320508075688772},"97":{"tf":2.0}}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"114":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"0":{"tf":1.0}}}},"p":{"df":6,"docs":{"1":{"tf":1.0},"109":{"tf":1.7320508075688772},"16":{"tf":1.0},"3":{"tf":1.0},"62":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"117":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":4,"docs":{"56":{"tf":1.4142135623730951},"97":{"tf":1.0},"98":{"tf":1.4142135623730951},"99":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"113":{"tf":1.4142135623730951},"17":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"98":{"tf":3.4641016151377544},"99":{"tf":2.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"118":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"43":{"tf":1.0},"50":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":6,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"5":{"tf":1.0},"71":{"tf":1.0},"9":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"115":{"tf":1.0},"23":{"tf":1.0},"33":{"tf":2.0},"65":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"15":{"tf":1.0},"94":{"tf":1.0},"99":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":8,"docs":{"107":{"tf":1.0},"11":{"tf":1.0},"2":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.4142135623730951},"68":{"tf":1.0},"70":{"tf":1.0},"97":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"=":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"117":{"tf":1.0}}}}},"df":12,"docs":{"107":{"tf":1.0},"18":{"tf":1.0},"64":{"tf":1.4142135623730951},"69":{"tf":2.0},"75":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.7320508075688772},"91":{"tf":2.0},"98":{"tf":2.0},"99":{"tf":2.0}}},"o":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":1,"docs":{"7":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"116":{"tf":1.4142135623730951},"3":{"tf":1.0},"93":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"5":{"tf":1.0},"69":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":2,"docs":{"114":{"tf":1.4142135623730951},"81":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"5":{"tf":1.0},"69":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"15":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"75":{"tf":1.0},"91":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"69":{"tf":1.0},"76":{"tf":1.0}}}},"t":{"df":2,"docs":{"66":{"tf":1.0},"73":{"tf":1.4142135623730951}}},"x":{"df":4,"docs":{"47":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"90":{"tf":1.0},"97":{"tf":1.0}}}}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"85":{"tf":1.0},"91":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"62":{"tf":1.0},"63":{"tf":1.0},"70":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":5,"docs":{"103":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"108":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"86":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":27,"docs":{"100":{"tf":2.23606797749979},"101":{"tf":1.7320508075688772},"102":{"tf":1.7320508075688772},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":1.7320508075688772},"107":{"tf":1.4142135623730951},"108":{"tf":2.23606797749979},"109":{"tf":1.0},"110":{"tf":1.0},"111":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"113":{"tf":1.4142135623730951},"114":{"tf":1.0},"115":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"117":{"tf":1.7320508075688772},"21":{"tf":1.0},"56":{"tf":1.0},"93":{"tf":2.23606797749979},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"87":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}},"df":8,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"91":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"l":{"df":7,"docs":{"103":{"tf":3.4641016151377544},"107":{"tf":2.23606797749979},"39":{"tf":2.0},"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"75":{"tf":1.0},"88":{"tf":1.7320508075688772}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"16":{"tf":1.0}}}},"df":87,"docs":{"10":{"tf":1.0},"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.0},"107":{"tf":1.7320508075688772},"108":{"tf":1.0},"109":{"tf":1.0},"111":{"tf":1.4142135623730951},"112":{"tf":1.0},"113":{"tf":1.0},"114":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"117":{"tf":1.0},"118":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":1.0},"3":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"4":{"tf":2.23606797749979},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"5":{"tf":1.4142135623730951},"51":{"tf":2.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":3.0},"64":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":2.0},"69":{"tf":2.8284271247461903},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951},"73":{"tf":2.0},"74":{"tf":1.0},"75":{"tf":1.7320508075688772},"77":{"tf":1.7320508075688772},"78":{"tf":1.0},"8":{"tf":3.1622776601683795},"82":{"tf":1.0},"88":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772},"90":{"tf":2.0},"91":{"tf":1.0},"92":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.4142135623730951},"97":{"tf":2.449489742783178},"99":{"tf":1.7320508075688772}},"e":{"'":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":7,"docs":{"106":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"34":{"tf":1.0},"8":{"tf":1.4142135623730951},"82":{"tf":1.0},"9":{"tf":1.4142135623730951}},"s":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"d":{"df":0,"docs":{},"o":{"c":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"73":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"106":{"tf":1.0},"112":{"tf":1.0},"33":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"47":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"73":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"v":{"0":{".":{"1":{".":{"0":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"116":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"d":{"df":3,"docs":{"73":{"tf":1.0},"75":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":5,"docs":{"28":{"tf":1.4142135623730951},"34":{"tf":1.0},"57":{"tf":1.4142135623730951},"76":{"tf":1.0},"85":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"100":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}}}}},"df":2,"docs":{"22":{"tf":1.7320508075688772},"23":{"tf":1.7320508075688772}},"e":{"c":{"<":{"df":0,"docs":{},"t":{">":{"`":{"]":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"75":{"tf":1.0}}}},"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"101":{"tf":1.0},"102":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"23":{"tf":2.6457513110645907},"3":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"45":{"tf":1.7320508075688772},"73":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":11,"docs":{"111":{"tf":1.0},"115":{"tf":1.7320508075688772},"22":{"tf":2.449489742783178},"23":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":2.8284271247461903},"51":{"tf":1.0},"69":{"tf":1.0},"75":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}}},"i":{"a":{"df":2,"docs":{"51":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"8":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":13,"docs":{"107":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.0},"60":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":2.23606797749979},"69":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"8":{"tf":1.0},"90":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"16":{"tf":2.0},"81":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"87":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":16,"docs":{"106":{"tf":2.6457513110645907},"16":{"tf":2.0},"60":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":2.23606797749979},"78":{"tf":1.0},"79":{"tf":2.23606797749979},"80":{"tf":2.23606797749979},"81":{"tf":1.4142135623730951},"82":{"tf":2.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":2.0},"87":{"tf":1.7320508075688772},"88":{"tf":2.23606797749979}}}},"y":{"df":8,"docs":{"103":{"tf":1.0},"16":{"tf":1.4142135623730951},"30":{"tf":1.0},"64":{"tf":1.0},"66":{"tf":1.0},"72":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.4142135623730951}}}},"df":1,"docs":{"114":{"tf":1.4142135623730951}},"e":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.0}}}},"r":{"df":1,"docs":{"73":{"tf":1.0}}},"v":{"df":1,"docs":{"51":{"tf":1.0}}}},"b":{"df":2,"docs":{"1":{"tf":1.0},"71":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"10":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"100":{"tf":1.0},"109":{"tf":1.0},"113":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.4142135623730951},"43":{"tf":1.0},"70":{"tf":1.0}}}},"’":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"90":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"8":{"tf":1.0},"80":{"tf":1.0},"9":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"69":{"tf":1.0},"92":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"68":{"tf":1.0},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"'":{"1":{"0":{"0":{"'":{">":{"<":{"/":{"a":{"df":1,"docs":{"54":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":5,"docs":{"33":{"tf":1.0},"47":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"90":{"tf":1.0},"97":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"106":{"tf":1.0},"65":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":9,"docs":{"118":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"73":{"tf":1.0},"85":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"k":{"df":10,"docs":{"103":{"tf":1.4142135623730951},"106":{"tf":1.0},"24":{"tf":1.0},"45":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951},"91":{"tf":1.4142135623730951}}},"l":{"d":{"df":5,"docs":{"16":{"tf":1.0},"68":{"tf":1.4142135623730951},"71":{"tf":1.0},"8":{"tf":1.0},"93":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"'":{"df":0,"docs":{},"v":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"62":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"11":{"tf":1.0},"17":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":17,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"113":{"tf":1.0},"12":{"tf":1.0},"121":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":2.8284271247461903},"73":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0},"9":{"tf":2.0},"90":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"113":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"23":{"tf":1.4142135623730951},"75":{"tf":1.0}}}}}}}}},"x":{"8":{"6":{"_":{"6":{"4":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"14":{"tf":1.0},"65":{"tf":1.7320508075688772},"68":{"tf":4.242640687119285},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"92":{"tf":1.4142135623730951}}},"y":{"df":1,"docs":{"68":{"tf":4.242640687119285}},"e":{"df":1,"docs":{"68":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":1,"docs":{"91":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"109":{"tf":1.0},"2":{"tf":1.0},"67":{"tf":1.0},"79":{"tf":1.0}}}},"r":{"df":1,"docs":{"111":{"tf":1.0}}},"v":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{},"r":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"’":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}},"z":{"df":15,"docs":{"100":{"tf":1.0},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.0},"105":{"tf":1.0},"106":{"tf":1.4142135623730951},"107":{"tf":1.0},"108":{"tf":1.7320508075688772},"111":{"tf":1.0},"112":{"tf":1.0},"113":{"tf":1.0},"115":{"tf":1.0},"116":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951}}}}},"title":{"root":{"a":{"d":{"d":{"df":3,"docs":{"44":{"tf":1.0},"48":{"tf":1.0},"92":{"tf":1.0}}},"df":1,"docs":{"98":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"115":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"104":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"116":{"tf":1.4142135623730951},"32":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"100":{"tf":1.0},"20":{"tf":1.0}}}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"51":{"tf":1.0},"71":{"tf":1.0},"96":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"101":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"91":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"113":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"99":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"90":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"28":{"tf":1.0}}}},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"117":{"tf":1.0},"31":{"tf":1.0},"97":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"100":{"tf":1.0},"20":{"tf":1.0},"47":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"121":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"95":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"28":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"40":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":8,"docs":{"103":{"tf":1.0},"104":{"tf":1.0},"107":{"tf":1.0},"111":{"tf":1.0},"25":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"113":{"tf":1.0},"117":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":5,"docs":{"105":{"tf":1.0},"107":{"tf":1.0},"25":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"52":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"105":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":2,"docs":{"35":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"19":{"tf":1.0},"45":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"110":{"tf":1.0},"34":{"tf":1.4142135623730951},"45":{"tf":1.0},"49":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"27":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"98":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"106":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"o":{"c":{"(":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":1,"docs":{"97":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{")":{"]":{"/":{"#":{"[":{"d":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}}},"df":8,"docs":{"105":{"tf":1.0},"109":{"tf":1.0},"110":{"tf":1.0},"43":{"tf":1.0},"51":{"tf":1.0},"69":{"tf":1.0},"91":{"tf":1.0},"96":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"112":{"tf":1.4142135623730951},"115":{"tf":1.0},"43":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":1.0},"95":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":14,"docs":{"106":{"tf":1.4142135623730951},"113":{"tf":1.0},"117":{"tf":1.0},"26":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"65":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"9":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.0},"99":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"40":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}},"df":1,"docs":{"41":{"tf":1.0}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"110":{"tf":1.0},"115":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"17":{"tf":1.0},"31":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":1,"docs":{"96":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"107":{"tf":1.0},"29":{"tf":1.0}}}}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"66":{"tf":1.0},"95":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"89":{"tf":1.0},"90":{"tf":1.0},"93":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"111":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"28":{"tf":1.0},"47":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"115":{"tf":1.0}},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"r":{"c":{"df":1,"docs":{"108":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"114":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"94":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"94":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"110":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.0}}}}},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"h":{"df":1,"docs":{"21":{"tf":1.0}},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"54":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"107":{"tf":1.0},"111":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"115":{"tf":1.4142135623730951}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":8,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"16":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"109":{"tf":1.0},"110":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"22":{"tf":1.0},"90":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"87":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":7,"docs":{"104":{"tf":1.0},"113":{"tf":1.0},"26":{"tf":1.4142135623730951},"61":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"92":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"27":{"tf":1.0}},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"109":{"tf":1.0},"52":{"tf":1.0},"61":{"tf":1.0}}}}}},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"100":{"tf":1.0},"20":{"tf":1.0},"47":{"tf":1.0}}},"k":{"df":3,"docs":{"107":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.0}}},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"o":{"a":{"d":{"df":2,"docs":{"111":{"tf":1.0},"47":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"107":{"tf":1.0}}},"t":{"df":3,"docs":{"103":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":7,"docs":{"10":{"tf":1.0},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"105":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"104":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":6,"docs":{"23":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"105":{"tf":1.0},"25":{"tf":1.4142135623730951},"74":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"94":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"107":{"tf":1.0}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"95":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":1,"docs":{"24":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"120":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"30":{"tf":1.0},"32":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"111":{"tf":1.0},"114":{"tf":1.4142135623730951},"19":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":3,"docs":{"104":{"tf":1.0},"109":{"tf":1.4142135623730951},"110":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":8,"docs":{"116":{"tf":1.0},"118":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"66":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"111":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"47":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"113":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"115":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"112":{"tf":1.4142135623730951}}}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"90":{"tf":1.0},"91":{"tf":1.0},"97":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"103":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"67":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"84":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"80":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"116":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"109":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"50":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"97":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"77":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"119":{"tf":1.0},"72":{"tf":1.0}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"35":{"tf":1.0}}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"105":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"107":{"tf":1.0},"111":{"tf":1.0},"42":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"df":5,"docs":{"106":{"tf":1.0},"112":{"tf":1.0},"116":{"tf":1.0},"31":{"tf":1.0},"49":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"32":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"116":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"c":{"'":{"df":1,"docs":{"41":{"tf":1.0}}},"df":5,"docs":{"0":{"tf":1.0},"107":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"113":{"tf":1.0},"117":{"tf":1.0},"26":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"90":{"tf":1.4142135623730951},"91":{"tf":1.0}},"i":{"df":2,"docs":{"29":{"tf":1.0},"33":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"111":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"117":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"115":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"105":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"115":{"tf":1.0},"33":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":6,"docs":{"106":{"tf":1.0},"116":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"65":{"tf":1.0},"69":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"34":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772}}}}}},"o":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":1,"docs":{"109":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"108":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"100":{"tf":1.0},"108":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"l":{"df":3,"docs":{"103":{"tf":1.0},"107":{"tf":1.0},"39":{"tf":1.0}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":3,"docs":{"3":{"tf":1.0},"5":{"tf":1.0},"69":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}}}},"df":2,"docs":{"22":{"tf":1.0},"23":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"23":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"45":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951}}}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"106":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}},"df":1,"docs":{"114":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"z":{"df":1,"docs":{"108":{"tf":1.0}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});