Object.assign(window.search, {"doc_urls":["introduction.html#introduction","editions/index.html#what-are-editions","editions/index.html#editions-do-not-split-the-ecosystem","editions/index.html#edition-migration-is-easy-and-largely-automated","editions/creating-a-new-project.html#creating-a-new-project","editions/transitioning-an-existing-project-to-a-new-edition.html#transitioning-an-existing-project-to-a-new-edition","editions/transitioning-an-existing-project-to-a-new-edition.html#starting-the-migration","editions/transitioning-an-existing-project-to-a-new-edition.html#updating-your-code-to-be-compatible-with-the-new-edition","editions/transitioning-an-existing-project-to-a-new-edition.html#enabling-the-new-edition-to-use-new-features","editions/advanced-migrations.html#advanced-migration-strategies","editions/advanced-migrations.html#how-migrations-work","editions/advanced-migrations.html#migrating-multiple-configurations","editions/advanced-migrations.html#migrating-a-large-project-or-workspace","editions/advanced-migrations.html#partial-migration-with-broken-code","editions/advanced-migrations.html#migrating-macros","editions/advanced-migrations.html#macro-hygiene","editions/advanced-migrations.html#documentation-tests","editions/advanced-migrations.html#generated-code","editions/advanced-migrations.html#migrating-non-cargo-projects","editions/advanced-migrations.html#writing-idiomatic-code-in-a-new-edition","rust-2015/index.html#rust-2015","rust-2018/index.html#rust-2018","rust-2018/path-changes.html#path-and-module-system-changes","rust-2018/path-changes.html#summary","rust-2018/path-changes.html#motivation","rust-2018/path-changes.html#more-details","rust-2018/path-changes.html#no-more-extern-crate","rust-2018/path-changes.html#the-crate-keyword-refers-to-the-current-crate","rust-2018/path-changes.html#extern-crate-paths","rust-2018/path-changes.html#no-more-modrs","rust-2018/path-changes.html#use-paths","rust-2018/trait-fn-parameters.html#anonymous-trait-function-parameters-deprecated","rust-2018/trait-fn-parameters.html#summary","rust-2018/trait-fn-parameters.html#details","rust-2018/new-keywords.html#new-keywords","rust-2018/new-keywords.html#summary","rust-2018/new-keywords.html#motivation","rust-2018/new-keywords.html#dyn-trait-for-trait-objects","rust-2018/new-keywords.html#async-and-await","rust-2018/new-keywords.html#try-keyword","rust-2018/tyvar-behind-raw-pointer.html#method-dispatch-for-raw-pointers-to-inference-variables","rust-2018/tyvar-behind-raw-pointer.html#summary","rust-2018/tyvar-behind-raw-pointer.html#details","rust-2018/cargo.html#cargo-changes","rust-2018/cargo.html#summary","rust-2021/index.html#rust-2021","rust-2021/prelude.html#additions-to-the-prelude","rust-2021/prelude.html#summary","rust-2021/prelude.html#details","rust-2021/prelude.html#migration","rust-2021/prelude.html#migration-needed","rust-2021/prelude.html#no-migration-needed","rust-2021/prelude.html#implementation-reference","rust-2021/default-cargo-resolver.html#default-cargo-feature-resolver","rust-2021/default-cargo-resolver.html#summary","rust-2021/default-cargo-resolver.html#details","rust-2021/default-cargo-resolver.html#migration","rust-2021/default-cargo-resolver.html#build-failures","rust-2021/default-cargo-resolver.html#exploring-features","rust-2021/IntoIterator-for-arrays.html#intoiterator-for-arrays","rust-2021/IntoIterator-for-arrays.html#summary","rust-2021/IntoIterator-for-arrays.html#details","rust-2021/IntoIterator-for-arrays.html#migration","rust-2021/IntoIterator-for-arrays.html#optional-migration","rust-2021/disjoint-capture-in-closures.html#disjoint-capture-in-closures","rust-2021/disjoint-capture-in-closures.html#summary","rust-2021/disjoint-capture-in-closures.html#details","rust-2021/disjoint-capture-in-closures.html#migration","rust-2021/disjoint-capture-in-closures.html#wild-card-patterns","rust-2021/disjoint-capture-in-closures.html#drop-order","rust-2021/disjoint-capture-in-closures.html#trait-implementations","rust-2021/panic-macro-consistency.html#panic-macro-consistency","rust-2021/panic-macro-consistency.html#summary","rust-2021/panic-macro-consistency.html#details","rust-2021/panic-macro-consistency.html#migration","rust-2021/reserving-syntax.html#reserving-syntax","rust-2021/reserving-syntax.html#summary","rust-2021/reserving-syntax.html#details","rust-2021/reserving-syntax.html#migration","rust-2021/warnings-promoted-to-error.html#warnings-promoted-to-errors","rust-2021/warnings-promoted-to-error.html#summary","rust-2021/warnings-promoted-to-error.html#details","rust-2021/warnings-promoted-to-error.html#bare_trait_objects","rust-2021/warnings-promoted-to-error.html#ellipsis_inclusive_range_patterns","rust-2021/warnings-promoted-to-error.html#migrations","rust-2021/or-patterns-macro-rules.html#or-patterns-in-macro-rules","rust-2021/or-patterns-macro-rules.html#summary","rust-2021/or-patterns-macro-rules.html#details","rust-2021/or-patterns-macro-rules.html#migration"],"index":{"documentStore":{"docInfo":{"0":{"body":26,"breadcrumbs":2,"title":1},"1":{"body":117,"breadcrumbs":2,"title":1},"10":{"body":134,"breadcrumbs":5,"title":2},"11":{"body":78,"breadcrumbs":6,"title":3},"12":{"body":80,"breadcrumbs":7,"title":4},"13":{"body":122,"breadcrumbs":7,"title":4},"14":{"body":136,"breadcrumbs":5,"title":2},"15":{"body":100,"breadcrumbs":5,"title":2},"16":{"body":43,"breadcrumbs":5,"title":2},"17":{"body":32,"breadcrumbs":5,"title":2},"18":{"body":103,"breadcrumbs":7,"title":4},"19":{"body":127,"breadcrumbs":8,"title":5},"2":{"body":50,"breadcrumbs":4,"title":3},"20":{"body":89,"breadcrumbs":4,"title":2},"21":{"body":43,"breadcrumbs":4,"title":2},"22":{"body":4,"breadcrumbs":10,"title":4},"23":{"body":23,"breadcrumbs":7,"title":1},"24":{"body":107,"breadcrumbs":7,"title":1},"25":{"body":6,"breadcrumbs":8,"title":2},"26":{"body":265,"breadcrumbs":9,"title":3},"27":{"body":43,"breadcrumbs":11,"title":5},"28":{"body":63,"breadcrumbs":9,"title":3},"29":{"body":66,"breadcrumbs":8,"title":2},"3":{"body":92,"breadcrumbs":6,"title":5},"30":{"body":231,"breadcrumbs":8,"title":2},"31":{"body":4,"breadcrumbs":12,"title":5},"32":{"body":8,"breadcrumbs":8,"title":1},"33":{"body":34,"breadcrumbs":8,"title":1},"34":{"body":4,"breadcrumbs":6,"title":2},"35":{"body":13,"breadcrumbs":5,"title":1},"36":{"body":0,"breadcrumbs":5,"title":1},"37":{"body":98,"breadcrumbs":8,"title":4},"38":{"body":11,"breadcrumbs":6,"title":2},"39":{"body":10,"breadcrumbs":6,"title":2},"4":{"body":59,"breadcrumbs":7,"title":3},"40":{"body":0,"breadcrumbs":14,"title":6},"41":{"body":5,"breadcrumbs":9,"title":1},"42":{"body":5,"breadcrumbs":9,"title":1},"43":{"body":0,"breadcrumbs":6,"title":2},"44":{"body":33,"breadcrumbs":5,"title":1},"45":{"body":34,"breadcrumbs":4,"title":2},"46":{"body":0,"breadcrumbs":6,"title":2},"47":{"body":16,"breadcrumbs":5,"title":1},"48":{"body":109,"breadcrumbs":5,"title":1},"49":{"body":72,"breadcrumbs":5,"title":1},"5":{"body":73,"breadcrumbs":11,"title":5},"50":{"body":182,"breadcrumbs":6,"title":2},"51":{"body":68,"breadcrumbs":6,"title":2},"52":{"body":134,"breadcrumbs":6,"title":2},"53":{"body":0,"breadcrumbs":10,"title":4},"54":{"body":6,"breadcrumbs":7,"title":1},"55":{"body":67,"breadcrumbs":7,"title":1},"56":{"body":84,"breadcrumbs":7,"title":1},"57":{"body":294,"breadcrumbs":8,"title":2},"58":{"body":207,"breadcrumbs":8,"title":2},"59":{"body":0,"breadcrumbs":6,"title":2},"6":{"body":38,"breadcrumbs":8,"title":2},"60":{"body":29,"breadcrumbs":5,"title":1},"61":{"body":157,"breadcrumbs":5,"title":1},"62":{"body":116,"breadcrumbs":5,"title":1},"63":{"body":15,"breadcrumbs":6,"title":2},"64":{"body":0,"breadcrumbs":8,"title":3},"65":{"body":31,"breadcrumbs":6,"title":1},"66":{"body":99,"breadcrumbs":6,"title":1},"67":{"body":111,"breadcrumbs":6,"title":1},"68":{"body":77,"breadcrumbs":8,"title":3},"69":{"body":133,"breadcrumbs":7,"title":2},"7":{"body":103,"breadcrumbs":11,"title":5},"70":{"body":132,"breadcrumbs":7,"title":2},"71":{"body":0,"breadcrumbs":8,"title":3},"72":{"body":33,"breadcrumbs":6,"title":1},"73":{"body":166,"breadcrumbs":6,"title":1},"74":{"body":108,"breadcrumbs":6,"title":1},"75":{"body":0,"breadcrumbs":6,"title":2},"76":{"body":38,"breadcrumbs":5,"title":1},"77":{"body":157,"breadcrumbs":5,"title":1},"78":{"body":72,"breadcrumbs":5,"title":1},"79":{"body":0,"breadcrumbs":8,"title":3},"8":{"body":84,"breadcrumbs":12,"title":6},"80":{"body":8,"breadcrumbs":6,"title":1},"81":{"body":13,"breadcrumbs":6,"title":1},"82":{"body":32,"breadcrumbs":6,"title":1},"83":{"body":37,"breadcrumbs":6,"title":1},"84":{"body":31,"breadcrumbs":6,"title":1},"85":{"body":0,"breadcrumbs":8,"title":3},"86":{"body":24,"breadcrumbs":6,"title":1},"87":{"body":116,"breadcrumbs":6,"title":1},"88":{"body":81,"breadcrumbs":6,"title":1},"9":{"body":0,"breadcrumbs":6,"title":3}},"docs":{"0":{"body":"Welcome to the Rust Edition Guide! \"Editions\" are Rust's way of introducing changes into the language that would not otherwise be backwards compatible. In this guide, we'll discuss: What editions are Which changes are contained in each edition How to migrate your code from one edition to another","breadcrumbs":"Introduction » Introduction","id":"0","title":"Introduction"},"1":{"body":"The release of Rust 1.0 established \"stability without stagnation\" as a core Rust deliverable. Ever since the 1.0 release, the rule for Rust has been that once a feature has been released on stable, we are committed to supporting that feature for all future releases. There are times, however, when it is useful to be able to make small changes to the language that are not backwards compatible. The most obvious example is introducing a new keyword, which would invalidate variables with the same name. For example, the first version of Rust did not have the async and await keywords. Suddenly changing those words to keywords in a later version would've broken code like let async = 1;. Editions are the mechanism we use to solve this problem. When we want to release a feature that would otherwise be backwards incompatible, we do so as part of a new Rust edition . Editions are opt-in, and so existing crates do not see these changes until they explicitly migrate over to the new edition. This means that even the latest version of Rust will still not treat async as a keyword, unless edition 2018 or later is chosen. This choice is made per crate as part of its Cargo.toml . New crates created by cargo new are always configured to use the latest stable edition.","breadcrumbs":"What are editions? » What are Editions?","id":"1","title":"What are Editions?"},"10":{"body":"cargo fix --edition works by running the equivalent of cargo check on your project with special lints enabled which will detect code that may not compile in the next edition. These lints include instructions on how to modify the code to make it compatible on both the current and the next edition. cargo fix applies these changes to the source code, and then runs cargo check again to verify that the fixes work. If the fixes fail, then it will back out the changes and display a warning. Changing the code to be simultaneously compatible with both the current and next edition makes it easier to incrementally migrate the code. If the automated migration does not completely succeed, or requires manual help, you can iterate while staying on the original edition before changing Cargo.toml to use the next edition. The lints that cargo fix --edition apply are part of a lint group . For example, when migrating from 2018 to 2021, Cargo uses the rust-2021-compatibility group of lints to fix the code. Check the Partial migration section below for tips on using individual lints to help with migration. cargo fix may run cargo check multiple times. For example, after applying one set of fixes, this may trigger new warnings which require further fixes. Cargo repeats this until no new warnings are generated.","breadcrumbs":"What are editions? » Advanced migrations » How migrations work","id":"10","title":"How migrations work"},"11":{"body":"cargo fix can only work with a single configuration at a time. If you use Cargo features or conditional compilation , then you may need to run cargo fix multiple times with different flags. For example, if you have code that uses #[cfg] attributes to include different code for different platforms, you may need to run cargo fix with the --target option to fix for different targets. This may require moving your code between machines if you don't have cross-compiling available. Similarly, if you have conditions on Cargo features, like #[cfg(feature = \"my-optional-thing\")], it is recommended to use the --all-features flag to allow cargo fix to migrate all the code behind those feature gates. If you want to migrate feature code individually, you can use the --features flag to migrate one at a time.","breadcrumbs":"What are editions? » Advanced migrations » Migrating multiple configurations","id":"11","title":"Migrating multiple configurations"},"12":{"body":"You can migrate a large project incrementally to make the process easier if you run into problems. In a Cargo workspace , each package defines its own edition, so the process naturally involves migrating one package at a time. Within a Cargo package , you can either migrate the entire package at once, or migrate individual Cargo targets one at a time. For example, if you have multiple binaries, tests, and examples, you can use specific target selection flags with cargo fix --edition to migrate just that one target. By default, cargo fix uses --all-targets. For even more advanced cases, you can specify the edition for each individual target in Cargo.toml like this: [[bin]]\nname = \"my-binary\"\nedition = \"2018\" This usually should not be required, but is an option if you have a lot of targets and are having difficulty migrating them all together.","breadcrumbs":"What are editions? » Advanced migrations » Migrating a large project or workspace","id":"12","title":"Migrating a large project or workspace"},"13":{"body":"Sometimes the fixes suggested by the compiler may fail to work. When this happens, Cargo will report a warning indicating what happened and what the error was. However, by default it will automatically back out the changes it made. It can be helpful to keep the code in the broken state and manually resolve the issue. Some of the fixes may have been correct, and the broken fix maybe be mostly correct, but just need minor tweaking. In this situation, use the --broken-code option with cargo fix to tell Cargo not to back out the changes. Then, you can go manually inspect the error and investigate what is needed to fix it. Another option to incrementally migrate a project is to apply individual fixes separately, one at a time. You can do this by adding the individual lints as warnings, and then either running cargo fix (without the --edition flag) or using your editor or IDE to apply its suggestions if it supports \"Quick Fixes\". For example, the 2018 edition uses the keyword-idents lint to fix any conflicting keywords. You can add #![warn(keyword_idents)] to the top of each crate (like at the top of src/lib.rs or src/main.rs). Then, running cargo fix will apply just the suggestions for that lint. You can see the list of lints enabled for each edition in the lint group page, or run the rustc -Whelp command.","breadcrumbs":"What are editions? » Advanced migrations » Partial migration with broken code","id":"13","title":"Partial migration with broken code"},"14":{"body":"Some macros may require manual work to fix them for the next edition. For example, cargo fix --edition may not be able to automatically fix a macro that generates syntax that does not work in the next edition. This may be a problem for both proc macros and macro_rules-style macros. macro_rules macros can sometimes be automatically updated if the macro is used within the same crate, but there are several situations where it cannot. Proc macros in general cannot be automatically fixed at all. For example, if we migrate a crate containing this (contrived) macro foo from 2015 to 2018, foo would not be automatically fixed. #[macro_export]\nmacro_rules! foo { () => { let dyn = 1; println!(\"it is {}\", dyn); };\n} When this macro is defined in a 2015 crate, it can be used from a crate of any other edition due to macro hygiene (discussed below). In 2015, dyn is a normal identifier and can be used without restriction. However, in 2018, dyn is no longer a valid identifier. When using cargo fix --edition to migrate to 2018, Cargo won't display any warnings or errors at all. However, foo won't work when called from any crate. If you have macros, you are encouraged to make sure you have tests that fully cover the macro's syntax. You may also want to test the macros by importing and using them in crates from multiple editions, just to ensure it works correctly everywhere. If you run into issues, you'll need to read through the chapters of this guide to understand how the code can be changed to work across all editions.","breadcrumbs":"What are editions? » Advanced migrations » Migrating macros","id":"14","title":"Migrating macros"},"15":{"body":"Macros use a system called \"edition hygiene\" where the tokens within a macro are marked with which edition they come from. This allows external macros to be called from crates of varying editions without needing to worry about which edition it is called from. Let's take a closer look at the example above that defines a macro_rules macro using dyn as an identifier. If that macro was defined in a crate using the 2015 edition, then that macro works fine, even if it were called from a 2018 crate where dyn is a keyword and that would normally be a syntax error. The let dyn = 1; tokens are marked as being from 2015, and the compiler will remember that wherever that code gets expanded. The parser looks at the edition of the tokens to know how to interpret it. The problem arises when changing the edition to 2018 in the crate where it is defined. Now, those tokens are tagged with the 2018 edition, and those will fail to parse. However, since we never called the macro from our crate, cargo fix --edition never had a chance to inspect the macro and fix it.","breadcrumbs":"What are editions? » Advanced migrations » Macro hygiene","id":"15","title":"Macro hygiene"},"16":{"body":"At this time, cargo fix is not able to update documentation tests . After updating the edition in Cargo.toml, you should run cargo test to ensure everything still passes. If your documentation tests use syntax that is not supported in the new edition, you will need to update them manually. In rare cases, you can manually set the edition for each test. For example, you can use the edition2018 annotation on the triple backticks to tell rustdoc which edition to use.","breadcrumbs":"What are editions? » Advanced migrations » Documentation tests","id":"16","title":"Documentation tests"},"17":{"body":"Another area where the automated fixes cannot apply is if you have a build script which generates Rust code at compile time (see Code generation for an example). In this situation, if you end up with code that doesn't work in the next edition, you will need to manually change the build script to generate code that is compatible.","breadcrumbs":"What are editions? » Advanced migrations » Generated code","id":"17","title":"Generated code"},"18":{"body":"If your project is not using Cargo as a build system, it may still be possible to make use of the automated lints to assist migrating to the next edition. You can enable the migration lints as described above by enabling the appropriate lint group . For example, you can use the #![warn(rust_2021_compatibility)] attribute or the -Wrust-2021-compatibility or --force-warns=rust-2021-compatibility CLI flag . The next step is to apply those lints to your code. There are several options here: Manually read the warnings and apply the suggestions recommended by the compiler. Use an editor or IDE that supports automatically applying suggestions. For example, Visual Studio Code with the Rust Analyzer extension has the ability to use the \"Quick Fix\" links to automatically apply suggestions. Many other editors and IDEs have similar functionality. Write a migration tool using the rustfix library. This is the library that Cargo uses internally to take the JSON messages from the compiler and modify the source code. Check the examples directory for examples of how to use the library.","breadcrumbs":"What are editions? » Advanced migrations » Migrating non-Cargo projects","id":"18","title":"Migrating non-Cargo projects"},"19":{"body":"Editions are not only about new features and removing old ones. In any programming language, idioms change over time, and Rust is no exception. While old code will continue to compile, it might be written with different idioms today. For example, in Rust 2015, external crates must be listed with extern crate like this: // src/lib.rs\nextern crate rand; In Rust 2018, it is no longer necessary to include these items. cargo fix has the --edition-idioms option to automatically transition some of these idioms to the new syntax. Warning : The current \"idiom lints\" are known to have some problems. They may make incorrect suggestions which may fail to compile. The current lints are: Edition 2018: unused-extern-crates explicit-outlives-requirements Edition 2021 does not have any idiom lints. The following instructions are recommended only for the intrepid who are willing to work through a few compiler/Cargo bugs! If you run into problems, you can try the --broken-code option described above to make as much progress as possible, and then resolve the remaining issues manually. With that out of the way, we can instruct Cargo to fix our code snippet with: cargo fix --edition-idioms Afterwards, the line with extern crate rand; in src/lib.rs will be removed. We're now more idiomatic, and we didn't have to fix our code manually!","breadcrumbs":"What are editions? » Advanced migrations » Writing idiomatic code in a new edition","id":"19","title":"Writing idiomatic code in a new edition"},"2":{"body":"The most important rule for editions is that crates in one edition can interoperate seamlessly with crates compiled in other editions. This ensures that the decision to migrate to a newer edition is a \"private one\" that the crate can make without affecting others. The requirement for crate interoperability implies some limits on the kinds of changes that we can make in an edition. In general, changes that occur in an edition tend to be \"skin deep\". All Rust code, regardless of edition, is ultimately compiled to the same internal representation within the compiler.","breadcrumbs":"What are editions? » Editions do not split the ecosystem","id":"2","title":"Editions do not split the ecosystem"},"20":{"body":"Rust 2015 has a theme of \"stability\". It commenced with the release of 1.0, and is the \"default edition\". The edition system was conceived in late 2017, but Rust 1.0 was released in May of 2015. As such, 2015 is the edition that you get when you don't specify any particular edition, for backwards compatibility reasons. \"Stability\" is the theme of Rust 2015 because 1.0 marked a huge change in Rust development. Previous to Rust 1.0, Rust was changing on a daily basis. This made it very difficult to write large software in Rust, and made it difficult to learn. With the release of Rust 1.0 and Rust 2015, we committed to backwards compatibility, ensuring a solid foundation for people to build projects on top of. Since it's the default edition, there's no way to port your code to Rust 2015; it just is . You'll be transitioning away from 2015, but never really to 2015. As such, there's not much else to say about it!","breadcrumbs":"Rust 2015 » Rust 2015","id":"20","title":"Rust 2015"},"21":{"body":"Info RFC #2052 , which also proposed the Edition system Release version 1.31.0 The edition system was created for the release of Rust 2018. The release of the Rust 2018 edition coincided with a number of other features all coordinated around the theme of productivity . The majority of those features were backwards compatible and are now available on all editions; however, some of those changes required the edition mechanism (most notably the module system changes ).","breadcrumbs":"Rust 2018 » Rust 2018","id":"21","title":"Rust 2018"},"22":{"body":"Minimum Rust version: 1.31","breadcrumbs":"Rust 2018 » Path and module system changes » Path and module system changes","id":"22","title":"Path and module system changes"},"23":{"body":"Paths in use declarations now work the same as other paths. Paths starting with :: must now be followed with an external crate. Paths in pub(in path) visibility modifiers must now start with crate, self, or super.","breadcrumbs":"Rust 2018 » Path and module system changes » Summary","id":"23","title":"Summary"},"24":{"body":"The module system is often one of the hardest things for people new to Rust. Everyone has their own things that take time to master, of course, but there's a root cause for why it's so confusing to many: while there are simple and consistent rules defining the module system, their consequences can feel inconsistent, counterintuitive and mysterious. As such, the 2018 edition of Rust introduces a few new module system features, but they end up simplifying the module system, to make it more clear as to what is going on. Here's a brief summary: extern crate is no longer needed in 99% of circumstances. The crate keyword refers to the current crate. Paths may start with a crate name, even within submodules. Paths starting with :: must reference an external crate. A foo.rs and foo/ subdirectory may coexist; mod.rs is no longer needed when placing submodules in a subdirectory. Paths in use declarations work the same as other paths. These may seem like arbitrary new rules when put this way, but the mental model is now significantly simplified overall. Read on for more details!","breadcrumbs":"Rust 2018 » Path and module system changes » Motivation","id":"24","title":"Motivation"},"25":{"body":"Let's talk about each new feature in turn.","breadcrumbs":"Rust 2018 » Path and module system changes » More details","id":"25","title":"More details"},"26":{"body":"This one is quite straightforward: you no longer need to write extern crate to import a crate into your project. Before: // Rust 2015 extern crate futures; mod submodule { use futures::Future;\n} After: // Rust 2018 mod submodule { use futures::Future;\n} Now, to add a new crate to your project, you can add it to your Cargo.toml, and then there is no step two. If you're not using Cargo, you already had to pass --extern flags to give rustc the location of external crates, so you'd just keep doing what you were doing there as well. One small note here: cargo fix will not currently automate this change. We may have it do this for you in the future. An exception There's one exception to this rule, and that's the \"sysroot\" crates. These are the crates distributed with Rust itself. Usually these are only needed in very specialized situations. Starting in 1.41, rustc accepts the --extern=CRATE_NAME flag which automatically adds the given crate name in a way similar to extern crate. Build tools may use this to inject sysroot crates into the crate's prelude. Cargo does not have a general way to express this, though it uses it for proc_macro crates. Some examples of needing to explicitly import sysroot crates are: std : Usually this is not necessary, because std is automatically imported unless the crate is marked with #![no_std] . core : Usually this is not necessary, because core is automatically imported, unless the crate is marked with #![no_core] . For example, some of the internal crates used by the standard library itself need this. proc_macro : This is automatically imported by Cargo if it is a proc-macro crate starting in 1.42. extern crate proc_macro; would be needed if you want to support older releases, or if using another build tool that does not pass the appropriate --extern flags to rustc. alloc : Items in the alloc crate are usually accessed via re-exports in the std crate. If you are working with a no_std crate that supports allocation, then you may need to explicitly import alloc. test : This is only available on the nightly channel , and is usually only used for the unstable benchmark support. Macros One other use for extern crate was to import macros; that's no longer needed. Macros may be imported with use like any other item. For example, the following use of extern crate: #[macro_use]\nextern crate bar; fn main() { baz!();\n} Can be changed to something like the following: use bar::baz; fn main() { baz!();\n} Renaming crates If you've been using as to rename your crate like this: extern crate futures as f; use f::Future; then removing the extern crate line on its own won't work. You'll need to do this: use futures as f; use self::f::Future; This change will need to happen in any module that uses f.","breadcrumbs":"Rust 2018 » Path and module system changes » No more extern crate","id":"26","title":"No more extern crate"},"27":{"body":"In use declarations and in other code, you can refer to the root of the current crate with the crate:: prefix. For instance, crate::foo::bar will always refer to the name bar inside the module foo, from anywhere else in the same crate. The prefix :: previously referred to either the crate root or an external crate; it now unambiguously refers to an external crate. For instance, ::foo::bar always refers to the name bar inside the external crate foo.","breadcrumbs":"Rust 2018 » Path and module system changes » The crate keyword refers to the current crate","id":"27","title":"The crate keyword refers to the current crate"},"28":{"body":"Previously, using an external crate in a module without a use import required a leading :: on the path. // Rust 2015 extern crate chrono; fn foo() { // this works in the crate root let x = chrono::Utc::now();\n} mod submodule { fn function() { // but in a submodule it requires a leading :: if not imported with `use` let x = ::chrono::Utc::now(); }\n} Now, extern crate names are in scope in the entire crate, including submodules. // Rust 2018 fn foo() { // this works in the crate root let x = chrono::Utc::now();\n} mod submodule { fn function() { // crates may be referenced directly, even in submodules let x = chrono::Utc::now(); }\n}","breadcrumbs":"Rust 2018 » Path and module system changes » Extern crate paths","id":"28","title":"Extern crate paths"},"29":{"body":"In Rust 2015, if you have a submodule: // This `mod` declaration looks for the `foo` module in\n// `foo.rs` or `foo/mod.rs`.\nmod foo; It can live in foo.rs or foo/mod.rs. If it has submodules of its own, it must be foo/mod.rs. So a bar submodule of foo would live at foo/bar.rs. In Rust 2018 the restriction that a module with submodules must be named mod.rs is lifted. foo.rs can just be foo.rs, and the submodule is still foo/bar.rs. This eliminates the special name, and if you have a bunch of files open in your editor, you can clearly see their names, instead of having a bunch of tabs named mod.rs. Rust 2015 Rust 2018 .\n├── lib.rs\n└── foo/ &nbsp;&nbsp; ├── mod.rs &nbsp;&nbsp; └── bar.rs .\n├── lib.rs\n├── foo.rs\n└── foo/ &nbsp;&nbsp; └── bar.rs","breadcrumbs":"Rust 2018 » Path and module system changes » No more mod.rs","id":"29","title":"No more mod.rs"},"3":{"body":"Our goal is to make it easy for crates to upgrade to a new edition. When we release a new edition, we also provide tooling to automate the migration . It makes minor changes to your code necessary to make it compatible with the new edition. For example, when migrating to Rust 2018, it changes anything named async to use the equivalent raw identifier syntax : r#async. The automated migrations are not necessarily perfect: there might be some corner cases where manual changes are still required. The tooling tries hard to avoid changes to semantics that could affect the correctness or performance of the code. In addition to tooling, we also maintain this Edition Migration Guide that covers the changes that are part of an edition. This guide describes each change and gives pointers to where you can learn more about it. It also covers any corner cases or details you should be aware of. This guide serves both as an overview of the edition and as a quick troubleshooting reference if you encounter problems with the automated tooling.","breadcrumbs":"What are editions? » Edition migration is easy and largely automated","id":"3","title":"Edition migration is easy and largely automated"},"30":{"body":"Minimum Rust version: 1.32 Rust 2018 simplifies and unifies path handling compared to Rust 2015. In Rust 2015, paths work differently in use declarations than they do elsewhere. In particular, paths in use declarations would always start from the crate root, while paths in other code implicitly started from the current scope. Those differences didn't have any effect in the top-level module, which meant that everything would seem straightforward until working on a project large enough to have submodules. In Rust 2018, paths in use declarations and in other code work the same way, both in the top-level module and in any submodule. You can use a relative path from the current scope, a path starting from an external crate name, or a path starting with crate, super, or self. Code that looked like this: // Rust 2015 extern crate futures; use futures::Future; mod foo { pub struct Bar;\n} use foo::Bar; fn my_poll() -> futures::Poll { ... } enum SomeEnum { V1(usize), V2(String),\n} fn func() { let five = std::sync::Arc::new(5); use SomeEnum::*; match ... { V1(i) => { ... } V2(s) => { ... } }\n} will look exactly the same in Rust 2018, except that you can delete the extern crate line: // Rust 2018 use futures::Future; mod foo { pub struct Bar;\n} use foo::Bar; fn my_poll() -> futures::Poll { ... } enum SomeEnum { V1(usize), V2(String),\n} fn func() { let five = std::sync::Arc::new(5); use SomeEnum::*; match ... { V1(i) => { ... } V2(s) => { ... } }\n} The same code will also work completely unmodified in a submodule: // Rust 2018 mod submodule { use futures::Future; mod foo { pub struct Bar; } use foo::Bar; fn my_poll() -> futures::Poll { ... } enum SomeEnum { V1(usize), V2(String), } fn func() { let five = std::sync::Arc::new(5); use SomeEnum::*; match ... { V1(i) => { ... } V2(s) => { ... } } }\n} This makes it easy to move code around in a project, and avoids introducing additional complexity to multi-module projects. If a path is ambiguous, such as if you have an external crate and a local module or item with the same name, you'll get an error, and you'll need to either rename one of the conflicting names or explicitly disambiguate the path. To explicitly disambiguate a path, use ::name for an external crate name, or self::name for a local module or item.","breadcrumbs":"Rust 2018 » Path and module system changes » use paths","id":"30","title":"use paths"},"31":{"body":"Minimum Rust version: 1.31","breadcrumbs":"Rust 2018 » Anonymous trait function parameters deprecated » Anonymous trait function parameters deprecated","id":"31","title":"Anonymous trait function parameters deprecated"},"32":{"body":"Trait function parameters may use any irrefutable pattern when the function has a body.","breadcrumbs":"Rust 2018 » Anonymous trait function parameters deprecated » Summary","id":"32","title":"Summary"},"33":{"body":"In accordance with RFC #1685 , parameters in trait method declarations are no longer allowed to be anonymous. For example, in the 2015 edition, this was allowed: trait Foo { fn foo(&self, u8);\n} In the 2018 edition, all parameters must be given an argument name (even if it's just _): trait Foo { fn foo(&self, baz: u8);\n}","breadcrumbs":"Rust 2018 » Anonymous trait function parameters deprecated » Details","id":"33","title":"Details"},"34":{"body":"Minimum Rust version: 1.27","breadcrumbs":"Rust 2018 » New keywords » New keywords","id":"34","title":"New keywords"},"35":{"body":"dyn is a strict keyword , in 2015 it is a weak keyword . async and await are strict keywords . try is a reserved keyword .","breadcrumbs":"Rust 2018 » New keywords » Summary","id":"35","title":"Summary"},"36":{"body":"","breadcrumbs":"Rust 2018 » New keywords » Motivation","id":"36","title":"Motivation"},"37":{"body":"The dyn Trait feature is the new syntax for using trait objects. In short: Box<Trait> becomes Box<dyn Trait> &Trait and &mut Trait become &dyn Trait and &mut dyn Trait And so on. In code: trait Trait {} impl Trait for i32 {} // old\nfn function1() -> Box<Trait> {\n# unimplemented!()\n} // new\nfn function2() -> Box<dyn Trait> {\n# unimplemented!()\n} That's it! Why? Using just the trait name for trait objects turned out to be a bad decision. The current syntax is often ambiguous and confusing, even to veterans, and favors a feature that is not more frequently used than its alternatives, is sometimes slower, and often cannot be used at all when its alternatives can. Furthermore, with impl Trait arriving, \"impl Trait vs dyn Trait\" is much more symmetric, and therefore a bit nicer, than \"impl Trait vs Trait\". impl Trait is explained here . In the new edition, you should therefore prefer dyn Trait to just Trait where you need a trait object.","breadcrumbs":"Rust 2018 » New keywords » dyn Trait for trait objects","id":"37","title":"dyn Trait for trait objects"},"38":{"body":"These keywords are reserved to implement the async-await feature of Rust, which was ultimately released to stable in 1.39.0 .","breadcrumbs":"Rust 2018 » New keywords » async and await","id":"38","title":"async and await"},"39":{"body":"The try keyword is reserved for use in try blocks, which have not (as of this writing) been stabilized ( tracking issue )","breadcrumbs":"Rust 2018 » New keywords » try keyword","id":"39","title":"try keyword"},"4":{"body":"When you create a new project with Cargo, it will automatically add configuration for the latest edition: > cargo new foo Created binary (application) `foo` project\n> cat foo/Cargo.toml\n[package]\nname = \"foo\"\nversion = \"0.1.0\"\nedition = \"2021\" [dependencies] That edition = \"2021\" setting will configure your package to use Rust 2021. No more configuration needed! If you'd prefer to use an older edition, you can change the value in that key, for example: [package]\nname = \"foo\"\nversion = \"0.1.0\"\nedition = \"2015\" [dependencies] This will build your package in Rust 2015.","breadcrumbs":"What are editions? » Creating a new project » Creating a new project","id":"4","title":"Creating a new project"},"40":{"body":"","breadcrumbs":"Rust 2018 » Method dispatch for raw pointers to inference variables » Method dispatch for raw pointers to inference variables","id":"40","title":"Method dispatch for raw pointers to inference variables"},"41":{"body":"The tyvar_behind_raw_pointer lint is now a hard error.","breadcrumbs":"Rust 2018 » Method dispatch for raw pointers to inference variables » Summary","id":"41","title":"Summary"},"42":{"body":"See Rust issue #46906 for details.","breadcrumbs":"Rust 2018 » Method dispatch for raw pointers to inference variables » Details","id":"42","title":"Details"},"43":{"body":"","breadcrumbs":"Rust 2018 » Cargo changes » Cargo changes","id":"43","title":"Cargo changes"},"44":{"body":"If there is a target definition in a Cargo.toml manifest, it no longer automatically disables automatic discovery of other targets. Target paths of the form src/{target_name}.rs are no longer inferred for targets where the path field is not set. cargo install for the current directory is no longer allowed, you must specify cargo install --path . to install the current package.","breadcrumbs":"Rust 2018 » Cargo changes » Summary","id":"44","title":"Summary"},"45":{"body":"Info RFC #3085 Release version 1.56.0 The Rust 2021 Edition contains several changes that bring new capabilities and more consistency to the language, and opens up room for expansion in the future. The following chapters dive into the details of each change, and they include guidance on migrating your existing code.","breadcrumbs":"Rust 2021 » Rust 2021","id":"45","title":"Rust 2021"},"46":{"body":"","breadcrumbs":"Rust 2021 » Additions to the prelude » Additions to the prelude","id":"46","title":"Additions to the prelude"},"47":{"body":"The TryInto, TryFrom and FromIterator traits are now part of the prelude. This might make calls to trait methods ambiguous which could make some code fail to compile.","breadcrumbs":"Rust 2021 » Additions to the prelude » Summary","id":"47","title":"Summary"},"48":{"body":"The prelude of the standard library is the module containing everything that is automatically imported in every module. It contains commonly used items such as Option, Vec, drop, and Clone. The Rust compiler prioritizes any manually imported items over those from the prelude, to make sure additions to the prelude will not break any existing code. For example, if you have a crate or module called example containing a pub struct Option;, then use example::*; will make Option unambiguously refer to the one from example; not the one from the standard library. However, adding a trait to the prelude can break existing code in a subtle way. For example, a call to x.try_into() which comes from a MyTryInto trait might fail to compile if std's TryInto is also imported, because the call to try_into is now ambiguous and could come from either trait. This is the reason we haven't added TryInto to the prelude yet, since there is a lot of code that would break this way. As a solution, Rust 2021 will use a new prelude. It's identical to the current one, except for three new additions: std::convert::TryInto std::convert::TryFrom std::iter::FromIterator The tracking issue can be found here .","breadcrumbs":"Rust 2021 » Additions to the prelude » Details","id":"48","title":"Details"},"49":{"body":"As a part of the 2021 edition a migration lint, rust_2021_prelude_collisions, has been added in order to aid in automatic migration of Rust 2018 codebases to Rust 2021. In order to have rustfix migrate your code to be Rust 2021 Edition compatible, run: cargo fix --edition The lint detects cases where functions or methods are called that have the same name as the methods defined in one of the new prelude traits. In some cases, it may rewrite your calls in various ways to ensure that you continue to call the same function you did before. If you'd like to migrate your code manually or better understand what rustfix is doing, below we've outlined the situations where a migration is needed along with a counter example of when it's not needed.","breadcrumbs":"Rust 2021 » Additions to the prelude » Migration","id":"49","title":"Migration"},"5":{"body":"Rust includes tooling to automatically transition a project from one edition to the next. It will update your source code so that it is compatible with the next edition. Briefly, the steps to update to the next edition are: Run cargo fix --edition Edit Cargo.toml and set the edition field to the next edition, for example edition = \"2021\" Run cargo build or cargo test to verify the fixes worked. The following sections dig into the details of these steps, and some of the issues you may encounter along the way. It's our intention that the migration to new editions is as smooth an experience as possible. If it's difficult for you to upgrade to the latest edition, we consider that a bug. If you run into problems with this process, please file a bug . Thank you!","breadcrumbs":"What are editions? » Transitioning an existing project to a new edition » Transitioning an existing project to a new edition","id":"5","title":"Transitioning an existing project to a new edition"},"50":{"body":"Conflicting trait methods When two traits that are in scope have the same method name, it is ambiguous which trait method should be used. For example: trait MyTrait<A> { // This name is the same as the `from_iter` method on the `FromIterator` trait from `std`. fn from_iter(x: Option<A>);\n} impl<T> MyTrait<()> for Vec<T> { fn from_iter(_: Option<()>) {}\n} fn main() { // Vec<T> implements both `std::iter::FromIterator` and `MyTrait` // If both traits are in scope (as would be the case in Rust 2021), // then it becomes ambiguous which `from_iter` method to call <Vec<i32>>::from_iter(None);\n} We can fix this by using fully qualified syntax: fn main() { // Now it is clear which trait method we're referring to <Vec<i32> as MyTrait<()>>::from_iter(None);\n} Inherent methods on dyn Trait objects Some users invoke methods on a dyn Trait value where the method name overlaps with a new prelude trait: mod submodule { pub trait MyTrait { // This has the same name as `TryInto::try_into` fn try_into(&self) -> Result<u32, ()>; }\n} // `MyTrait` isn't in scope here and can only be referred to through the path `submodule::MyTrait`\nfn bar(f: Box<dyn submodule::MyTrait>) { // If `std::convert::TryInto` is in scope (as would be the case in Rust 2021), // then it becomes ambiguous which `try_into` method to call f.try_into();\n} Unlike with static dispatch methods, calling a trait method on a trait object does not require that the trait be in scope. The code above works as long as there is no trait in scope with a conflicting method name. When the TryInto trait is in scope (which is the case in Rust 2021), this causes an ambiguity. Should the call be to MyTrait::try_into or std::convert::TryInto::try_into? In these cases, we can fix this by adding an additional dereferences or otherwise clarify the type of the method receiver. This ensures that the dyn Trait method is chosen, versus the methods from the prelude trait. For example, turning f.try_into() above into (&*f).try_into() ensures that we're calling try_into on the dyn MyTrait which can only refer to the MyTrait::try_into method.","breadcrumbs":"Rust 2021 » Additions to the prelude » Migration needed","id":"50","title":"Migration needed"},"51":{"body":"Inherent methods Many types define their own inherent methods with the same name as a trait method. For instance, below the struct MyStruct implements from_iter which shares the same name with the method from the trait FromIterator found in the standard library: use std::iter::IntoIterator; struct MyStruct { data: Vec<u32>\n} impl MyStruct { // This has the same name as `std::iter::FromIterator::from_iter` fn from_iter(iter: impl IntoIterator<Item = u32>) -> Self { Self { data: iter.into_iter().collect() } }\n} impl std::iter::FromIterator<u32> for MyStruct { fn from_iter<I: IntoIterator<Item = u32>>(iter: I) -> Self { Self { data: iter.into_iter().collect() } }\n} Inherent methods always take precedent over trait methods so there's no need for any migration.","breadcrumbs":"Rust 2021 » Additions to the prelude » No migration needed","id":"51","title":"No migration needed"},"52":{"body":"The lint needs to take a couple of factors into account when determining whether or not introducing 2021 Edition to a codebase will cause a name resolution collision (thus breaking the code after changing edition). These factors include: Is the call a fully-qualified call or does it use dot-call method syntax ? This will affect how the name is resolved due to auto-reference and auto-dereferencing on method call syntax. Manually dereferencing/referencing will allow specifying priority in the case of dot-call method syntax, while fully-qualified call requires specification of the type and the trait name in the method path (e.g. <Type as Trait>::method) Is this an inherent method or a trait method ? Inherent methods that take self will take priority over TryInto::try_into as inherent methods take priority over trait methods, but inherent methods that take &self or &mut self won't take priority due to requiring a auto-reference (while TryInto::try_into does not, as it takes self) Is the origin of this method from core/std? (As the traits can't have a collision with themselves) Does the given type implement the trait it could have a collision against? Is the method being called via dynamic dispatch? (i.e. is the self type dyn Trait) If so, trait imports don't affect resolution, and no migration lint needs to occur","breadcrumbs":"Rust 2021 » Additions to the prelude » Implementation Reference","id":"52","title":"Implementation Reference"},"53":{"body":"","breadcrumbs":"Rust 2021 » Default Cargo feature resolver » Default Cargo feature resolver","id":"53","title":"Default Cargo feature resolver"},"54":{"body":"edition = \"2021\" implies resolver = \"2\" in Cargo.toml.","breadcrumbs":"Rust 2021 » Default Cargo feature resolver » Summary","id":"54","title":"Summary"},"55":{"body":"Since Rust 1.51.0, Cargo has opt-in support for a new feature resolver which can be activated with resolver = \"2\" in Cargo.toml. Starting in Rust 2021, this will be the default. That is, writing edition = \"2021\" in Cargo.toml will imply resolver = \"2\". The resolver is a global setting for a workspace , and the setting is ignored in dependencies. The setting is only honored for the top-level package of the workspace. If you are using a virtual workspace , you will still need to explicitly set the resolver field in the [workspace] definition if you want to opt-in to the new resolver. The new feature resolver no longer merges all requested features for crates that are depended on in multiple ways. See the announcement of Rust 1.51 for details.","breadcrumbs":"Rust 2021 » Default Cargo feature resolver » Details","id":"55","title":"Details"},"56":{"body":"There are no automated migration tools for updating for the new resolver. For most projects, there are usually few or no changes as a result of updating. When updating with cargo fix --edition, Cargo will display a report if the new resolver will build dependencies with different features. It may look something like this: note: Switching to Edition 2021 will enable the use of the version 2 feature resolver in Cargo. This may cause some dependencies to be built with fewer features enabled than previously. More information about the resolver changes may be found at https://doc.rust-lang.org/nightly/edition-guide/rust-2021/default-cargo-resolver.html When building the following dependencies, the given features will no longer be used: bstr v0.2.16: default, lazy_static, regex-automata, unicode libz-sys v1.1.3 (as host dependency): libc This lets you know that certain dependencies will no longer be built with the given features.","breadcrumbs":"Rust 2021 » Default Cargo feature resolver » Migration","id":"56","title":"Migration"},"57":{"body":"There may be some circumstances where your project may not build correctly after the change. If a dependency declaration in one package assumes that certain features are enabled in another, and those features are now disabled, it may fail to compile. For example, let's say we have a dependency like this: # Cargo.toml [dependencies]\nbstr = { version = \"0.2.16\", default-features = false }\n# ... And somewhere in our dependency tree, another package has this: # Another package's Cargo.toml [build-dependencies]\nbstr = \"0.2.16\" In our package, we've been using the words_with_breaks method from bstr, which requires bstr's \"unicode\" feature to be enabled. This has historically worked because Cargo unified the features of bstr between the two packages. However, after updating to Rust 2021, the new resolver will build bstr twice, once with the default features (as a build dependency), and once with no features (as our normal dependency). Since bstr is now being built without the \"unicode\" feature, the words_with_breaks method doesn't exist, and the build will fail with an error that the method is missing. The solution here is to ensure that the dependency is declared with the features you are actually using. For example: [dependencies]\nbstr = { version = \"0.2.16\", default-features = false, features = [\"unicode\"] } In some cases, this may be a problem with a third-party dependency that you don't have direct control over. You can consider submitting a patch to that project to try to declare the correct set of features for the problematic dependency. Alternatively, you can add features to any dependency from within your own Cargo.toml file. For example, if the bstr example given above was declared in some third-party dependency, you can just copy the correct dependency declaration into your own project. The features will be unified, as long as they match the unification rules of the new resolver. Those are: Features enabled on platform-specific dependencies for targets not currently being built are ignored. Build-dependencies and proc-macros do not share features with normal dependencies. Dev-dependencies do not activate features unless building a target that needs them (like tests or examples). A real-world example is using diesel and diesel_migrations . These packages provide database support, and the database is selected using a feature, like this: [dependencies]\ndiesel = { version = \"1.4.7\", features = [\"postgres\"] }\ndiesel_migrations = \"1.4.0\" The problem is that diesel_migrations has an internal proc-macro which itself depends on diesel, and the proc-macro assumes its own copy of diesel has the same features enabled as the rest of the dependency graph. After updating to the new resolver, it fails to build because now there are two copies of diesel, and the one built for the proc-macro is missing the \"postgres\" feature. A solution here is to add diesel as a build-dependency with the required features, for example: [build-dependencies]\ndiesel = { version = \"1.4.7\", features = [\"postgres\"] } This causes Cargo to add \"postgres\" as a feature for host dependencies (proc-macros and build-dependencies). Now, the diesel_migrations proc-macro will get the \"postgres\" feature enabled, and it will build correctly. The 2.0 release of diesel (currently in development) does not have this problem as it has been restructured to not have this dependency requirement.","breadcrumbs":"Rust 2021 » Default Cargo feature resolver » Build failures","id":"57","title":"Build failures"},"58":{"body":"The cargo tree command has had substantial improvements to help with the migration to the new resolver. cargo tree can be used to explore the dependency graph, and to see which features are being enabled, and importantly why they are being enabled. One option is to use the --duplicates flag (-d for short), which will tell you when a package is being built multiple times. Taking the bstr example from earlier, we might see: > cargo tree -d\nbstr v0.2.16\n└── foo v0.1.0 (/MyProjects/foo) bstr v0.2.16\n[build-dependencies]\n└── bar v0.1.0 └── foo v0.1.0 (/MyProjects/foo) This output tells us that bstr is built twice, and shows the chain of dependencies that led to its inclusion in both cases. You can print which features each package is using with the -f flag, like this: cargo tree -f '{p} {f}' This tells Cargo to change the \"format\" of the output, where it will print both the package and the enabled features. You can also use the -e flag to tell it which \"edges\" to display. For example, cargo tree -e features will show in-between each dependency which features are being added by each dependency. This option becomes more useful with the -i flag which can be used to \"invert\" the tree. This allows you to see how features flow into a given dependency. For example, let's say the dependency graph is large, and we're not quite sure who is depending on bstr, the following command will show that: > cargo tree -e features -i bstr\nbstr v0.2.16\n├── bstr feature \"default\"\n│ [build-dependencies]\n│ └── bar v0.1.0\n│ └── bar feature \"default\"\n│ └── foo v0.1.0 (/MyProjects/foo)\n├── bstr feature \"lazy_static\"\n│ └── bstr feature \"unicode\"\n│ └── bstr feature \"default\" (*)\n├── bstr feature \"regex-automata\"\n│ └── bstr feature \"unicode\" (*)\n├── bstr feature \"std\"\n│ └── bstr feature \"default\" (*)\n└── bstr feature \"unicode\" (*) This snippet of output shows that the project foo depends on bar with the \"default\" feature. Then, bar depends on bstr as a build-dependency with the \"default\" feature. We can further see that bstr's \"default\" feature enables \"unicode\" (among other features).","breadcrumbs":"Rust 2021 » Default Cargo feature resolver » Exploring features","id":"58","title":"Exploring features"},"59":{"body":"","breadcrumbs":"Rust 2021 » IntoIterator for arrays » IntoIterator for arrays","id":"59","title":"IntoIterator for arrays"},"6":{"body":"As an example, let's take a look at transitioning from the 2015 edition to the 2018 edition. The steps are essentially the same when transitioning to other editions like 2021. Imagine we have a crate that has this code in src/lib.rs: trait Foo { fn foo(&self, i32);\n} This code uses an anonymous parameter, that i32. This is not supported in Rust 2018 , and so this would fail to compile. Let's get this code up to date!","breadcrumbs":"What are editions? » Transitioning an existing project to a new edition » Starting the migration","id":"6","title":"Starting the migration"},"60":{"body":"Arrays implement IntoIterator in all editions. Calls to IntoIterator::into_iter are hidden in Rust 2015 and Rust 2018 when using method call syntax (i.e., array.into_iter()). So, array.into_iter() still resolves to (&array).into_iter() as it has before. array.into_iter() changes meaning to be the call to IntoIterator::into_iter in Rust 2021.","breadcrumbs":"Rust 2021 » IntoIterator for arrays » Summary","id":"60","title":"Summary"},"61":{"body":"Until Rust 1.53, only references to arrays implement IntoIterator. This means you can iterate over &[1, 2, 3] and &mut [1, 2, 3], but not over [1, 2, 3] directly. for &e in &[1, 2, 3] {} // Ok :) for e in [1, 2, 3] {} // Error :( This has been a long-standing issue , but the solution is not as simple as it seems. Just adding the trait implementation would break existing code. array.into_iter() already compiles today because that implicitly calls (&array).into_iter() due to how method call syntax works . Adding the trait implementation would change the meaning. Usually this type of breakage (adding a trait implementation) is categorized as 'minor' and acceptable. But in this case there is too much code that would be broken by it. It has been suggested many times to \"only implement IntoIterator for arrays in Rust 2021\". However, this is simply not possible. You can't have a trait implementation exist in one edition and not in another, since editions can be mixed. Instead, the trait implementation was added in all editions (starting in Rust 1.53.0) but with a small hack to avoid breakage until Rust 2021. In Rust 2015 and 2018 code, the compiler will still resolve array.into_iter() to (&array).into_iter() like before, as if the trait implementation does not exist. This only applies to the .into_iter() method call syntax. It does not affect any other syntax such as for e in [1, 2, 3], iter.zip([1, 2, 3]) or IntoIterator::into_iter([1, 2, 3]). Those will start to work in all editions. While it's a shame that this required a small hack to avoid breakage, this solution keeps the difference between the editions to an absolute minimum.","breadcrumbs":"Rust 2021 » IntoIterator for arrays » Details","id":"61","title":"Details"},"62":{"body":"A lint, array_into_iter, gets triggered whenever there is some call to into_iter() that will change meaning in Rust 2021. The array_into_iter lint has already been a warning by default on all editions since the 1.41 release (with several enhancements made in 1.55). If your code is already warning free, then it should already be ready to go for Rust 2021! You can automatically migrate your code to be Rust 2021 Edition compatible or ensure it is already compatible by running: cargo fix --edition Because the difference between editions is small, the migration to Rust 2021 is fairly straight-forward. For method calls of into_iter on arrays, the elements being implemented will change from references to owned values. For example: fn main() { let array = [1u8, 2, 3]; for x in array.into_iter() { // x is a `&u8` in Rust 2015 and Rust 2018 // x is a `u8` in Rust 2021 }\n} The most straightforward way to migrate in Rust 2021, is by keeping the exact behavior from previous editions by calling iter() which also iterates over owned arrays by reference: fn main() { let array = [1u8, 2, 3]; for x in array.iter() { // <- This line changed // x is a `&u8` in all editions }\n}","breadcrumbs":"Rust 2021 » IntoIterator for arrays » Migration","id":"62","title":"Migration"},"63":{"body":"If you are using fully qualified method syntax (i.e., IntoIterator::into_iter(array)) in a previous edition, this can be upgraded to method call syntax (i.e., array.into_iter()).","breadcrumbs":"Rust 2021 » IntoIterator for arrays » Optional migration","id":"63","title":"Optional migration"},"64":{"body":"","breadcrumbs":"Rust 2021 » Disjoint capture in closures » Disjoint capture in closures","id":"64","title":"Disjoint capture in closures"},"65":{"body":"|| a.x + 1 now captures only a.x instead of a. This can cause things to be dropped at different times or affect whether closures implement traits like Send or Clone. If possible changes are detected, cargo fix will insert statements like let _ = &a to force a closure to capture the entire variable.","breadcrumbs":"Rust 2021 » Disjoint capture in closures » Summary","id":"65","title":"Summary"},"66":{"body":"Closures automatically capture anything that you refer to from within their body. For example, || a + 1 automatically captures a reference to a from the surrounding context. In Rust 2018 and before, closures capture entire variables, even if the closure only uses one field. For example, || a.x + 1 captures a reference to a and not just a.x. Capturing a in its entirety prevents mutation or moves from other fields of a, so that code like this does not compile: let a = SomeStruct::new();\ndrop(a.x); // Move out of one field of the struct\nprintln!(\"{}\", a.y); // Ok: Still use another field of the struct\nlet c = || println!(\"{}\", a.y); // Error: Tries to capture all of `a`\nc(); Starting in Rust 2021, closures captures are more precise. Typically they will only capture the fields they use (in some cases, they might capture more than just what they use, see the Rust reference for full details). Therefore, the above example will compile fine in Rust 2021. Disjoint capture was proposed as part of RFC 2229 and the RFC contains details about the motivation.","breadcrumbs":"Rust 2021 » Disjoint capture in closures » Details","id":"66","title":"Details"},"67":{"body":"As a part of the 2021 edition a migration lint, rust_2021_incompatible_closure_captures, has been added in order to aid in automatic migration of Rust 2018 codebases to Rust 2021. In order to have rustfix migrate your code to be Rust 2021 Edition compatible, run: cargo fix --edition Below is an examination of how to manually migrate code to use closure captures that are compatible with Rust 2021 should the automatic migration fail or you would like to better understand how the migration works. Changing the variables captured by a closure can cause programs to change behavior or to stop compiling in two cases: changes to drop order, or when destructors run ( details ); changes to which traits a closure implements ( details ). Whenever any of the scenarios below are detected, cargo fix will insert a \"dummy let\" into your closure to force it to capture the entire variable: let x = (vec![22], vec![23]);\nlet c = move || { // \"Dummy let\" that forces `x` to be captured in its entirety let _ = &x; // Otherwise, only `x.0` would be captured here println!(\"{:?}\", x.0);\n}; This is a conservative analysis: in many cases, these dummy lets can be safely removed and your program will work fine.","breadcrumbs":"Rust 2021 » Disjoint capture in closures » Migration","id":"67","title":"Migration"},"68":{"body":"Closures now only capture data that needs to be read, which means the following closures will not capture x: let x = 10;\nlet c = || { let _ = x; // no-op\n}; let c = || match x { _ => println!(\"Hello World!\")\n}; The let _ = x statement here is a no-op, since the _ pattern completely ignores the right-hand side, and x is a reference to a place in memory (in this case, a variable). This change by itself (capturing fewer values) doesn't trigger any suggestions, but it may do so in conjunction with the \"drop order\" change below. Subtle: There are other similar expressions, such as the \"dummy lets\" let _ = &x that we insert, which are not no-ops. This is because the right-hand side (&x) is not a reference to a place in memory, but rather an expression that must first be evaluated (and whose result is then discarded).","breadcrumbs":"Rust 2021 » Disjoint capture in closures » Wild Card Patterns","id":"68","title":"Wild Card Patterns"},"69":{"body":"When a closure takes ownership of a value from a variable t, that value is then dropped when the closure is dropped, and not when the variable t goes out of scope: # fn move_value<T>(_: T){}\n{ let t = (vec![0], vec![0]); { let c = || move_value(t); // t is moved here } // c is dropped, which drops the tuple `t` as well\n} // t goes out of scope here The above code will run the same in both Rust 2018 and Rust 2021. However, in cases where the closure only takes ownership of part of a variable, there can be differences: # fn move_value<T>(_: T){}\n{ let t = (vec![0], vec![0]); { let c = || { // In Rust 2018, captures all of `t`. // In Rust 2021, captures only `t.0` move_value(t.0); }; // In Rust 2018, `c` (and `t`) are both dropped when we // exit this block. // // In Rust 2021, `c` and `t.0` are both dropped when we // exit this block. } // In Rust 2018, the value from `t` has been moved and is\n// not dropped.\n//\n// In Rust 2021, the value from `t.0` has been moved, but `t.1`\n// remains, so it will be dropped here.\n} In most cases, dropping values at different times just affects when memory is freed and is not important. However, some Drop impls (aka, destructors) have side-effects, and changing the drop order in those cases can alter the semantics of your program. In such cases, the compiler will suggest inserting a dummy let to force the entire variable to be captured.","breadcrumbs":"Rust 2021 » Disjoint capture in closures » Drop Order","id":"69","title":"Drop Order"},"7":{"body":"Your code may or may not use features that are incompatible with the new edition. In order to help transition to the next edition, Cargo includes the cargo fix subcommand to automatically update your source code. To start, let's run it: cargo fix --edition This will check your code, and automatically fix any issues that it can. Let's look at src/lib.rs again: trait Foo { fn foo(&self, _: i32);\n} It's re-written our code to introduce a parameter name for that i32 value. In this case, since it had no name, cargo fix will replace it with _, which is conventional for unused variables. cargo fix can't always fix your code automatically. If cargo fix can't fix something, it will print the warning that it cannot fix to the console. If you see one of these warnings, you'll have to update your code manually. See the Advanced migration strategies chapter for more on working with the migration process, and read the chapters in this guide which explain which changes are needed. If you have problems, please seek help at the user's forums .","breadcrumbs":"What are editions? » Transitioning an existing project to a new edition » Updating your code to be compatible with the new edition","id":"7","title":"Updating your code to be compatible with the new edition"},"70":{"body":"Closures automatically implement the following traits based on what values they capture: Clone : if all captured values are Clone. Auto traits like Send , Sync , and UnwindSafe : if all captured values implement the given trait. In Rust 2021, since different values are being captured, this can affect what traits a closure will implement. The migration lints test each closure to see whether it would have implemented a given trait before and whether it still implements it now; if they find that a trait used to be implemented but no longer is, then \"dummy lets\" are inserted. For instance, a common way to allow passing around raw pointers between threads is to wrap them in a struct and then implement Send/Sync auto trait for the wrapper. The closure that is passed to thread::spawn uses the specific fields within the wrapper but the entire wrapper is captured regardless. Since the wrapper is Send/Sync, the code is considered safe and therefore compiles successfully. With disjoint captures, only the specific field mentioned in the closure gets captured, which wasn't originally Send/Sync defeating the purpose of the wrapper. use std::thread; struct Ptr(*mut i32);\nunsafe impl Send for Ptr {} let mut x = 5;\nlet px = Ptr(&mut x as *mut i32); let c = thread::spawn(move || { unsafe { *(px.0) += 10; }\n}); // Closure captured px.0 which is not Send","breadcrumbs":"Rust 2021 » Disjoint capture in closures » Trait implementations","id":"70","title":"Trait implementations"},"71":{"body":"","breadcrumbs":"Rust 2021 » Panic macro consistency » Panic macro consistency","id":"71","title":"Panic macro consistency"},"72":{"body":"panic!(..) now always uses format_args!(..), just like println!(). panic!(\"{\") is no longer accepted, without escaping the { as {{. panic!(x) is no longer accepted if x is not a string literal. Use std::panic::panic_any(x) to panic with a non-string payload. Or use panic!(\"{}\", x) to use x's Display implementation. The same applies to assert!(expr, ..).","breadcrumbs":"Rust 2021 » Panic macro consistency » Summary","id":"72","title":"Summary"},"73":{"body":"The panic!() macro is one of Rust's most well known macros. However, it has some subtle surprises that we can't just change due to backwards compatibility. // Rust 2018\npanic!(\"{}\", 1); // Ok, panics with the message \"1\"\npanic!(\"{}\"); // Ok, panics with the message \"{}\" The panic!() macro only uses string formatting when it's invoked with more than one argument. When invoked with a single argument, it doesn't even look at that argument. // Rust 2018\nlet a = \"{\";\nprintln!(a); // Error: First argument must be a format string literal\npanic!(a); // Ok: The panic macro doesn't care It even accepts non-strings such as panic!(123), which is uncommon and rarely useful since it produces a surprisingly unhelpful message: panicked at 'Box<Any>'. This will especially be a problem once implicit format arguments are stabilized. That feature will make println!(\"hello {name}\") a short-hand for println!(\"hello {}\", name). However, panic!(\"hello {name}\") would not work as expected, since panic!() doesn't process a single argument as format string. To avoid that confusing situation, Rust 2021 features a more consistent panic!() macro. The new panic!() macro will no longer accept arbitrary expressions as the only argument. It will, just like println!(), always process the first argument as format string. Since panic!() will no longer accept arbitrary payloads, panic_any() will be the only way to panic with something other than a formatted string. // Rust 2021\npanic!(\"{}\", 1); // Ok, panics with the message \"1\"\npanic!(\"{}\"); // Error, missing argument\npanic!(a); // Error, must be a string literal In addition, core::panic!() and std::panic!() will be identical in Rust 2021. Currently, there are some historical differences between those two, which can be noticeable when switching #![no_std] on or off.","breadcrumbs":"Rust 2021 » Panic macro consistency » Details","id":"73","title":"Details"},"74":{"body":"A lint, non_fmt_panics, gets triggered whenever there is some call to panic that uses some deprecated behavior that will error in Rust 2021. The non_fmt_panics lint has already been a warning by default on all editions since the 1.50 release (with several enhancements made in later releases). If your code is already warning free, then it should already be ready to go for Rust 2021! You can automatically migrate your code to be Rust 2021 Edition compatible or ensure it is already compatible by running: cargo fix --edition Should you choose or need to manually migrate, you'll need to update all panic invocations to either use the same formatting as println or use std::panic::panic_any to panic with non-string data. For example, in the case of panic!(MyStruct), you'll need to convert to using std::panic::panic_any (note that this is a function not a macro): std::panic::panic_any(MyStruct). In the case of panic messages that include curly braces but the wrong number of arguments (e.g., panic!(\"Some curlies: {}\")), you can panic with the string literal by either using the same syntax as println! (i.e., panic!(\"{}\", \"Some curlies: {}\")) or by escaping the curly braces (i.e., panic!(\"Some curlies: {{}}\")).","breadcrumbs":"Rust 2021 » Panic macro consistency » Migration","id":"74","title":"Migration"},"75":{"body":"","breadcrumbs":"Rust 2021 » Reserving syntax » Reserving syntax","id":"75","title":"Reserving syntax"},"76":{"body":"any_identifier#, any_identifier\"...\", and any_identifier'...' are now reserved syntax, and no longer tokenize. This is mostly relevant to macros. E.g. quote!{ #a#b } is no longer accepted. It doesn't treat keywords specially, so e.g. match\"...\" {} is no longer accepted. Insert whitespace between the identifier and the subsequent #, \", or ' to avoid errors. Edition migrations will help you insert whitespace in such cases.","breadcrumbs":"Rust 2021 » Reserving syntax » Summary","id":"76","title":"Summary"},"77":{"body":"To make space for new syntax in the future, we've decided to reserve syntax for prefixed identifiers and literals: prefix#identifier, prefix\"string\", prefix'c', and prefix#123, where prefix can be any identifier. (Except those prefixes that already have a meaning, such as b'...' (byte strings) and r\"...\" (raw strings).) This provides syntax we can expand into in the future without requiring an edition boundary. We may use this for temporary syntax until the next edition, or for permanent syntax if appropriate. Without an edition, this would be a breaking change, since macros can currently accept syntax such as hello\"world\", which they will see as two separate tokens: hello and \"world\". The (automatic) fix is simple though: just insert a space: hello \"world\". Likewise, prefix#ident should become prefix #ident. Edition migrations will help with this fix. Other than turning these into a tokenization error, the RFC does not attach a meaning to any prefix yet. Assigning meaning to specific prefixes is left to future proposals, which will now—thanks to reserving these prefixes—not be breaking changes. Some new prefixes you might potentially see in the future (though we haven't committed to any of them yet): k#keyword to allow writing keywords that don't exist yet in the current edition. For example, while async is not a keyword in edition 2015, this prefix would've allowed us to accept k#async in edition 2015 without having to wait for edition 2018 to reserve async as a keyword. f\"\" as a short-hand for a format string. For example, f\"hello {name}\" as a short-hand for the equivalent format!() invocation. s\"\" for String literals. c\"\" or z\"\" for null-terminated C strings.","breadcrumbs":"Rust 2021 » Reserving syntax » Details","id":"77","title":"Details"},"78":{"body":"As a part of the 2021 edition a migration lint, rust_2021_prefixes_incompatible_syntax, has been added in order to aid in automatic migration of Rust 2018 codebases to Rust 2021. In order to have rustfix migrate your code to be Rust 2021 Edition compatible, run: cargo fix --edition Should you want or need to manually migrate your code, migration is fairly straight-forward. Let's say you have a macro that is defined like so: macro_rules! my_macro { ($a:tt $b:tt) => {};\n} In Rust 2015 and 2018 it's legal for this macro to be called like so with no space between the first token tree and the second: my_macro!(z\"hey\"); This z prefix is no longer allowed in Rust 2021, so in order to call this macro, you must add a space after the prefix like so: my_macro!(z \"hey\");","breadcrumbs":"Rust 2021 » Reserving syntax » Migration","id":"78","title":"Migration"},"79":{"body":"","breadcrumbs":"Rust 2021 » Warnings promoted to errors » Warnings promoted to errors","id":"79","title":"Warnings promoted to errors"},"8":{"body":"In order to use some new features, you must explicitly opt in to the new edition. Once you're ready to continue, change your Cargo.toml to add the new edition key/value pair. For example: [package]\nname = \"foo\"\nversion = \"0.1.0\"\nedition = \"2018\" If there's no edition key, Cargo will default to Rust 2015. But in this case, we've chosen 2018, and so our code will compile with Rust 2018! The next step is to test your project on the new edition. Run your project tests to verify that everything still works, such as running cargo test . If new warnings are issued, you may want to consider running cargo fix again (without the --edition flag) to apply any suggestions given by the compiler. Congrats! Your code is now valid in both Rust 2015 and Rust 2018!","breadcrumbs":"What are editions? » Transitioning an existing project to a new edition » Enabling the new edition to use new features","id":"8","title":"Enabling the new edition to use new features"},"80":{"body":"Code that triggered the bare_trait_objects and ellipsis_inclusive_range_patterns lints will error in Rust 2021.","breadcrumbs":"Rust 2021 » Warnings promoted to errors » Summary","id":"80","title":"Summary"},"81":{"body":"Two existing lints are becoming hard errors in Rust 2021, but these lints will remain warnings in older editions.","breadcrumbs":"Rust 2021 » Warnings promoted to errors » Details","id":"81","title":"Details"},"82":{"body":"The use of the dyn keyword to identify trait objects will be mandatory in Rust 2021. For example, the following code which does not include the dyn keyword in &MyTrait will produce an error instead of just a lint in Rust 2021: pub trait MyTrait {} pub fn my_function(_trait_object: &MyTrait) { // should be `&dyn MyTrait` unimplemented!()\n}","breadcrumbs":"Rust 2021 » Warnings promoted to errors » bare_trait_objects:","id":"82","title":"bare_trait_objects:"},"83":{"body":"The deprecated ... syntax for inclusive range patterns (i.e., ranges where the end value is included in the range) is no longer accepted in Rust 2021. It has been superseded by ..=, which is consistent with expressions. For example, the following code which uses ... in a pattern will produce an error instead of just a lint in Rust 2021: pub fn less_or_eq_to_100(n: u8) -> bool { matches!(n, 0...100) // should be `0..=100`\n}","breadcrumbs":"Rust 2021 » Warnings promoted to errors » ellipsis_inclusive_range_patterns:","id":"83","title":"ellipsis_inclusive_range_patterns:"},"84":{"body":"If your Rust 2015 or 2018 code does not produce any warnings for bare_trait_objects or ellipsis_inclusive_range_patterns and you've not allowed these lints through the use of #![allow()] or some other mechanism, then there's no need to migrate. To automatically migrate any crate that uses ... in patterns or does not use dyn with trait objects, you can run cargo fix --edition.","breadcrumbs":"Rust 2021 » Warnings promoted to errors » Migrations","id":"84","title":"Migrations"},"85":{"body":"","breadcrumbs":"Rust 2021 » Or patterns in macro-rules » Or patterns in macro-rules","id":"85","title":"Or patterns in macro-rules"},"86":{"body":"How patterns work in macro_rules macros changes slightly: $_:pat in macro_rules now matches usage of | too: e.g. A | B. The new $_:pat_param behaves like $_:pat did before; it does not match (top level) |. $_:pat_param is available in all editions.","breadcrumbs":"Rust 2021 » Or patterns in macro-rules » Summary","id":"86","title":"Summary"},"87":{"body":"Starting in Rust 1.53.0, patterns are extended to support | nested anywhere in the pattern. This enables you to write Some(1 | 2) instead of Some(1) | Some(2). Since this was simply not allowed before, this is not a breaking change. However, this change also affects macro_rules macros . Such macros can accept patterns using the :pat fragment specifier. Currently, :pat does not match top level |, since before Rust 1.53, not all patterns (at all nested levels) could contain a |. Macros that accept patterns like A | B, such as matches!() use something like $($_:pat)|+. Because this would potentially break existing macros, the meaning of :pat did not change in Rust 1.53.0 to include |. Instead, that change happens in Rust 2021. In the new edition, the :pat fragment specifier will match A | B. $_:pat fragments in Rust 2021 cannot be followed by an explicit |. Since there are times that one still wishes to match pattern fragments followed by a |, the fragment specified :pat_param has been added to retain the older behavior. It's important to remember that editions are per crate , so the only relevant edition is the edition of the crate where the macro is defined. The edition of the crate where the macro is used does not change how the macro works.","breadcrumbs":"Rust 2021 » Or patterns in macro-rules » Details","id":"87","title":"Details"},"88":{"body":"A lint, rust_2021_incompatible_or_patterns, gets triggered whenever there is a use $_:pat which will change meaning in Rust 2021. You can automatically migrate your code to be Rust 2021 Edition compatible or ensure it is already compatible by running: cargo fix --edition If you have a macro which relies on $_:pat not matching the top level use of | in patterns, you'll need to change each occurrence of $_:pat to $_:pat_param. For example: macro_rules! my_macro { ($x:pat | $y:pat) => { // TODO: implementation } } // This macro works in Rust 2018 since `$x:pat` does not match against `|`:\nmy_macro!(1 | 2); // In Rust 2021 however, the `$_:pat` fragment matches `|` and is not allowed\n// to be followed by a `|`. To make sure this macro still works in Rust 2021\n// change the macro to the following:\nmacro_rules! my_macro { ($x:pat_param | $y:pat) => { // <- this line is different // TODO: implementation } }","breadcrumbs":"Rust 2021 » Or patterns in macro-rules » Migration","id":"88","title":"Migration"},"9":{"body":"","breadcrumbs":"What are editions? » Advanced migrations » Advanced migration strategies","id":"9","title":"Advanced migration strategies"}},"length":89,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{".":{".":{"1":{"0":{"0":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"1":{"0":{"0":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"1":{"6":{"df":1,"docs":{"57":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"20":{"tf":2.23606797749979}}},"2":{"7":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"3":{"1":{".":{"0":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"22":{"tf":1.0},"31":{"tf":1.0}}},"2":{"df":1,"docs":{"30":{"tf":1.0}}},"9":{".":{"0":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"0":{"df":1,"docs":{"57":{"tf":1.0}}},"7":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"1":{"df":2,"docs":{"26":{"tf":1.0},"62":{"tf":1.0}}},"2":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"5":{"0":{"df":1,"docs":{"74":{"tf":1.0}}},"1":{".":{"0":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"55":{"tf":1.0}}},"3":{".":{"0":{"df":2,"docs":{"61":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":2,"docs":{"61":{"tf":1.0},"87":{"tf":1.0}}},"5":{"df":1,"docs":{"62":{"tf":1.0}}},"6":{".":{"0":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":2,"docs":{"68":{"tf":1.0},"70":{"tf":1.0}}},"6":{"8":{"5":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"1":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"61":{"tf":2.449489742783178},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"73":{"tf":2.0}},"u":{"8":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"2":{".":{"0":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"0":{"1":{"5":{"df":19,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":3.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"33":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"7":{"df":1,"docs":{"20":{"tf":1.0}}},"8":{"df":29,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"24":{"tf":1.0},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":2.23606797749979},"33":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":2.0},"73":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":2.0},"84":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":31,"docs":{"10":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"4":{"tf":1.7320508075688772},"45":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.7320508075688772},"5":{"tf":1.0},"50":{"tf":1.7320508075688772},"52":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":2.449489742783178},"66":{"tf":1.4142135623730951},"67":{"tf":2.0},"69":{"tf":2.0},"70":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772},"78":{"tf":2.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":2.0}}},"df":0,"docs":{}},"5":{"2":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"2":{"9":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"61":{"tf":2.8284271247461903},"62":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0}}},"3":{"0":{"8":{"5":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"61":{"tf":2.8284271247461903},"62":{"tf":1.4142135623730951}}},"4":{"6":{"9":{"0":{"6":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"70":{"tf":1.0}}},"9":{"9":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"_":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"86":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":3,"docs":{"86":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":2.0}}}},"df":0,"docs":{}}},"df":5,"docs":{"33":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":2.23606797749979},"7":{"tf":1.4142135623730951}}},"a":{"#":{"b":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"x":{"df":2,"docs":{"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}},":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":7,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"50":{"tf":1.4142135623730951},"57":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":8,"docs":{"26":{"tf":1.0},"61":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"83":{"tf":1.0},"87":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"55":{"tf":1.0},"57":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":6,"docs":{"13":{"tf":1.0},"26":{"tf":1.7320508075688772},"4":{"tf":1.0},"57":{"tf":1.7320508075688772},"78":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"3":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.0},"73":{"tf":1.0}}}}},"df":9,"docs":{"13":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":2.0},"67":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":3,"docs":{"12":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"52":{"tf":1.4142135623730951},"61":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.0},"88":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"d":{"df":3,"docs":{"49":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}},"k":{"a":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"26":{"tf":2.0}}},"df":0,"docs":{},"w":{"df":12,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"33":{"tf":1.4142135623730951},"44":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"70":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"84":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"49":{"tf":1.0},"5":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":6,"docs":{"26":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":2.0},"74":{"tf":2.0},"77":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}},"n":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"57":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":7,"docs":{"1":{"tf":1.0},"27":{"tf":1.4142135623730951},"30":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":5,"docs":{"30":{"tf":1.0},"37":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":2.0}}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}},"z":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":3,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"6":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":1.0},"57":{"tf":1.7320508075688772},"61":{"tf":1.0},"66":{"tf":1.0}}}}},"y":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"3":{"tf":1.0},"66":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"4":{"tf":1.0}}},"df":7,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":2.0},"61":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"18":{"tf":1.0},"26":{"tf":1.0},"77":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"24":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"33":{"tf":1.0},"73":{"tf":3.0},"74":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"21":{"tf":1.0},"30":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":4,"docs":{"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":2.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":5,"docs":{"1":{"tf":1.7320508075688772},"3":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"18":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"52":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"56":{"tf":1.0},"58":{"tf":1.0}}},"df":20,"docs":{"13":{"tf":1.0},"14":{"tf":2.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"26":{"tf":2.0},"4":{"tf":1.0},"44":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}}},"df":6,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":2.0},"56":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"11":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"86":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"3":{"tf":1.0},"30":{"tf":1.0},"61":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.4142135623730951}}}},"r":{"df":1,"docs":{"3":{"tf":1.0}}},"y":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"50":{"tf":1.0}}}},".":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},":":{":":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.7320508075688772},"58":{"tf":2.23606797749979}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"80":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.0}}},"i":{"df":1,"docs":{"20":{"tf":1.0}}}},"z":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"33":{"tf":1.0}}}},"df":3,"docs":{"77":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":5,"docs":{"37":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"58":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0}}}}},"df":6,"docs":{"15":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":2.0},"62":{"tf":1.0},"70":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":9,"docs":{"10":{"tf":1.0},"26":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"86":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"62":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"49":{"tf":1.0},"67":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":9,"docs":{"11":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"4":{"tf":1.0}}}}},"df":1,"docs":{"12":{"tf":1.0}}},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"39":{"tf":1.0},"69":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"32":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"50":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"x":{"<":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}},"df":5,"docs":{"48":{"tf":1.7320508075688772},"52":{"tf":1.0},"61":{"tf":1.0},"77":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"24":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"45":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"1":{"tf":1.0},"13":{"tf":2.0},"19":{"tf":1.0},"61":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"'":{"df":2,"docs":{"57":{"tf":1.0},"58":{"tf":1.0}}},"df":3,"docs":{"56":{"tf":1.0},"57":{"tf":2.8284271247461903},"58":{"tf":4.123105625617661}}}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"19":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"l":{"d":{"df":9,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":3.605551275463989},"58":{"tf":1.7320508075688772}}},"df":0,"docs":{},"t":{"df":3,"docs":{"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":13,"docs":{"14":{"tf":1.0},"15":{"tf":2.23606797749979},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"50":{"tf":2.23606797749979},"52":{"tf":2.6457513110645907},"60":{"tf":1.7320508075688772},"61":{"tf":1.7320508075688772},"62":{"tf":1.7320508075688772},"63":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"52":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.4142135623730951},"73":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":3.1622776601683795},"67":{"tf":2.23606797749979},"68":{"tf":1.7320508075688772},"69":{"tf":1.7320508075688772},"70":{"tf":2.8284271247461903}}}}}},"r":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"73":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":11,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.0},"26":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}}}},"df":30,"docs":{"1":{"tf":1.0},"10":{"tf":3.0},"11":{"tf":2.449489742783178},"12":{"tf":2.23606797749979},"13":{"tf":2.23606797749979},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"19":{"tf":1.7320508075688772},"26":{"tf":2.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":1.7320508075688772},"53":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":2.0},"57":{"tf":1.4142135623730951},"58":{"tf":2.6457513110645907},"62":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951},"7":{"tf":2.449489742783178},"74":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.7320508075688772},"84":{"tf":1.0},"88":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":17,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":2.0},"52":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":2.0},"7":{"tf":1.0},"74":{"tf":1.4142135623730951},"76":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":1,"docs":{"4":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":7,"docs":{"24":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0}}}}},"df":6,"docs":{"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":2.23606797749979},"70":{"tf":1.0},"77":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"56":{"tf":1.0},"57":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"11":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"58":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":35,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"10":{"tf":2.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"26":{"tf":1.7320508075688772},"3":{"tf":2.449489742783178},"4":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.7320508075688772},"65":{"tf":1.0},"67":{"tf":2.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.4142135623730951},"8":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":2.23606797749979},"88":{"tf":1.7320508075688772}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"45":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"10":{"tf":2.0},"18":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"74":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"1":{"tf":1.0},"50":{"tf":1.0},"8":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"28":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"28":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"57":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.0},"50":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"18":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"48":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"64":{"tf":1.0},"65":{"tf":1.4142135623730951},"66":{"tf":2.0},"67":{"tf":2.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"70":{"tf":2.449489742783178}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":4,"docs":{"49":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":39,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":2.449489742783178},"11":{"tf":2.23606797749979},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":2.23606797749979},"18":{"tf":1.7320508075688772},"19":{"tf":2.23606797749979},"2":{"tf":1.0},"20":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":2.23606797749979},"37":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.7320508075688772},"61":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":2.6457513110645907},"70":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"52":{"tf":1.7320508075688772}}}}}},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"15":{"tf":1.0},"48":{"tf":1.4142135623730951}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"13":{"tf":1.0},"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"77":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}},"t":{"df":17,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"3":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":18,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"57":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"30":{"tf":1.0},"68":{"tf":1.0}}},"x":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"1":{"tf":1.0},"11":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"30":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"24":{"tf":1.0},"37":{"tf":1.0},"73":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"24":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"67":{"tf":1.0}}}}},"i":{"d":{"df":4,"docs":{"5":{"tf":1.0},"57":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"24":{"tf":1.0},"45":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"83":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.7320508075688772},"66":{"tf":1.0},"87":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"19":{"tf":1.0},"49":{"tf":1.0},"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"14":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"1":{"tf":1.0},"26":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"3":{"tf":1.0},"57":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"14":{"tf":1.0},"57":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"24":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"3":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":18,"docs":{"1":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":2.449489742783178},"15":{"tf":2.23606797749979},"19":{"tf":2.23606797749979},"2":{"tf":2.0},"23":{"tf":1.4142135623730951},"24":{"tf":2.23606797749979},"26":{"tf":5.291502622129181},"27":{"tf":3.0},"28":{"tf":2.8284271247461903},"3":{"tf":1.0},"30":{"tf":2.6457513110645907},"48":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"74":{"tf":2.23606797749979}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"10":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"37":{"tf":1.0},"44":{"tf":1.4142135623730951},"48":{"tf":1.0},"57":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.4142135623730951},"87":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":3,"docs":{"51":{"tf":1.7320508075688772},"68":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":1,"docs":{"58":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"37":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.7320508075688772},"33":{"tf":1.0},"57":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":11,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"20":{"tf":1.4142135623730951},"53":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":2.6457513110645907},"62":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"24":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"55":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"4":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"57":{"tf":5.0990195135927845},"58":{"tf":3.4641016151377544}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":3,"docs":{"31":{"tf":1.0},"74":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"52":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":3,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"67":{"tf":1.0},"69":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":16,"docs":{"24":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":1.4142135623730951},"45":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.4142135623730951},"61":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.0},"49":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},"v":{"df":1,"docs":{"57":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"20":{"tf":1.0},"57":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":2.0}}}}}}},"df":1,"docs":{"57":{"tf":2.8284271247461903}}}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"11":{"tf":2.0},"19":{"tf":1.0},"30":{"tf":1.4142135623730951},"56":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"5":{"tf":1.0}},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"df":1,"docs":{"5":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"28":{"tf":1.0},"61":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"18":{"tf":1.0},"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"44":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"14":{"tf":1.0}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"64":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"40":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"45":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.7320508075688772}}}}}}}},"df":2,"docs":{"26":{"tf":1.4142135623730951},"49":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.7320508075688772},"76":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"11":{"tf":1.0},"20":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{"a":{".":{"df":0,"docs":{},"x":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"48":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":3.4641016151377544}}}}},"u":{"df":0,"docs":{},"e":{"df":4,"docs":{"14":{"tf":1.0},"52":{"tf":1.4142135623730951},"61":{"tf":1.0},"73":{"tf":1.0}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":4,"docs":{"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":8,"docs":{"14":{"tf":2.0},"15":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":2.449489742783178},"50":{"tf":2.0},"52":{"tf":1.0},"82":{"tf":1.7320508075688772},"84":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":4,"docs":{"52":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.4142135623730951},"86":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"45":{"tf":1.0},"58":{"tf":1.7320508075688772},"70":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"12":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"58":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":43,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":2.6457513110645907},"10":{"tf":2.6457513110645907},"12":{"tf":2.0},"13":{"tf":1.7320508075688772},"14":{"tf":2.6457513110645907},"15":{"tf":3.0},"16":{"tf":2.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":2.449489742783178},"2":{"tf":2.8284271247461903},"20":{"tf":2.23606797749979},"21":{"tf":2.23606797749979},"24":{"tf":1.0},"3":{"tf":2.6457513110645907},"33":{"tf":1.4142135623730951},"37":{"tf":1.0},"4":{"tf":2.23606797749979},"45":{"tf":1.0},"49":{"tf":1.7320508075688772},"5":{"tf":3.3166247903554},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":2.23606797749979},"62":{"tf":2.449489742783178},"63":{"tf":1.0},"67":{"tf":1.7320508075688772},"7":{"tf":2.0},"74":{"tf":1.7320508075688772},"76":{"tf":1.0},"77":{"tf":2.8284271247461903},"78":{"tf":1.7320508075688772},"8":{"tf":2.6457513110645907},"81":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":2.23606797749979},"88":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"8":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"13":{"tf":1.0},"18":{"tf":1.4142135623730951},"29":{"tf":1.0}}}}}}},"df":2,"docs":{"58":{"tf":1.7320508075688772},"61":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"80":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":2.23606797749979},"58":{"tf":2.0},"8":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"5":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":3,"docs":{"17":{"tf":1.0},"24":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"62":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":10,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"57":{"tf":1.0},"62":{"tf":1.0},"74":{"tf":1.0},"88":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":7,"docs":{"12":{"tf":1.0},"28":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"66":{"tf":1.0},"67":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":17,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"72":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":9,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"16":{"tf":1.0},"30":{"tf":1.0},"48":{"tf":1.0},"8":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":30,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":2.0},"19":{"tf":1.0},"26":{"tf":1.7320508075688772},"3":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.0},"48":{"tf":2.23606797749979},"49":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"57":{"tf":2.6457513110645907},"58":{"tf":1.7320508075688772},"6":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.7320508075688772},"74":{"tf":1.0},"77":{"tf":1.4142135623730951},"8":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.0},"26":{"tf":1.4142135623730951},"30":{"tf":1.0},"48":{"tf":1.0},"77":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":9,"docs":{"1":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.7320508075688772},"77":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.0}}}},"t":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"15":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"37":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"87":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"1":{"tf":1.0},"26":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"55":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"26":{"tf":1.0},"68":{"tf":1.4142135623730951},"73":{"tf":1.0},"83":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"18":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"=":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":8,"docs":{"15":{"tf":1.0},"19":{"tf":2.23606797749979},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":3.605551275463989},"27":{"tf":1.7320508075688772},"28":{"tf":2.0},"30":{"tf":2.23606797749979}}}}}}}},"f":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}},")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":9,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"57":{"tf":1.7320508075688772},"6":{"tf":1.0},"67":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"62":{"tf":1.0},"78":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":3,"docs":{"26":{"tf":1.7320508075688772},"58":{"tf":1.7320508075688772},"77":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":16,"docs":{"1":{"tf":1.7320508075688772},"11":{"tf":2.449489742783178},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":2.23606797749979},"57":{"tf":5.0},"58":{"tf":4.69041575982343},"7":{"tf":1.0},"73":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}},"w":{"df":3,"docs":{"19":{"tf":1.0},"24":{"tf":1.0},"56":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"56":{"tf":1.0},"68":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"44":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":2.23606797749979},"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"29":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":3,"docs":{"15":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}},"x":{"df":25,"docs":{"10":{"tf":3.0},"11":{"tf":2.23606797749979},"12":{"tf":1.4142135623730951},"13":{"tf":3.1622776601683795},"14":{"tf":2.449489742783178},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":2.0},"26":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"56":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951},"7":{"tf":3.0},"74":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":7,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.7320508075688772},"58":{"tf":2.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"58":{"tf":1.0}}}}},"n":{"df":13,"docs":{"26":{"tf":1.4142135623730951},"28":{"tf":2.0},"30":{"tf":2.449489742783178},"33":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"50":{"tf":2.449489742783178},"51":{"tf":1.4142135623730951},"6":{"tf":1.0},"62":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":13,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951},"45":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}}}},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"33":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.0},"29":{"tf":2.23606797749979}}}},"/":{"b":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.0},"30":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":12,"docs":{"14":{"tf":2.0},"24":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":2.23606797749979},"30":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"4":{"tf":2.0},"58":{"tf":2.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"r":{"c":{"df":4,"docs":{"18":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}},"df":4,"docs":{"58":{"tf":1.0},"73":{"tf":2.449489742783178},"74":{"tf":1.0},"77":{"tf":1.4142135623730951}}}},"df":1,"docs":{"44":{"tf":1.0}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"7":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"62":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":3,"docs":{"48":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"87":{"tf":2.23606797749979},"88":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":2,"docs":{"62":{"tf":1.0},"74":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"50":{"tf":1.4142135623730951},"51":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"_":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}},"x":{"df":1,"docs":{"50":{"tf":1.0}}}},"<":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"47":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}},"i":{"df":4,"docs":{"14":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"63":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"30":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"1":{"df":1,"docs":{"37":{"tf":1.0}}},"2":{"df":1,"docs":{"37":{"tf":1.0}}},"df":6,"docs":{"18":{"tf":1.0},"28":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"74":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"58":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"1":{"tf":1.0},"26":{"tf":2.0},"30":{"tf":1.0},"45":{"tf":1.0},"77":{"tf":2.0}},"e":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"17":{"tf":2.0},"2":{"tf":1.0},"26":{"tf":1.0}}}}},"t":{"df":5,"docs":{"15":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"88":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"3":{"tf":1.0}},"n":{"df":8,"docs":{"26":{"tf":1.0},"33":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"70":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":4,"docs":{"13":{"tf":1.0},"24":{"tf":1.0},"62":{"tf":1.0},"74":{"tf":1.0}},"e":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"57":{"tf":1.0},"58":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}}},"df":4,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":1.0},"3":{"tf":1.7320508075688772},"7":{"tf":1.0}},"e":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"68":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.4142135623730951}},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"26":{"tf":1.0},"87":{"tf":1.0}}}}}},"r":{"d":{"df":3,"docs":{"3":{"tf":1.0},"41":{"tf":1.0},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"12":{"tf":1.0},"29":{"tf":1.0},"77":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"77":{"tf":1.4142135623730951}}}},"p":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"58":{"tf":1.0},"7":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"24":{"tf":1.0}}},"df":9,"docs":{"18":{"tf":1.0},"26":{"tf":1.0},"37":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.7320508075688772}}}},"y":{"df":1,"docs":{"78":{"tf":1.0}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"57":{"tf":1.0},"73":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"57":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.0},"15":{"tf":1.4142135623730951}}}}}}}},"i":{".":{"df":5,"docs":{"52":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"3":{"2":{"df":4,"docs":{"37":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"d":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"48":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":6,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"3":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}},"df":1,"docs":{"19":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"55":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":4,"docs":{"37":{"tf":2.23606797749979},"51":{"tf":1.7320508075688772},"69":{"tf":1.0},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"38":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":2.8284271247461903},"62":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":2.8284271247461903},"72":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"30":{"tf":1.0},"61":{"tf":1.0}}}}}}},"df":3,"docs":{"2":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":8,"docs":{"14":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":2.8284271247461903},"28":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"52":{"tf":1.0},"69":{"tf":1.0},"87":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":12,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"58":{"tf":1.0},"83":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"40":{"tf":1.0},"44":{"tf":1.0}}}},"o":{"df":2,"docs":{"21":{"tf":1.0},"45":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"50":{"tf":1.0},"51":{"tf":1.7320508075688772},"52":{"tf":2.0}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"65":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"15":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.7320508075688772}}},"n":{"c":{"df":3,"docs":{"27":{"tf":1.4142135623730951},"51":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":6,"docs":{"29":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"19":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"18":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"57":{"tf":1.0}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"61":{"tf":1.0},"62":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"(":{"[":{"1":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":3,"docs":{"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0},"52":{"tf":1.0},"7":{"tf":1.0}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"o":{"c":{"df":2,"docs":{"74":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":2,"docs":{"50":{"tf":1.0},"73":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":10,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"'":{"df":11,"docs":{"20":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"61":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"19":{"tf":1.0},"26":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951}}},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{"[":{"1":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":3,"docs":{"10":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"57":{"tf":1.0},"68":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"k":{"#":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"13":{"tf":1.0},"26":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0}}}},"y":{"/":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":2,"docs":{"4":{"tf":1.0},"8":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":12,"docs":{"1":{"tf":2.0},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":2.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"15":{"tf":1.0},"56":{"tf":1.0}},"n":{"df":2,"docs":{"19":{"tf":1.0},"73":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"19":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"20":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"58":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}},"r":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"74":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"20":{"tf":1.0},"3":{"tf":1.0}}}}},"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"g":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"1":{"0":{"0":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"'":{"df":7,"docs":{"15":{"tf":1.0},"25":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"78":{"tf":1.0}}},"df":4,"docs":{"56":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":5,"docs":{"30":{"tf":1.4142135623730951},"55":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"18":{"tf":1.7320508075688772},"26":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}},"df":0,"docs":{}},"z":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":5,"docs":{"19":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"62":{"tf":1.0},"88":{"tf":1.0}}},"k":{"df":1,"docs":{"18":{"tf":1.0}}},"t":{"df":18,"docs":{"10":{"tf":2.449489742783178},"13":{"tf":2.23606797749979},"18":{"tf":2.0},"19":{"tf":1.7320508075688772},"41":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"67":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"19":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"77":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"50":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"33":{"tf":1.0},"44":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"70":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"78":{"tf":1.0},"83":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":7,"docs":{"15":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"56":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0}}}},"t":{"df":2,"docs":{"12":{"tf":1.0},"48":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"14":{"tf":1.0}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"78":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":14,"docs":{"14":{"tf":3.605551275463989},"15":{"tf":3.0},"26":{"tf":2.0},"57":{"tf":2.449489742783178},"71":{"tf":1.0},"73":{"tf":2.449489742783178},"74":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.7320508075688772},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":2.6457513110645907},"88":{"tf":2.0}}}}},"d":{"df":0,"docs":{},"e":{"df":5,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"20":{"tf":1.4142135623730951},"62":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":15,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"12":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"24":{"tf":1.0},"3":{"tf":1.7320508075688772},"30":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.0},"88":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":5,"docs":{"18":{"tf":1.0},"24":{"tf":1.0},"51":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":15,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"3":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"df":3,"docs":{"15":{"tf":1.4142135623730951},"20":{"tf":1.0},"26":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":7,"docs":{"30":{"tf":1.7320508075688772},"57":{"tf":1.0},"68":{"tf":1.0},"76":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":2.0},"88":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{"!":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"y":{"b":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":8,"docs":{"1":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"68":{"tf":1.0},"77":{"tf":1.7320508075688772},"87":{"tf":1.0},"88":{"tf":1.0}},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"18":{"tf":1.0},"73":{"tf":2.0},"74":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":12,"docs":{"33":{"tf":1.0},"40":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":4.123105625617661},"51":{"tf":2.449489742783178},"52":{"tf":3.4641016151377544},"57":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":31,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":2.449489742783178},"11":{"tf":2.0},"12":{"tf":2.6457513110645907},"13":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"18":{"tf":2.0},"2":{"tf":1.0},"3":{"tf":2.23606797749979},"45":{"tf":1.0},"49":{"tf":2.449489742783178},"5":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":2.0},"63":{"tf":1.0},"67":{"tf":2.6457513110645907},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"74":{"tf":1.7320508075688772},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":2.449489742783178},"84":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"22":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"61":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"13":{"tf":1.0},"3":{"tf":1.0},"61":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"57":{"tf":1.4142135623730951},"73":{"tf":1.0}}}},"x":{"df":1,"docs":{"61":{"tf":1.0}}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.0},"29":{"tf":2.0}}}},"df":5,"docs":{"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":2.0},"50":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":9,"docs":{"21":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":2.23606797749979},"48":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":15,"docs":{"12":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.4142135623730951},"4":{"tf":1.0},"45":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"76":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"24":{"tf":1.0},"36":{"tf":1.0},"66":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{".":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"69":{"tf":1.0}}}},"<":{"df":0,"docs":{},"t":{">":{"(":{"_":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":5,"docs":{"11":{"tf":1.0},"30":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.7320508075688772}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"37":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"14":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":4,"docs":{"37":{"tf":1.4142135623730951},"52":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"!":{"(":{"1":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{},"z":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"78":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"58":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":2.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"(":{")":{">":{">":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"50":{"tf":2.23606797749979},"82":{"tf":2.0}}}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":20,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":2.0},"3":{"tf":1.0},"30":{"tf":2.23606797749979},"33":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":2.23606797749979},"51":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"77":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{";":{"&":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"19":{"tf":1.0},"26":{"tf":1.4142135623730951},"3":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":23,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":3.0},"30":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":1.7320508075688772},"78":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"20":{"tf":1.0}}}}},"w":{"df":26,"docs":{"1":{"tf":2.23606797749979},"10":{"tf":1.4142135623730951},"16":{"tf":1.0},"19":{"tf":1.7320508075688772},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.7320508075688772},"34":{"tf":1.0},"37":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"58":{"tf":1.0},"7":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.4142135623730951},"8":{"tf":2.6457513110645907},"86":{"tf":1.0},"87":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":2.0},"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"5":{"tf":2.0},"7":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"73":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":4,"docs":{"18":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":3,"docs":{"26":{"tf":1.0},"56":{"tf":1.0},"74":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":20,"docs":{"15":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":2.0},"65":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0},"86":{"tf":1.0}},"—":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"77":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"74":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"37":{"tf":2.0},"50":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"52":{"tf":1.0}},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":3,"docs":{"61":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":2.0}}},"l":{"d":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"37":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"26":{"tf":1.0},"4":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":5,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"57":{"tf":1.4142135623730951},"73":{"tf":1.0},"8":{"tf":1.0}}},"df":20,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":2.0},"30":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"p":{"df":1,"docs":{"68":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"29":{"tf":1.0},"45":{"tf":1.0}}}},"t":{"df":3,"docs":{"1":{"tf":1.0},"55":{"tf":1.4142135623730951},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"a":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":9,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"50":{"tf":1.0},"58":{"tf":1.4142135623730951},"63":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"49":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"78":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":1.0},"52":{"tf":1.0},"70":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"50":{"tf":1.0},"67":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"19":{"tf":1.0},"37":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}},"v":{"df":1,"docs":{"19":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.7320508075688772}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":8,"docs":{"1":{"tf":1.0},"19":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"57":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":7,"docs":{"12":{"tf":2.0},"4":{"tf":2.0},"44":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":2.23606797749979},"58":{"tf":1.7320508075688772},"8":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}}}}},"1":{"2":{"3":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"x":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}},"df":0,"docs":{}},"df":4,"docs":{"71":{"tf":1.0},"72":{"tf":2.0},"73":{"tf":3.872983346207417},"74":{"tf":2.449489742783178}},"k":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}},"t":{"df":9,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"3":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":1,"docs":{"57":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"16":{"tf":1.0},"26":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}}}},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"87":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":1,"docs":{"87":{"tf":2.0}},"h":{"df":8,"docs":{"22":{"tf":1.0},"23":{"tf":2.23606797749979},"24":{"tf":2.0},"28":{"tf":1.4142135623730951},"30":{"tf":3.4641016151377544},"44":{"tf":1.7320508075688772},"50":{"tf":1.0},"52":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":8,"docs":{"32":{"tf":1.0},"68":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":2.449489742783178},"88":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"72":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"58":{"tf":1.0}},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"20":{"tf":1.0},"24":{"tf":1.0}}}}},"r":{"df":2,"docs":{"1":{"tf":1.0},"87":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"24":{"tf":1.0},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.0},"57":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"3":{"tf":1.0},"40":{"tf":1.0},"70":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"5":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":2.23606797749979}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"77":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"37":{"tf":1.0},"4":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"#":{"1":{"2":{"3":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"77":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"'":{"c":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"27":{"tf":1.4142135623730951},"77":{"tf":2.8284271247461903},"78":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"—":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":6,"docs":{"26":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":2.449489742783178},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"20":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0}},"s":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"56":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"7":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":2,"docs":{"68":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"a":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}},"i":{"df":1,"docs":{"52":{"tf":2.0}}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":10,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"3":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.7320508075688772},"7":{"tf":1.0},"73":{"tf":1.0}}}}}},"c":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"14":{"tf":1.4142135623730951},"26":{"tf":1.0},"57":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":4,"docs":{"73":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"19":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":13,"docs":{"10":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.0},"26":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"21":{"tf":1.0},"66":{"tf":1.0},"77":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"3":{"tf":1.0},"57":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"70":{"tf":1.0}}}},"u":{"b":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":5,"docs":{"30":{"tf":1.7320508075688772},"48":{"tf":1.0},"50":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"x":{".":{"0":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"70":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"63":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"13":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"58":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"r":{"#":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":1,"docs":{"83":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"16":{"tf":1.0},"73":{"tf":1.0}}}},"w":{"df":4,"docs":{"3":{"tf":1.0},"40":{"tf":1.0},"70":{"tf":1.0},"77":{"tf":1.0}}}},"df":1,"docs":{"77":{"tf":1.0}},"e":{"a":{"d":{"df":5,"docs":{"14":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":3,"docs":{"62":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"20":{"tf":1.0},"48":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"50":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"11":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"26":{"tf":1.0},"7":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"24":{"tf":1.4142135623730951},"27":{"tf":2.449489742783178},"3":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"66":{"tf":2.0},"68":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"70":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"56":{"tf":1.0},"58":{"tf":1.0}}}}},"l":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":10,"docs":{"1":{"tf":2.23606797749979},"20":{"tf":1.7320508075688772},"21":{"tf":1.7320508075688772},"26":{"tf":1.0},"3":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"74":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"v":{"df":2,"docs":{"76":{"tf":1.0},"87":{"tf":1.0}}}},"i":{"df":1,"docs":{"88":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"19":{"tf":1.0},"69":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":2,"docs":{"15":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"26":{"tf":1.0},"67":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"30":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"56":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":14,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"61":{"tf":1.0},"77":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":6,"docs":{"35":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}},"v":{"df":11,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":2.6457513110645907},"56":{"tf":2.0},"57":{"tf":1.7320508075688772},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"t":{"df":1,"docs":{"57":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"56":{"tf":1.0},"68":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"87":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"f":{"c":{"df":5,"docs":{"21":{"tf":1.0},"33":{"tf":1.0},"45":{"tf":1.0},"66":{"tf":1.4142135623730951},"77":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.0}}},"t":{"df":4,"docs":{"24":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":6,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.0},"57":{"tf":1.0},"85":{"tf":1.0}}}},"n":{"df":18,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.7320508075688772},"62":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.7320508075688772},"84":{"tf":1.0},"88":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"0":{"tf":1.0},"73":{"tf":1.0}}},"_":{"2":{"0":{"2":{"1":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":2,"docs":{"13":{"tf":1.0},"26":{"tf":1.7320508075688772}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":47,"docs":{"0":{"tf":1.0},"1":{"tf":2.449489742783178},"10":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"2":{"tf":1.0},"20":{"tf":3.3166247903554},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"29":{"tf":2.0},"3":{"tf":1.0},"30":{"tf":3.0},"31":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"42":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"5":{"tf":1.0},"50":{"tf":1.7320508075688772},"55":{"tf":1.7320508075688772},"57":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":2.23606797749979},"62":{"tf":2.8284271247461903},"66":{"tf":2.0},"67":{"tf":2.0},"69":{"tf":2.8284271247461903},"70":{"tf":1.0},"73":{"tf":2.23606797749979},"74":{"tf":1.7320508075688772},"78":{"tf":2.23606797749979},"8":{"tf":2.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"87":{"tf":2.23606797749979},"88":{"tf":2.23606797749979}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":4,"docs":{"18":{"tf":1.0},"49":{"tf":1.4142135623730951},"67":{"tf":1.0},"78":{"tf":1.0}}}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":2,"docs":{"67":{"tf":1.0},"70":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":15,"docs":{"1":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":2.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"57":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"28":{"tf":1.0},"30":{"tf":1.4142135623730951},"50":{"tf":2.6457513110645907},"69":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"77":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":11,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"29":{"tf":1.0},"42":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":2.0},"66":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"77":{"tf":1.4142135623730951}},"k":{"df":1,"docs":{"7":{"tf":1.0}}},"m":{"df":3,"docs":{"24":{"tf":1.0},"30":{"tf":1.0},"61":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}},"f":{":":{":":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"23":{"tf":1.0},"30":{"tf":1.0},"51":{"tf":2.0},"52":{"tf":2.23606797749979}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"69":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"d":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"70":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":2,"docs":{"65":{"tf":1.0},"70":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"3":{"tf":1.0}}}},"t":{"df":7,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":2.0},"57":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"14":{"tf":1.0},"18":{"tf":1.0},"45":{"tf":1.0},"62":{"tf":1.0},"74":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"51":{"tf":1.0},"57":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"37":{"tf":1.0},"58":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.4142135623730951}}}},"w":{"df":1,"docs":{"58":{"tf":2.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"69":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"18":{"tf":1.0},"26":{"tf":1.0},"68":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"24":{"tf":1.0},"61":{"tf":1.0},"77":{"tf":1.0}},"i":{"df":2,"docs":{"61":{"tf":1.0},"87":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"30":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":1.0},"49":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"86":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"1":{"tf":1.0},"26":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"58":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"48":{"tf":1.0},"57":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951}}}},"v":{"df":1,"docs":{"1":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"1":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":2.449489742783178}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"26":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"87":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"37":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":5,"docs":{"12":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"70":{"tf":1.4142135623730951},"77":{"tf":1.0}},"i":{"df":5,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"44":{"tf":1.0},"52":{"tf":1.0},"87":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":4,"docs":{"13":{"tf":1.0},"19":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"1":{"tf":1.0},"20":{"tf":1.4142135623730951},"39":{"tf":1.0},"73":{"tf":1.0}}}},"l":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"38":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"26":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":10,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"30":{"tf":2.0},"55":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.4142135623730951},"66":{"tf":1.0},"7":{"tf":1.0},"87":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"65":{"tf":1.0},"68":{"tf":1.0}}}}}}},"i":{"c":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"df":1,"docs":{"10":{"tf":1.0}}}},"d":{"'":{"df":1,"docs":{"48":{"tf":1.0}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}},"y":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"x":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"a":{"df":0,"docs":{},"r":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"5":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":3,"docs":{"26":{"tf":1.7320508075688772},"50":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":5,"docs":{"18":{"tf":1.0},"26":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":13,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"62":{"tf":1.0},"78":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"26":{"tf":1.0},"30":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"72":{"tf":1.4142135623730951},"73":{"tf":2.6457513110645907},"74":{"tf":1.4142135623730951},"77":{"tf":2.23606797749979}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"30":{"tf":1.7320508075688772},"48":{"tf":1.0},"51":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"24":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"28":{"tf":2.23606797749979},"29":{"tf":2.23606797749979},"30":{"tf":2.0},"50":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"76":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"l":{"df":3,"docs":{"48":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":12,"docs":{"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"30":{"tf":1.0},"48":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"8":{"tf":1.0},"87":{"tf":1.4142135623730951}}}},"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"13":{"tf":1.7320508075688772},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":14,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"23":{"tf":1.0},"30":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":9,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.7320508075688772},"55":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"87":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"14":{"tf":1.0},"48":{"tf":1.0},"58":{"tf":1.0},"88":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"73":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"56":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":1,"docs":{"56":{"tf":1.0}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"n":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":16,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":2.449489742783178},"83":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":6,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"24":{"tf":2.0}}}}}}}},"t":{".":{"0":{"df":1,"docs":{"69":{"tf":1.7320508075688772}}},"1":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"a":{"b":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":8,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.6457513110645907},"58":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"25":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":2.449489742783178},"44":{"tf":2.0},"57":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"69":{"tf":3.4641016151377544}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"13":{"tf":1.0},"16":{"tf":1.0},"58":{"tf":2.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":2.23606797749979},"26":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"5":{"tf":1.0}}}},"t":{"'":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"21":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":6,"docs":{"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.0},"51":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"37":{"tf":1.4142135623730951},"66":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"11":{"tf":1.0},"24":{"tf":1.4142135623730951},"65":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":12,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":1.4142135623730951},"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"30":{"tf":1.0},"48":{"tf":1.0},"57":{"tf":1.4142135623730951},"61":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"26":{"tf":1.0},"77":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":1,"docs":{"48":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"50":{"tf":1.0},"84":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"52":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":14,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"87":{"tf":1.0}}}},"p":{"df":1,"docs":{"10":{"tf":1.0}}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"19":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"15":{"tf":2.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"18":{"tf":1.0},"26":{"tf":1.4142135623730951},"3":{"tf":2.0},"5":{"tf":1.0},"56":{"tf":1.0}}}},"p":{"df":7,"docs":{"13":{"tf":1.4142135623730951},"20":{"tf":1.0},"30":{"tf":1.4142135623730951},"55":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"39":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{">":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":18,"docs":{"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.7320508075688772},"37":{"tf":4.898979485566356},"47":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":4.242640687119285},"51":{"tf":1.7320508075688772},"52":{"tf":2.6457513110645907},"6":{"tf":1.0},"61":{"tf":2.449489742783178},"65":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":2.8284271247461903},"82":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"57":{"tf":1.0},"58":{"tf":2.6457513110645907},"78":{"tf":1.0}}}},"i":{"df":6,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.7320508075688772},"57":{"tf":1.0},"66":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"10":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"50":{"tf":1.0},"52":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":3,"docs":{"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"25":{"tf":1.0},"37":{"tf":1.0},"50":{"tf":1.0},"77":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"57":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":7,"docs":{"26":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.4142135623730951},"67":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.0},"61":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"3":{"2":{">":{">":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":3,"docs":{"33":{"tf":1.4142135623730951},"62":{"tf":1.7320508075688772},"83":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"2":{"tf":1.0},"38":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"27":{"tf":1.0},"48":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"14":{"tf":1.0},"49":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":1,"docs":{"57":{"tf":1.0}},"i":{"df":2,"docs":{"30":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"1":{"tf":1.0},"26":{"tf":1.4142135623730951},"57":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"50":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"30":{"tf":1.0},"61":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"19":{"tf":1.0},"7":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"14":{"tf":1.0},"16":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"74":{"tf":1.0}}}},"df":0,"docs":{}},"df":4,"docs":{"17":{"tf":1.0},"24":{"tf":1.0},"45":{"tf":1.0},"6":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":3,"docs":{"3":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":45,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":1.7320508075688772},"11":{"tf":2.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"14":{"tf":2.23606797749979},"15":{"tf":1.7320508075688772},"16":{"tf":1.7320508075688772},"18":{"tf":2.8284271247461903},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":4.123105625617661},"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"3":{"tf":1.0},"30":{"tf":3.872983346207417},"32":{"tf":1.0},"37":{"tf":2.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":2.0},"58":{"tf":2.449489742783178},"6":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":2.0},"67":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.7320508075688772},"72":{"tf":2.0},"73":{"tf":1.4142135623730951},"74":{"tf":2.23606797749979},"77":{"tf":1.0},"8":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"87":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"7":{"tf":1.0}}},"df":1,"docs":{"50":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"12":{"tf":1.0},"26":{"tf":2.23606797749979},"56":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"0":{".":{"1":{".":{"0":{"df":1,"docs":{"58":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"1":{"6":{"df":2,"docs":{"56":{"tf":1.0},"58":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}}}}},".":{"1":{".":{"3":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"(":{"df":1,"docs":{"30":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"14":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":8,"docs":{"4":{"tf":1.0},"50":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":2.23606797749979},"7":{"tf":1.0},"70":{"tf":2.0},"83":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"1":{"tf":1.0},"40":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":2.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"15":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"!":{"[":{"0":{"df":1,"docs":{"69":{"tf":2.0}}},"2":{"2":{"df":1,"docs":{"67":{"tf":1.0}}},"3":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"3":{"2":{">":{">":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"u":{"3":{"2":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"20":{"tf":1.0},"26":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"10":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":11,"docs":{"1":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.4142135623730951},"45":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":2.0},"8":{"tf":1.0}}}}},"u":{"df":1,"docs":{"50":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"a":{"df":2,"docs":{"26":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0},"26":{"tf":1.0},"55":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"2":{"0":{"2":{"1":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":12,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"62":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"84":{"tf":1.0}},"s":{"=":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":13,"docs":{"0":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"30":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"df":3,"docs":{"19":{"tf":1.0},"50":{"tf":1.4142135623730951},"58":{"tf":1.0}}},"v":{"df":4,"docs":{"49":{"tf":1.0},"57":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0}}}},"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"26":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"13":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":4,"docs":{"62":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.0},"88":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"15":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"52":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"87":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"57":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.4142135623730951},"26":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"1":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"df":23,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":2.23606797749979},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":2.0},"5":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"55":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"d":{"df":3,"docs":{"57":{"tf":1.0},"68":{"tf":1.0},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"'":{"df":0,"docs":{},"v":{"df":2,"docs":{"1":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"70":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":8,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"39":{"tf":1.0},"55":{"tf":1.0},"77":{"tf":1.0},"87":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"7":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"74":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"x":{"'":{"df":1,"docs":{"72":{"tf":1.0}}},".":{"0":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":6,"docs":{"28":{"tf":2.0},"62":{"tf":2.23606797749979},"67":{"tf":1.7320508075688772},"68":{"tf":2.8284271247461903},"70":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}},"y":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":3,"docs":{"26":{"tf":1.0},"4":{"tf":1.0},"49":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"14":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.4142135623730951},"7":{"tf":1.0},"74":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"r":{"df":2,"docs":{"26":{"tf":1.0},"8":{"tf":1.0}}},"v":{"df":2,"docs":{"26":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}}},"z":{"df":2,"docs":{"77":{"tf":1.0},"78":{"tf":1.0}}}}},"breadcrumbs":{"root":{"0":{".":{".":{".":{"1":{"0":{"0":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"=":{"1":{"0":{"0":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"1":{"6":{"df":1,"docs":{"57":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"20":{"tf":2.23606797749979}}},"2":{"7":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"3":{"1":{".":{"0":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"22":{"tf":1.0},"31":{"tf":1.0}}},"2":{"df":1,"docs":{"30":{"tf":1.0}}},"9":{".":{"0":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"0":{"df":1,"docs":{"57":{"tf":1.0}}},"7":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"1":{"df":2,"docs":{"26":{"tf":1.0},"62":{"tf":1.0}}},"2":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"5":{"0":{"df":1,"docs":{"74":{"tf":1.0}}},"1":{".":{"0":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"55":{"tf":1.0}}},"3":{".":{"0":{"df":2,"docs":{"61":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":2,"docs":{"61":{"tf":1.0},"87":{"tf":1.0}}},"5":{"df":1,"docs":{"62":{"tf":1.0}}},"6":{".":{"0":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":2,"docs":{"68":{"tf":1.0},"70":{"tf":1.0}}},"6":{"8":{"5":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"1":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"61":{"tf":2.449489742783178},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"73":{"tf":2.0}},"u":{"8":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"2":{".":{"0":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}},"0":{"1":{"5":{"df":19,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":3.3166247903554},"26":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"33":{"tf":1.0},"35":{"tf":1.0},"4":{"tf":1.4142135623730951},"6":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":1.4142135623730951},"84":{"tf":1.0}}},"7":{"df":1,"docs":{"20":{"tf":1.0}}},"8":{"df":46,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"21":{"tf":2.23606797749979},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"3":{"tf":1.0},"30":{"tf":2.449489742783178},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":2.0},"73":{"tf":1.4142135623730951},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"8":{"tf":2.0},"84":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"/":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":50,"docs":{"10":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"4":{"tf":1.7320508075688772},"45":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":2.0},"5":{"tf":1.0},"50":{"tf":2.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"62":{"tf":2.6457513110645907},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":2.23606797749979},"68":{"tf":1.0},"69":{"tf":2.23606797749979},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":2.0},"74":{"tf":2.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":2.23606797749979},"79":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":2.23606797749979}}},"df":0,"docs":{}},"5":{"2":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"2":{"9":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"61":{"tf":2.8284271247461903},"62":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0}}},"3":{"0":{"8":{"5":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"61":{"tf":2.8284271247461903},"62":{"tf":1.4142135623730951}}},"4":{"6":{"9":{"0":{"6":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{"df":1,"docs":{"70":{"tf":1.0}}},"9":{"9":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"_":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"86":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":3,"docs":{"86":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951},"88":{"tf":2.0}}}},"df":0,"docs":{}}},"df":5,"docs":{"33":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":2.23606797749979},"7":{"tf":1.4142135623730951}}},"a":{"#":{"b":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"x":{"df":2,"docs":{"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951}}}},":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":7,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"50":{"tf":1.4142135623730951},"57":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":8,"docs":{"26":{"tf":1.0},"61":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"83":{"tf":1.0},"87":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"55":{"tf":1.0},"57":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":6,"docs":{"13":{"tf":1.0},"26":{"tf":1.7320508075688772},"4":{"tf":1.0},"57":{"tf":1.7320508075688772},"78":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":10,"docs":{"3":{"tf":1.0},"30":{"tf":1.0},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"73":{"tf":1.0}}}}},"df":9,"docs":{"13":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":2.0},"67":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":12,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"52":{"tf":1.4142135623730951},"61":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"87":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.0},"88":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"d":{"df":3,"docs":{"49":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}},"k":{"a":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"26":{"tf":2.0}}},"df":0,"docs":{},"w":{"df":12,"docs":{"11":{"tf":1.0},"15":{"tf":1.0},"33":{"tf":1.4142135623730951},"44":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"70":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"84":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"49":{"tf":1.0},"5":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":6,"docs":{"26":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":2.0},"74":{"tf":2.0},"77":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}},"n":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"57":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":7,"docs":{"1":{"tf":1.0},"27":{"tf":1.4142135623730951},"30":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":5,"docs":{"30":{"tf":1.0},"37":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":2.0}}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"67":{"tf":1.0}}}},"z":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":4,"docs":{"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"6":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":7,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":1.0},"57":{"tf":1.7320508075688772},"61":{"tf":1.0},"66":{"tf":1.0}}}}},"y":{"_":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"3":{"tf":1.0},"66":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"4":{"tf":1.0}}},"df":7,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":2.0},"61":{"tf":1.0},"72":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"18":{"tf":1.0},"26":{"tf":1.0},"77":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"24":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"33":{"tf":1.0},"73":{"tf":3.0},"74":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"21":{"tf":1.0},"30":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"59":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"62":{"tf":2.23606797749979},"63":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"72":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":5,"docs":{"1":{"tf":1.7320508075688772},"3":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"18":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"52":{"tf":1.7320508075688772},"70":{"tf":1.4142135623730951}},"m":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"56":{"tf":1.0},"58":{"tf":1.0}}},"df":20,"docs":{"13":{"tf":1.0},"14":{"tf":2.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"26":{"tf":2.0},"4":{"tf":1.0},"44":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"70":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}}},"df":6,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":2.23606797749979},"56":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"11":{"tf":1.0},"21":{"tf":1.0},"26":{"tf":1.0},"86":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":5,"docs":{"3":{"tf":1.0},"30":{"tf":1.0},"61":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.7320508075688772}}}},"r":{"df":1,"docs":{"3":{"tf":1.0}}},"y":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}},"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"50":{"tf":1.0}}}},".":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},":":{":":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.7320508075688772},"58":{"tf":2.23606797749979}},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"70":{"tf":1.0}}},"i":{"df":1,"docs":{"20":{"tf":1.0}}}},"z":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"33":{"tf":1.0}}}},"df":3,"docs":{"77":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":5,"docs":{"37":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"58":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0}}}}},"df":6,"docs":{"15":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":2.0},"62":{"tf":1.0},"70":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":9,"docs":{"10":{"tf":1.0},"26":{"tf":1.0},"49":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"86":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"62":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.0},"87":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"49":{"tf":1.0},"67":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":9,"docs":{"11":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"4":{"tf":1.0}}}}},"df":1,"docs":{"12":{"tf":1.0}}},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"39":{"tf":1.0},"69":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"32":{"tf":1.0},"66":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"50":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"x":{"<":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"61":{"tf":1.7320508075688772}}}},"df":5,"docs":{"48":{"tf":1.7320508075688772},"52":{"tf":1.0},"61":{"tf":1.0},"77":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"24":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"45":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"1":{"tf":1.0},"13":{"tf":2.23606797749979},"19":{"tf":1.0},"61":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"'":{"df":2,"docs":{"57":{"tf":1.0},"58":{"tf":1.0}}},"df":3,"docs":{"56":{"tf":1.0},"57":{"tf":2.8284271247461903},"58":{"tf":4.123105625617661}}}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"19":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"l":{"d":{"df":9,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":3.7416573867739413},"58":{"tf":1.7320508075688772}}},"df":0,"docs":{},"t":{"df":3,"docs":{"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"58":{"tf":1.4142135623730951}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":13,"docs":{"14":{"tf":1.0},"15":{"tf":2.23606797749979},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"50":{"tf":2.23606797749979},"52":{"tf":2.6457513110645907},"60":{"tf":1.7320508075688772},"61":{"tf":1.7320508075688772},"62":{"tf":1.7320508075688772},"63":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.4142135623730951}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"52":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.4142135623730951},"73":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"64":{"tf":1.7320508075688772},"65":{"tf":1.7320508075688772},"66":{"tf":3.3166247903554},"67":{"tf":2.449489742783178},"68":{"tf":2.0},"69":{"tf":2.0},"70":{"tf":3.0}}}}}},"r":{"d":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":1,"docs":{"73":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":11,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.0},"26":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}}}},"df":31,"docs":{"1":{"tf":1.0},"10":{"tf":3.0},"11":{"tf":2.449489742783178},"12":{"tf":2.23606797749979},"13":{"tf":2.23606797749979},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":2.0},"19":{"tf":1.7320508075688772},"26":{"tf":2.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"44":{"tf":1.7320508075688772},"49":{"tf":1.0},"5":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"57":{"tf":1.7320508075688772},"58":{"tf":2.8284271247461903},"62":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951},"7":{"tf":2.449489742783178},"74":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.7320508075688772},"84":{"tf":1.0},"88":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":17,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":2.0},"52":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":2.0},"7":{"tf":1.0},"74":{"tf":1.4142135623730951},"76":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":1,"docs":{"4":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":7,"docs":{"24":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0}}}}},"df":6,"docs":{"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.4142135623730951},"69":{"tf":2.23606797749979},"70":{"tf":1.0},"77":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"56":{"tf":1.0},"57":{"tf":1.0}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"11":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"58":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":43,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"10":{"tf":2.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":2.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":2.449489742783178},"30":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.7320508075688772},"65":{"tf":1.0},"67":{"tf":2.0},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.4142135623730951},"8":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":2.23606797749979},"88":{"tf":1.7320508075688772}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"45":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"10":{"tf":2.0},"18":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"74":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"1":{"tf":1.0},"50":{"tf":1.0},"8":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"28":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"28":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"57":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.0},"50":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"18":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"48":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"64":{"tf":1.7320508075688772},"65":{"tf":1.7320508075688772},"66":{"tf":2.23606797749979},"67":{"tf":2.23606797749979},"68":{"tf":1.7320508075688772},"69":{"tf":2.0},"70":{"tf":2.6457513110645907}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":4,"docs":{"49":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":39,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":2.449489742783178},"11":{"tf":2.23606797749979},"13":{"tf":2.0},"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":2.449489742783178},"18":{"tf":1.7320508075688772},"19":{"tf":2.449489742783178},"2":{"tf":1.0},"20":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":2.23606797749979},"37":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.7320508075688772},"61":{"tf":1.7320508075688772},"62":{"tf":1.4142135623730951},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":2.8284271247461903},"70":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"52":{"tf":1.7320508075688772}}}}}},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"15":{"tf":1.0},"48":{"tf":1.4142135623730951}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"13":{"tf":1.0},"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"20":{"tf":1.0},"77":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}},"t":{"df":17,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"3":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"62":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":18,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"57":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"30":{"tf":1.0},"68":{"tf":1.0}}},"x":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"1":{"tf":1.0},"11":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"30":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"24":{"tf":1.0},"37":{"tf":1.0},"73":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"24":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"67":{"tf":1.0}}}}},"i":{"d":{"df":4,"docs":{"5":{"tf":1.0},"57":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"24":{"tf":1.0},"45":{"tf":1.0},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"83":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.7320508075688772},"66":{"tf":1.0},"87":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"19":{"tf":1.0},"49":{"tf":1.0},"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"14":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"1":{"tf":1.0},"26":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"3":{"tf":1.0},"57":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"14":{"tf":1.0},"57":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"24":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"3":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":18,"docs":{"1":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":2.449489742783178},"15":{"tf":2.23606797749979},"19":{"tf":2.23606797749979},"2":{"tf":2.0},"23":{"tf":1.4142135623730951},"24":{"tf":2.23606797749979},"26":{"tf":5.385164807134504},"27":{"tf":3.3166247903554},"28":{"tf":3.0},"3":{"tf":1.0},"30":{"tf":2.6457513110645907},"48":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.0},"84":{"tf":1.0},"87":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"74":{"tf":2.23606797749979}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"10":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"37":{"tf":1.0},"44":{"tf":1.4142135623730951},"48":{"tf":1.0},"57":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.4142135623730951},"87":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":3,"docs":{"51":{"tf":1.7320508075688772},"68":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":1,"docs":{"58":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"37":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.7320508075688772},"33":{"tf":1.0},"57":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":12,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"20":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":2.0},"58":{"tf":2.8284271247461903},"62":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"24":{"tf":1.0},"49":{"tf":1.0},"51":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.0},"55":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"4":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"57":{"tf":5.0990195135927845},"58":{"tf":3.4641016151377544}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":5,"docs":{"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"74":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"52":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":3,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"67":{"tf":1.0},"69":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":16,"docs":{"24":{"tf":1.0},"25":{"tf":1.4142135623730951},"3":{"tf":1.0},"33":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.0},"55":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"66":{"tf":2.0},"67":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"87":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.0},"49":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},"v":{"df":1,"docs":{"57":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"20":{"tf":1.0},"57":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":2.0}}}}}}},"df":1,"docs":{"57":{"tf":2.8284271247461903}}}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"11":{"tf":2.0},"19":{"tf":1.0},"30":{"tf":1.4142135623730951},"56":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.4142135623730951},"70":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"5":{"tf":1.0}},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"df":1,"docs":{"5":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"28":{"tf":1.0},"61":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"18":{"tf":1.0},"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"44":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"14":{"tf":1.0}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"64":{"tf":1.7320508075688772},"65":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"45":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":2.0}}}}}}}},"df":2,"docs":{"26":{"tf":1.4142135623730951},"49":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.7320508075688772},"76":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"11":{"tf":1.0},"20":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{"a":{".":{"df":0,"docs":{},"x":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"48":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":3.605551275463989}}}}},"u":{"df":0,"docs":{},"e":{"df":4,"docs":{"14":{"tf":1.0},"52":{"tf":1.4142135623730951},"61":{"tf":1.0},"73":{"tf":1.0}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":4,"docs":{"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":8,"docs":{"14":{"tf":2.0},"15":{"tf":1.7320508075688772},"35":{"tf":1.0},"37":{"tf":2.6457513110645907},"50":{"tf":2.0},"52":{"tf":1.0},"82":{"tf":1.7320508075688772},"84":{"tf":1.0}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":4,"docs":{"52":{"tf":1.0},"74":{"tf":1.0},"76":{"tf":1.4142135623730951},"86":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":10,"docs":{"0":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"45":{"tf":1.0},"58":{"tf":1.7320508075688772},"70":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":2,"docs":{"3":{"tf":1.7320508075688772},"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"12":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"58":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":45,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":3.0},"10":{"tf":2.8284271247461903},"11":{"tf":1.0},"12":{"tf":2.23606797749979},"13":{"tf":2.0},"14":{"tf":2.8284271247461903},"15":{"tf":3.1622776601683795},"16":{"tf":2.23606797749979},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":2.8284271247461903},"2":{"tf":3.1622776601683795},"20":{"tf":2.23606797749979},"21":{"tf":2.23606797749979},"24":{"tf":1.0},"3":{"tf":3.0},"33":{"tf":1.4142135623730951},"37":{"tf":1.0},"4":{"tf":2.449489742783178},"45":{"tf":1.0},"49":{"tf":1.7320508075688772},"5":{"tf":3.7416573867739413},"52":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"6":{"tf":2.23606797749979},"60":{"tf":1.0},"61":{"tf":2.23606797749979},"62":{"tf":2.449489742783178},"63":{"tf":1.0},"67":{"tf":1.7320508075688772},"7":{"tf":2.6457513110645907},"74":{"tf":1.7320508075688772},"76":{"tf":1.0},"77":{"tf":2.8284271247461903},"78":{"tf":1.7320508075688772},"8":{"tf":3.1622776601683795},"81":{"tf":1.0},"84":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":2.23606797749979},"88":{"tf":1.4142135623730951},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"8":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"13":{"tf":1.0},"18":{"tf":1.4142135623730951},"29":{"tf":1.0}}}}}}},"df":2,"docs":{"58":{"tf":1.7320508075688772},"61":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"30":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"80":{"tf":1.0},"83":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":2.23606797749979},"58":{"tf":2.0},"8":{"tf":1.4142135623730951},"87":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"5":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":3,"docs":{"17":{"tf":1.0},"24":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"62":{"tf":1.0},"74":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":10,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"57":{"tf":1.0},"62":{"tf":1.0},"74":{"tf":1.0},"88":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":7,"docs":{"12":{"tf":1.0},"28":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"66":{"tf":1.0},"67":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"3":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":18,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"30":{"tf":1.0},"41":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":1.7320508075688772},"74":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"72":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":9,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"24":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"16":{"tf":1.0},"30":{"tf":1.0},"48":{"tf":1.0},"8":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":30,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":2.0},"19":{"tf":1.0},"26":{"tf":1.7320508075688772},"3":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.0},"48":{"tf":2.23606797749979},"49":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"57":{"tf":2.6457513110645907},"58":{"tf":1.7320508075688772},"6":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.7320508075688772},"74":{"tf":1.0},"77":{"tf":1.4142135623730951},"8":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.0},"26":{"tf":1.4142135623730951},"30":{"tf":1.0},"48":{"tf":1.0},"77":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":12,"docs":{"1":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"57":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.7320508075688772},"7":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.0}}}},"t":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"15":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"45":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"37":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"87":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"1":{"tf":1.0},"26":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"55":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"26":{"tf":1.0},"68":{"tf":1.4142135623730951},"73":{"tf":1.0},"83":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"18":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"=":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":8,"docs":{"15":{"tf":1.0},"19":{"tf":2.23606797749979},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":3.7416573867739413},"27":{"tf":1.7320508075688772},"28":{"tf":2.23606797749979},"30":{"tf":2.23606797749979}}}}}}}},"f":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}},")":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":9,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"57":{"tf":1.7320508075688772},"6":{"tf":1.0},"67":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"62":{"tf":1.0},"78":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":3,"docs":{"26":{"tf":1.7320508075688772},"58":{"tf":1.7320508075688772},"77":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":17,"docs":{"1":{"tf":1.7320508075688772},"11":{"tf":2.449489742783178},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":2.0},"56":{"tf":2.449489742783178},"57":{"tf":5.0990195135927845},"58":{"tf":4.898979485566356},"7":{"tf":1.0},"73":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}},"w":{"df":3,"docs":{"19":{"tf":1.0},"24":{"tf":1.0},"56":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"56":{"tf":1.0},"68":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"44":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"66":{"tf":2.23606797749979},"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"29":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":3,"docs":{"15":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}},"x":{"df":25,"docs":{"10":{"tf":3.0},"11":{"tf":2.23606797749979},"12":{"tf":1.4142135623730951},"13":{"tf":3.1622776601683795},"14":{"tf":2.449489742783178},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":2.0},"26":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"56":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951},"7":{"tf":3.0},"74":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":7,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.7320508075688772},"58":{"tf":2.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"58":{"tf":1.0}}}}},"n":{"df":13,"docs":{"26":{"tf":1.4142135623730951},"28":{"tf":2.0},"30":{"tf":2.449489742783178},"33":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"50":{"tf":2.449489742783178},"51":{"tf":1.4142135623730951},"6":{"tf":1.0},"62":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":13,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.4142135623730951},"45":{"tf":1.0},"5":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951}}}}}},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"33":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.0},"29":{"tf":2.23606797749979}}}},"/":{"b":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.0},"30":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":12,"docs":{"14":{"tf":2.0},"24":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":2.23606797749979},"30":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"4":{"tf":2.0},"58":{"tf":2.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"r":{"c":{"df":4,"docs":{"18":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}},"df":4,"docs":{"58":{"tf":1.0},"73":{"tf":2.449489742783178},"74":{"tf":1.0},"77":{"tf":1.4142135623730951}}}},"df":1,"docs":{"44":{"tf":1.0}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"7":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"62":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":3,"docs":{"48":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"87":{"tf":2.23606797749979},"88":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":2,"docs":{"62":{"tf":1.0},"74":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"50":{"tf":1.4142135623730951},"51":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"(":{"_":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}},"x":{"df":1,"docs":{"50":{"tf":1.0}}}},"<":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"47":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"66":{"tf":1.0}},"i":{"df":4,"docs":{"14":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"63":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"30":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"1":{"df":1,"docs":{"37":{"tf":1.0}}},"2":{"df":1,"docs":{"37":{"tf":1.0}}},"df":7,"docs":{"18":{"tf":1.0},"28":{"tf":1.4142135623730951},"31":{"tf":1.7320508075688772},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"49":{"tf":1.4142135623730951},"74":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"58":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"1":{"tf":1.0},"26":{"tf":2.0},"30":{"tf":1.0},"45":{"tf":1.0},"77":{"tf":2.0}},"e":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"17":{"tf":2.23606797749979},"2":{"tf":1.0},"26":{"tf":1.0}}}}},"t":{"df":5,"docs":{"15":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.0},"88":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"3":{"tf":1.0}},"n":{"df":8,"docs":{"26":{"tf":1.0},"33":{"tf":1.0},"52":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":1.0},"70":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":4,"docs":{"13":{"tf":1.0},"24":{"tf":1.0},"62":{"tf":1.0},"74":{"tf":1.0}},"e":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":2,"docs":{"57":{"tf":1.0},"58":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"18":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}}},"df":4,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":1.0},"3":{"tf":1.7320508075688772},"7":{"tf":1.0}},"e":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"68":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.4142135623730951}},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"26":{"tf":1.0},"87":{"tf":1.0}}}}}},"r":{"d":{"df":3,"docs":{"3":{"tf":1.0},"41":{"tf":1.0},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"12":{"tf":1.0},"29":{"tf":1.0},"77":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"77":{"tf":1.4142135623730951}}}},"p":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"58":{"tf":1.0},"7":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"24":{"tf":1.0}}},"df":9,"docs":{"18":{"tf":1.0},"26":{"tf":1.0},"37":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.4142135623730951},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.7320508075688772}}}},"y":{"df":1,"docs":{"78":{"tf":1.0}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"57":{"tf":1.0},"73":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"57":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"d":{"df":0,"docs":{},"o":{"c":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.0},"15":{"tf":1.7320508075688772}}}}}}}},"i":{".":{"df":5,"docs":{"52":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"3":{"2":{"df":4,"docs":{"37":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"d":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"48":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":6,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"3":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}},"df":1,"docs":{"19":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"55":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":4,"docs":{"37":{"tf":2.23606797749979},"51":{"tf":1.7320508075688772},"69":{"tf":1.0},"70":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":12,"docs":{"38":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":2.8284271247461903},"62":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":3.0},"72":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"30":{"tf":1.0},"61":{"tf":1.0}}}}}}},"df":3,"docs":{"2":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"df":8,"docs":{"14":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":2.8284271247461903},"28":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"52":{"tf":1.0},"69":{"tf":1.0},"87":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":12,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"58":{"tf":1.0},"83":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0}}}},"o":{"df":2,"docs":{"21":{"tf":1.0},"45":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"56":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"50":{"tf":1.0},"51":{"tf":1.7320508075688772},"52":{"tf":2.0}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"65":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"15":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.7320508075688772}}},"n":{"c":{"df":3,"docs":{"27":{"tf":1.4142135623730951},"51":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":6,"docs":{"29":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"19":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"18":{"tf":1.0},"2":{"tf":1.0},"26":{"tf":1.0},"57":{"tf":1.0}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"61":{"tf":1.0},"62":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"(":{"[":{"1":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"63":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":5,"docs":{"59":{"tf":1.7320508075688772},"60":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"62":{"tf":1.0},"63":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0},"52":{"tf":1.0},"7":{"tf":1.0}},"t":{"df":1,"docs":{"0":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"o":{"c":{"df":2,"docs":{"74":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":2,"docs":{"50":{"tf":1.0},"73":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":10,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"61":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"'":{"df":11,"docs":{"20":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"61":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"19":{"tf":1.0},"26":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951}}},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{"[":{"1":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":3,"docs":{"10":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"57":{"tf":1.0},"68":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"k":{"#":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"13":{"tf":1.0},"26":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0}}}},"y":{"/":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":2,"docs":{"4":{"tf":1.0},"8":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":14,"docs":{"1":{"tf":2.0},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":2.23606797749979},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":2.0},"76":{"tf":1.0},"77":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"15":{"tf":1.0},"56":{"tf":1.0}},"n":{"df":2,"docs":{"19":{"tf":1.0},"73":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"19":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":5,"docs":{"12":{"tf":1.7320508075688772},"20":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"58":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}},"r":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"74":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"56":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"20":{"tf":1.0},"3":{"tf":1.0}}}}},"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"g":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"1":{"0":{"0":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"'":{"df":7,"docs":{"15":{"tf":1.0},"25":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"78":{"tf":1.0}}},"df":4,"docs":{"56":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":5,"docs":{"30":{"tf":1.4142135623730951},"55":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.0}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"c":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"18":{"tf":1.7320508075688772},"26":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}},"df":0,"docs":{}},"z":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":5,"docs":{"19":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.0},"62":{"tf":1.0},"88":{"tf":1.0}}},"k":{"df":1,"docs":{"18":{"tf":1.0}}},"t":{"df":18,"docs":{"10":{"tf":2.449489742783178},"13":{"tf":2.23606797749979},"18":{"tf":2.0},"19":{"tf":1.7320508075688772},"41":{"tf":1.0},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"67":{"tf":1.0},"70":{"tf":1.0},"74":{"tf":1.4142135623730951},"78":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"19":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"77":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"50":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"33":{"tf":1.0},"44":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"70":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"78":{"tf":1.0},"83":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":7,"docs":{"15":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"56":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0}}}},"t":{"df":2,"docs":{"12":{"tf":1.0},"48":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"14":{"tf":1.0}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"78":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":15,"docs":{"14":{"tf":3.7416573867739413},"15":{"tf":3.1622776601683795},"26":{"tf":2.0},"57":{"tf":2.449489742783178},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":2.6457513110645907},"74":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.7320508075688772},"85":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951},"87":{"tf":2.8284271247461903},"88":{"tf":2.23606797749979}}}}},"d":{"df":0,"docs":{},"e":{"df":5,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"20":{"tf":1.4142135623730951},"62":{"tf":1.0},"74":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":15,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"12":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"24":{"tf":1.0},"3":{"tf":1.7320508075688772},"30":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.0},"88":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":5,"docs":{"18":{"tf":1.0},"24":{"tf":1.0},"51":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":15,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"3":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"df":3,"docs":{"15":{"tf":1.4142135623730951},"20":{"tf":1.0},"26":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":7,"docs":{"30":{"tf":1.7320508075688772},"57":{"tf":1.0},"68":{"tf":1.0},"76":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":2.0},"88":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{"!":{"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"y":{"b":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":8,"docs":{"1":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"68":{"tf":1.0},"77":{"tf":1.7320508075688772},"87":{"tf":1.0},"88":{"tf":1.0}},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"69":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"70":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"18":{"tf":1.0},"73":{"tf":2.0},"74":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":14,"docs":{"33":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":4.123105625617661},"51":{"tf":2.449489742783178},"52":{"tf":3.4641016151377544},"57":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":35,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":2.8284271247461903},"11":{"tf":2.449489742783178},"12":{"tf":3.0},"13":{"tf":2.0},"14":{"tf":2.23606797749979},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":2.449489742783178},"19":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":2.449489742783178},"45":{"tf":1.0},"49":{"tf":2.6457513110645907},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.7320508075688772},"52":{"tf":1.0},"56":{"tf":1.7320508075688772},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"62":{"tf":2.23606797749979},"63":{"tf":1.4142135623730951},"67":{"tf":2.8284271247461903},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"74":{"tf":2.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":2.6457513110645907},"84":{"tf":2.0},"88":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"22":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"61":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"13":{"tf":1.0},"3":{"tf":1.0},"61":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"57":{"tf":1.4142135623730951},"73":{"tf":1.0}}}},"x":{"df":1,"docs":{"61":{"tf":1.0}}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"24":{"tf":1.0},"29":{"tf":2.23606797749979}}}},"df":5,"docs":{"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":2.0},"50":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"23":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":11,"docs":{"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"30":{"tf":2.449489742783178},"48":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":15,"docs":{"12":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"37":{"tf":1.4142135623730951},"4":{"tf":1.0},"45":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"66":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"76":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"24":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"66":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"t":{".":{"0":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"69":{"tf":1.0}}}},"<":{"df":0,"docs":{},"t":{">":{"(":{"_":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":5,"docs":{"11":{"tf":1.0},"30":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"69":{"tf":1.7320508075688772}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"37":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"14":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":4,"docs":{"37":{"tf":1.4142135623730951},"52":{"tf":1.0},"61":{"tf":1.0},"70":{"tf":1.4142135623730951}}}},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"!":{"(":{"1":{"df":1,"docs":{"88":{"tf":1.0}}},"df":0,"docs":{},"z":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"78":{"tf":1.0},"88":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"58":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":2.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"(":{")":{">":{">":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"50":{"tf":2.23606797749979},"82":{"tf":2.0}}}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":20,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":2.0},"3":{"tf":1.0},"30":{"tf":2.23606797749979},"33":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":2.23606797749979},"51":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"77":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{";":{"&":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"19":{"tf":1.0},"26":{"tf":1.4142135623730951},"3":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":23,"docs":{"11":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":3.0},"30":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"57":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":1.7320508075688772},"78":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"20":{"tf":1.0}}}}},"w":{"df":31,"docs":{"1":{"tf":2.23606797749979},"10":{"tf":1.4142135623730951},"16":{"tf":1.0},"19":{"tf":2.0},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.7320508075688772},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":2.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":2.23606797749979},"45":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":2.0},"50":{"tf":1.0},"55":{"tf":1.7320508075688772},"56":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"58":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":2.0},"73":{"tf":1.0},"77":{"tf":1.4142135623730951},"8":{"tf":3.1622776601683795},"86":{"tf":1.0},"87":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":2.0},"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"5":{"tf":2.0},"7":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"73":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":4,"docs":{"18":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":3,"docs":{"26":{"tf":1.0},"56":{"tf":1.0},"74":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":20,"docs":{"15":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":2.0},"65":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0},"86":{"tf":1.0}},"—":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"77":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"74":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"37":{"tf":2.23606797749979},"50":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"52":{"tf":1.0}},"r":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":3,"docs":{"61":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":2.0}}},"l":{"d":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"37":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"26":{"tf":1.0},"4":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":5,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"57":{"tf":1.4142135623730951},"73":{"tf":1.0},"8":{"tf":1.0}}},"df":20,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":2.0},"30":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":1.4142135623730951},"87":{"tf":1.0}}},"p":{"df":1,"docs":{"68":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"29":{"tf":1.0},"45":{"tf":1.0}}}},"t":{"df":3,"docs":{"1":{"tf":1.0},"55":{"tf":1.4142135623730951},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"a":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":9,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"50":{"tf":1.0},"58":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"49":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"69":{"tf":1.7320508075688772},"7":{"tf":1.0},"78":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":1.0},"52":{"tf":1.0},"70":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"50":{"tf":1.0},"67":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"19":{"tf":1.0},"37":{"tf":1.0},"66":{"tf":1.0},"69":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}},"v":{"df":1,"docs":{"19":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.7320508075688772}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":8,"docs":{"1":{"tf":1.0},"19":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"57":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":7,"docs":{"12":{"tf":2.0},"4":{"tf":2.0},"44":{"tf":1.0},"55":{"tf":1.0},"57":{"tf":2.23606797749979},"58":{"tf":1.7320508075688772},"8":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"73":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}}}}},"1":{"2":{"3":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"x":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}},"df":0,"docs":{}},"df":4,"docs":{"71":{"tf":1.7320508075688772},"72":{"tf":2.23606797749979},"73":{"tf":4.0},"74":{"tf":2.6457513110645907}},"k":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"31":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"6":{"tf":1.0},"7":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}},"t":{"df":9,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"3":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"78":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":1,"docs":{"57":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"16":{"tf":1.0},"26":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}}}},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"87":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":1,"docs":{"87":{"tf":2.0}},"h":{"df":12,"docs":{"22":{"tf":1.7320508075688772},"23":{"tf":2.449489742783178},"24":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.0},"29":{"tf":1.0},"30":{"tf":3.7416573867739413},"44":{"tf":1.7320508075688772},"50":{"tf":1.0},"52":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":8,"docs":{"32":{"tf":1.0},"68":{"tf":1.7320508075688772},"83":{"tf":1.4142135623730951},"84":{"tf":1.0},"85":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951},"87":{"tf":2.6457513110645907},"88":{"tf":1.4142135623730951}}}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"72":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"58":{"tf":1.0}},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"20":{"tf":1.0},"24":{"tf":1.0}}}}},"r":{"df":2,"docs":{"1":{"tf":1.0},"87":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"24":{"tf":1.0},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.0},"57":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"3":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"70":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"5":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":2.23606797749979}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"77":{"tf":1.0},"87":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"66":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"37":{"tf":1.0},"4":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"#":{"1":{"2":{"3":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"77":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"'":{"c":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"27":{"tf":1.4142135623730951},"77":{"tf":2.8284271247461903},"78":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"—":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":8,"docs":{"26":{"tf":1.0},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"48":{"tf":2.6457513110645907},"49":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"66":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":3,"docs":{"20":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0}},"s":{"df":3,"docs":{"27":{"tf":1.0},"28":{"tf":1.0},"56":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"7":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":2,"docs":{"68":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"a":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"66":{"tf":1.4142135623730951},"67":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}},"i":{"df":1,"docs":{"52":{"tf":2.0}}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":10,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"3":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.7320508075688772},"7":{"tf":1.0},"73":{"tf":1.0}}}}}},"c":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"14":{"tf":1.4142135623730951},"26":{"tf":1.0},"57":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":4,"docs":{"73":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}},"t":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"19":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":15,"docs":{"10":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"18":{"tf":1.7320508075688772},"20":{"tf":1.0},"26":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"4":{"tf":2.23606797749979},"5":{"tf":2.0},"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":6,"docs":{"79":{"tf":1.7320508075688772},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"21":{"tf":1.0},"66":{"tf":1.0},"77":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"3":{"tf":1.0},"57":{"tf":1.0},"77":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"*":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"70":{"tf":1.0}}}},"u":{"b":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"23":{"tf":1.0}}}}},"df":5,"docs":{"30":{"tf":1.7320508075688772},"48":{"tf":1.0},"50":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"x":{".":{"0":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"70":{"tf":1.0}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"63":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"13":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"58":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}},"r":{"#":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":1,"docs":{"83":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"16":{"tf":1.0},"73":{"tf":1.0}}}},"w":{"df":6,"docs":{"3":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"70":{"tf":1.0},"77":{"tf":1.0}}}},"df":1,"docs":{"77":{"tf":1.0}},"e":{"a":{"d":{"df":5,"docs":{"14":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"68":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":3,"docs":{"62":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"57":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"20":{"tf":1.0},"48":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"50":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"11":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"26":{"tf":1.0},"7":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":10,"docs":{"24":{"tf":1.4142135623730951},"27":{"tf":2.6457513110645907},"3":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.7320508075688772},"52":{"tf":2.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"66":{"tf":2.0},"68":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"70":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"56":{"tf":1.0},"58":{"tf":1.0}}}}},"l":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":10,"docs":{"1":{"tf":2.23606797749979},"20":{"tf":1.7320508075688772},"21":{"tf":1.7320508075688772},"26":{"tf":1.0},"3":{"tf":1.0},"38":{"tf":1.0},"45":{"tf":1.0},"57":{"tf":1.0},"62":{"tf":1.0},"74":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"v":{"df":2,"docs":{"76":{"tf":1.0},"87":{"tf":1.0}}}},"i":{"df":1,"docs":{"88":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"19":{"tf":1.0},"69":{"tf":1.0},"81":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":2,"docs":{"15":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"26":{"tf":1.0},"67":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"30":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"56":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":14,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"28":{"tf":1.4142135623730951},"3":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"61":{"tf":1.0},"77":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":7,"docs":{"35":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"77":{"tf":2.0},"78":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}},"v":{"df":11,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"55":{"tf":2.8284271247461903},"56":{"tf":2.23606797749979},"57":{"tf":2.0},"58":{"tf":1.4142135623730951},"60":{"tf":1.0},"61":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"56":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"t":{"df":1,"docs":{"57":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"56":{"tf":1.0},"68":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"87":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"f":{"c":{"df":5,"docs":{"21":{"tf":1.0},"33":{"tf":1.0},"45":{"tf":1.0},"66":{"tf":1.4142135623730951},"77":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.0}}},"t":{"df":4,"docs":{"24":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":9,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.4142135623730951},"26":{"tf":1.0},"57":{"tf":1.0},"85":{"tf":1.7320508075688772},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}},"n":{"df":18,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.7320508075688772},"62":{"tf":1.0},"67":{"tf":1.4142135623730951},"69":{"tf":1.0},"7":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.7320508075688772},"84":{"tf":1.0},"88":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"0":{"tf":1.0},"73":{"tf":1.0}}},"_":{"2":{"0":{"2":{"1":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"67":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":2,"docs":{"13":{"tf":1.0},"26":{"tf":1.7320508075688772}}},"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":81,"docs":{"0":{"tf":1.0},"1":{"tf":2.449489742783178},"10":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"2":{"tf":1.0},"20":{"tf":3.605551275463989},"21":{"tf":2.23606797749979},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"25":{"tf":1.0},"26":{"tf":2.0},"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"29":{"tf":2.23606797749979},"3":{"tf":1.0},"30":{"tf":3.1622776601683795},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":2.0},"5":{"tf":1.0},"50":{"tf":2.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":2.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"58":{"tf":1.0},"59":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":2.0},"61":{"tf":2.449489742783178},"62":{"tf":3.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":2.23606797749979},"67":{"tf":2.23606797749979},"68":{"tf":1.0},"69":{"tf":3.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":2.449489742783178},"74":{"tf":2.0},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":2.449489742783178},"79":{"tf":1.0},"8":{"tf":2.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"84":{"tf":1.4142135623730951},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":2.449489742783178},"88":{"tf":2.449489742783178}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":4,"docs":{"18":{"tf":1.0},"49":{"tf":1.4142135623730951},"67":{"tf":1.0},"78":{"tf":1.0}}}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":2,"docs":{"67":{"tf":1.0},"70":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":15,"docs":{"1":{"tf":1.0},"14":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":2.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"57":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0},"74":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"28":{"tf":1.0},"30":{"tf":1.4142135623730951},"50":{"tf":2.6457513110645907},"69":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"77":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":11,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"29":{"tf":1.0},"42":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":2.0},"66":{"tf":1.0},"7":{"tf":1.4142135623730951},"70":{"tf":1.0},"77":{"tf":1.4142135623730951}},"k":{"df":1,"docs":{"7":{"tf":1.0}}},"m":{"df":3,"docs":{"24":{"tf":1.0},"30":{"tf":1.0},"61":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}},"f":{":":{":":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":4,"docs":{"23":{"tf":1.0},"30":{"tf":1.0},"51":{"tf":2.0},"52":{"tf":2.23606797749979}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"69":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"d":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"70":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":2,"docs":{"65":{"tf":1.0},"70":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"3":{"tf":1.0}}}},"t":{"df":7,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":2.0},"57":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"14":{"tf":1.0},"18":{"tf":1.0},"45":{"tf":1.0},"62":{"tf":1.0},"74":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"61":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"51":{"tf":1.0},"57":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"37":{"tf":1.0},"58":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.4142135623730951}}}},"w":{"df":1,"docs":{"58":{"tf":2.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"68":{"tf":1.4142135623730951},"69":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"18":{"tf":1.0},"26":{"tf":1.0},"68":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"24":{"tf":1.0},"61":{"tf":1.0},"77":{"tf":1.0}},"i":{"df":2,"docs":{"61":{"tf":1.0},"87":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"24":{"tf":1.4142135623730951},"30":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":1.0},"49":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"86":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"1":{"tf":1.0},"26":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"58":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"48":{"tf":1.0},"57":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951}}}},"v":{"df":1,"docs":{"1":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"1":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":2.449489742783178}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"26":{"tf":1.0},"56":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"87":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"37":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":5,"docs":{"12":{"tf":1.0},"52":{"tf":1.0},"57":{"tf":1.0},"70":{"tf":1.4142135623730951},"77":{"tf":1.0}},"i":{"df":5,"docs":{"12":{"tf":1.0},"20":{"tf":1.0},"44":{"tf":1.0},"52":{"tf":1.0},"87":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":4,"docs":{"13":{"tf":1.0},"19":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"{":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"1":{"tf":1.0},"20":{"tf":1.4142135623730951},"39":{"tf":1.0},"73":{"tf":1.0}}}},"l":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"38":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"26":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":10,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"30":{"tf":2.0},"55":{"tf":1.0},"6":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"66":{"tf":1.0},"7":{"tf":1.0},"87":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"65":{"tf":1.0},"68":{"tf":1.0}}}}}}},"i":{"c":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"df":1,"docs":{"10":{"tf":1.0}}}},"d":{"'":{"df":1,"docs":{"48":{"tf":1.0}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"74":{"tf":1.4142135623730951}}},"y":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"x":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"a":{"df":0,"docs":{},"r":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"5":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":3,"docs":{"26":{"tf":1.7320508075688772},"50":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":5,"docs":{"18":{"tf":1.0},"26":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":13,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"67":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"62":{"tf":1.0},"78":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"26":{"tf":1.0},"30":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":2,"docs":{"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"72":{"tf":1.4142135623730951},"73":{"tf":2.6457513110645907},"74":{"tf":1.4142135623730951},"77":{"tf":2.23606797749979}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"30":{"tf":1.7320508075688772},"48":{"tf":1.0},"51":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":6,"docs":{"24":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"28":{"tf":2.23606797749979},"29":{"tf":2.23606797749979},"30":{"tf":2.0},"50":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"76":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"l":{"df":3,"docs":{"48":{"tf":1.0},"68":{"tf":1.0},"73":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":12,"docs":{"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"30":{"tf":1.0},"48":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"8":{"tf":1.0},"87":{"tf":1.4142135623730951}}}},"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"13":{"tf":1.7320508075688772},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"8":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":14,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"32":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"23":{"tf":1.0},"30":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":9,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.7320508075688772},"55":{"tf":1.0},"57":{"tf":1.0},"6":{"tf":1.0},"87":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"14":{"tf":1.0},"48":{"tf":1.0},"58":{"tf":1.0},"88":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"73":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"56":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":1,"docs":{"56":{"tf":1.0}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"n":{"c":{"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":17,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.7320508075688772},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.4142135623730951},"77":{"tf":2.6457513110645907},"78":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":13,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"22":{"tf":1.7320508075688772},"23":{"tf":1.0},"24":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}}}}}}},"t":{".":{"0":{"df":1,"docs":{"69":{"tf":1.7320508075688772}}},"1":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}},"a":{"b":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}}},"k":{"df":0,"docs":{},"e":{"df":8,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.6457513110645907},"58":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"25":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":2.449489742783178},"44":{"tf":2.0},"57":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"69":{"tf":3.4641016151377544}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"13":{"tf":1.0},"16":{"tf":1.0},"58":{"tf":2.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":2.449489742783178},"26":{"tf":1.0},"5":{"tf":1.0},"57":{"tf":1.0},"70":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"5":{"tf":1.0}}}},"t":{"'":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"21":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"52":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":6,"docs":{"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.0},"51":{"tf":1.0},"8":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"37":{"tf":1.4142135623730951},"66":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"11":{"tf":1.0},"24":{"tf":1.4142135623730951},"65":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":12,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":1.4142135623730951},"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"30":{"tf":1.0},"48":{"tf":1.0},"57":{"tf":1.4142135623730951},"61":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"26":{"tf":1.0},"77":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"70":{"tf":1.0}}}}}},"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"70":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":1,"docs":{"48":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"50":{"tf":1.0},"84":{"tf":1.0}}}}}}},"u":{"df":1,"docs":{"52":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":14,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"87":{"tf":1.0}}}},"p":{"df":1,"docs":{"10":{"tf":1.0}}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"19":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"15":{"tf":2.0},"76":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"18":{"tf":1.0},"26":{"tf":1.4142135623730951},"3":{"tf":2.0},"5":{"tf":1.0},"56":{"tf":1.0}}}},"p":{"df":7,"docs":{"13":{"tf":1.4142135623730951},"20":{"tf":1.0},"30":{"tf":1.4142135623730951},"55":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"39":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{">":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":18,"docs":{"31":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":2.0},"37":{"tf":5.0990195135927845},"47":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":4.242640687119285},"51":{"tf":1.7320508075688772},"52":{"tf":2.6457513110645907},"6":{"tf":1.0},"61":{"tf":2.449489742783178},"65":{"tf":1.0},"67":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":3.0},"82":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":2.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"57":{"tf":1.0},"58":{"tf":2.6457513110645907},"78":{"tf":1.0}}}},"i":{"df":6,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":2.0},"57":{"tf":1.0},"66":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"10":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.0},"74":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"47":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":2,"docs":{"50":{"tf":1.0},"52":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":3,"docs":{"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"25":{"tf":1.0},"37":{"tf":1.0},"50":{"tf":1.0},"77":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"57":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":7,"docs":{"26":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.4142135623730951},"67":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":4,"docs":{"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":2.0},"61":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"66":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"3":{"2":{">":{">":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}},"8":{"df":3,"docs":{"33":{"tf":1.4142135623730951},"62":{"tf":1.7320508075688772},"83":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"2":{"tf":1.0},"38":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"27":{"tf":1.0},"48":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"14":{"tf":1.0},"49":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"56":{"tf":1.0},"57":{"tf":1.7320508075688772},"58":{"tf":2.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":1,"docs":{"57":{"tf":1.0}},"i":{"df":2,"docs":{"30":{"tf":1.0},"57":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"1":{"tf":1.0},"26":{"tf":1.4142135623730951},"57":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"50":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"30":{"tf":1.0},"61":{"tf":1.4142135623730951},"77":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"19":{"tf":1.0},"7":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"14":{"tf":1.0},"16":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"57":{"tf":1.4142135623730951},"7":{"tf":2.0},"74":{"tf":1.0}}}},"df":0,"docs":{}},"df":4,"docs":{"17":{"tf":1.0},"24":{"tf":1.0},"45":{"tf":1.0},"6":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":3,"docs":{"3":{"tf":1.0},"5":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"86":{"tf":1.0}}}},"df":45,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":1.7320508075688772},"11":{"tf":2.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"14":{"tf":2.23606797749979},"15":{"tf":1.7320508075688772},"16":{"tf":1.7320508075688772},"18":{"tf":2.8284271247461903},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":4.123105625617661},"27":{"tf":1.0},"28":{"tf":1.7320508075688772},"3":{"tf":1.0},"30":{"tf":4.0},"32":{"tf":1.0},"37":{"tf":2.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":2.0},"58":{"tf":2.449489742783178},"6":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":2.0},"67":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.7320508075688772},"72":{"tf":2.0},"73":{"tf":1.4142135623730951},"74":{"tf":2.23606797749979},"77":{"tf":1.0},"8":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"87":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"7":{"tf":1.0}}},"df":1,"docs":{"50":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"12":{"tf":1.0},"26":{"tf":2.23606797749979},"56":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"0":{".":{"1":{".":{"0":{"df":1,"docs":{"58":{"tf":2.23606797749979}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"1":{"6":{"df":2,"docs":{"56":{"tf":1.0},"58":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}}}}},".":{"1":{".":{"3":{"df":1,"docs":{"56":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"(":{"df":1,"docs":{"30":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"14":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":8,"docs":{"4":{"tf":1.0},"50":{"tf":1.0},"62":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":2.23606797749979},"7":{"tf":1.0},"70":{"tf":2.0},"83":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":10,"docs":{"1":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"68":{"tf":1.0},"69":{"tf":2.0},"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"15":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"!":{"[":{"0":{"df":1,"docs":{"69":{"tf":2.0}}},"2":{"2":{"df":1,"docs":{"67":{"tf":1.0}}},"3":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"3":{"2":{">":{">":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"u":{"3":{"2":{"df":1,"docs":{"51":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"20":{"tf":1.0},"26":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"10":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":11,"docs":{"1":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.4142135623730951},"45":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":2.0},"8":{"tf":1.0}}}}},"u":{"df":1,"docs":{"50":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"a":{"df":2,"docs":{"26":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0},"26":{"tf":1.0},"55":{"tf":1.0},"78":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"_":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"2":{"0":{"2":{"1":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":15,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"62":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"8":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.4142135623730951}},"s":{"=":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":13,"docs":{"0":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"30":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":1.0},"55":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"df":3,"docs":{"19":{"tf":1.0},"50":{"tf":1.4142135623730951},"58":{"tf":1.0}}},"v":{"df":4,"docs":{"49":{"tf":1.0},"57":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0}}}},"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"26":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":1,"docs":{"13":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":4,"docs":{"62":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.0},"88":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"15":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"52":{"tf":1.0},"65":{"tf":1.0},"70":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"87":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":8,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"24":{"tf":1.0},"57":{"tf":1.0},"66":{"tf":1.0},"70":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"28":{"tf":1.0},"57":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.4142135623730951},"26":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"1":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"df":23,"docs":{"10":{"tf":2.0},"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":2.23606797749979},"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"30":{"tf":2.0},"5":{"tf":1.0},"50":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"7":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":2,"docs":{"12":{"tf":1.7320508075688772},"55":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"d":{"df":3,"docs":{"57":{"tf":1.0},"68":{"tf":1.0},"77":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"d":{"'":{"df":0,"docs":{},"v":{"df":2,"docs":{"1":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"70":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":2.23606797749979}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":8,"docs":{"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"26":{"tf":1.0},"39":{"tf":1.0},"55":{"tf":1.0},"77":{"tf":1.0},"87":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"19":{"tf":1.0},"7":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"74":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"x":{"'":{"df":1,"docs":{"72":{"tf":1.0}}},".":{"0":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"48":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":6,"docs":{"28":{"tf":2.0},"62":{"tf":2.23606797749979},"67":{"tf":1.7320508075688772},"68":{"tf":2.8284271247461903},"70":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}},"y":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":3,"docs":{"26":{"tf":1.0},"4":{"tf":1.0},"49":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":7,"docs":{"14":{"tf":1.0},"20":{"tf":1.0},"26":{"tf":1.0},"30":{"tf":1.4142135623730951},"7":{"tf":1.0},"74":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"r":{"df":2,"docs":{"26":{"tf":1.0},"8":{"tf":1.0}}},"v":{"df":2,"docs":{"26":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}}},"z":{"df":2,"docs":{"77":{"tf":1.0},"78":{"tf":1.0}}}}},"title":{"root":{"2":{"0":{"1":{"5":{"df":1,"docs":{"20":{"tf":1.0}}},"8":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"d":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"57":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":3,"docs":{"18":{"tf":1.0},"43":{"tf":1.0},"53":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"22":{"tf":1.0},"43":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"64":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":4,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":11,"docs":{"25":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"66":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0},"81":{"tf":1.0},"87":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"69":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"83":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"26":{"tf":1.0},"28":{"tf":1.0}}}}}}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"53":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.0},"70":{"tf":1.0}}}}}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"27":{"tf":1.0},"34":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"12":{"tf":1.0},"3":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":4,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"71":{"tf":1.0},"85":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":20,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"56":{"tf":1.0},"6":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"74":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"25":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"24":{"tf":1.0},"36":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}},"w":{"df":6,"docs":{"19":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"63":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"22":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"68":{"tf":1.0},"85":{"tf":1.0}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"12":{"tf":1.0},"18":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.0},"52":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"75":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"85":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"45":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"23":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.0}}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"75":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"31":{"tf":1.0},"37":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":2,"docs":{"30":{"tf":1.0},"8":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"68":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});