# Contributing

We'd love your help! Thanks for caring about the book.

## Licensing

This repository is under the same license as Rust itself, MIT/Apache2. You
can find the full text of each license in the `LICENSE-*` files in this
repository.

## Code of Conduct

The Rust project has [a code of conduct](http://rust-lang.org/conduct.html)
that governs all sub-projects, including this one. Please respect it!

## Review

Our [open pull requests][pulls] are new chapters or edits that we're
currently working on. We would love if you would read through those and make
comments for any suggestions or corrections!

[pulls]: https://github.com/rust-lang/book/pulls

## Help wanted

If you're looking for ways to help that don't involve large amounts of
reading or writing, check out the [open issues with the E-help-wanted
label][help-wanted]. These might be small fixes to the text Rust code,
frontend code, or shell scripts that would help us be more efficient or
enhance the book in some way!

[help-wanted]: https://github.com/rust-lang/book/issues?q=is%3Aopen+is%3Aissue+label%3AE-help-wanted

## Translations

We'd especially love help translating the second edition of the book! See the
[Translations] label to join in efforts that are currently in progress. Open
a new issue to start working on a new language! We're waiting on [mdbook
support] for multiple languages before we merge any in, but feel free to
start! The second edition is frozen and won't see major changes, so if 
you start with that, you won't have to redo work :)

[Translations]: https://github.com/rust-lang/book/issues?q=is%3Aopen+is%3Aissue+label%3ATranslations
[mdbook support]: https://github.com/azerupi/mdBook/issues/5

## Edition specific details

Each edition of the book may be taking contributions, but only of certain
kinds depending on the edition. Read on to learn the details!

### Contributing to the 2018 Edition

The 2018 is a "living" edition; it's not scheduled for in-print publication
at this time, and so is able to be updated at any time. We'd love pull
requests to fix issues with this edition, but we're not interested in
extremely large changes without discussing them first. If you'd like to make
a big change, please open an issue first! We'd hate for you to do some hard work
that we ultimately wouldn't accept.

## Contributing to the Second Edition

The second edition is completely frozen, and not accepting changes. It's
meant to be in sync with the print version available from No Starch
Press.

## Contributing to the First Edition

The first edition is completely frozen, and not accepting changes. It's
mostly kept around for history's sake.
