A `yield` clause was used in an `async` context.

Example of erroneous code:

```compile_fail
#![feature(generators)]

let generator = || {
    async {
        yield;
    }
};
```

Here, the `yield` keyword is used in an `async` block,
which is not yet supported.

To fix this error, you have to move `yield` out of the `async` block:

```
#![feature(generators)]

let generator = || {
    yield;
};
```
