/*
 * Decompiled with CFR 0.152.
 */
package com.sun.fastinfoset.runtime;

import com.sun.fastinfoset.runtime.MaskingClassLoader;
import com.sun.fastinfoset.runtime.ParallelWorldClassLoader;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class FastInfosetRuntime {
    private static List maskedPackages = Arrays.asList("com.sun.xml.fastinfoset.", "org.jvnet.fastinsfoset.");
    private static Map loaders = new HashMap();
    private static String sideDirectory;

    public static ClassLoader getClassLoader() {
        return FastInfosetRuntime.getClassLoader(FastInfosetRuntime.class.getClassLoader());
    }

    public static synchronized ClassLoader getClassLoader(ClassLoader parent) {
        ClassLoader child = (ClassLoader)loaders.get(parent);
        if (child != null) {
            return child;
        }
        if (sideDirectory == null) {
            Properties p = new Properties();
            InputStream is = parent.getResourceAsStream("com/sun/fastinfoset/runtime/runtime.properties");
            if (is != null) {
                try {
                    p.load(is);
                    sideDirectory = p.getProperty("sideDirectory");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (sideDirectory == null) {
                sideDirectory = "";
            }
        }
        child = sideDirectory.length() > 0 ? new ParallelWorldClassLoader(new MaskingClassLoader(parent, maskedPackages), sideDirectory) : parent;
        loaders.put(parent, child);
        return child;
    }

    private FastInfosetRuntime() {
    }
}

