/*
 * Decompiled with CFR 0.152.
 */
package com.sun.fastinfoset.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

final class MaskingClassLoader
extends ClassLoader {
    private final String[] prefixList;

    public MaskingClassLoader(ClassLoader parent, List prefixList) {
        super(parent);
        this.prefixList = prefixList.toArray(new String[prefixList.size()]);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.matchesPrefix(name)) {
            throw new ClassNotFoundException();
        }
        return super.loadClass(name, resolve);
    }

    public URL getResource(String name) {
        if (this.matchesPrefix(name)) {
            return null;
        }
        return super.getResource(name);
    }

    public Enumeration getResources(String name) throws IOException {
        if (this.matchesPrefix(name)) {
            return new Vector().elements();
        }
        return super.getResources(name);
    }

    private boolean matchesPrefix(String name) {
        for (int i = 0; i < this.prefixList.length; ++i) {
            String packprefix = this.prefixList[i];
            if (!name.startsWith(packprefix)) continue;
            return true;
        }
        return false;
    }
}

