/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wts.tools.mri;

import com.sun.wts.tools.mri.Artifact;
import com.sun.wts.tools.mri.CopyEx;
import com.sun.wts.tools.mri.DOMUtil;
import com.sun.wts.tools.mri.Pom;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Checksum;
import org.apache.tools.ant.types.FilterSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TaskImpl
extends Task {
    private String version;
    private File destdir;
    private final List filterSets = new ArrayList();
    private final List artifacts = new ArrayList();

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setVersion(String version) {
        if (version.startsWith("-")) {
            version = version.substring(1);
        }
        this.version = version;
    }

    public FilterSet createFilterSet() {
        FilterSet filterSet = new FilterSet();
        this.filterSets.add(filterSet);
        return filterSet;
    }

    public void addConfiguredArtifact(Artifact a) {
        this.artifacts.add(a);
    }

    public void execute() throws BuildException {
        if (this.artifacts.isEmpty()) {
            throw new BuildException("No <artifact> is given");
        }
        if (this.version == null) {
            throw new BuildException("No @version is given");
        }
        if (this.destdir == null) {
            throw new BuildException("No @destdir is given");
        }
        for (int i = 0; i < this.artifacts.size(); ++i) {
            Artifact a = (Artifact)this.artifacts.get(i);
            this.log("Importing " + a.getJar(), 2);
            Pom p = this.parsePom(a);
            File groupDir = new File(this.destdir, p.groupId);
            File jars = new File(groupDir, "jars");
            File poms = new File(groupDir, "poms");
            File srcs = new File(groupDir, "java-sources");
            jars.mkdirs();
            poms.mkdirs();
            srcs.mkdirs();
            File outJar = this.getMavenizedName(jars, p, ".jar");
            this.copy(outJar, a.getJar(), false);
            this.calcChecksum(outJar);
            File outPom = this.getMavenizedName(poms, p, ".pom");
            this.copy(outPom, a.getPom(), true);
            this.calcChecksum(outPom);
            if (a.getSrczip() == null) continue;
            File outSrc = this.getMavenizedName(srcs, p, "-sources.jar");
            this.copy(outSrc, a.getSrczip(), false);
            this.calcChecksum(outSrc);
        }
    }

    private Pom parsePom(Artifact a) {
        try {
            File tmp = File.createTempFile("mri", null);
            tmp.delete();
            this.copy(tmp, a.getPom(), true);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document dom = dbf.newDocumentBuilder().parse(tmp);
            Pom pom = new Pom(this.getElementText(dom, a, "groupId"), this.getElementText(dom, a, "artifactId"), this.getElementText(dom, a, "version"));
            tmp.delete();
            return pom;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (SAXException e) {
            throw new BuildException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String getElementText(Document dom, Artifact a, String elementName) {
        Element e = DOMUtil.getFirstChild(dom.getDocumentElement(), elementName);
        if (e == null) {
            throw new BuildException(a.getPom() + " doesn't contain " + elementName);
        }
        return DOMUtil.getElementText(e);
    }

    private void copy(File dst, File src, boolean filter) {
        CopyEx cp = new CopyEx();
        cp.setTaskName(this.getTaskName());
        cp.setProject(this.getProject());
        cp.setTofile(dst);
        cp.setFile(src);
        if (filter) {
            cp.getFilterSets().addAll(this.filterSets);
            FilterSet fs = new FilterSet();
            fs.addFilter("VERSION", this.version);
            cp.getFilterSets().add(fs);
        }
        cp.execute();
    }

    private void calcChecksum(File f) {
        Checksum md5 = new Checksum();
        md5.setTaskName(this.getTaskName());
        md5.setProject(this.getProject());
        md5.setAlgorithm("md5");
        md5.setFile(f);
        md5.execute();
    }

    private File getMavenizedName(File dstDir, Pom pom, String extension) {
        return new File(dstDir, pom.artifactId + '-' + pom.version + extension);
    }
}

