#ifndef __VSCAN_ANTIVIR_H_
#define __VSCAN_ANTIVIR_H_

#include "vscan-global.h"

/* Configuration Section :-) */

/* default location of samba-style configuration file (needs Samba >= 2.2.4
 or Samba 3.0 */

#define PARAMCONF "/etc/samba/vscan-antivir.conf"

/* H+BEDV AntiVir related stuff */
/* program name for scanner process */
#define VSCAN_ANTIVIR_PROGRAM_NAME	"/usr/lib/AntiVir/antivir"

/* enable scan in archive files */
#define VSCAN_AVARCH_ENABLED		0
/* maximum compression ratio of files in archive */
#define VSCAN_AVARCH_MAXRATIO		150
/* maximum archived file size (in bytes) */
#define VSCAN_AVARCH_MAXFILESIZE	(1024 * 1048576)
/* maximum recursion level */
#define VSCAN_AVARCH_MAXRECLEVEL	5

/* non virus types of alerts (all off by default) */
#define VSCAN_AVDETECT_DIALER		0
#define VSCAN_AVDETECT_GAME		0
#define VSCAN_AVDETECT_JOKE		0
#define VSCAN_AVDETECT_PMS		0
#define VSCAN_AVDETECT_SPY		0
#define VSCAN_AVDETECT_ALLTYPES		0

/* End Configuration Section */

/* functions by vscan-antivir_core */

/* user connects to a share (might startup scanner daemon) */
int vscan_antivir_connect(void);

/* prepare a scan (might open a socket) */
int vscan_antivir_init(void);

/* scan a file */
int vscan_antivir_scanfile(int sockfd, char *scan_file, char *client_ip);

/* end a scan (might close a socket) */
void vscan_antivir_end(int sockfd);

/* user disconnects from a share (might shutdown scanner daemon) */
void vscan_antivir_disconnect(void);


#endif /* __VSCAN_ANTIVIR_H_ */
