/*
 *  $Id: vscan-fsav.h,v 1.1.2.3 2004/09/29 13:59:03 reniar Exp $
 *
 * Virusscanning VFS module for samba.
 * Log infected files via syslog
 * facility and block access using fsecure antivirus
 *
 * Copyright (C) Monex AG  Oliver Jehle, 2003
 *
 * based on the existing  F-PROT module by
 * Copyright (C) Rainer Link, 2001-2003
 * Copyright (C) Stefan (metze) Metzmacher, 2003
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __VSCAN_FSAV_H_
#define __VSCAN_FSAV_H_

#include "vscan-global.h"

#include "vscan-fsav_core.h"

#define VSCAN_MODULE_STR "vscan-fsav"


/* configuration section */

/* default location of samba-style configuration file (needs Samba >= 2.2.4 or Samba 3.0 */

#define PARAMCONF "/etc/samba/vscan-fsav.conf"

/* FSAV-related settings */

/* should fsavd started for each user */
#define VSAN_FSAV_USERINSTANCE False

/* the uid fsavd is running. Normally 0 as fsavd runs as root. Should be -1
   if fsavd is started for each user */
#define VSCAN_FSAV_CONNECT_ID 0

/* fsav configuration file */
#define VSCAN_FSAV_CONFIG_FILE "/etc/fsav.conf"

/* location of fsavd binary */
#define VSCAN_FSAV_BINARY "/opt/f-secure/fsav/bin/fsavd"

/* path to FSAV databases */
#define VSCAN_FSAV_DB_DIR "/var/opt/f-secure/fsav/databases"

/* fsav socket name */
#define VSCAN_FSAV_SOCKET "/tmp/.fsav-0"

/* scan inside archives */
#define VSCAN_FSAV_ARCHIVE_SCAN True

/* scan mime */
#define VSCAN_FSAV_MINE_SCAN True

/* scan depth in archives */
#define VSCAN_FSAV_MAX_NESTED_LEVEL 5

/* scan timeout, 0 = no timeout */
#define VSCAN_FSAV_TIMEOUT 0


/* end configuration section */


#endif /* __VSCAN_FSAV_H */
