#ifndef __VSCAN_OAV_H_
#define __VSCAN_OAV_H_

#include "vscan-global.h"

/* default location of samba-style configuration file (needs Samba >= 2.2.4
 or Samba 3.0 */

#define PARAMCONF "/etc/samba/vscan-oav.conf"

/* IP:PORT OAV ScannerDaemon listens on */
#define VSCAN_OAV_IP	"127.0.0.1"
#define VSCAN_OAV_PORT 	8127

/* End Configuration Section */

#ifndef MAXLINE
 #define MAXLINE 4096
#endif


/* functions by vscan-oav_core */
/* opens a socket */
int vscan_oav_init(const char* oav_ip, const unsigned short int oav_port); 
/* scans a file */
int vscan_oav_scanfile(int sockfd, char *scan_file, char* client_ip);
/* closes socket */
void vscan_oav_end(int sockfd);


#endif /* __VSCAN_OAV_H_ */
