#ifndef __VSCAN_FPROTD_H_
#define __VSCAN_FPROTD_H_

#include "vscan-global.h"


/* default location of samba-style configuration file (needs Samba >= 2.2.4
 or Samba 3.0 */

#define PARAMCONF "/etc/samba/vscan-fprotd.conf"

/* IP:PORT F-Prot Daemon listens on */
#define VSCAN_FPROTD_IP		"127.0.0.1"
#define VSCAN_FPROTD_PORT 	"10200;10201;10202;10203;10204"	

/* Arguments to F-Prot Daemon as for F-Prot command line scanner
   Important: white space has to be written as %20 */
#define VSCAN_FPROTD_ARGS	"-dumb%20-archive"

/* End Configuration Section */



#ifndef MAXLINE
 #define MAXLINE 4096
#endif

/* functions by vscan-fprotd_core */
/* opens a socket */
int vscan_fprotd_init(void); 
/* scans a file */
int vscan_fprotd_scanfile(int sockfd, char *scan_file, char* client_ip);
/* closes socket */
void vscan_fprotd_end(int sockfd);


#endif /* __VSCAN_FPROTD_H_ */
