#ifndef __VSCAN_ICAP_H_
#define __VSCAN_ICAP_H_

#include "vscan-global.h"

/* Configuration Section :-) */

/* default location of samba-style configuration file (needs Samba >= 2.2.4
 or Samba 3.0 */

#define PARAMCONF "/etc/samba/vscan-icap.conf"

/* IP:PORT ICAP server listens on */
#define VSCAN_ICAP_IP    "127.0.0.1"
#define VSCAN_ICAP_PORT  1344


/* End Configuration Section */

/* functions by vscan-icap_core */
/* connect to ICAP server */
int vscan_icap_init(void);
/* scans a file */
int vscan_icap_scanfile(int sockfd, char *scan_file, char *client_ip);
/* close connection */
void vscan_icap_end(int sockfd);


#endif /* __VSCAN_ICAP_H_ */
