/* 
 * $Id: mcDaemon.c,v 1.1.2.3 2004/04/03 11:57:21 reniar Exp $
 *
 * Daemon which implements a on-demand scanning facility by using McAfee
 * Virus Scanner for the samba-vscan-mcdaemon module.
 *
 * Copyleft (C), 2003
 * Arturo 'Buanzo' Busleiman <buanzo@buanzo.com.ar>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <signal.h>

int num_mcd = 0;
int howmany = 0;
char virusname[1024] = "";
#define YES_VIRUS 13
#define NO_VIRUS 0

/* puerto al que se conecta el modulo samba-vscan-mcafee */
#define PUERTO 8128

/* cantidad de uvscan preforkeados */
#define NUM_PREFORK 1


/* tamanio del paquete - deberia ser 5+1+(pathname_length)
 segun el kernel, el maximo tamanio de path es 4095 chars.
 es un limite global. 4095+1+5=4101 -> 4224 (128*33 ya que 128*32=4096)
*/
#define TAMPKT 4224

/* comando UVSCAN completo
 chequear manpage uvscan para mas data
 a este string se le pega el nombre del pipe que corresponda
*/
#define CMD_UVSCAN "/usr/local/bin/uvscan --afc 64 --noboot --noexpire -p --secure -f"

struct Sdesc
{
  pid_t pid;
  int libre;
} sdesc[64];

struct Tpdesc
{
  FILE *pipe_fp;
  FILE *cmd_fp;
} pdesc;

void
crear_pipe (int cual)
{
  char filnam[255] = "";
  static int ya_creado = 0;
  if (ya_creado)
    return;
  umask (0);
  snprintf (filnam, sizeof (filnam) - 1, "/var/spool/mcdaemon/MD_%d", cual);
  unlink (filnam);
  mknod (filnam, S_IFIFO | 0660, 0);
  ya_creado = 1;
}

void
open_uvscan (int z)
{
  int cmdf2;
  char filnam[255] = "";

  snprintf (filnam, sizeof (filnam) - 1, "%s/var/spool/mcdaemon/MD_%d",
	    CMD_UVSCAN, z);

  if ((pdesc.pipe_fp = popen (filnam, "r")) == NULL)
    {
      perror ("popen");
      exit (1);
    }
  snprintf (filnam, sizeof (filnam) - 1, "/var/spool/mcdaemon/MD_%d", z);
  cmdf2 = open (filnam, O_WRONLY);
  fcntl (cmdf2, F_SETFD, O_NONBLOCK);
  pdesc.cmd_fp = fdopen (cmdf2, "w");

}

int
mcafee_scan (char *reqf, int pidx)
{
  char linea1[5000] = "";
  printf ("[%d] Scanning '%s'\n", pidx, reqf);
  fprintf (pdesc.cmd_fp, "%s\n", reqf);
  fclose (pdesc.cmd_fp);
  linea1[0] = 0;
  fgets ((char *) &linea1, sizeof (linea1) - 1, pdesc.pipe_fp);
  linea1[strlen (linea1) - 1] = 0;
  if ((strlen (linea1) != 0)
      && (strncmp ("No file or directory found matching", linea1, 35) != 0))
    {
      strcpy (virusname, "");
      fgets ((char *) &virusname, sizeof (virusname) - 1, pdesc.pipe_fp);
      virusname[strlen (virusname) - 1] = 0;
      pclose (pdesc.pipe_fp);
      return (YES_VIRUS);
    }
  pclose (pdesc.pipe_fp);
  return (NO_VIRUS);
}

int
procesar_solicitud (char *req, int pidx)
{

  if (strlen (req) >= 5)
    if (index (req, ';') == NULL)
      if (strncmp ("SCAN ", req, 5) == 0)
	{
	  req += 5;
	  return (mcafee_scan (req, pidx));
	}
  return (YES_VIRUS + NO_VIRUS + 1);
}

int
reenviar_solicitud (char *reqf, int puertofeliz)
{
  int i = 0;
  int q_estado = 0;
  int csoq, cbytes = 0;
  char buf2[TAMPKT] = "";
  struct hostent *che;
  struct sockaddr_in csu_addr;
#ifdef DEBUG
  printf ("\n[%d] IN reenviar_solicitud ('%s')\n", getpid (), reqf);
#endif
  if ((che = gethostbyname ("localhost")) == NULL)
    {
      perror ("gethostbyname");
      exit (1);
    }
  if ((csoq = socket (AF_INET, SOCK_STREAM, 0)) == -1)
    {
      perror ("socket");
      exit (1);
    }

#ifdef DEBUG
  printf ("[%d] conectando al sock '%d'\n", getpid (), puertofeliz);
#endif
  csu_addr.sin_port = htons (puertofeliz);
  csu_addr.sin_family = AF_INET;
  csu_addr.sin_addr = *((struct in_addr *) che->h_addr);
  memset (&(csu_addr.sin_zero), 0, 8);
  if (connect
      (csoq, (struct sockaddr *) &csu_addr, sizeof (struct sockaddr)) == -1)
    {
      return (YES_VIRUS + NO_VIRUS + 1);
    }
#ifdef DEBUG
  else
    printf ("CONECCION LOGRADA\n");
#endif

  if ((cbytes = send (csoq, reqf, strlen (reqf), 0)) == -1)
    {
      perror ("send");
      exit (1);
    }
  for (i = sizeof (buf2); i > -1; i--)
    buf2[i] = 0;
  while ((cbytes = recv (csoq, buf2, sizeof (buf2), 0)) < 0);
  buf2[cbytes] = '\0';
  close (csoq);
  if (strncmp ("FOUND: ", buf2, 7) == 0)
    {
      q_estado = YES_VIRUS;
      strcpy (virusname, "              ");
      strcat (virusname, buf2 + 7);
    }
  else
    q_estado = NO_VIRUS;
#ifdef DEBUG
  printf ("[MASTER] BUF2 = '%s'\n", buf2);
  printf ("[MASTER] Virusname = '%s'\n", virusname);
#endif
  return q_estado;
}

void
sigchld_handler (int s)
{
  pid_t chpid;
  int ww = 0;
  chpid = wait (NULL);
#ifdef DEBUG
  printf ("EL HIJO %d HA MUERTO\n", chpid);
#endif
  for (ww = 1; ww < (num_mcd + 1); ww++)
    if (sdesc[ww].pid == chpid)
      {
	sdesc[ww].libre = 1;
	break;
      }
#ifdef DEBUG
  printf ("------- Se ha liberado el puerto %d\n", PUERTO + (3 * ww));
#endif

}

int
lock_puerto ()
{
  int wwp = 0;
  for (;;)
    {
      for (wwp = 1; wwp < (num_mcd + 1); wwp++)
	if (sdesc[wwp].libre)
	  {
	    sdesc[wwp].libre = 0;
	    return (PUERTO + (3 * wwp));
	  }
      usleep (150);
    }
}

int
main (int argc, char **argv)
{
  int this_is_master = 0;
  int my_number = 0;
  int freeport = 0;
  int soq, nsoq;		/* soq: new incoming conn. nsoq: client socket */
  struct sigaction sa;
  unsigned int sin_size;
  struct sockaddr_in my_addr;
  struct sockaddr_in his_addr;
  int numbytes = 0;
  int yes = 1;
  int i = 0;
  int estado = 0;
  char buf[TAMPKT] = "";
  pid_t cpid = 0;
  int real_fork = 0;
  int backlog = 0;
  if (getenv ("NUM_MCD") == NULL)
    {
      printf ("McDaemon is not configured.\n");
      printf ("Please configure maximum number of daemons via env var NUM_MCD.\n");
      exit (254);
    }
  if ((num_mcd = atoi (getenv ("NUM_MCD"))) < 1)
    {
      printf ("McDaemon is not correctly configured \n");
      printf ("Please set the environment variable NUM_MCD ");
      printf ("greather than 0.\n");
      exit (254);
    }
  if (num_mcd > 64)
    {
      printf ("McDaemon configured via NUM_MCD greater than 64.\n");
      printf ("It's not permitted to use more than 64 daemons.\n");
      exit (64);
    }
  for (i = 1; i < (num_mcd + 1); i++)
    sdesc[i].libre = 1;
  if (argc == 2)
    {
      if ((my_number = atoi (argv[1])) == 0)
	this_is_master = 1;
    }
  else
    {
      printf ("Usuage: %s <number>\n", argv[0]);
      printf ("<number> indicates number of maximum processes.\n");
      printf ("Number of processes must be at least one and not greater than 64\n");
      exit (255);
    }

  if ((soq = socket (AF_INET, SOCK_STREAM, 0)) == -1)
    {
      perror ("socket");
      exit (1);
    }

  if (setsockopt (soq, SOL_SOCKET, SO_REUSEADDR, &yes, sizeof (int)) == -1)
    perror ("setsockopt");
  my_addr.sin_family = AF_INET;
  my_addr.sin_port = htons (PUERTO + (my_number * 3));
  my_addr.sin_addr.s_addr = INADDR_ANY;
  memset (&(my_addr.sin_zero), '\0', 8);
  if (bind
      (soq, (struct sockaddr *) &my_addr, sizeof (struct sockaddr)) == -1)
    {
      perror ("bind");
      exit (1);
    }

  if (this_is_master)
    backlog = num_mcd;
  else
    backlog = 1;

  if (listen (soq, backlog) == -1)
    {
      perror ("listen");
      exit (1);
    }
  if (this_is_master)
    {
      sa.sa_handler = sigchld_handler;
      sigemptyset (&sa.sa_mask);
      sa.sa_flags = SA_RESTART;
      if (sigaction (SIGCHLD, &sa, NULL) == -1)
	{
	  perror ("sigaction");
	  exit (1);
	}
    }
/* FIN CODIGO PRE ACCEPT */

  while (1)
    {
      if (my_number > 0)
	{
	  crear_pipe (my_number);
	  open_uvscan (my_number);
	}
      sin_size = sizeof (struct sockaddr_in);
      if ((nsoq =
	   accept (soq, (struct sockaddr *) &his_addr, &sin_size)) == -1)
	{
	  perror ("accept");
	  continue;
	}
      if (this_is_master)
	{
	  real_fork = 1;
	  freeport = lock_puerto ();
#ifdef DEBUG
	  printf ("MASTER ha asignado el puerto '%d'\n", freeport);
#endif
	  cpid = fork ();
	}			/* si cpid == 0 -> hijo */
      else
	{
	  real_fork = 0;
	  cpid = 0;
	}
      if (cpid > 0)
	sdesc[(freeport - 8128) / 3].pid = cpid;
      if (cpid == 0)
	{
	  if (real_fork)
	    close (soq);
	  for (i = TAMPKT; i > -1; i--)
	    buf[i] = 0;
	  if ((numbytes = recv (nsoq, buf, TAMPKT - 1, 0)) == -1)
	    {
	      perror ("recv");
	      exit (1);
	    }

	  for (i = numbytes; i > 0; i--)
	    if (buf[i] == '\n' || buf[i] == '\r')
	      buf[i] = 0;

	  if (this_is_master)
	    estado = reenviar_solicitud (buf, freeport);
	  else
	    estado = procesar_solicitud (buf, my_number);

	  switch (estado)
	    {
	    case YES_VIRUS:
	      {
		char msg[TAMPKT - 1] = "FOUND: ";
		strcat (msg, virusname + 14);
		send (nsoq, msg, strlen (msg), 0);
		break;
	      }
	    case NO_VIRUS:
	      {
		char *msg = "OK\n";
		send (nsoq, msg, strlen (msg), 0);
		break;
	      }
	    default:
	      {
		char *msg = "ERROR\n";
		send (nsoq, msg, strlen (msg), 0);
		break;
	      }
	    }
	  close (nsoq);
	  if (real_fork)
	    exit (0);
	}
      close (nsoq);
    }

  return 0;

}
