/*
 * $Id: vscan-mcdaemon_core.c,v 1.1.2.6 2005/08/18 13:36:23 reniar Exp $
 * 
 * Core Interface for McAfee Virus Scanner via McDaemon			
 *
 * Copyleft (C) Arturo 'Buanzo' Busleiman, 2003
 *              Arturo 'Buanzo' Busleiman <buanzo@buanzo.com.ar>
 *              Rainer Link, 2003-2004
 *		Rainer Link <rainer@openantivirus.org>
 *
 * This software is licensed under the GNU General Public License (GPL)
 * See: http://www.gnu.org/copyleft/gpl.html
 *
*/

#include "vscan-mcdaemon_core.h"
#include "vscan-global.h"

/* hum, global vars ... */
extern BOOL verbose_file_logging;
extern BOOL send_warning_message;
extern fstring  mcdaemon_ip;
extern unsigned short int mcdaemon_port;


/* initialise socket to McDaemon
   returns -1 on error or the socket descriptor */
int vscan_mcdaemon_init(void)
{

	return vscan_inet_socket_init("mcdaemon", mcdaemon_ip, mcdaemon_port); 

}

/*
  If virus is found, logs the filename/virusname into syslog
*/
void vscan_mcdaemon_log_virus(char *infected_file, char *result, char* client_ip)
{
        char *str;
        size_t len;

        /* remove "FOUND: " from the result string to get only the virus name */

	len = strlen(result);
        /* sanity check ... */
        if ( len < 7 ) {
            /* hum, sth went wrong ... */
            vscan_syslog_alert("ALERT - Scan result: '%s' infected with virus 'UNKOWN', client: '%s'", infected_file, client_ip);
	    if ( send_warning_message )
		vscan_send_warning_message(infected_file, "UNKNOWN", client_ip);

        } else {
            str = result;
            str+= 7;
            vscan_syslog_alert("ALERT - Scan result: '%s' infected with virus '%s', client: '%s'", infected_file, str, client_ip);
	    if ( send_warning_message )
		vscan_send_warning_message(infected_file, str, client_ip);
        }
}



/*
  Scans a file (*FILE*, not a directory - keep that in mind) for a virus
  Expects socket descriptor and file name to scan for
  Returns -2 on a minor error, -1 on error, 0 if no virus was found, 
  1 if a virus was found 
*/
int vscan_mcdaemon_scanfile(int sockfd, char *scan_file, char* client_ip)
{
	size_t len;
	char recvline[MAXLINE + 1];
	pstring mcafeeCommand;

	FILE *fpin, *fpout;

	fpin = fdopen(sockfd, "r");
	if ( fpin == NULL ) {
		vscan_syslog("ERROR: can not open stream for reading - %s", strerror(errno));
		return VSCAN_SCAN_ERROR;
	}

	fpout = fdopen(sockfd, "w");
	if ( fpout == NULL ) {
		/* closing fpin */
		fclose(fpin);
		vscan_syslog("ERROR: can not open stream for writing - %s", strerror(errno));
		return VSCAN_SCAN_ERROR;
	}

	if ( verbose_file_logging )
	        vscan_syslog("INFO: Scanning file : '%s'", scan_file);

	/* McDaemon expects "SCAN <filename>\n" */
	/* what about if the <filename> itself contains '\n'? */
        pstrcpy(mcafeeCommand, "SCAN ");
        pstrcat(mcafeeCommand, scan_file);
        pstrcat(mcafeeCommand, "\n");

	/* NOTE: what happens if scan_file is very long? */

	/* write to socket-stream */
	if ( fputs(mcafeeCommand, fpout) == EOF) {
		vscan_syslog("ERROR: can not send file name to McDaemon!");
		/* closing streams */
		fclose(fpin);
		fclose(fpout);
		return VSCAN_SCAN_ERROR;
	}

	/* hum, instead of flush()ing, use setvbuf to set line-based buffering? */
	if ( fflush(fpout) == EOF ) {
		vscan_syslog("ERROR: can not flush output stream - %s", strerror(errno));
		/* FIXME: shouldn't we return -1 here? */
	}

	/* read from socket-stream */
	if ( fgets(recvline, MAXLINE, fpin) == NULL ) {
		vscan_syslog("ERROR: can not get result from McDaemon!");
		/* closing streams */
		fclose(fpin);
		fclose(fpout);
		return VSCAN_SCAN_ERROR;
	}

	/* closing streams */
	fclose(fpin);
	fclose(fpout);

	/* Response from McDaemon is either
	   - OK                  file scanned and not infected
	   - FOUND: <virusname>  file scanned and infected
	   - ERROR		 sth went wrong, i.e. file not found
	*/
	if ( strncmp("FOUND", recvline, 5) == 0   ) {
		/* virus found */
		vscan_mcdaemon_log_virus(scan_file, recvline, client_ip);
		return VSCAN_SCAN_VIRUS_FOUND;
	} else if ( strncmp("ERROR", recvline, 5) == 0  ) {
		/* ERROR */
		if ( verbose_file_logging )
			vscan_syslog("ERROR: file %s not found, not readable or an error occured", scan_file);
		return VSCAN_SCAN_MINOR_ERROR;
	} else if ( strncmp("OK", recvline, 2) == 0 ) {
		/* OK */
		if ( verbose_file_logging )
			vscan_syslog("INFO: file %s is clean", scan_file);
        } else {
		/* unknown response */
		vscan_syslog("ERROR: unknown response from McDaemon while scanning %s!", scan_file);
		/* FIXME: should we really mark this as a minor error? */
		return VSCAN_SCAN_MINOR_ERROR;
	}	

	return VSCAN_SCAN_OK;
	
}

/*
  close socket
*/
void vscan_mcdaemon_end(int sockfd)
{

	vscan_socket_end(sockfd);

}
