#ifndef __VSCAN_SYMANTEC_H_
#define __VSCAN_SYMANTEC_H_

#include "vscan-global.h"

/* Configuration Section :-) */

/* default location of samba-style configuration file (needs Samba >= 2.2.4
 or Samba 3.0 */

#define PARAMCONF "/etc/samba/vscan-symantec.conf"

/* IP and port CarrierScan listens on */
static const char VSCAN_CS_IP_PORT[] = "127.0.0.1:7777";

/* End Configuration Section */

/* functions by vscan-symantec_core */
/* initialize CarrierScan API */
void vscan_symantec_init(void); 
/* scans a file */
int vscan_symantec_scanfile(char *scan_file, char *client_ip);
/* terminates CarrierScan API */
void vscan_symantec_end(void);


#endif /* __VSCAN_SYMANTEC_H_ */
