/*
 * generic wrapper.
 *
 * Copyright 1999-2008 Gentoo Foundation
 * Licensed under the GPL-2
 */

#ifndef WRAPPER_ARGS_PROTO
# error WRAPPER_ARGS_PROTO needs to be defined
#endif
#ifndef WRAPPER_RET_TYPE
# define WRAPPER_RET_TYPE int
#endif
#ifndef WRAPPER_RET_DEFAULT
# define WRAPPER_RET_DEFAULT -1
#endif
#ifndef WRAPPER_PRE_CHECKS
# define WRAPPER_PRE_CHECKS() true
#endif

extern WRAPPER_RET_TYPE EXTERN_NAME(WRAPPER_ARGS_PROTO);
static WRAPPER_RET_TYPE (*WRAPPER_TRUE_NAME)(WRAPPER_ARGS_PROTO) = NULL;

#ifndef SB_HIDDEN_FUNC
# define _SB_HIDDEN_FUNC(x) sb_unwrapped_##x
# define SB_HIDDEN_FUNC(x) _SB_HIDDEN_FUNC(x)
#endif
attribute_hidden
WRAPPER_RET_TYPE SB_HIDDEN_FUNC(WRAPPER_NAME)(WRAPPER_ARGS_PROTO)
{
	check_dlsym(WRAPPER_TRUE_NAME, WRAPPER_SYMNAME, WRAPPER_SYMVER);
	return WRAPPER_TRUE_NAME(WRAPPER_ARGS);
}

WRAPPER_RET_TYPE WRAPPER_NAME(WRAPPER_ARGS_PROTO)
{
	WRAPPER_RET_TYPE result = WRAPPER_RET_DEFAULT;

	if (WRAPPER_PRE_CHECKS())
		if (WRAPPER_SAFE())
			result = SB_HIDDEN_FUNC(WRAPPER_NAME)(WRAPPER_ARGS);

	return result;
}
