.TH sane-plustek 5 "27 October 2003" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane-plustek
.SH NAME
sane-plustek \- SANE backend for Plustek parallel port and
LM983[1/2/3] based USB flatbed scanners
.SH DESCRIPTION
The
.B sane-plustek
library implements a SANE (Scanner Access Now Easy) backend that
provides access to USB flatbed scanners based on National Semiconductor
Merlin chipsets (LM9831, 9832 and 9833).
If you're looking for parallel-port support for Plustek scanner
please refer to the
.B sane-plustek_pp
backend.

.SH "SUPPORTED DEVICES"
The Backend is able to support USB scanner based on the National
Semiconductor chipsets LM9831, LM9832 and LM9833. The following tables
show various devices which are currently reported to work. If your
Plustek scanner has another Product ID, then the device is
.B NOT
supported, as it contains an unsupported ASIC inside.
.br

Vendor Plustek - ID: 0x07B3
.br
----------------------------------------------------------
.br
USB Model:         ASIC:  Properties:              Prod-ID
.br
----------------------------------------------------------
.br
OpticPro U12       LM9831  600x1200dpi 42bit 512Kb 0x0010
.br
OpticPro UT12      LM9831  600x1200dpi 42bit 512Kb 0x0013
.br
OpticPro UT12      LM9832  600x1200dpi 42bit 512Kb 0x0017
.br
OpticPro UT16      LM9832  600x1200dpi 42bit 512Kb 0x0017
.br
OpticPro U24       LM9831 1200x2400dpi 42bit   2Mb 0x0011
.br
OpticPro U24       LM9832 1200x2400dpi 42bit   2Mb 0x0015
.br
OpticPro UT24      LM9832 1200x2400dpi 42bit   2Mb 0x0017
.PP

Vendor KYE/Genius - ID: 0x0458
.br
----------------------------------------------------------
.br
USB Model:         ASIC:  Properties:              Prod-ID
.br
----------------------------------------------------------
.br
Colorpage HR6 V2   LM9832  600x1200dpi 42bit 512Kb 0x2007
.br
Colorpage HR6 V2   LM9832  600x1200dpi 42bit 512Kb 0x2008
.br
Colorpage HR6A     LM9832  600x1200dpi 42bit 512Kb 0x2009
.br
Colorpage HR7      LM9832  600x1200dpi 42bit 512Kb 0x2013
.br
Colorpage HR7LE    LM9832  600x1200dpi 42bit 512Kb 0x2015
.br
Colorpage HR6X     LM9832  600x1200dpi 42bit 512Kb 0x2016
.PP

Vendor Hewlett-Packard - ID: 0x03F0
.br
----------------------------------------------------------
.br
USB Model:         ASIC:  Properties:              Prod-ID
.br
----------------------------------------------------------
.br
ScanJet 2100C      LM9831  600x1200dpi 42bit 512Kb 0x0505
.br
ScanJet 2200C      LM9832  600x1200dpi 42bit 512Kb 0x0605
.PP

Vendor Mustek - ID: 0x0400
.br
----------------------------------------------------------
.br
USB Model:         ASIC:  Properties:              Prod-ID
.br
----------------------------------------------------------
.br
BearPaw 1200       LM9831  600x1200dpi 42bit 512Kb 0x1000
.br
BearPaw 2400       LM9832 1200x2400dpi 42bit   2Mb 0x1001
.PP

Vendor UMAX - ID: 0x1606
.br
----------------------------------------------------------
.br
USB Model:         ASIC:  Properties:              Prod-ID
.br
----------------------------------------------------------
.br
UMAX 3400/3450     LM9832  600x1200dpi 42bit 512Kb 0x0060
.br
UMAX 5400          LM9832 1200x2400dpi 42bit 512Kb 0x0160
.PP

Vendor COMPAQ - ID: 0x049F
.br
----------------------------------------------------------
.br
USB Model:         ASIC:  Properties:              Prod-ID
.br
----------------------------------------------------------
.br
S4-100             LM9832  600x1200dpi 42bit 512Kb 0x001A
.PP

Vendor Epson - ID: 0x04B8
.br
----------------------------------------------------------
.br
USB Model:         ASIC:  Properties:              Prod-ID
.br
----------------------------------------------------------
.br
Perfection 1250    LM9832 1200x2400dpi 42bit 512Kb 0x010F
.br
Perfection 1260    LM9832 1200x2400dpi 42bit 512Kb 0x011D
.PP

Vendor CANON - ID: 0x04A9
.br
----------------------------------------------------------
.br
USB Model:         ASIC:  Properties:              Prod-ID
.br
----------------------------------------------------------
.br
CanoScan N650/656U LM9832  600x1200dpi 42bit 512Kb 0x2206
.br
CanoScan N1220U    LM9832 1200x2400dpi 42bit 512Kb 0x2207
.br
CanoScan N670/676U LM9833  600x1200dpi 48bit 512Kb 0x220D
.br
CanoScan N1240U    LM9833 1200x2400dpi 48bit 512Kb 0x220E
.br
CanoScan LIDE20    LM9833  600x1200dpi 48bit 512Kb 0x220D
.br
CanoScan LIDE30    LM9833 1200x2400dpi 48bit 512Kb 0x220E

.SH "OTHER PLUSTEK SCANNERS"
For parallelport device support see the
.B plustek_pp
backend.
.br
The SCSI scanner OpticPro 19200S is a rebadged Artec AM12S scanner
and is supported by the
.B Artec
backend.
.br
Only the National Semiconductor LM983[1/2/] based devices of Plustek
are supported by this driver. Older versions of the U12, the UT12,
the U1212 and U1248 (GrandTech chipset) are not supported.
.PP
Model    Chipset    backend
.br
---------------------------
.br
U1248    GrandTech  gt68xx
.br
UT16B    GrandTech  gt68xx

.SH "CONFIGURATION"
To use your scanner with this backend, you need at least two
entries in the configuration file
.br
.I @CONFIGDIR@/plustek.conf
.TP
.I [usb] vendor-id product-id
.TP
.I device /dev/usbscanner
.PP
.I [usb]
tells the backend, that the following devicename (here
.I /dev/usbscanner
) has to be interpreted as USB scanner device. If vendor- and
product-id has not been specified, the backend tries to
detect this by its own. If device ist set to
.I auto
 then the next matching device is used.
.PP
.B
The Options:
.PP
option warmup t
.RS
.I t
specifies the warmup period in seconds
.RE
.PP
option lampOff t
.RS
.I t
is the time in seconds for switching off the lamps in
standby mode
.RE
.PP
option lOffonEnd b
.RS
.I b
specifies the behaviour when closing the backend, 1 --> switch
lamps off, 0 --> do not change lamp status
.RE
.PP
option invertNegatives b
.RS
.I b
0 --> do not invert the picture during negativ scans,
1 --> invert picture
.RE
.PP
option cacheCalData b
.RS
.I b
0 --> do not save coarse calibration results,
1 --> save results of coarse calibration in ~/.sane/ directory
.RE
.PP
option altCalibration b
.RS
.I b
0 --> use standard calibration routines,
1 --> use alternate calibration (only non Plustek
.br
      devices, standard for CIS devices)
.RE
.PP
option skipFine b
.RS
.I b
0 --> perform fine calibration,
1 --> skip fine calibration (only non Plustek devices)
.RE
.PP
option skipFineWhite b
.RS
.I b
0 --> perform white fine calibration,
1 --> skip white fine calibration (only non Plustek devices)
.RE
.PP
option skipCalibration b
.RS
.I b
0 --> perform calibration,
1 --> skip calibration (only non Plustek devices)
.RE
.PP
option enableTPA b
.RS
.I b
0 --> default behaviour, specified by the internal tables,
1 --> override internal tables and allow TPA mode (EPSON only)
.RE

.PP
option posOffX x
.br
option posOffY y
.br
option tpaOffX x
.br
option tpaOffY y
.br
option negOffX x
.br
option negOffY y
.RS
.I x y
By using this settings, the user can adjust the given image
positions.
.B Please note, that there's no internal range checking for
.B this feature.
.RE
.PP
option posShadingY p
.br
option tpaShadingY p
.br
option negShadingY p
.RS
.I p
overrides the internal shading position. The values are in steps.
.B Please note, that there's no internal range checking for
.B this feature.
.RE
.PP
option redGamma r
.br
option greenGamma g
.br
option blueGamma b
.br
option grayGamma gr
.RS
.I r g b gr
.RE
By using these values, the internal linear gamma table (r,g,b,gr = 1.0)
can be adjusted.
.PP
option red_gain r
.br
option green_gain g
.br
option blue_gain b
.RS
.I r g b
These values can be used to adjust the internally detected gain values of
the AFE for each channel. The range is between 0 and 63.
.RE

.PP
See the plustek.conf file for examples.
.PP
.B Note:
.br
You have to make sure, that the USB subsystem is loaded
correctly and the module
.I scanner
has been loaded too. To make this module recognize your
scanner, you might have to add the following line to
your
.B "/etc/modules.conf"
:
.br
.I options scanner vendor=0x7b3 product=0x17
.PP
.br
If you're not sure about the vendor and product id of your
device, simply load the USB subsystem and plug in your
scanner. Then do a
.I cat /proc/bus/usb/devices
and look for the scanner.
.br
Alternatively, the backend is able to access your scanner via
libusb. You might use
.B sane-find-scanner
to check that you have access to your device.
.PP
.B Note:
.br
If there's no configuration file, the backend defaults to
.B device auto
. So it

.SH FILES
.TP
.I @CONFIGDIR@/plustek.conf
The backend configuration file
.TP
.I @LIBDIR@/libsane-plustek.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-plustek.so
The shared library implementing this backend (present on systems that
support dynamic loading).

.SH "CONTACT AND BUG-REPORTS"
Please send any information and bug-reports to:
.br
.B Plustek Driver Mailing List <plustek@linuxhacker.org>
.br
or directly to:
.br
.B Gerhard Jaeger <gerhard@gjaeger.de>
.PP
Additional info and hints can be obtained from our
.br
Mailing-List archive at:
.br
.B http://www.linuxhacker.org/cgi-bin/ezmlm-cgi/3
.PP
or directly from the projects' homepage at:
.br
.B http://www.gjaeger.de/scanner/plustek.html
.PP
To obtain debug messages from the backend, please set the
environment-variable
.I SANE_DEBUG_PLUSTEK
before calling your favorite scan-frontend (i.e. xscanimage).
.br
.B i.e.: export SANE_DEBUG_PLUSTEK=20 ; xscanimage
.PP
The value controls the verbosity of the backend. Please note, that
values greater than 19 force the backend to output raw data files,
which could be rather large. The ending of these files is ".raw".
For problem reports it should be enough the set the verbosity to
13.

.SH "KNOWN BUGS & RESTRICTIONS"
* The driver does not support these manic scalings up
.br
  to 16 times the physical resolution. The only scaling
.br
  is done on resolutions between the physical resolution
.br
  of the CDD-sensor and the stepper motor i.e. you have a
.br
  600x1200 dpi scanner and you are scanning using 800dpi,
.br
  so scaling is necesary, because the sensor only delivers
.br
  600dpi but the motor is capable to perform 800dpi steps.
.br
* Plusteks' model policy is somewhat inconsistent. This
.br
  means, they sell technical different devices under the
.br
  same product name. Therefore it is possible that some
.br
  devices like the UT12 or U12 won't work - please check
.br
  the model list above and compare the product-id to
.br
  the one your device has.
.br
* Negative/Slide scanning quality is poor.
