/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import net.sf.saxon.ConversionContext;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.Version;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.functions.ExtensionFunctionFactory;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.JavaExtensionLibrary;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.instruct.Debugger;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Configuration
implements ConversionContext,
Serializable {
    private transient URIResolver resolver;
    protected transient ErrorListener listener;
    private int treeModel = 1;
    private boolean lineNumbering = false;
    private TraceListener traceListener = null;
    private FunctionLibrary extensionBinder;
    protected VendorFunctionLibrary vendorFunctionLibrary;
    protected int recoveryPolicy = 1;
    private String messageEmitterClass = "net.sf.saxon.event.MessageEmitter";
    private String sourceParserClass;
    private String styleParserClass;
    private transient OutputURIResolver outputURIResolver;
    private boolean timing = false;
    private boolean versionWarning = true;
    private boolean allowExternalFunctions = true;
    private boolean traceExternalFunctions = false;
    private boolean validation = false;
    private boolean allNodesUntyped = false;
    private boolean lazyConstructionMode = false;
    private NamePool targetNamePool = null;
    private boolean stripsAllWhiteSpace = false;
    private int hostLanguage = 10;
    private int schemaValidationMode = 4;
    private boolean validationWarnings = false;
    private boolean retainDTDattributeTypes = false;
    private Debugger debugger = null;
    protected Optimizer optimizer = null;
    private ExtensionFunctionFactory extensionFunctionFactory = new ExtensionFunctionFactory(this);
    private List externalObjectModels = new ArrayList(4);
    private ClassLoader classLoader;
    private int implicitTimezone;
    public static final int RECOVER_SILENTLY = 0;
    public static final int RECOVER_WITH_WARNINGS = 1;
    public static final int DO_NOT_RECOVER = 2;
    public static final int XSLT = 10;
    public static final int XQUERY = 11;
    public static final int XML_SCHEMA = 12;
    public static final int JAVA_APPLICATION = 13;
    public static final int XPATH = 14;

    public Configuration() {
        this.targetNamePool = NamePool.getDefaultNamePool();
        this.extensionBinder = new JavaExtensionLibrary(this);
        this.registerStandardObjectModels();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(15) + gregorianCalendar.get(16);
        this.implicitTimezone = n / 60000;
    }

    public String getProductTitle() {
        return "Saxon " + Version.getProductVersion() + " from Saxonica";
    }

    public boolean isSchemaAware(int n) {
        return false;
    }

    public void displayLicenseMessage() {
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int n) {
        this.hostLanguage = n;
    }

    public URIResolver getURIResolver() {
        if (this.resolver == null) {
            this.resolver = new StandardURIResolver(this);
        }
        return this.resolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.resolver = uRIResolver;
    }

    public URIResolver makeURIResolver(String string) throws TransformerException {
        Object object = this.getInstance(string, null);
        if (object instanceof URIResolver) {
            return (URIResolver)object;
        }
        throw new DynamicError("Class " + string + " is not a URIResolver");
    }

    public ErrorListener getErrorListener() {
        if (this.listener == null) {
            this.listener = new StandardErrorListener();
            ((StandardErrorListener)this.listener).setRecoveryPolicy(this.recoveryPolicy);
        }
        return this.listener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.listener = errorListener;
    }

    public int getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(int n) {
        this.treeModel = n;
    }

    public boolean isLineNumbering() {
        return this.lineNumbering;
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
    }

    public TraceListener makeTraceListener(String string) throws XPathException {
        Object object = this.getInstance(string, null);
        if (object instanceof TraceListener) {
            return (TraceListener)object;
        }
        throw new DynamicError("Class " + string + " is not a TraceListener");
    }

    public void setExtensionBinder(FunctionLibrary functionLibrary) {
        this.extensionBinder = functionLibrary;
    }

    public FunctionLibrary getExtensionBinder() {
        return this.extensionBinder;
    }

    public VendorFunctionLibrary getVendorFunctionLibrary() {
        if (this.vendorFunctionLibrary == null) {
            this.vendorFunctionLibrary = new VendorFunctionLibrary();
        }
        return this.vendorFunctionLibrary;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setRecoveryPolicy(int n) {
        this.recoveryPolicy = n;
    }

    public String getMessageEmitterClass() {
        return this.messageEmitterClass;
    }

    public void setMessageEmitterClass(String string) {
        this.messageEmitterClass = string;
    }

    public String getSourceParserClass() {
        return this.sourceParserClass;
    }

    public void setSourceParserClass(String string) {
        this.sourceParserClass = string;
    }

    public String getStyleParserClass() {
        return this.styleParserClass;
    }

    public void setStyleParserClass(String string) {
        this.styleParserClass = string;
    }

    public OutputURIResolver getOutputURIResolver() {
        if (this.outputURIResolver == null) {
            this.outputURIResolver = StandardOutputResolver.getInstance();
        }
        return this.outputURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void setTiming(boolean bl) {
        this.timing = bl;
    }

    public boolean isVersionWarning() {
        return this.versionWarning;
    }

    public void setVersionWarning(boolean bl) {
        this.versionWarning = bl;
    }

    public boolean isAllowExternalFunctions() {
        return this.allowExternalFunctions;
    }

    public void setAllowExternalFunctions(boolean bl) {
        this.allowExternalFunctions = bl;
    }

    public boolean isTraceExternalFunctions() {
        return this.traceExternalFunctions;
    }

    public void setRetainDTDAttributeTypes(boolean bl) throws TransformerFactoryConfigurationError {
        if (bl && !this.isSchemaAware(12)) {
            throw new TransformerFactoryConfigurationError("Retaining DTD attribute types requires the schema-aware product");
        }
        this.retainDTDattributeTypes = bl;
    }

    public boolean isRetainDTDAttributeTypes() {
        return this.retainDTDattributeTypes;
    }

    public void setTraceExternalFunctions(boolean bl) {
        this.traceExternalFunctions = bl;
    }

    public ExtensionFunctionFactory getExtensionFunctionFactory() {
        return this.extensionFunctionFactory;
    }

    public void setExtensionFunctionFactory(ExtensionFunctionFactory extensionFunctionFactory) {
        this.extensionFunctionFactory = extensionFunctionFactory;
    }

    public boolean isValidation() {
        return this.validation;
    }

    public void setValidation(boolean bl) {
        this.validation = bl;
    }

    public void setAllNodesUntyped(boolean bl) {
        this.allNodesUntyped = bl;
    }

    public boolean areAllNodesUntyped() {
        return this.allNodesUntyped;
    }

    public int getSchemaValidationMode() {
        return this.schemaValidationMode;
    }

    public void setSchemaValidationMode(int n) {
        switch (n) {
            case 3: 
            case 4: {
                break;
            }
            case 1: 
            case 2: {
                if (this.isSchemaAware(12)) break;
                this.needSchemaAwareVersion();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported validation mode " + n);
            }
        }
        this.schemaValidationMode = n;
    }

    public void setValidationWarnings(boolean bl) {
        this.validationWarnings = bl;
    }

    public boolean isValidationWarnings() {
        return this.validationWarnings;
    }

    public NamePool getNamePool() {
        return this.targetNamePool;
    }

    public void setNamePool(NamePool namePool) {
        this.targetNamePool = namePool;
    }

    public boolean isStripsAllWhiteSpace() {
        return this.stripsAllWhiteSpace;
    }

    public void setStripsAllWhiteSpace(boolean bl) {
        this.stripsAllWhiteSpace = bl;
    }

    public XMLReader getSourceParser() throws TransformerFactoryConfigurationError {
        XMLReader xMLReader;
        if (this.getSourceParserClass() != null) {
            xMLReader = this.makeParser(this.getSourceParserClass());
        } else {
            try {
                xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new TransformerFactoryConfigurationError(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new TransformerFactoryConfigurationError(sAXException);
            }
        }
        if (this.isValidation()) {
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXException sAXException) {
                throw new TransformerFactoryConfigurationError("The XML parser does not support validation");
            }
        }
        return xMLReader;
    }

    public XMLReader getStyleParser() throws TransformerFactoryConfigurationError {
        XMLReader xMLReader;
        if (this.getStyleParserClass() != null) {
            xMLReader = this.makeParser(this.getStyleParserClass());
        } else {
            try {
                xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new TransformerFactoryConfigurationError(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new TransformerFactoryConfigurationError(sAXException);
            }
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new TransformerFactoryConfigurationError(sAXNotRecognizedException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new TransformerFactoryConfigurationError(sAXNotSupportedException);
        }
        return xMLReader;
    }

    public String readSchema(PipelineConfiguration pipelineConfiguration, String string, String string2, String string3) throws TransformerConfigurationException {
        this.needSchemaAwareVersion();
        return null;
    }

    public void readMultipleSchemas(PipelineConfiguration pipelineConfiguration, String string, List list, String string2) throws SchemaException {
        this.needSchemaAwareVersion();
    }

    public String readInlineSchema(PipelineConfiguration pipelineConfiguration, NodeInfo nodeInfo, String string) throws SchemaException {
        this.needSchemaAwareVersion();
        return null;
    }

    private void needSchemaAwareVersion() {
        throw new UnsupportedOperationException("You need the schema-aware version of Saxon for this operation");
    }

    public void addSchemaSource(Source source) throws SchemaException {
        this.needSchemaAwareVersion();
    }

    public void addSchema(Object object) throws TransformerConfigurationException {
        this.needSchemaAwareVersion();
    }

    public Object getSchema(String string) {
        return null;
    }

    public SchemaDeclaration getElementDeclaration(int n) {
        return null;
    }

    public SchemaDeclaration getAttributeDeclaration(int n) {
        return null;
    }

    public SchemaType getSchemaType(int n) {
        if (n < 1023) {
            return BuiltInSchemaFactory.getSchemaType(n);
        }
        return null;
    }

    public Receiver getDocumentValidator(Receiver receiver, String string, NamePool namePool, int n) {
        return receiver;
    }

    public Receiver getElementValidator(Receiver receiver, int n, int n2, SchemaType schemaType, int n3, NamePool namePool) throws XPathException {
        return receiver;
    }

    public long validateAttribute(int n, CharSequence charSequence, int n2) throws ValidationException {
        return -1L;
    }

    public Receiver getAnnotationStripper(Receiver receiver) {
        return receiver;
    }

    public NodeTest makeSubstitutionGroupTest(SchemaDeclaration schemaDeclaration) {
        this.needSchemaAwareVersion();
        return null;
    }

    public XMLReader makeParser(String string) throws TransformerFactoryConfigurationError {
        Object object;
        try {
            object = this.getInstance(string, null);
        }
        catch (XPathException xPathException) {
            throw new TransformerFactoryConfigurationError(xPathException);
        }
        if (object instanceof XMLReader) {
            return (XMLReader)object;
        }
        throw new TransformerFactoryConfigurationError("Class " + string + " is not a SAX2 XMLReader");
    }

    public static Locale getLocale(String string) {
        String string2;
        String string3;
        int n = string.indexOf("-");
        if (n < 1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(1, n);
            string2 = string.substring(n + 1);
        }
        return new Locale(string3, string2);
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public SlotManager makeSlotManager() {
        if (this.debugger == null) {
            return new SlotManager();
        }
        return this.debugger.makeSlotManager();
    }

    public Optimizer getOptimizer() {
        if (this.optimizer == null) {
            this.optimizer = new Optimizer();
        }
        return this.optimizer;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class getClass(String string, boolean bl, ClassLoader classLoader) throws XPathException {
        if (bl) {
            System.err.println("Loading " + string);
        }
        try {
            ClassLoader classLoader2 = classLoader;
            if (classLoader2 == null) {
                classLoader2 = this.classLoader;
            }
            if (classLoader2 == null) {
                classLoader2 = Thread.currentThread().getContextClassLoader();
            }
            if (classLoader2 != null) {
                try {
                    return classLoader2.loadClass(string);
                }
                catch (Exception exception) {
                    return Class.forName(string);
                }
            }
            return Class.forName(string);
        }
        catch (Exception exception) {
            if (bl) {
                System.err.println("No Java class " + string + " could be loaded");
            }
            throw new DynamicError("Failed to load " + string, exception);
        }
    }

    public Object getInstance(String string, ClassLoader classLoader) throws XPathException {
        Class clazz = this.getClass(string, false, classLoader);
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new DynamicError("Failed to instantiate class " + string, exception);
        }
    }

    public Comparator makeCollator(String string) throws XPathException {
        Object object = this.getInstance(string, null);
        if (object instanceof Comparator) {
            return (Comparator)object;
        }
        throw new DynamicError("Failed to load collation class " + string + ": it is not an instance of java.util.Comparator");
    }

    public void setLazyConstructionMode(boolean bl) {
        this.lazyConstructionMode = bl;
    }

    public boolean isLazyConstructionMode() {
        return this.lazyConstructionMode;
    }

    public void registerStandardObjectModels() {
        String[] stringArray = new String[]{"net.sf.saxon.dom.DOMObjectModel", "net.sf.saxon.jdom.JDOMObjectModel", "net.sf.saxon.xom.XOMObjectModel"};
        String[] stringArray2 = new String[]{"org.w3c.dom.Node", "org.jdom.Element", "nu.xom.Node"};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.getClass(stringArray2[i], false, null);
                ExternalObjectModel externalObjectModel = (ExternalObjectModel)this.getInstance(stringArray[i], null);
                this.registerExternalObjectModel(externalObjectModel);
                continue;
            }
            catch (XPathException xPathException) {
                continue;
            }
            catch (ClassCastException classCastException) {
                System.err.println("Warning: external object model " + stringArray[i] + " has been loaded, but is not an instance of net.sf.saxon.om.ExternalObjectModel");
            }
        }
    }

    public void registerExternalObjectModel(ExternalObjectModel externalObjectModel) {
        this.externalObjectModels.add(externalObjectModel);
    }

    public ExternalObjectModel findExternalObjectModel(Object object) {
        Iterator iterator = this.externalObjectModels.iterator();
        while (iterator.hasNext()) {
            ExternalObjectModel externalObjectModel = (ExternalObjectModel)iterator.next();
            if (!externalObjectModel.isRecognizedNode(object)) continue;
            return externalObjectModel;
        }
        return null;
    }

    public List getExternalObjectModels() {
        return this.externalObjectModels;
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipelineConfiguration = new PipelineConfiguration();
        pipelineConfiguration.setConfiguration(this);
        pipelineConfiguration.setErrorListener(this.getErrorListener());
        pipelineConfiguration.setURIResolver(this.getURIResolver());
        return pipelineConfiguration;
    }

    public void setImplicitTimezone(int n) {
        if (n < -840 || n > 840) {
            throw new IllegalArgumentException("Implicit timezone is out of range: range is -840 to +840 minutes");
        }
        this.implicitTimezone = n;
    }

    public int getImplicitTimezone() {
        return this.implicitTimezone;
    }
}

