/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class IDFilter
extends XMLFilterImpl {
    private String id;
    private int activeDepth = 0;
    private Stack namespacePrefixes = new Stack();
    private Stack namespaceURIs = new Stack();

    public IDFilter(String string) {
        this.id = string;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.activeDepth > 0) {
            super.startPrefixMapping(string, string2);
        } else {
            this.namespacePrefixes.push(string);
            this.namespaceURIs.push(string2);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (this.activeDepth > 0) {
            super.endPrefixMapping(string);
        } else {
            this.namespacePrefixes.pop();
            this.namespaceURIs.pop();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.activeDepth == 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getType(i).equals("ID") || !attributes.getValue(i).equals(this.id)) continue;
                this.activeDepth = 1;
                break;
            }
            if (this.activeDepth == 1) {
                HashMap hashMap = new HashMap(this.namespacePrefixes.size());
                for (int i = 0; i < this.namespacePrefixes.size(); ++i) {
                    if (this.namespaceURIs.elementAt(i).equals("")) {
                        hashMap.remove(this.namespacePrefixes.elementAt(i));
                        continue;
                    }
                    hashMap.put(this.namespacePrefixes.elementAt(i), this.namespaceURIs.elementAt(i));
                }
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    super.startPrefixMapping(string4, (String)hashMap.get(string4));
                }
            }
        } else {
            ++this.activeDepth;
        }
        if (this.activeDepth > 0) {
            super.startElement(string, string2, string3, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.activeDepth > 0) {
            super.endElement(string, string2, string3);
            --this.activeDepth;
            if (this.activeDepth == 0) {
                for (int i = this.namespacePrefixes.size() - 1; i >= 0; --i) {
                    super.endPrefixMapping((String)this.namespacePrefixes.elementAt(i));
                }
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.activeDepth > 0) {
            super.characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.activeDepth > 0) {
            super.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.activeDepth > 0) {
            super.processingInstruction(string, string2);
        }
    }
}

