/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetStripper;
import net.sf.saxon.style.UseWhenFilter;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;

public class PreparedStylesheet
implements Templates,
Serializable {
    private Executable executable;
    private transient Configuration config;
    private NamePool targetNamePool;
    private transient StyleNodeFactory nodeFactory;
    private int errorCount = 0;

    protected PreparedStylesheet(Configuration configuration) {
        this.config = configuration;
    }

    public Transformer newTransformer() {
        Controller controller = new Controller(this.config, this.executable);
        controller.setPreparedStylesheet(this);
        return controller;
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setTargetNamePool(NamePool namePool) {
        this.targetNamePool = namePool;
    }

    public NamePool getTargetNamePool() {
        if (this.targetNamePool == null) {
            return this.config.getNamePool();
        }
        return this.targetNamePool;
    }

    public StyleNodeFactory getStyleNodeFactory() {
        return this.nodeFactory;
    }

    protected void prepare(Source source) throws TransformerConfigurationException {
        block3: {
            this.nodeFactory = new StyleNodeFactory(this.config);
            try {
                DocumentImpl documentImpl = PreparedStylesheet.loadStylesheetModule(source, this.config, this.config.getNamePool(), this.nodeFactory);
                this.setStylesheetDocument(documentImpl, this.nodeFactory);
            }
            catch (XPathException xPathException) {
                if (this.errorCount != 0) break block3;
                ++this.errorCount;
            }
        }
        if (this.errorCount > 0) {
            throw new TransformerConfigurationException("Failed to compile stylesheet. " + this.errorCount + (this.errorCount == 1 ? " error " : " errors ") + "detected.");
        }
    }

    public static DocumentImpl loadStylesheetModule(Source source, Configuration configuration, NamePool namePool, StyleNodeFactory styleNodeFactory) throws XPathException {
        TreeBuilder treeBuilder = new TreeBuilder();
        PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
        treeBuilder.setPipelineConfiguration(pipelineConfiguration);
        treeBuilder.setSystemId(source.getSystemId());
        treeBuilder.setNodeFactory(styleNodeFactory);
        treeBuilder.setLineNumbering(true);
        StartTagBuffer startTagBuffer = new StartTagBuffer();
        UseWhenFilter useWhenFilter = new UseWhenFilter(startTagBuffer);
        useWhenFilter.setUnderlyingReceiver(treeBuilder);
        startTagBuffer.setUnderlyingReceiver(useWhenFilter);
        StylesheetStripper stylesheetStripper = new StylesheetStripper();
        stylesheetStripper.setStylesheetRules(namePool);
        stylesheetStripper.setUnderlyingReceiver(startTagBuffer);
        CommentStripper commentStripper = new CommentStripper();
        commentStripper.setUnderlyingReceiver(stylesheetStripper);
        Sender sender = new Sender(pipelineConfiguration);
        AugmentedSource augmentedSource = AugmentedSource.makeAugmentedSource(source);
        augmentedSource.setSchemaValidationMode(4);
        if (augmentedSource.getXMLReader() == null) {
            augmentedSource.setXMLReader(configuration.getStyleParser());
        }
        sender.send(augmentedSource, commentStripper);
        DocumentImpl documentImpl = (DocumentImpl)treeBuilder.getCurrentRoot();
        return documentImpl;
    }

    public static PreparedStylesheet loadCompiledStylesheet(Configuration configuration, String string) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
        PreparedStylesheet preparedStylesheet = (PreparedStylesheet)objectInputStream.readObject();
        objectInputStream.close();
        NamePool namePool = preparedStylesheet.getTargetNamePool();
        preparedStylesheet.setConfiguration(configuration);
        preparedStylesheet.getExecutable().setConfiguration(configuration);
        configuration.setNamePool(namePool);
        NamePool.setDefaultNamePool(namePool);
        return preparedStylesheet;
    }

    protected void setStylesheetDocument(DocumentImpl documentImpl, StyleNodeFactory styleNodeFactory) throws XPathException {
        DocumentImpl documentImpl2 = documentImpl;
        this.nodeFactory = styleNodeFactory;
        StyleElement styleElement = (StyleElement)documentImpl2.getDocumentElement();
        if (styleElement instanceof LiteralResultElement) {
            documentImpl2 = ((LiteralResultElement)styleElement).makeStylesheet(this, styleNodeFactory);
        }
        if (!(documentImpl2.getDocumentElement() instanceof XSLStylesheet)) {
            throw new StaticError("Outermost element of stylesheet is not xsl:stylesheet or xsl:transform or literal result element");
        }
        XSLStylesheet xSLStylesheet = (XSLStylesheet)documentImpl2.getDocumentElement();
        if (this.config.isVersionWarning() && xSLStylesheet.getVersion().equals(BigDecimal.valueOf(1L))) {
            try {
                this.config.getErrorListener().warning(new TransformerException("Running an XSLT 1.0 stylesheet with an XSLT 2.0 processor"));
            }
            catch (TransformerException transformerException) {
                throw StaticError.makeStaticError(transformerException);
            }
        }
        xSLStylesheet.setPreparedStylesheet(this);
        try {
            xSLStylesheet.preprocess();
        }
        catch (XPathException xPathException) {
            Throwable throwable = xPathException.getException();
            if (throwable instanceof XPathException && !((XPathException)throwable).hasBeenReported()) {
                try {
                    this.config.getErrorListener().fatalError((XPathException)throwable);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw xPathException;
        }
        this.executable = xSLStylesheet.compileStylesheet();
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public Properties getOutputProperties() {
        Properties properties = this.executable.getDefaultOutputProperties();
        return new Properties(properties);
    }

    public void reportError(TransformerException transformerException) throws TransformerException {
        ++this.errorCount;
        this.config.getErrorListener().fatalError(transformerException);
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void reportWarning(TransformerException transformerException) {
        try {
            this.config.getErrorListener().warning(transformerException);
        }
        catch (TransformerException transformerException2) {
            // empty catch block
        }
    }
}

