/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Transform;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trace.XQueryTraceListener;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.UntypedAtomicValue;
import org.xml.sax.InputSource;

public class Query {
    Configuration config;

    protected Configuration makeConfiguration() {
        return new Configuration();
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    public static void main(String[] stringArray) throws Exception {
        new Query().doMain(stringArray, "java net.sf.saxon.Query");
    }

    protected void doMain(String[] stringArray, String string) {
        this.config = this.makeConfiguration();
        this.config.setHostLanguage(11);
        boolean bl = this.config.isSchemaAware(11);
        boolean bl2 = false;
        int n = 1;
        StaticQueryContext staticQueryContext = new StaticQueryContext(this.config);
        DynamicQueryContext dynamicQueryContext = new DynamicQueryContext(this.config);
        String string2 = null;
        String string3 = null;
        boolean bl3 = false;
        String string4 = null;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        Properties properties = new Properties();
        properties.setProperty("indent", "yes");
        try {
            Object object;
            XQueryExpression xQueryExpression;
            OutputStream outputStream;
            Object object2;
            int n2 = 0;
            while (n2 < stringArray.length && stringArray[n2].charAt(0) == '-') {
                Object object3;
                if (stringArray[n2].equals("-ds")) {
                    this.config.setTreeModel(0);
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-dt")) {
                    this.config.setTreeModel(1);
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-e")) {
                    bl4 = true;
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-l")) {
                    this.config.setLineNumbering(true);
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-3")) {
                    ++n2;
                    n = 3;
                    continue;
                }
                if (stringArray[n2].equals("-9")) {
                    ++n2;
                    n = 9;
                    continue;
                }
                if (stringArray[n2].equals("-noext")) {
                    ++n2;
                    this.config.setAllowExternalFunctions(false);
                    continue;
                }
                if (stringArray[n2].equals("-o")) {
                    if (stringArray.length < ++n2 + 1) {
                        this.badUsage(string, "No output file name");
                    }
                    string4 = stringArray[n2++];
                    continue;
                }
                if (stringArray[n2].equals("-pull")) {
                    ++n2;
                    bl6 = true;
                    continue;
                }
                if (stringArray[n2].equals("-r")) {
                    if (stringArray.length < ++n2 + 1) {
                        this.badUsage(string, "No URIResolver class");
                    }
                    object3 = stringArray[n2++];
                    this.config.setURIResolver(this.config.makeURIResolver((String)object3));
                    dynamicQueryContext.setURIResolver(this.config.makeURIResolver((String)object3));
                    continue;
                }
                if (stringArray[n2].equals("-s")) {
                    if (stringArray.length < ++n2 + 1) {
                        this.badUsage(string, "No source file name");
                    }
                    string2 = stringArray[n2++];
                    continue;
                }
                if (stringArray[n2].equals("-strip")) {
                    this.config.setStripsAllWhiteSpace(true);
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-t")) {
                    System.err.println(this.config.getProductTitle());
                    System.err.println("Java version " + System.getProperty("java.version"));
                    this.config.setTiming(true);
                    bl2 = true;
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-T")) {
                    this.config.setTraceListener(new XQueryTraceListener());
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-TJ")) {
                    ++n2;
                    this.config.setTraceExternalFunctions(true);
                    continue;
                }
                if (stringArray[n2].equals("-TL")) {
                    if (stringArray.length < n2 + 2) {
                        this.badUsage(string, "No TraceListener class specified");
                    }
                    object3 = this.config.makeTraceListener(stringArray[++n2]);
                    this.config.setTraceListener((TraceListener)object3);
                    this.config.setLineNumbering(true);
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-u")) {
                    bl3 = true;
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-val")) {
                    if (bl) {
                        this.config.setSchemaValidationMode(1);
                    } else {
                        Query.quit("The -val option requires a schema-aware processor", 2);
                    }
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-vlax")) {
                    if (bl) {
                        this.config.setSchemaValidationMode(2);
                    } else {
                        Query.quit("The -vlax option requires a schema-aware processor", 2);
                    }
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-vw")) {
                    if (bl) {
                        this.config.setValidationWarnings(true);
                    } else {
                        Query.quit("The -vw option requires a schema-aware processor", 2);
                    }
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-wrap")) {
                    bl5 = true;
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-?")) {
                    this.badUsage(string, "");
                    continue;
                }
                if (stringArray[n2].equals("-")) {
                    string3 = "-";
                    ++n2;
                    continue;
                }
                this.badUsage(string, "Unknown option " + stringArray[n2]);
            }
            if (!"-".equals(string3)) {
                if (stringArray.length < n2 + 1) {
                    this.badUsage(string, "No query file name");
                }
                string3 = stringArray[n2++];
            }
            for (int i = n2; i < stringArray.length; ++i) {
                String string5;
                object2 = stringArray[i];
                int n3 = ((String)object2).indexOf("=");
                if (n3 < 1 || n3 >= ((String)object2).length() - 1) {
                    this.badUsage(string, "Bad param=value pair on command line: " + (String)object2);
                }
                if ((string5 = ((String)object2).substring(0, n3)).startsWith("!")) {
                    properties.setProperty(string5.substring(1), ((String)object2).substring(n3 + 1));
                    continue;
                }
                if (string5.startsWith("+")) {
                    Object object4 = Transform.loadDocuments(((String)object2).substring(n3 + 1), bl3, this.config, true);
                    dynamicQueryContext.setParameter(string5.substring(1), object4);
                    continue;
                }
                dynamicQueryContext.setParameter(string5, new UntypedAtomicValue(((String)object2).substring(n3 + 1)));
            }
            this.config.displayLicenseMessage();
            if (bl6) {
                this.config.setLazyConstructionMode(true);
            }
            Source source = null;
            if (string2 != null) {
                if (bl3 || string2.startsWith("http:") || string2.startsWith("file:")) {
                    source = dynamicQueryContext.getURIResolver().resolve(string2, null);
                } else if (string2.equals("-")) {
                    source = new SAXSource(new InputSource(System.in));
                } else {
                    File file = new File(string2);
                    if (!file.exists()) {
                        Query.quit("Source file " + file + " does not exist", 2);
                    }
                    object2 = new InputSource(file.toURI().toString());
                    source = new SAXSource((InputSource)object2);
                }
            }
            if (string3.equals("-")) {
                object2 = new InputStreamReader(System.in);
            } else if (string3.startsWith("{") && string3.endsWith("}")) {
                String string6 = string3.substring(1, string3.length() - 1);
                object2 = new StringReader(string6);
            } else {
                object2 = new FileReader(string3);
                staticQueryContext.setBaseURI(new File(string3).toURI().toString());
            }
            if (string4 != null) {
                File file = new File(string4);
                if (file.isDirectory()) {
                    Query.quit("Output is a directory", 2);
                }
                outputStream = new FileOutputStream(file);
            } else {
                outputStream = System.out;
            }
            long l = new Date().getTime();
            try {
                if (bl2) {
                    System.err.println("Compiling query from " + string3);
                }
                xQueryExpression = staticQueryContext.compileQuery((Reader)object2);
                if (bl2) {
                    long l2 = new Date().getTime();
                    System.err.println("Compilation time: " + (l2 - l) + " milliseconds");
                    l = l2;
                }
            }
            catch (XPathException xPathException) {
                int n4 = -1;
                object = null;
                if (xPathException.getLocator() != null) {
                    n4 = xPathException.getLocator().getLineNumber();
                    object = xPathException.getLocator().getSystemId();
                }
                if (xPathException.hasBeenReported()) {
                    Query.quit("Failed to compile query", 2);
                } else if (n4 == -1) {
                    System.err.println("Failed to compile query: " + xPathException.getMessage());
                } else {
                    System.err.println("Static error at line " + n4 + " of " + (String)object + ':');
                    System.err.println(xPathException.getMessage());
                }
                xQueryExpression = null;
                System.exit(2);
            }
            if (bl4) {
                staticQueryContext.explainGlobalVariables();
                staticQueryContext.explainGlobalFunctions();
                xQueryExpression.explain(staticQueryContext.getNamePool());
            }
            for (int i = 0; i < n; ++i) {
                block82: {
                    if (source != null) {
                        if (bl2) {
                            System.err.println("Processing " + source.getSystemId());
                        }
                        DocumentInfo documentInfo = staticQueryContext.buildDocument(source);
                        dynamicQueryContext.setContextNode(documentInfo);
                    }
                    try {
                        if (bl5) {
                            SequenceIterator sequenceIterator = xQueryExpression.iterator(dynamicQueryContext);
                            object = QueryResult.wrap(sequenceIterator, this.config);
                            QueryResult.serialize((NodeInfo)object, new StreamResult(outputStream), properties, this.config);
                            outputStream.close();
                            break block82;
                        }
                        if (bl6) {
                            if (bl5) {
                                properties.setProperty("{http://saxon.sf.net/}require-well-formed", "yes");
                            }
                            try {
                                xQueryExpression.pull(dynamicQueryContext, new StreamResult(outputStream), properties);
                                break block82;
                            }
                            catch (XPathException xPathException) {
                                if (!xPathException.hasBeenReported()) {
                                    this.config.getErrorListener().fatalError(xPathException);
                                }
                                throw xPathException;
                            }
                        }
                        xQueryExpression.run(dynamicQueryContext, new StreamResult(outputStream), properties);
                    }
                    catch (TerminationException terminationException) {
                        throw terminationException;
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.hasBeenReported()) {
                            throw new DynamicError("Run-time errors were reported");
                        }
                        throw xPathException;
                    }
                }
                if (!bl2) continue;
                long l3 = new Date().getTime();
                System.err.println("Execution time: " + (l3 - l) + " milliseconds");
                l = l3;
            }
        }
        catch (TerminationException terminationException) {
            Query.quit(terminationException.getMessage(), 1);
        }
        catch (XPathException xPathException) {
            Query.quit("Query processing failed: " + xPathException.getMessage(), 2);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            transformerFactoryConfigurationError.printStackTrace();
            Query.quit("Query processing failed", 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Query.quit("Fatal error during transformation: " + exception.getMessage(), 2);
        }
    }

    protected static void quit(String string, int n) {
        System.err.println(string);
        System.exit(n);
    }

    protected void badUsage(String string, String string2) {
        if (!"".equals(string2)) {
            System.err.println(string2);
        }
        System.err.println(this.config.getProductTitle());
        System.err.println("Usage: " + string + " [options] query {param=value}...");
        System.err.println("Options: ");
        System.err.println("  -ds             Use standard tree data structure");
        System.err.println("  -dt             Use tinytree data structure (default)");
        System.err.println("  -e              Explain optimized query expression");
        System.err.println("  -noext          Disallow calls to Java methods");
        System.err.println("  -o filename     Send output to named file");
        System.err.println("  -pull           Run query in pull mode");
        System.err.println("  -r classname    Use specified URIResolver class");
        System.err.println("  -s file|URI     Provide initial context document");
        System.err.println("  -strip          Strip whitespace text nodes");
        System.err.println("  -t              Display version and timing information");
        System.err.println("  -T              Trace query execution");
        System.err.println("  -TJ             Trace calls to external Java functions");
        System.err.println("  -TL classname   Trace query execution to user-defined trace listener");
        System.err.println("  -u              Names are URLs not filenames");
        if (this.config.isSchemaAware(11)) {
            System.err.println("  -val            Validate source documents using schema");
            System.err.println("  -vlax           Lax validation of source documents using schema");
            System.err.println("  -vw             Treat validation errors on result document as warnings");
        }
        System.err.println("  -wrap           Wraps result sequence in XML elements");
        System.err.println("  -?              Display this message ");
        System.err.println("  param=value     Set stylesheet string parameter");
        System.err.println("  +param=value    Set stylesheet document parameter");
        System.err.println("  !option=value   Set serialization option");
        if ("".equals(string2)) {
            System.exit(0);
        } else {
            System.exit(2);
        }
    }
}

