/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.trans.XPathException;

public class CharacterMapExpander
extends ProxyReceiver {
    private HashMap charMap;
    private int min = Integer.MAX_VALUE;
    private int max = 0;
    private boolean useNullMarkers = true;

    public void setCharacterMaps(List list) {
        this.charMap = new HashMap(64);
        for (int i = 0; i < list.size(); ++i) {
            HashMap hashMap = (HashMap)list.get(i);
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                int n2 = n;
                if (n2 < this.min) {
                    this.min = n2;
                }
                if (n2 > this.max) {
                    this.max = n2;
                }
                this.charMap.put(n, hashMap.get(n));
            }
        }
        if (this.min > 55296) {
            this.min = 55296;
        }
    }

    public void setUseNullMarkers(boolean bl) {
        this.useNullMarkers = bl;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        CharSequence charSequence2 = this.map(charSequence, this.useNullMarkers);
        if (charSequence2 == charSequence) {
            super.attribute(n, n2, charSequence, n3, n4);
        } else {
            super.attribute(n, n2, charSequence2, n3, n4 | 0x100);
        }
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if ((n2 & 1) == 0) {
            super.characters(this.map(charSequence, this.useNullMarkers), n, n2 | 0x100);
        } else {
            super.characters(charSequence, n, n2);
        }
    }

    private CharSequence map(CharSequence charSequence, boolean bl) {
        int n;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < charSequence.length()) {
            if ((n = charSequence.charAt(n2++)) < this.min || n > this.max) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return charSequence;
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        n = 0;
        while (n < charSequence.length()) {
            char c;
            if ((c = charSequence.charAt(n++)) >= this.min && c <= this.max) {
                if (XMLChar.isHighSurrogate(c)) {
                    char c2;
                    int n3;
                    String string;
                    if ((string = (String)this.charMap.get(new Integer(n3 = XMLChar.supplemental(c, c2 = charSequence.charAt(n++))))) == null) {
                        fastStringBuffer.append(c);
                        fastStringBuffer.append(c2);
                        continue;
                    }
                    if (bl) {
                        fastStringBuffer.append('\u0000');
                        fastStringBuffer.append(string);
                        fastStringBuffer.append('\u0000');
                        continue;
                    }
                    fastStringBuffer.append(string);
                    continue;
                }
                String string = (String)this.charMap.get(new Integer(c));
                if (string == null) {
                    fastStringBuffer.append(c);
                    continue;
                }
                if (bl) {
                    fastStringBuffer.append('\u0000');
                    fastStringBuffer.append(string);
                    fastStringBuffer.append('\u0000');
                    continue;
                }
                fastStringBuffer.append(string);
                continue;
            }
            fastStringBuffer.append(c);
        }
        return fastStringBuffer;
    }
}

