/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SaxonLocator;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ReceivingContentHandler
implements ContentHandler,
LexicalHandler,
DTDHandler,
SaxonLocator {
    private NamePool pool;
    private PipelineConfiguration pipe;
    private Receiver receiver;
    private boolean inDTD = false;
    private Locator locator;
    private char[] buffer = new char[4096];
    private int used = 0;
    private int[] namespaces = new int[50];
    private int namespacesUsed = 0;

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipe = pipelineConfiguration;
        pipelineConfiguration.setLocationProvider(this);
        this.pool = pipelineConfiguration.getConfiguration().getNamePool();
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public Configuration getConfiguration() {
        return this.pipe.getConfiguration();
    }

    public void startDocument() throws SAXException {
        try {
            this.used = 0;
            this.namespacesUsed = 0;
            this.pipe.setLocationProvider(this);
            this.receiver.setPipelineConfiguration(this.pipe);
            this.receiver.open();
            this.receiver.startDocument(0);
        }
        catch (XPathException xPathException) {
            throw new SAXException(xPathException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.flush();
            this.receiver.endDocument();
            this.receiver.close();
        }
        catch (ValidationException validationException) {
            validationException.setLocator(this.locator);
            throw new SAXException(validationException);
        }
        catch (XPathException xPathException) {
            throw new SAXException(xPathException);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.namespacesUsed >= this.namespaces.length) {
            int[] nArray = new int[this.namespacesUsed * 2];
            System.arraycopy(this.namespaces, 0, nArray, 0, this.namespacesUsed);
            this.namespaces = nArray;
        }
        this.namespaces[this.namespacesUsed++] = this.pool.allocateNamespaceCode(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            int n;
            this.flush();
            int n2 = this.getNameCode(string, string2, string3);
            this.receiver.startElement(n2, -1, 0, 0);
            for (n = 0; n < this.namespacesUsed; ++n) {
                this.receiver.namespace(this.namespaces[n], 0);
            }
            for (n = 0; n < attributes.getLength(); ++n) {
                int n3 = 0;
                int n4 = this.getNameCode(attributes.getURI(n), attributes.getLocalName(n), attributes.getQName(n));
                String string4 = attributes.getType(n);
                int n5 = -1;
                if (this.getConfiguration().isRetainDTDAttributeTypes()) {
                    if (!string4.equals("CDATA")) {
                        if (string4.equals("ID")) {
                            n5 = 560;
                        } else if (string4.equals("IDREF")) {
                            n5 = 561;
                        } else if (string4.equals("IDREFS")) {
                            n5 = 562;
                        } else if (string4.equals("NMTOKEN")) {
                            n5 = 556;
                        } else if (string4.equals("NMTOKENS")) {
                            n5 = 557;
                        } else if (string4.equals("ENTITY")) {
                            n5 = 563;
                        } else if (string4.equals("ENTITIES")) {
                            n5 = 564;
                        }
                    }
                } else if (string4.equals("ID")) {
                    n3 |= 0x400;
                } else if (string4.equals("IDREF") || string4.equals("IDREFS")) {
                    n3 |= 0x800;
                }
                this.receiver.attribute(n4, n5, attributes.getValue(n), 0, n3);
            }
            this.receiver.startContent();
            this.namespacesUsed = 0;
        }
        catch (XPathException xPathException) {
            throw new SAXException(xPathException);
        }
    }

    private int getNameCode(String string, String string2, String string3) throws SAXException {
        if (string3.equals("")) {
            throw new SAXException("Saxon requires an XML parser that reports the QName of each element");
        }
        if (string2.equals("")) {
            throw new SAXException("Parser configuration problem: namespace reporting is not enabled");
        }
        String string4 = Name.getPrefix(string3);
        return this.pool.allocate(string4, string, string2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.flush();
            this.receiver.endElement();
        }
        catch (ValidationException validationException) {
            validationException.setLocator(this.locator);
            if (!validationException.hasBeenReported()) {
                try {
                    this.pipe.getErrorListener().fatalError(validationException);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw new SAXException(validationException);
        }
        catch (XPathException xPathException) {
            throw new SAXException(xPathException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        while (this.used + n2 > this.buffer.length) {
            char[] cArray2 = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, cArray2, 0, this.used);
            this.buffer = cArray2;
        }
        System.arraycopy(cArray, n, this.buffer, this.used, n2);
        this.used += n2;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            this.flush();
            if (!this.inDTD) {
                if (string == null) {
                    this.comment(string2.toCharArray(), 0, string2.length());
                } else {
                    if (!XMLChar.isValidNCName(string)) {
                        throw new SAXException("Invalid processing instruction name (" + string + ')');
                    }
                    this.receiver.processingInstruction(string, string2, 0, 0);
                }
            }
        }
        catch (XPathException xPathException) {
            throw new SAXException(xPathException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.flush();
            if (!this.inDTD) {
                this.receiver.comment(new CharSlice(cArray, n, n2), 0, 0);
            }
        }
        catch (XPathException xPathException) {
            throw new SAXException(xPathException);
        }
    }

    private void flush() throws XPathException {
        if (this.used > 0) {
            this.receiver.characters(new CharSlice(this.buffer, 0, this.used), 0, 0);
            this.used = 0;
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        String string5 = string3;
        if (this.locator != null) {
            try {
                String string6 = this.locator.getSystemId();
                URI uRI = new URI(string6).resolve(string3);
                string5 = uRI.toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        try {
            this.receiver.setUnparsedEntity(string, string5, string2);
        }
        catch (XPathException xPathException) {
            throw new SAXException(xPathException);
        }
    }

    public String getSystemId() {
        if (this.locator == null) {
            return null;
        }
        return this.locator.getSystemId();
    }

    public String getPublicId() {
        if (this.locator == null) {
            return null;
        }
        return this.locator.getPublicId();
    }

    public int getLineNumber() {
        if (this.locator == null) {
            return -1;
        }
        return this.locator.getLineNumber();
    }

    public int getColumnNumber() {
        if (this.locator == null) {
            return -1;
        }
        return this.locator.getColumnNumber();
    }

    public String getSystemId(int n) {
        return this.getSystemId();
    }

    public int getLineNumber(int n) {
        return this.getLineNumber();
    }
}

