/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;

public class StartTagBuffer
extends ProxyReceiver
implements NamespaceResolver {
    int elementNameCode;
    int elementTypeCode;
    int elementLocationId;
    int elementProperties;
    AttributeCollectionImpl bufferedAttributes;
    private int[] namespaces = new int[50];
    private int namespacesSize = 0;
    private int[] countStack = new int[50];
    private int depth = 0;

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        super.setPipelineConfiguration(pipelineConfiguration);
        this.bufferedAttributes = new AttributeCollectionImpl(this.getNamePool());
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        this.elementNameCode = n;
        this.elementTypeCode = n2;
        this.elementLocationId = n3;
        this.elementProperties = n4;
        this.bufferedAttributes.clear();
        this.countStack[this.depth] = 0;
        if (++this.depth >= this.countStack.length) {
            int[] nArray = new int[this.depth * 2];
            System.arraycopy(this.countStack, 0, nArray, 0, this.depth);
            this.countStack = nArray;
        }
    }

    public void namespace(int n, int n2) throws XPathException {
        this.addToStack(n);
        int n3 = this.depth - 1;
        this.countStack[n3] = this.countStack[n3] + 1;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        this.bufferedAttributes.addAttribute(n, n2, ((Object)charSequence).toString(), n3, n4);
    }

    private void addToStack(int n) {
        if (this.namespacesSize + 1 >= this.namespaces.length) {
            int[] nArray = new int[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, nArray, 0, this.namespacesSize);
            this.namespaces = nArray;
        }
        this.namespaces[this.namespacesSize++] = n;
    }

    public void startContent() throws XPathException {
        int n;
        super.startElement(this.elementNameCode, this.elementTypeCode, this.elementLocationId, this.elementProperties);
        for (n = this.namespacesSize - this.countStack[this.depth - 1]; n < this.namespacesSize; ++n) {
            super.namespace(this.namespaces[n], 0);
        }
        for (n = 0; n < this.bufferedAttributes.getLength(); ++n) {
            super.attribute(this.bufferedAttributes.getNameCode(n), this.bufferedAttributes.getTypeAnnotation(n), this.bufferedAttributes.getValue(n), this.bufferedAttributes.getLocationId(n), this.bufferedAttributes.getProperties(n));
        }
        super.startContent();
    }

    public void endElement() throws XPathException {
        int n = this.countStack[--this.depth];
        this.namespacesSize -= n;
        super.endElement();
    }

    public int getElementNameCode() {
        return this.elementNameCode;
    }

    public String getAttribute(int n) {
        return this.bufferedAttributes.getValueByFingerprint(n & 0xFFFFF);
    }

    protected short getURICode(short s) {
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            if (this.namespaces[i] >> 16 != s) continue;
            return (short)(this.namespaces[i] & 0xFFFF);
        }
        if (s == 0) {
            return 0;
        }
        return -1;
    }

    public String getURIForPrefix(String string, boolean bl) {
        NamePool namePool = this.getNamePool();
        if ("".equals(string) && !bl) {
            return "";
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        short s = namePool.getCodeForPrefix(string);
        short s2 = this.getURICode(s);
        if (s2 == -1) {
            return null;
        }
        return namePool.getURIFromURICode(s2);
    }

    public Iterator iteratePrefixes() {
        NamePool namePool = this.getNamePool();
        ArrayList<String> arrayList = new ArrayList<String>(this.namespacesSize);
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            String string = namePool.getPrefixFromNamespaceCode(this.namespaces[i]);
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        arrayList.add("xml");
        return arrayList.iterator();
    }
}

