/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class TransformerReceiver
extends ProxyReceiver {
    Controller controller;
    Builder builder;
    Result result;
    String systemId;

    public TransformerReceiver(Controller controller) {
        this.controller = controller;
    }

    public void open() throws XPathException {
        this.setPipelineConfiguration(this.controller.makePipelineConfiguration());
        this.builder = this.controller.makeBuilder();
        this.builder.setPipelineConfiguration(this.getPipelineConfiguration());
        this.builder.setSystemId(this.systemId);
        Receiver receiver = this.controller.makeStripper(this.builder);
        if (this.controller.getExecutable().stripsInputTypeAnnotations()) {
            receiver = this.controller.getConfiguration().getAnnotationStripper(receiver);
        }
        this.setUnderlyingReceiver(receiver);
        super.open();
    }

    public Transformer getTransformer() {
        return this.controller;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        super.startElement(n, n2, n3, n4);
    }

    public void setResult(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result must not be null");
        }
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public void close() throws XPathException {
        super.close();
        DocumentInfo documentInfo = (DocumentInfo)this.builder.getCurrentRoot();
        if (documentInfo == null) {
            throw new DynamicError("No source document has been built");
        }
        documentInfo.getNamePool().allocateDocumentNumber(documentInfo);
        try {
            this.controller.transformDocument(documentInfo, this.result);
        }
        catch (TransformerException transformerException) {
            throw DynamicError.makeDynamicError(transformerException);
        }
    }
}

