/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.ValidationErrorValue;

public class CastAsQName
extends ComputedExpression {
    private Expression operand;
    private AtomicType targetType;

    public CastAsQName(Expression expression, AtomicType atomicType) {
        this.operand = expression;
        this.targetType = atomicType;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.operand instanceof StringValue) {
            try {
                String string;
                CharSequence charSequence = ((StringValue)this.operand).getStringValueCS();
                String[] stringArray = Name.getQNameParts(charSequence);
                if ("".equals(stringArray[0])) {
                    string = "";
                } else {
                    string = staticContext.getURIForPrefix(stringArray[0]);
                    if (string == null) {
                        StaticError staticError = new StaticError("Prefix '" + stringArray[0] + "' has not been declared");
                        throw staticError;
                    }
                }
                if (this.targetType.getFingerprint() == 530) {
                    return new QNameValue(stringArray[0], string, stringArray[1]);
                }
                if (Type.isSubType(this.targetType, Type.QNAME_TYPE)) {
                    QNameValue qNameValue = new QNameValue(stringArray[0], string, stringArray[1]);
                    AtomicValue atomicValue = this.targetType.makeDerivedValue(qNameValue, charSequence, true);
                    if (atomicValue instanceof ValidationErrorValue) {
                        throw ((ValidationErrorValue)atomicValue).getException();
                    }
                    return atomicValue;
                }
                NotationValue notationValue = new NotationValue(stringArray[0], string, stringArray[1]);
                AtomicValue atomicValue = this.targetType.makeDerivedValue(notationValue, charSequence, true);
                if (atomicValue instanceof ValidationErrorValue) {
                    throw ((ValidationErrorValue)atomicValue).getException();
                }
                return atomicValue;
            }
            catch (QNameException qNameException) {
                StaticError staticError = new StaticError(qNameException);
                throw staticError;
            }
        }
        StaticError staticError = new StaticError("The argument of a QName constructor must be a string literal");
        throw staticError;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        return super.promote(promotionOffer);
    }

    public int computeCardinality() {
        return 16384;
    }

    public ItemType getItemType() {
        return this.targetType;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.operand);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        throw new UnsupportedOperationException("A QName constructor cannot be evaluated at run-time");
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "cast as QName");
        this.operand.display(n + 1, namePool, printStream);
    }
}

