/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CastAsQName;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.ValidationErrorValue;

public final class CastExpression
extends UnaryExpression {
    private AtomicType targetType;
    private AtomicType targetPrimitiveType;
    private boolean allowEmpty = false;
    private boolean derived = false;

    public CastExpression(Expression expression, AtomicType atomicType, boolean bl) {
        super(expression);
        this.allowEmpty = bl;
        this.targetType = atomicType;
        this.targetPrimitiveType = (AtomicType)atomicType.getPrimitiveItemType();
        this.derived = this.targetType.getFingerprint() != this.targetPrimitiveType.getFingerprint();
        this.adoptChildExpression(expression);
    }

    public AtomicValue doQNameCast(StaticContext staticContext) throws XPathException {
        if (!(this.operand instanceof StringValue)) {
            throw new StaticError("The argument of a QName or NOTATION constructor must be a string literal");
        }
        return QNameValue.castToQName((StringValue)this.operand, this.targetType, staticContext);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        if (this.operand instanceof AtomicValue) {
            return this.analyze(staticContext, Type.ITEM_TYPE);
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.analyze(staticContext, itemType);
        SequenceType sequenceType = SequenceType.makeSequenceType(Type.ANY_ATOMIC_TYPE, this.getCardinality());
        RoleLocator roleLocator = new RoleLocator(2, "cast as", 0, null);
        roleLocator.setSourceLocator(this);
        this.operand = TypeChecker.staticTypeCheck(this.operand, sequenceType, false, roleLocator, staticContext);
        if (Type.isSubType(this.operand.getItemType(), this.targetType)) {
            return this.operand;
        }
        if (this.targetType.isNamespaceSensitive()) {
            return new CastAsQName(this.operand, this.targetType).analyze(staticContext, itemType);
        }
        if (this.operand instanceof AtomicValue) {
            return (AtomicValue)this.evaluateItem(null);
        }
        return this;
    }

    public int computeCardinality() {
        return this.allowEmpty ? 24576 : 16384;
    }

    public ItemType getItemType() {
        return this.targetType;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string;
        ValidationException validationException;
        AtomicValue atomicValue = (AtomicValue)this.operand.evaluateItem(xPathContext);
        if (atomicValue == null) {
            if (this.allowEmpty) {
                return null;
            }
            DynamicError dynamicError = new DynamicError("Cast does not allow an empty sequence");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        AtomicValue atomicValue2 = atomicValue.convert(this.targetPrimitiveType, xPathContext, true);
        if (atomicValue2 instanceof ValidationErrorValue) {
            validationException = ((ValidationErrorValue)atomicValue2).getException();
            string = validationException.getErrorCodeLocalPart();
            this.dynamicError(validationException.getMessage(), string, xPathContext);
        }
        if (this.derived && (atomicValue2 = atomicValue2.convert(this.targetType, xPathContext, true)) instanceof ValidationErrorValue) {
            validationException = ((ValidationErrorValue)atomicValue2).getException();
            string = validationException.getErrorCodeLocalPart();
            this.dynamicError(validationException.getMessage(), string, xPathContext);
        }
        return atomicValue2;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.targetType == ((CastExpression)object).targetType && this.allowEmpty == ((CastExpression)object).allowEmpty;
    }

    protected String displayOperator(NamePool namePool) {
        return "cast as " + this.targetType.toString(namePool);
    }
}

