/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.GeneralComparison10;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.SimpleMappingExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.AnalyzeString;
import net.sf.saxon.instruct.ForEach;
import net.sf.saxon.instruct.ForEachGroup;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.While;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sort.SortExpression;
import net.sf.saxon.sort.TupleSorter;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class ExpressionTool {
    private ExpressionTool() {
    }

    public static Expression make(String string, StaticContext staticContext, int n, int n2, int n3) throws XPathException {
        ExpressionParser expressionParser = new ExpressionParser();
        if (n2 == -1) {
            n2 = 0;
        }
        Expression expression = expressionParser.parse(string, n, n2, n3, staticContext);
        expression = expression.simplify(staticContext);
        ExpressionTool.makeParentReferences(expression);
        return expression;
    }

    public static void copyLocationInfo(Expression expression, Expression expression2) {
        if (expression instanceof ComputedExpression && expression2 instanceof ComputedExpression) {
            ((ComputedExpression)expression2).setLocationId(((ComputedExpression)expression).getLocationId());
        }
    }

    public static void makeParentReferences(Expression expression) {
        if (expression == null) {
            return;
        }
        Iterator iterator = expression.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            if (!(expression2 instanceof ComputedExpression)) continue;
            ((ComputedExpression)expression2).setParentExpression((ComputedExpression)expression);
            ExpressionTool.makeParentReferences(expression2);
        }
    }

    public static SourceLocator getLocator(Expression expression) {
        if (expression instanceof ComputedExpression) {
            return (ComputedExpression)expression;
        }
        return null;
    }

    public static boolean isRepeatedSubexpression(Expression expression, Expression expression2) {
        if (expression instanceof PathExpression) {
            return expression2 == ((PathExpression)expression).getStepExpression();
        }
        if (expression instanceof FilterExpression) {
            return expression2 == ((FilterExpression)expression).getFilter();
        }
        if (expression instanceof ForExpression) {
            return expression2 == ((ForExpression)expression).getAction();
        }
        if (expression instanceof QuantifiedExpression) {
            return expression2 == ((QuantifiedExpression)expression).getAction();
        }
        if (expression instanceof SimpleMappingExpression) {
            return expression2 == ((SimpleMappingExpression)expression).getStepExpression();
        }
        if (expression instanceof SortExpression) {
            return ((SortExpression)expression).isSortKey(expression2);
        }
        if (expression instanceof TupleSorter) {
            return ((TupleSorter)expression).isSortKey(expression2);
        }
        if (expression instanceof AnalyzeString) {
            return expression2 == ((AnalyzeString)expression).getMatchingExpression() || expression2 == ((AnalyzeString)expression).getNonMatchingExpression();
        }
        if (expression instanceof ForEach) {
            return expression2 == ((ForEach)expression).getActionExpression();
        }
        if (expression instanceof ForEachGroup) {
            return expression2 == ((ForEachGroup)expression).getActionExpression();
        }
        if (expression instanceof While) {
            return expression2 == ((While)expression).getActionExpression();
        }
        if (expression instanceof GeneralComparison) {
            return expression2 == ((GeneralComparison)expression).getOperands()[1];
        }
        if (expression instanceof GeneralComparison10) {
            Expression[] expressionArray = ((GeneralComparison10)expression).getOperands();
            return expression2 == expressionArray[0] || expression2 == expressionArray[1];
        }
        return false;
    }

    public static Expression unsorted(Expression expression, boolean bl) throws XPathException {
        if (expression instanceof Value) {
            return expression;
        }
        PromotionOffer promotionOffer = new PromotionOffer();
        promotionOffer.action = 13;
        promotionOffer.mustEliminateDuplicates = bl;
        Expression expression2 = expression.promote(promotionOffer);
        if (expression2 != expression) {
            if (expression2 instanceof ComputedExpression) {
                ((ComputedExpression)expression2).setParentExpression(expression.getParentExpression());
            }
            return expression2;
        }
        return expression;
    }

    public static Expression unsortedIfHomogeneous(Expression expression, boolean bl) throws XPathException {
        if (expression instanceof Value) {
            return expression;
        }
        if (!(expression.getItemType() instanceof AnyItemType)) {
            PromotionOffer promotionOffer = new PromotionOffer();
            promotionOffer.action = 13;
            promotionOffer.mustEliminateDuplicates = bl;
            return expression.promote(promotionOffer);
        }
        return expression;
    }

    public static ValueRepresentation lazyEvaluate(Expression expression, XPathContext xPathContext, boolean bl) throws XPathException {
        if (expression instanceof Value) {
            return (Value)expression;
        }
        if (expression instanceof VariableReference) {
            return ((VariableReference)expression).evaluateVariable(xPathContext);
        }
        if (xPathContext == null) {
            return ExpressionTool.eagerEvaluate(expression, xPathContext);
        }
        if (!Cardinality.allowsMany(expression.getCardinality())) {
            return ExpressionTool.eagerEvaluate(expression, xPathContext);
        }
        if ((expression.getDependencies() & 0x6D) != 0) {
            return ExpressionTool.eagerEvaluate(expression, xPathContext);
        }
        return Closure.make(expression, xPathContext, bl);
    }

    public static Value eagerEvaluate(Expression expression, XPathContext xPathContext) throws XPathException {
        int n;
        if (expression instanceof Value && !(expression instanceof Closure)) {
            return (Value)expression;
        }
        if (expression instanceof VariableReference) {
            ValueRepresentation valueRepresentation = ((VariableReference)expression).evaluateVariable(xPathContext);
            if (valueRepresentation instanceof Closure) {
                return SequenceExtent.makeSequenceExtent(((Closure)valueRepresentation).iterate(null));
            }
            if (valueRepresentation instanceof Value) {
                return (Value)valueRepresentation;
            }
            if (valueRepresentation instanceof NodeInfo) {
                return new SingletonNode((NodeInfo)valueRepresentation);
            }
        }
        if (((n = expression.getImplementationMethod()) & 2) != 0) {
            SequenceIterator sequenceIterator = expression.iterate(xPathContext);
            if (sequenceIterator instanceof EmptyIterator) {
                return EmptySequence.getInstance();
            }
            if (sequenceIterator instanceof SingletonIterator) {
                Item item = ((SingletonIterator)sequenceIterator).getValue();
                return Value.asValue(item);
            }
            Value value = SequenceExtent.makeSequenceExtent(sequenceIterator);
            int n2 = value.getLength();
            if (n2 == 0) {
                return EmptySequence.getInstance();
            }
            if (n2 == 1) {
                return Value.asValue(value.itemAt(0));
            }
            return value;
        }
        if ((n & 1) != 0) {
            Item item = expression.evaluateItem(xPathContext);
            return Value.asValue(item);
        }
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin((InstructionInfoProvider)((Object)expression));
        SequenceOutputter sequenceOutputter = new SequenceOutputter();
        sequenceOutputter.setPipelineConfiguration(controller.makePipelineConfiguration());
        xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
        sequenceOutputter.open();
        expression.process(xPathContextMinor);
        sequenceOutputter.close();
        return Value.asValue(sequenceOutputter.getSequence());
    }

    public static boolean markTailFunctionCalls(Expression expression) {
        if (expression instanceof ComputedExpression) {
            return ((ComputedExpression)expression).markTailFunctionCalls();
        }
        return false;
    }

    public static String indent(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        return string;
    }

    public static int allocateSlots(Expression expression, int n, SlotManager slotManager) {
        if (expression instanceof Assignation) {
            ((Assignation)expression).setSlotNumber(n++);
            if (slotManager != null) {
                slotManager.allocateSlotNumber(((Assignation)expression).getVariableFingerprint());
            }
        }
        Iterator iterator = expression.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            n = ExpressionTool.allocateSlots(expression2, n, slotManager);
        }
        return n;
    }

    public static boolean effectiveBooleanValue(SequenceIterator sequenceIterator) throws XPathException {
        Item item = sequenceIterator.next();
        if (item == null) {
            return false;
        }
        if (item instanceof NodeInfo) {
            return true;
        }
        if (item instanceof BooleanValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with an atomic value");
            }
            return ((BooleanValue)item).getBooleanValue();
        }
        if (item instanceof StringValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with an atomic value");
            }
            return item.getStringValueCS().length() != 0;
        }
        if (item instanceof NumericValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with an atomic value");
            }
            return !item.equals(DoubleValue.ZERO) && item.equals(item);
        }
        ExpressionTool.ebvError("sequence starting with an atomic value other than a boolean, number, or string");
        return false;
    }

    public static void ebvError(String string) throws XPathException {
        DynamicError dynamicError = new DynamicError("Effective boolean value is not defined for a " + string);
        dynamicError.setIsTypeError(true);
        throw dynamicError;
    }

    public static boolean dependsOnVariable(Expression expression, Binding[] bindingArray) {
        if (expression instanceof VariableReference) {
            for (int i = 0; i < bindingArray.length; ++i) {
                if (((VariableReference)expression).getBinding() != bindingArray[i]) continue;
                return true;
            }
            return false;
        }
        Iterator iterator = expression.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            if (!ExpressionTool.dependsOnVariable(expression2, bindingArray)) continue;
            return true;
        }
        return false;
    }
}

