/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class ForExpression
extends Assignation {
    private transient RangeVariableDeclaration positionVariable = null;
    private PositionBinding positionBinding = null;

    public void setPositionVariable(RangeVariableDeclaration rangeVariableDeclaration) {
        this.positionVariable = rangeVariableDeclaration;
        if (rangeVariableDeclaration != null) {
            this.positionBinding = new PositionBinding();
        }
    }

    public void setAction(Expression expression) {
        super.setAction(expression);
        if (this.positionVariable != null) {
            this.positionVariable.fixupReferences(this.positionBinding);
        }
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        Object object;
        Object object2;
        Expression expression;
        if (this.declaration == null) {
            this.sequence = this.sequence.analyze(staticContext, itemType);
            this.action = this.action.analyze(staticContext, itemType);
            return this;
        }
        this.sequence = this.sequence.analyze(staticContext, itemType);
        if (this.sequence instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        SequenceType sequenceType = this.declaration.getRequiredType();
        SequenceType sequenceType2 = SequenceType.makeSequenceType(sequenceType.getPrimaryType(), 57344);
        RoleLocator roleLocator = new RoleLocator(3, new Integer(this.nameCode), 0, staticContext.getNamePool());
        roleLocator.setSourceLocator(this);
        this.sequence = TypeChecker.strictTypeCheck(this.sequence, sequenceType2, roleLocator, staticContext);
        ItemType itemType2 = this.sequence.getItemType();
        this.declaration.refineTypeInformation(itemType2, 16384, null, this.sequence.getSpecialProperties());
        this.action = this.action.analyze(staticContext, itemType);
        if (this.action instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        if (this.action instanceof IfExpression && ((IfExpression)this.action).getElseExpression() instanceof EmptySequence && ((IfExpression)(expression = (IfExpression)this.action)).getCondition() instanceof ValueComparison) {
            object2 = (ValueComparison)((IfExpression)expression).getCondition();
            object = ((BinaryExpression)object2).getOperands();
            for (int i = 0; i < 2; ++i) {
                Expression expression2;
                Expression expression3;
                if (this.positionVariable != null && this.positionVariable.getReferenceList().size() == 1 && object[i] instanceof VariableReference && ((VariableReference)object[i]).getBinding() == this.positionBinding && (object[1 - i].getDependencies() & 0x1E) == 0) {
                    expression3 = SystemFunction.makeSystemFunction("position", 1, staticContext.getNamePool());
                    ((FunctionCall)expression3).setArguments(SimpleExpression.NO_ARGUMENTS);
                    expression2 = i == 0 ? new ValueComparison(expression3, ((BinaryExpression)object2).getOperator(), object[1]) : new ValueComparison(object[0], ((BinaryExpression)object2).getOperator(), expression3);
                    this.sequence = new FilterExpression(this.sequence, expression2, staticContext);
                    this.action = ((IfExpression)expression).getThenExpression();
                    this.positionVariable = null;
                    this.positionBinding = null;
                    return this.simplify(staticContext).analyze(staticContext, itemType);
                }
                expression3 = object[i];
                expression2 = new ContextItemExpression();
                if (expression3 instanceof PathExpression) {
                    expression3 = ((PathExpression)expression3).getFirstStep();
                    expression2 = ((PathExpression)expression3).getRemainingSteps();
                }
                if (!(expression3 instanceof VariableReference) || ((VariableReference)expression3).getBinding() != this || (object[1 - i].getDependencies() & 0x1E) != 0) continue;
                ValueComparison valueComparison = i == 0 ? new ValueComparison(expression2, ((BinaryExpression)object2).getOperator(), object[1]) : new ValueComparison(object[0], ((BinaryExpression)object2).getOperator(), expression2);
                this.sequence = new FilterExpression(this.sequence, valueComparison, staticContext);
                this.action = ((IfExpression)expression).getThenExpression();
                this.positionVariable = null;
                this.positionBinding = null;
                return this.simplify(staticContext).analyze(staticContext, itemType);
            }
        }
        if (this.positionVariable == null && this.sequence instanceof PathExpression && this.action instanceof PathExpression) {
            int n = this.declaration.getReferenceCount(this);
            object2 = (PathExpression)this.action;
            object = ((PathExpression)object2).getStartExpression();
            if (n == 1 && object instanceof VariableReference && ((VariableReference)object).getBinding() == this) {
                PathExpression pathExpression = new PathExpression(this.sequence, ((PathExpression)object2).getStepExpression());
                return pathExpression.simplify(staticContext).analyze(staticContext, itemType);
            }
        }
        if (this.action instanceof VariableReference && ((VariableReference)this.action).getBinding() == this) {
            return this.sequence;
        }
        this.declaration = null;
        expression = this.promoteWhereClause(this.positionBinding);
        if (expression != null) {
            return expression;
        }
        if (this.positionVariable == null) {
            object2 = new PromotionOffer();
            ((PromotionOffer)object2).containingExpression = this;
            ((PromotionOffer)object2).action = 11;
            object = new Binding[]{this};
            ((PromotionOffer)object2).bindingList = object;
            Container container = this.getParentExpression();
            this.action = this.action.promote((PromotionOffer)object2);
            if (((PromotionOffer)object2).containingExpression instanceof LetExpression) {
                ((ComputedExpression)((PromotionOffer)object2).containingExpression).setParentExpression(container);
                ((PromotionOffer)object2).containingExpression = ((PromotionOffer)object2).containingExpression.analyze(staticContext, itemType);
            }
            return ((PromotionOffer)object2).containingExpression;
        }
        return this;
    }

    public boolean markTailFunctionCalls() {
        if (!Cardinality.allowsMany(this.sequence.getCardinality())) {
            return ExpressionTool.markTailFunctionCalls(this.action);
        }
        return false;
    }

    protected Binding[] extendBindingList(Binding[] bindingArray) {
        if (this.positionBinding == null) {
            return super.extendBindingList(bindingArray);
        }
        Binding[] bindingArray2 = new Binding[bindingArray.length + 2];
        System.arraycopy(bindingArray, 0, bindingArray2, 0, bindingArray.length);
        bindingArray2[bindingArray.length] = this;
        bindingArray2[bindingArray.length + 1] = this.positionBinding;
        return bindingArray2;
    }

    public int getImplementationMethod() {
        return 6;
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        this.action.checkPermittedContents(schemaType, staticContext, false);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        MappingAction mappingAction = new MappingAction(xPathContext, this.slotNumber, this.positionBinding, this.action);
        return new MappingIterator(sequenceIterator, mappingAction, null);
    }

    public void process(XPathContext xPathContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        int n = 1;
        while ((item = sequenceIterator.next()) != null) {
            xPathContext.setLocalVariable(this.slotNumber, item);
            if (this.positionBinding != null) {
                this.positionBinding.setPosition(n++);
            }
            this.action.process(xPathContext);
        }
    }

    public ItemType getItemType() {
        return this.action.getItemType();
    }

    public int computeCardinality() {
        int n = this.sequence.getCardinality();
        int n2 = this.action.getCardinality();
        return Cardinality.multiply(n, n2);
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "for $" + this.getVariableName(namePool) + (this.positionVariable == null ? "" : " at $?") + " in");
        this.sequence.display(n + 1, namePool, printStream);
        printStream.println(ExpressionTool.indent(n) + "return");
        this.action.display(n + 1, namePool, printStream);
    }

    protected int getConstructType() {
        return 2012;
    }

    private static class PositionBinding
    implements Binding {
        private int position;

        private PositionBinding() {
        }

        private void setPosition(int n) {
            this.position = n;
        }

        public boolean isGlobal() {
            return false;
        }

        public ValueRepresentation evaluateVariable(XPathContext xPathContext) throws XPathException {
            return new IntegerValue(this.position);
        }
    }

    private static class MappingAction
    implements MappingFunction {
        private XPathContext context;
        private int slotNumber;
        private Expression action;
        private PositionBinding positionBinding;
        private int position = 1;

        public MappingAction(XPathContext xPathContext, int n, PositionBinding positionBinding, Expression expression) {
            this.context = xPathContext;
            this.slotNumber = n;
            this.positionBinding = positionBinding;
            this.action = expression;
        }

        public Object map(Item item, XPathContext xPathContext) throws XPathException {
            this.context.setLocalVariable(this.slotNumber, item);
            if (this.positionBinding != null) {
                this.positionBinding.setPosition(this.position++);
            }
            return this.action.iterate(this.context);
        }
    }
}

