/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.util.Comparator;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.expr.MinimaxComparison;
import net.sf.saxon.expr.PositionRange;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SingletonComparison;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Position;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class GeneralComparison
extends BinaryExpression {
    protected int singletonOperator;
    protected AtomicComparer comparer;

    public GeneralComparison(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
        this.singletonOperator = GeneralComparison.getSingletonOperator(n);
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        int n;
        int n2;
        this.operand0 = this.operand0.analyze(staticContext, itemType);
        this.operand1 = this.operand1.analyze(staticContext, itemType);
        if (this.operand0 == EmptySequence.getInstance() || this.operand1 == EmptySequence.getInstance()) {
            return BooleanValue.FALSE;
        }
        this.operand0 = ExpressionTool.unsorted(this.operand0, false);
        this.operand1 = ExpressionTool.unsorted(this.operand1, false);
        SequenceType sequenceType = SequenceType.ATOMIC_SEQUENCE;
        RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, sequenceType, false, roleLocator, staticContext);
        RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, sequenceType, false, roleLocator2, staticContext);
        ItemType itemType2 = this.operand0.getItemType();
        ItemType itemType3 = this.operand1.getItemType();
        int n3 = this.operand0.getCardinality();
        int n4 = this.operand1.getCardinality();
        if (itemType2 != Type.ANY_ATOMIC_TYPE && itemType2 != Type.UNTYPED_ATOMIC_TYPE && itemType3 != Type.ANY_ATOMIC_TYPE && itemType3 != Type.UNTYPED_ATOMIC_TYPE && !Type.isComparable(n2 = itemType2.getPrimitiveType(), n = itemType3.getPrimitiveType())) {
            StaticError staticError = new StaticError("Cannot compare " + itemType2.toString(staticContext.getNamePool()) + " to " + itemType3.toString(staticContext.getNamePool()));
            staticError.setErrorCode("XPTY0004");
            staticError.setIsTypeError(true);
            throw staticError;
        }
        if (n3 == 16384 && n4 == 16384 && itemType2 != Type.ANY_ATOMIC_TYPE && itemType3 != Type.ANY_ATOMIC_TYPE) {
            Expression expression = this.operand0;
            Expression expression2 = this.operand1;
            if (itemType2 == Type.UNTYPED_ATOMIC_TYPE) {
                if (itemType3 == Type.UNTYPED_ATOMIC_TYPE) {
                    expression = new CastExpression(this.operand0, Type.STRING_TYPE, false);
                    this.adoptChildExpression(expression);
                    expression2 = new CastExpression(this.operand1, Type.STRING_TYPE, false);
                    this.adoptChildExpression(expression2);
                } else if (Type.isSubType(itemType3, Type.NUMBER_TYPE)) {
                    expression = new CastExpression(this.operand0, Type.DOUBLE_TYPE, false);
                    this.adoptChildExpression(expression);
                } else {
                    expression = new CastExpression(this.operand0, (AtomicType)itemType3, false);
                    this.adoptChildExpression(expression);
                }
            } else if (itemType3 == Type.UNTYPED_ATOMIC_TYPE) {
                if (Type.isSubType(itemType2, Type.NUMBER_TYPE)) {
                    expression2 = new CastExpression(this.operand1, Type.DOUBLE_TYPE, false);
                    this.adoptChildExpression(expression2);
                } else {
                    expression2 = new CastExpression(this.operand1, (AtomicType)itemType2, false);
                    this.adoptChildExpression(expression2);
                }
            }
            ValueComparison valueComparison = new ValueComparison(expression, this.singletonOperator, expression2);
            ExpressionTool.copyLocationInfo(this, valueComparison);
            valueComparison.setParentExpression(this.getParentExpression());
            return valueComparison.simplify(staticContext).analyze(staticContext, itemType);
        }
        Comparator comparator = staticContext.getCollation(staticContext.getDefaultCollationName());
        if (comparator == null) {
            comparator = CodepointCollator.getInstance();
        }
        this.comparer = new AtomicComparer(comparator, staticContext.getConfiguration());
        if (!Cardinality.allowsMany(n3) && !Cardinality.allowsMany(n4)) {
            SingletonComparison singletonComparison = new SingletonComparison(this.operand0, this.singletonOperator, this.operand1);
            ExpressionTool.copyLocationInfo(this, singletonComparison);
            singletonComparison.setParentExpression(this.getParentExpression());
            singletonComparison.setComparator(this.comparer, staticContext.getConfiguration());
            return singletonComparison.analyze(staticContext, itemType);
        }
        if (!Cardinality.allowsMany(n3)) {
            GeneralComparison generalComparison = this.getInverseComparison();
            ExpressionTool.copyLocationInfo(this, generalComparison);
            generalComparison.setParentExpression(this.getParentExpression());
            generalComparison.comparer = this.comparer;
            return generalComparison.analyze(staticContext, itemType);
        }
        if (this.operand0 instanceof RangeExpression && Type.isSubType(this.operand1.getItemType(), Type.INTEGER_TYPE) && !Cardinality.allowsMany(this.operand1.getCardinality())) {
            Expression expression = ((RangeExpression)this.operand0).operand0;
            Expression expression3 = ((RangeExpression)this.operand0).operand1;
            if (this.operand1 instanceof Position && expression instanceof IntegerValue && expression3 instanceof IntegerValue) {
                PositionRange positionRange = new PositionRange((int)((IntegerValue)expression).longValue(), (int)((IntegerValue)expression3).longValue());
                ExpressionTool.copyLocationInfo(this, positionRange);
                positionRange.setParentExpression(this.getParentExpression());
                return positionRange;
            }
            IntegerRangeTest integerRangeTest = new IntegerRangeTest(this.operand1, expression, expression3);
            ExpressionTool.copyLocationInfo(this, integerRangeTest);
            integerRangeTest.setParentExpression(this.getParentExpression());
            return integerRangeTest;
        }
        if (this.operator != 6 && this.operator != 22 && (Type.isSubType(itemType2, Type.NUMBER_TYPE) || Type.isSubType(itemType3, Type.NUMBER_TYPE))) {
            Serializable serializable;
            Object object;
            Expression expression = this.operand0;
            if (!Type.isSubType(itemType2, Type.NUMBER_TYPE)) {
                object = new RoleLocator(1, Token.tokens[this.operator], 0, null);
                ((RoleLocator)object).setSourceLocator(this);
                expression = TypeChecker.staticTypeCheck(expression, SequenceType.NUMERIC_SEQUENCE, false, (RoleLocator)object, staticContext);
            }
            object = this.operand1;
            if (!Type.isSubType(itemType3, Type.NUMBER_TYPE)) {
                serializable = new RoleLocator(1, Token.tokens[this.operator], 1, null);
                ((RoleLocator)serializable).setSourceLocator(this);
                object = TypeChecker.staticTypeCheck((Expression)object, SequenceType.NUMERIC_SEQUENCE, false, (RoleLocator)serializable, staticContext);
            }
            serializable = new MinimaxComparison(expression, this.operator, (Expression)object);
            ExpressionTool.copyLocationInfo(this, (Expression)((Object)serializable));
            ((ComputedExpression)serializable).setParentExpression(this.getParentExpression());
            return ((MinimaxComparison)serializable).analyze(staticContext, itemType);
        }
        if (this.operand0 instanceof Value && this.operand1 instanceof Value) {
            return (AtomicValue)this.evaluateItem(null);
        }
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue;
        SequenceIterator sequenceIterator = this.operand0.iterate(xPathContext);
        SequenceIterator sequenceIterator2 = this.operand1.iterate(xPathContext);
        Value value = SequenceExtent.makeSequenceExtent(sequenceIterator2);
        int n = value.getLength();
        if (n == 0) {
            return false;
        }
        if (n == 1) {
            AtomicValue atomicValue2;
            AtomicValue atomicValue3 = (AtomicValue)value.itemAt(0);
            while ((atomicValue2 = (AtomicValue)sequenceIterator.next()) != null) {
                try {
                    if (!GeneralComparison.compare(atomicValue2, this.singletonOperator, atomicValue3, this.comparer, xPathContext)) continue;
                    return true;
                }
                catch (DynamicError dynamicError) {
                    if (dynamicError.getXPathContext() == null) {
                        dynamicError.setXPathContext(xPathContext);
                    }
                    if (dynamicError.getLocator() == null) {
                        dynamicError.setLocator(this);
                    }
                    throw dynamicError;
                }
            }
            return false;
        }
        while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) {
            AtomicValue atomicValue4;
            SequenceIterator sequenceIterator3 = value.iterate(null);
            while ((atomicValue4 = (AtomicValue)sequenceIterator3.next()) != null) {
                try {
                    if (!GeneralComparison.compare(atomicValue, this.singletonOperator, atomicValue4, this.comparer, xPathContext)) continue;
                    return true;
                }
                catch (DynamicError dynamicError) {
                    if (dynamicError.getXPathContext() == null) {
                        dynamicError.setXPathContext(xPathContext);
                    }
                    if (dynamicError.getLocator() == null) {
                        dynamicError.setLocator(this);
                    }
                    throw dynamicError;
                }
            }
        }
        return false;
    }

    protected static boolean compare(AtomicValue atomicValue, int n, AtomicValue atomicValue2, AtomicComparer atomicComparer, XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue3 = atomicValue;
        AtomicValue atomicValue4 = atomicValue2;
        if (atomicValue instanceof UntypedAtomicValue) {
            if (atomicValue2 instanceof NumericValue) {
                atomicValue3 = atomicValue.convert(517, xPathContext);
            } else if (!(atomicValue2 instanceof UntypedAtomicValue)) {
                atomicValue3 = atomicValue.convert(atomicValue2.getItemType().getPrimitiveType(), xPathContext);
            }
        }
        if (atomicValue2 instanceof UntypedAtomicValue) {
            if (atomicValue instanceof NumericValue) {
                atomicValue4 = atomicValue2.convert(517, xPathContext);
            } else if (!(atomicValue instanceof UntypedAtomicValue)) {
                atomicValue4 = atomicValue2.convert(atomicValue.getItemType().getPrimitiveType(), xPathContext);
            }
        }
        return ValueComparison.compare(atomicValue3, n, atomicValue4, atomicComparer);
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }

    private static int getSingletonOperator(int n) {
        switch (n) {
            case 6: {
                return 44;
            }
            case 13: {
                return 48;
            }
            case 22: {
                return 45;
            }
            case 12: {
                return 47;
            }
            case 11: {
                return 46;
            }
            case 14: {
                return 49;
            }
        }
        return n;
    }

    protected GeneralComparison getInverseComparison() {
        return new GeneralComparison(this.operand1, Token.inverse(this.operator), this.operand0);
    }

    protected String displayOperator() {
        return "many-to-many " + super.displayOperator();
    }
}

