/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.BooleanValue;

public final class IsLastExpression
extends ComputedExpression {
    private boolean condition;

    public IsLastExpression(boolean bl) {
        this.condition = bl;
    }

    public boolean getCondition() {
        return this.condition;
    }

    public Expression simplify(StaticContext staticContext) {
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) {
        return this;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.condition == xPathContext.isAtLast());
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }

    public int computeCardinality() {
        return 16384;
    }

    public int getIntrinsicDependencies() {
        return 12;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + (this.condition ? "" : "not ") + "isLast()");
    }
}

