/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Value;

public class LetExpression
extends Assignation {
    boolean keepValue;

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.declaration == null) {
            return this;
        }
        this.sequence = this.sequence.analyze(staticContext, itemType);
        RoleLocator roleLocator = new RoleLocator(3, new Integer(this.nameCode), 0, staticContext.getNamePool());
        roleLocator.setSourceLocator(this);
        this.sequence = TypeChecker.strictTypeCheck(this.sequence, this.declaration.getRequiredType(), roleLocator, staticContext);
        ItemType itemType2 = this.sequence.getItemType();
        this.declaration.refineTypeInformation(itemType2, this.sequence.getCardinality(), this.sequence instanceof Value ? (Value)this.sequence : null, this.sequence.getSpecialProperties());
        this.action = this.action.analyze(staticContext, itemType);
        int n = this.declaration.getReferenceCount(this);
        if (n == 0) {
            return this.action;
        }
        this.keepValue = n != 1;
        this.declaration = null;
        Expression expression = this.promoteWhereClause(null);
        if (expression != null) {
            return expression;
        }
        return this;
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        this.action.checkPermittedContents(schemaType, staticContext, bl);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        ValueRepresentation valueRepresentation = this.eval(xPathContext);
        xPathContext.setLocalVariable(this.slotNumber, valueRepresentation);
        return this.action.iterate(xPathContext);
    }

    protected ValueRepresentation eval(XPathContext xPathContext) throws XPathException {
        return ExpressionTool.lazyEvaluate(this.sequence, xPathContext, this.keepValue);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        ValueRepresentation valueRepresentation = this.eval(xPathContext);
        xPathContext.setLocalVariable(this.slotNumber, valueRepresentation);
        return this.action.evaluateItem(xPathContext);
    }

    public void process(XPathContext xPathContext) throws XPathException {
        ValueRepresentation valueRepresentation = this.eval(xPathContext);
        xPathContext.setLocalVariable(this.slotNumber, valueRepresentation);
        this.action.process(xPathContext);
    }

    public ItemType getItemType() {
        return this.action.getItemType();
    }

    public int computeCardinality() {
        return this.action.getCardinality();
    }

    public int computeSpecialProperties() {
        return this.action.getSpecialProperties();
    }

    public boolean markTailFunctionCalls() {
        return ExpressionTool.markTailFunctionCalls(this.action);
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Binding[] bindingArray;
        Object object;
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.sequence = this.sequence.promote(promotionOffer);
        if (promotionOffer.action == 12 || promotionOffer.action == 13) {
            this.action = this.action.promote(promotionOffer);
        } else if (promotionOffer.action == 11) {
            object = promotionOffer.bindingList;
            bindingArray = new Binding[promotionOffer.bindingList.length + 1];
            System.arraycopy(promotionOffer.bindingList, 0, bindingArray, 0, promotionOffer.bindingList.length);
            bindingArray[promotionOffer.bindingList.length] = this;
            promotionOffer.bindingList = bindingArray;
            this.action = this.action.promote(promotionOffer);
            promotionOffer.bindingList = object;
        }
        if (this.sequence instanceof VariableReference) {
            object = new PromotionOffer();
            object.action = 12;
            bindingArray = new Binding[]{this};
            object.bindingList = bindingArray;
            object.containingExpression = this.sequence;
            this.action = this.action.promote((PromotionOffer)object);
            return this.action;
        }
        return this;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "let $" + this.getVariableName(namePool) + "[keep=" + (this.keepValue ? "yes" : "no") + "] :=");
        this.sequence.display(n + 1, namePool, printStream);
        printStream.println(ExpressionTool.indent(n) + "return");
        this.action.display(n + 1, namePool, printStream);
    }
}

