/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Value;

public class MinimaxComparison
extends BinaryExpression {
    public MinimaxComparison(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        NumericValue[] numericValueArray;
        Expression expression = super.analyze(staticContext, itemType);
        if (expression != this) {
            return expression;
        }
        if (this.operand0 instanceof Value) {
            numericValueArray = MinimaxComparison.getRange(this.operand0.iterate(null));
            if (numericValueArray == null) {
                return BooleanValue.FALSE;
            }
            this.operand0 = this.operator == 12 || this.operator == 14 ? numericValueArray[0] : numericValueArray[1];
        }
        if (this.operand1 instanceof Value) {
            numericValueArray = MinimaxComparison.getRange(this.operand1.iterate(null));
            if (numericValueArray == null) {
                return BooleanValue.FALSE;
            }
            this.operand1 = this.operator == 11 || this.operator == 13 ? numericValueArray[0] : numericValueArray[1];
        }
        return this;
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        NumericValue[] numericValueArray = MinimaxComparison.getRange(this.operand0.iterate(xPathContext));
        NumericValue[] numericValueArray2 = MinimaxComparison.getRange(this.operand1.iterate(xPathContext));
        if (numericValueArray == null) {
            return false;
        }
        if (numericValueArray2 == null) {
            return false;
        }
        switch (this.operator) {
            case 12: {
                return numericValueArray[0].compareTo(numericValueArray2[1]) < 0;
            }
            case 14: {
                return numericValueArray[0].compareTo(numericValueArray2[1]) <= 0;
            }
            case 11: {
                return numericValueArray[1].compareTo(numericValueArray2[0]) > 0;
            }
            case 13: {
                return numericValueArray[1].compareTo(numericValueArray2[0]) >= 0;
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + this.operator);
    }

    private static NumericValue[] getRange(SequenceIterator sequenceIterator) throws XPathException {
        AtomicValue atomicValue;
        NumericValue[] numericValueArray = null;
        while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) {
            NumericValue numericValue = (NumericValue)atomicValue.getPrimitiveValue();
            if (numericValue.isNaN()) continue;
            if (numericValueArray == null) {
                numericValueArray = new NumericValue[]{numericValue, numericValue};
                continue;
            }
            if (numericValue.compareTo(numericValueArray[0]) < 0) {
                numericValueArray[0] = numericValue;
            }
            if (numericValue.compareTo(numericValueArray[1]) <= 0) continue;
            numericValueArray[1] = numericValue;
        }
        return numericValueArray;
    }
}

