/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.BooleanValue;

public final class PositionRange
extends ComputedExpression {
    private int minPosition;
    private int maxPosition;

    public PositionRange(int n, int n2) {
        this.minPosition = n;
        this.maxPosition = n2;
    }

    public Expression simplify(StaticContext staticContext) throws StaticError {
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) {
        return this;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        int n = xPathContext.getContextPosition();
        return BooleanValue.get(n >= this.minPosition && n <= this.maxPosition);
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }

    public int computeCardinality() {
        return 16384;
    }

    public int getIntrinsicDependencies() {
        return 4;
    }

    public int getMinPosition() {
        return this.minPosition;
    }

    public int getMaxPosition() {
        return this.maxPosition;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "positionRange(" + this.minPosition + "," + this.maxPosition + ")");
    }
}

