/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.SingleNodeExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;

public class RootExpression
extends SingleNodeExpression {
    public Expression simplify(StaticContext staticContext) throws StaticError {
        return this;
    }

    public boolean equals(Object object) {
        return object instanceof RootExpression;
    }

    public final int computeCardinality() {
        return 16384;
    }

    public int hashCode() {
        return "RootExpression".hashCode();
    }

    public NodeInfo getNode(XPathContext xPathContext) throws XPathException {
        Item item = xPathContext.getContextItem();
        if (item == null) {
            this.dynamicError("Finding root of tree: the context item is undefined", "XPDY0002", xPathContext);
        }
        if (item instanceof NodeInfo) {
            DocumentInfo documentInfo = ((NodeInfo)item).getDocumentRoot();
            if (documentInfo == null) {
                this.dynamicError("The root of the tree containing the context item is not a document node", "XPDY0050", xPathContext);
            }
            return documentInfo;
        }
        this.typeError("Finding root of tree: the context item is not a node", "XPTY0020", xPathContext);
        return null;
    }

    public int getIntrinsicDependencies() {
        return 0x810010;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + '/');
    }
}

