/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public final class UntypedAtomicConverter
extends UnaryExpression
implements MappingFunction {
    private AtomicType requiredItemType;
    private RoleLocator role;

    public UntypedAtomicConverter(Expression expression, AtomicType atomicType, RoleLocator roleLocator) {
        super(expression);
        this.requiredItemType = atomicType;
        this.role = roleLocator;
        ExpressionTool.copyLocationInfo(expression, this);
    }

    public ItemType getItemType() {
        return Type.getCommonSuperType(this.requiredItemType, this.operand.getItemType());
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.analyze(staticContext, itemType);
        if (this.operand instanceof Value) {
            return SequenceExtent.makeSequenceExtent(this.iterate(null)).simplify(staticContext);
        }
        ItemType itemType2 = this.operand.getItemType();
        if (itemType2 instanceof NodeTest) {
            return this;
        }
        if (itemType2 == Type.ANY_ATOMIC_TYPE || itemType2 instanceof AnyItemType || itemType2 == Type.UNTYPED_ATOMIC_TYPE) {
            return this;
        }
        return this.operand;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        return new MappingIterator(sequenceIterator, this, xPathContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.operand.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        if (item instanceof UntypedAtomicValue) {
            try {
                AtomicValue atomicValue = ((UntypedAtomicValue)item).convert(this.requiredItemType, xPathContext, true);
                if (atomicValue instanceof ValidationErrorValue) {
                    throw ((ValidationErrorValue)atomicValue).getException();
                }
                return atomicValue;
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }
        return item;
    }

    public Object map(Item item, XPathContext xPathContext) throws XPathException {
        if (item instanceof UntypedAtomicValue) {
            AtomicValue atomicValue = ((UntypedAtomicValue)item).convert(this.requiredItemType, xPathContext, true);
            if (atomicValue instanceof ValidationErrorValue) {
                throw ((ValidationErrorValue)atomicValue).getException();
            }
            return atomicValue;
        }
        return item;
    }

    protected String displayOperator(NamePool namePool) {
        return "convert untyped atomic items to " + this.requiredItemType.toString(namePool);
    }
}

