/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.Value;

public class VariableReference
extends ComputedExpression
implements BindingReference {
    Binding binding = null;
    SequenceType staticType = null;
    Value constantValue = null;
    transient String displayName = null;

    public VariableReference(VariableDeclaration variableDeclaration) {
        variableDeclaration.registerReference(this);
        this.displayName = variableDeclaration.getVariableName();
    }

    public Expression simplify(StaticContext staticContext) {
        return this;
    }

    public void setStaticType(SequenceType sequenceType, Value value, int n) {
        this.staticType = sequenceType;
        this.constantValue = value;
        this.staticProperties = n & 0xFFFEFFFF | sequenceType.getCardinality() | this.getDependencies();
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.constantValue != null) {
            this.binding = null;
            return this.constantValue;
        }
        if (this.staticType == null) {
            throw new IllegalStateException("Variable $" + this.displayName + " has not been fixed up");
        }
        return this;
    }

    public void fixup(Binding binding) {
        this.binding = binding;
    }

    public ItemType getItemType() {
        if (this.staticType == null) {
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    public int computeCardinality() {
        if (this.staticType == null) {
            return 57344;
        }
        return this.staticType.getCardinality();
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public boolean equals(Object object) {
        return object instanceof VariableReference && this.binding == ((VariableReference)object).binding && this.binding != null;
    }

    public int hashCode() {
        return this.binding.hashCode();
    }

    public int getIntrinsicDependencies() {
        if (this.binding == null || !this.binding.isGlobal()) {
            return 128;
        }
        return 0;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression;
        if (promotionOffer.action == 12 && (expression = promotionOffer.accept(this)) != null) {
            this.binding = null;
            return expression;
        }
        return this;
    }

    public int getImplementationMethod() {
        return 7;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        ValueRepresentation valueRepresentation = this.evaluateVariable(xPathContext);
        return Value.getIterator(valueRepresentation);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        ValueRepresentation valueRepresentation = this.evaluateVariable(xPathContext);
        if (valueRepresentation instanceof Item) {
            return (Item)valueRepresentation;
        }
        return Value.asItem((Value)valueRepresentation, xPathContext);
    }

    public void process(XPathContext xPathContext) throws XPathException {
        ValueRepresentation valueRepresentation = this.evaluateVariable(xPathContext);
        if (valueRepresentation instanceof NodeInfo) {
            valueRepresentation = new SingletonNode((NodeInfo)valueRepresentation);
        }
        ((Value)valueRepresentation).process(xPathContext);
    }

    public ValueRepresentation evaluateVariable(XPathContext xPathContext) throws XPathException {
        if (this.binding == null) {
            throw new IllegalStateException("Variable $" + this.displayName + " has not been fixed up");
        }
        return this.binding.evaluateVariable(xPathContext);
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        if (this.displayName != null) {
            printStream.println(ExpressionTool.indent(n) + '$' + this.displayName);
        } else {
            printStream.println(ExpressionTool.indent(n) + "$(unbound variable)");
        }
    }
}

