/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.SecondsDurationValue;

public class Adjust
extends SystemFunction {
    int implicitTimezone;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.implicitTimezone = staticContext.getConfiguration().getImplicitTimezone();
        return super.simplify(staticContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        CalendarValue calendarValue = (CalendarValue)atomicValue.getPrimitiveValue();
        int n = this.argument.length;
        if (n == 1) {
            SecondsDurationValue secondsDurationValue = SecondsDurationValue.fromMilliseconds(this.implicitTimezone * 60000);
            return calendarValue.setTimezone(secondsDurationValue);
        }
        AtomicValue atomicValue2 = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return calendarValue.removeTimezone();
        }
        SecondsDurationValue secondsDurationValue = (SecondsDurationValue)atomicValue2.getPrimitiveValue();
        return calendarValue.setTimezone(secondsDurationValue);
    }
}

