/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;

public class Collection
extends SystemFunction
implements MappingFunction {
    private String expressionBaseURI = null;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(staticContext);
            this.expressionBaseURI = staticContext.getBaseURI();
        }
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        String string;
        DocumentInfo documentInfo;
        if (this.getNumberOfArguments() == 0) {
            this.dynamicError("There is no default collection", "FODC0002", xPathContext);
        }
        if ((documentInfo = (DocumentInfo)Document.makeDoc(string = this.argument[0].evaluateItem(xPathContext).getStringValue(), this.expressionBaseURI, xPathContext, this)) == null) {
            this.dynamicError("Failed to load collection catalogue " + string, xPathContext);
            return null;
        }
        AxisIterator axisIterator = documentInfo.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
        if (!(nodeInfo == null || "collection".equals(nodeInfo.getLocalPart()) && nodeInfo.getURI().equals(""))) {
            this.dynamicError("collection catalogue must contain top-level element <collection>", xPathContext);
        }
        AxisIterator axisIterator2 = nodeInfo.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        return new MappingIterator(axisIterator2, this, xPathContext);
    }

    public Object map(Item item, XPathContext xPathContext) throws XPathException {
        String string;
        NodeInfo nodeInfo = (NodeInfo)item;
        if (!"doc".equals(nodeInfo.getLocalPart()) || !nodeInfo.getURI().equals("")) {
            this.dynamicError("children of <collection> element must be <doc> elements", xPathContext);
        }
        if ((string = Navigator.getAttributeValue(nodeInfo, "", "href")) == null) {
            this.dynamicError("<doc> element in catalogue has no @href attribute", xPathContext);
        }
        NodeInfo nodeInfo2 = Document.makeDoc(string, nodeInfo.getBaseURI(), xPathContext, this);
        return nodeInfo2;
    }
}

