/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.NamespaceConstant;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;

public class ConstructorFunctionLibrary
implements FunctionLibrary {
    private Configuration config;

    public ConstructorFunctionLibrary(Configuration configuration) {
        this.config = configuration;
    }

    public boolean isAvailable(int n, String string, String string2, int n2) {
        if (n2 != 1 && n2 != -1) {
            return false;
        }
        if (string.equals("http://www.w3.org/2001/XMLSchema")) {
            AtomicType atomicType = (AtomicType)Type.getBuiltInItemType(string, string2);
            return atomicType != null;
        }
        if (NamespaceConstant.isXDTNamespace(string)) {
            AtomicType atomicType = (AtomicType)Type.getBuiltInItemType("http://www.w3.org/2005/04/xpath-datatypes", string2);
            return atomicType != null;
        }
        SchemaType schemaType = this.config.getSchemaType(n);
        return schemaType != null && schemaType instanceof AtomicType;
    }

    public Expression bind(int n, String string, String string2, Expression[] expressionArray) throws XPathException {
        SchemaType schemaType;
        String string3 = string;
        boolean bl = string.equals("http://www.w3.org/2001/XMLSchema");
        if (!bl && NamespaceConstant.isXDTNamespace(string)) {
            string3 = "http://www.w3.org/2005/04/xpath-datatypes";
            bl = true;
        }
        if (bl) {
            if (expressionArray.length != 1) {
                throw new StaticError("A constructor function must have exactly one argument");
            }
            AtomicType atomicType = (AtomicType)Type.getBuiltInItemType(string3, string2);
            if (atomicType == null) {
                StaticError staticError = new StaticError("Unknown constructor function: {" + string + '}' + string2);
                staticError.setErrorCode("XPST0017");
                throw staticError;
            }
            return new CastExpression(expressionArray[0], atomicType, true);
        }
        if (expressionArray.length == 1 && (schemaType = this.config.getSchemaType(n & 0xFFFFF)) != null && schemaType instanceof AtomicType) {
            return new CastExpression(expressionArray[0], (AtomicType)schemaType, true);
        }
        return null;
    }

    public FunctionLibrary copy() {
        return this;
    }
}

