/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class EscapeURI
extends SystemFunction {
    private static final String hex = "0123456789ABCDEF";

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.argument[0].evaluateItem(xPathContext);
        if (item == null) {
            return StringValue.EMPTY_STRING;
        }
        CharSequence charSequence = item.getStringValueCS();
        AtomicValue atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        boolean bl = ((BooleanValue)atomicValue.getPrimitiveValue()).getBooleanValue();
        return new StringValue(EscapeURI.escape(charSequence, bl));
    }

    public static CharSequence escape(CharSequence charSequence, boolean bl) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                fastStringBuffer.append(c);
                continue;
            }
            if (c <= ' ' || c >= '\u007f') {
                EscapeURI.escapeChar(c, i + 1 < charSequence.length() ? charSequence.charAt(i + 1) : (char)' ', fastStringBuffer);
                continue;
            }
            if (bl) {
                if ("-_.!~*'()%".indexOf(c) >= 0) {
                    fastStringBuffer.append(c);
                    continue;
                }
                EscapeURI.escapeChar(c, ' ', fastStringBuffer);
                continue;
            }
            if ("-_.!~*'()%;/?:@&=+$,#[]".indexOf(c) >= 0) {
                fastStringBuffer.append(c);
                continue;
            }
            EscapeURI.escapeChar(c, ' ', fastStringBuffer);
        }
        return fastStringBuffer;
    }

    private static void escapeChar(char c, char c2, FastStringBuffer fastStringBuffer) {
        byte[] byArray = new byte[4];
        int n = UnicodeCharacterSet.getUTF8Encoding(c, c2, byArray);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] >= 0 ? byArray[i] : 256 + byArray[i];
            fastStringBuffer.append('%');
            fastStringBuffer.append(hex.charAt(n2 / 16));
            fastStringBuffer.append(hex.charAt(n2 % 16));
        }
    }
}

