/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.NumberInstruction;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;

public class FormatDate
extends SystemFunction
implements XSLTFunction {
    private static Pattern componentPattern = Pattern.compile("([YMDdWwFHhmsfZzPCE])\\s*(.*)");
    private static Pattern formatPattern = Pattern.compile("([^ot,]*?)([ot]?)(,.*)?");
    private static Pattern widthPattern = Pattern.compile(",(\\*|[0-9]+)(\\-(\\*|[0-9]+))?");

    public void checkArguments(StaticContext staticContext) throws XPathException {
        int n = this.argument.length;
        if (n != 2 && n != 5) {
            throw new StaticError("Function " + this.getDisplayName(staticContext.getNamePool()) + " must have either two or five arguments", ExpressionTool.getLocator(this));
        }
        super.checkArguments(staticContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string;
        AtomicValue atomicValue;
        CalendarValue calendarValue = (CalendarValue)this.argument[0].evaluateItem(xPathContext);
        if (calendarValue == null) {
            return null;
        }
        String string2 = this.argument[1].evaluateItem(xPathContext).getStringValue();
        string = this.argument.length > 2 ? ((atomicValue = (AtomicValue)this.argument[2].evaluateItem(xPathContext)) == null ? Locale.getDefault().getLanguage() : ((string = atomicValue.getStringValue()).length() >= 2 ? string.substring(0, 2) : Locale.getDefault().getLanguage())) : Locale.getDefault().getLanguage();
        return new StringValue(FormatDate.formatDate(calendarValue, string2, string, xPathContext));
    }

    private static CharSequence formatDate(CalendarValue calendarValue, String string, String string2, XPathContext xPathContext) throws XPathException {
        Numberer numberer = NumberInstruction.makeNumberer(string2, xPathContext);
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        int n = 0;
        while (true) {
            Object object;
            if (n < string.length() && string.charAt(n) != '[') {
                fastStringBuffer.append(string.charAt(n));
                if (string.charAt(n) == ']' && (++n == string.length() || string.charAt(n) != ']')) {
                    DynamicError dynamicError = new DynamicError("Closing ']' in date picture must be written as ']]'");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                ++n;
                continue;
            }
            if (n == string.length()) break;
            if (string.charAt(++n) == '[') {
                fastStringBuffer.append('[');
                ++n;
                continue;
            }
            int n2 = string.indexOf("]", n);
            if (n2 == -1) {
                object = new DynamicError("Date format contains a '[' with no matching ']'");
                ((DynamicError)object).setXPathContext(xPathContext);
                throw object;
            }
            object = string.substring(n, n2);
            fastStringBuffer.append(FormatDate.formatComponent(calendarValue, ((String)object).trim(), numberer, xPathContext));
            n = n2 + 1;
        }
        return fastStringBuffer;
    }

    private static CharSequence formatComponent(CalendarValue calendarValue, String string, Numberer numberer, XPathContext xPathContext) throws XPathException {
        boolean bl = calendarValue instanceof TimeValue;
        boolean bl2 = calendarValue instanceof DateValue;
        DateTimeValue dateTimeValue = bl ? ((TimeValue)calendarValue).toDateTime() : (bl2 ? (DateTimeValue)calendarValue.convert(519, xPathContext) : (DateTimeValue)calendarValue);
        Calendar calendar = dateTimeValue.getCalendar();
        Matcher matcher = componentPattern.matcher(string);
        if (!matcher.matches()) {
            try {
                xPathContext.getController().getErrorListener().warning(new DynamicError("Unrecognized date/time component [" + string + "] (ignored)"));
            }
            catch (TransformerException transformerException) {
                throw DynamicError.makeDynamicError(transformerException);
            }
            return "";
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        if (string3 == null) {
            string3 = "";
        }
        boolean bl3 = false;
        if ("".equals(string3) || string3.startsWith(",")) {
            bl3 = true;
            switch (string2.charAt(0)) {
                case 'F': {
                    string3 = "Nn" + string3;
                    break;
                }
                case 'P': {
                    string3 = 'n' + string3;
                    break;
                }
                case 'C': 
                case 'E': {
                    string3 = 'N' + string3;
                    break;
                }
                case 'm': 
                case 's': {
                    string3 = "01" + string3;
                    break;
                }
                default: {
                    string3 = '1' + string3;
                }
            }
        }
        switch (string2.charAt(0)) {
            case 'Y': {
                if (bl) {
                    return "";
                }
                return FormatDate.formatNumber(string2, calendar.get(1), string3, bl3, numberer, xPathContext);
            }
            case 'M': {
                if (bl) {
                    return "";
                }
                return FormatDate.formatNumber(string2, calendar.get(2) + 1, string3, bl3, numberer, xPathContext);
            }
            case 'D': {
                if (bl) {
                    return "";
                }
                return FormatDate.formatNumber(string2, calendar.get(5), string3, bl3, numberer, xPathContext);
            }
            case 'd': {
                if (bl) {
                    return "";
                }
                return FormatDate.formatNumber(string2, calendar.get(6), string3, bl3, numberer, xPathContext);
            }
            case 'W': {
                if (bl) {
                    return "";
                }
                return FormatDate.formatNumber(string2, calendar.get(3), string3, bl3, numberer, xPathContext);
            }
            case 'w': {
                if (bl) {
                    return "";
                }
                return FormatDate.formatNumber(string2, calendar.get(4), string3, bl3, numberer, xPathContext);
            }
            case 'H': {
                if (bl2) {
                    return "";
                }
                return FormatDate.formatNumber(string2, calendar.get(11), string3, bl3, numberer, xPathContext);
            }
            case 'h': {
                if (bl2) {
                    return "";
                }
                int n = calendar.get(10);
                if (n == 0) {
                    n = 12;
                }
                return FormatDate.formatNumber(string2, n, string3, bl3, numberer, xPathContext);
            }
            case 'm': {
                if (bl2) {
                    return "";
                }
                return FormatDate.formatNumber(string2, calendar.get(12), string3, bl3, numberer, xPathContext);
            }
            case 's': {
                if (bl2) {
                    return "";
                }
                return FormatDate.formatNumber(string2, calendar.get(13), string3, bl3, numberer, xPathContext);
            }
            case 'f': {
                if (bl2) {
                    return "";
                }
                int n = calendar.get(14) % 1000;
                return (1000 + n + "").substring(1);
            }
            case 'Z': 
            case 'z': {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(8);
                DateTimeValue.appendTimezone(calendar, fastStringBuffer);
                return fastStringBuffer.toString();
            }
            case 'F': {
                if (bl) {
                    return "";
                }
                return FormatDate.formatNumber(string2, calendar.get(7), string3, bl3, numberer, xPathContext);
            }
            case 'P': {
                if (bl2) {
                    return "";
                }
                int n = calendar.get(11);
                int n2 = calendar.get(12);
                return FormatDate.formatNumber(string2, n * 60 + n2, string3, bl3, numberer, xPathContext);
            }
            case 'C': {
                return "Gregorian";
            }
            case 'E': {
                if (bl) {
                    return "";
                }
                return "*AD*";
            }
        }
        DynamicError dynamicError = new DynamicError("Unknown formatDate/time component specifier '" + string3.charAt(0) + '\'');
        dynamicError.setXPathContext(xPathContext);
        throw dynamicError;
    }

    private static CharSequence formatNumber(String string, int n, String string2, boolean bl, Numberer numberer, XPathContext xPathContext) throws XPathException {
        Object object;
        int n2;
        int n3;
        Matcher matcher = formatPattern.matcher(string2);
        if (!matcher.matches()) {
            matcher = formatPattern.matcher("1");
            matcher.matches();
        }
        String string3 = matcher.group(1);
        String string4 = matcher.group(2);
        String string5 = "t".equals(string4) ? "traditional" : null;
        String string6 = "o".equals(string4) ? numberer.getOrdinalSuffixForDateTime(string) : null;
        String string7 = matcher.group(3);
        if (string7 == null || "".equals(string7)) {
            n3 = 1;
            n2 = Integer.MAX_VALUE;
        } else {
            object = FormatDate.getWidths(string7, xPathContext);
            n3 = object[0];
            n2 = object[1];
            if (bl && string3.endsWith("1") && n3 != string3.length()) {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(n3 + 1);
                for (int i = 1; i < n3; ++i) {
                    fastStringBuffer.append('0');
                }
                fastStringBuffer.append('1');
                string3 = fastStringBuffer.toString();
            }
        }
        if ("P".equals(string) && !"N".equals(string3) && !"n".equals(string3) && !"Nn".equals(string3)) {
            string3 = "n";
        }
        if ("N".equals(string3) || "n".equals(string3) || "Nn".equals(string3)) {
            object = "";
            if ("M".equals(string)) {
                object = numberer.monthName(n, n3, n2);
            } else if ("F".equals(string)) {
                object = numberer.dayName(n, n3, n2);
            } else if ("P".equals(string)) {
                object = numberer.halfDayName(n, n3, n2);
            } else {
                string3 = "1";
            }
            if ("N".equals(string3)) {
                return ((String)object).toUpperCase();
            }
            if ("n".equals(string3)) {
                return ((String)object).toLowerCase();
            }
            return object;
        }
        object = numberer.format(n, string3, 0, ",", string5, string6);
        while (((String)object).length() < n3) {
            object = ("00000000" + (String)object).substring(((String)object).length() + 8 - n3);
        }
        if (((String)object).length() > n2 && string.charAt(0) == 'Y') {
            object = ((String)object).substring(((String)object).length() - n2);
        }
        return object;
    }

    private static int[] getWidths(String string, XPathContext xPathContext) throws XPathException {
        try {
            Object object;
            int n = -1;
            int n2 = -1;
            if (!"".equals(string)) {
                object = widthPattern.matcher(string);
                if (((Matcher)object).matches()) {
                    String string2 = ((Matcher)object).group(1);
                    n = string2 == null || "".equals(string2) || "*".equals(string2) ? 1 : Integer.parseInt(string2);
                    String string3 = ((Matcher)object).group(3);
                    n2 = string3 == null || "".equals(string3) || "*".equals(string3) ? Integer.MAX_VALUE : Integer.parseInt(string3);
                } else {
                    try {
                        xPathContext.getController().getErrorListener().warning(new DynamicError("Invalid width specifier '" + string + "' in date/time picture (ignored)"));
                    }
                    catch (TransformerException transformerException) {
                        throw DynamicError.makeDynamicError(transformerException);
                    }
                    n = 1;
                    n2 = 50;
                }
            }
            if (n > n2 && n2 != -1) {
                object = new DynamicError("Minimum width in date/time picture exceeds maximum width");
                ((DynamicError)object).setXPathContext(xPathContext);
                throw object;
            }
            object = new int[2];
            object[0] = n;
            object[1] = n2;
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            DynamicError dynamicError = new DynamicError("Invalid integer used as width in date/time picture");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
    }
}

