/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.StringReader;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import org.xml.sax.InputSource;

public class Parse
extends SystemFunction {
    String baseURI;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.baseURI == null) {
            super.checkArguments(staticContext);
            this.baseURI = staticContext.getBaseURI();
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        StringReader stringReader = new StringReader(atomicValue.getStringValue());
        InputSource inputSource = new InputSource(stringReader);
        inputSource.setSystemId(this.baseURI);
        SAXSource sAXSource = new SAXSource(inputSource);
        sAXSource.setSystemId(this.baseURI);
        Builder builder = controller.makeBuilder();
        Receiver receiver = controller.makeStripper(builder);
        if (controller.getExecutable().stripsInputTypeAnnotations()) {
            receiver = controller.getConfiguration().getAnnotationStripper(receiver);
        }
        try {
            new Sender(controller.makePipelineConfiguration()).send(sAXSource, receiver);
            return (DocumentInfo)builder.getCurrentRoot();
        }
        catch (XPathException xPathException) {
            throw new DynamicError(xPathException);
        }
    }
}

