/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.RegexTranslator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class Replace
extends SystemFunction {
    private Pattern regexp;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        Expression expression = this.simplifyArguments(staticContext);
        if (!(expression instanceof Value)) {
            this.regexp = Matches.tryToCompile(this.argument, 1, 3);
            if (this.regexp != null && this.regexp.matcher("").matches()) {
                DynamicError dynamicError = new DynamicError("The regular expression must not be one that matches a zero-length string");
                dynamicError.setErrorCode("FORX0003");
                throw dynamicError;
            }
        }
        return expression;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Object object;
        Object object2;
        Object object3;
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            atomicValue = StringValue.EMPTY_STRING;
        }
        AtomicValue atomicValue2 = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
        CharSequence charSequence = atomicValue2.getStringValueCS();
        this.checkReplacement(charSequence, xPathContext);
        Pattern pattern = this.regexp;
        if (pattern == null) {
            object3 = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
            if (this.argument.length == 3) {
                object2 = "";
            } else {
                object = (AtomicValue)this.argument[3].evaluateItem(xPathContext);
                object2 = ((AtomicValue)object).getStringValueCS();
            }
            try {
                object = RegexTranslator.translate(((AtomicValue)object3).getStringValueCS(), true);
                pattern = Pattern.compile((String)object, Matches.setFlags((CharSequence)object2));
            }
            catch (RegexTranslator.RegexSyntaxException regexSyntaxException) {
                DynamicError dynamicError = new DynamicError(regexSyntaxException);
                dynamicError.setErrorCode("FORX0002");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                DynamicError dynamicError = new DynamicError(patternSyntaxException);
                dynamicError.setErrorCode("FORX0002");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            if (pattern.matcher("").matches()) {
                this.dynamicError("The regular expression must not be one that matches a zero-length string", "FORX0003", xPathContext);
            }
        }
        object3 = atomicValue.getStringValue();
        object2 = pattern.matcher((CharSequence)object3);
        try {
            object = ((Matcher)object2).replaceAll(((Object)charSequence).toString());
            return new StringValue((CharSequence)object);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            int n = ((Matcher)object2).groupCount();
            if (n >= 9) {
                throw indexOutOfBoundsException;
            }
            String string = ((Object)charSequence).toString();
            String string2 = "\\$[" + (n + 1) + "-9]";
            String string3 = Pattern.compile(string2).matcher(string).replaceAll("");
            String string4 = ((Matcher)object2).replaceAll(string3);
            return new StringValue(string4);
        }
    }

    private void checkReplacement(CharSequence charSequence, XPathContext xPathContext) throws XPathException {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 == '$') {
                if (i + 1 < charSequence.length()) {
                    if ((c = charSequence.charAt(++i)) >= '0' && c <= '9') continue;
                    this.dynamicError("Invalid replacement string in replace(): $ sign must be followed by digit 0-9", "FORX0004", xPathContext);
                    continue;
                }
                this.dynamicError("Invalid replacement string in replace(): $ sign at end of string", "FORX0004", xPathContext);
                continue;
            }
            if (c2 != '\\') continue;
            if (i + 1 < charSequence.length()) {
                if ((c = charSequence.charAt(++i)) == '\\' || c == '$') continue;
                this.dynamicError("Invalid replacement string in replace(): \\ character must be followed by \\ or $", "FORX0004", xPathContext);
                continue;
            }
            this.dynamicError("Invalid replacement string in replace(): \\ character at end of string", "FORX0004", xPathContext);
        }
    }
}

