/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class Unicode
extends SystemFunction {
    public static final int TO_CODEPOINTS = 0;
    public static final int FROM_CODEPOINTS = 1;

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        switch (this.operation) {
            case 0: {
                throw new UnsupportedOperationException("Cannot call evaluateItem on a sequence");
            }
            case 1: {
                return new StringValue(Unicode.unicodeToString(this.argument[0].iterate(xPathContext), xPathContext));
            }
        }
        throw new UnsupportedOperationException("Unknown Unicode operation");
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        switch (this.operation) {
            case 0: {
                Item item = this.argument[0].evaluateItem(xPathContext);
                if (item == null) {
                    return EmptyIterator.getInstance();
                }
                return Unicode.stringToUnicode(item.getStringValueCS());
            }
            case 1: {
                return SingletonIterator.makeIterator(this.evaluateItem(xPathContext));
            }
        }
        throw new UnsupportedOperationException("Unknown Unicode operation");
    }

    private static SequenceIterator stringToUnicode(CharSequence charSequence) {
        return new StringValue(charSequence).iterateCharacters();
    }

    private static CharSequence unicodeToString(SequenceIterator sequenceIterator, XPathContext xPathContext) throws XPathException {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        NumericValue numericValue;
        while ((numericValue = (NumericValue)sequenceIterator.next()) != null) {
            long l = numericValue.longValue();
            if (l > Integer.MAX_VALUE || !XMLChar.isValid((int)l)) {
                DynamicError dynamicError = new DynamicError("Invalid XML character [decimal " + l + ']');
                dynamicError.setErrorCode("FOCH0001");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            if (l < 65536L) {
                fastStringBuffer.append((char)l);
                continue;
            }
            fastStringBuffer.append(XMLChar.highSurrogate((int)l));
            fastStringBuffer.append(XMLChar.lowSurrogate((int)l));
        }
        return fastStringBuffer.condense();
    }
}

