/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.RegexIterator;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.RegexTranslator;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;

public class AnalyzeString
extends Instruction {
    private Expression select;
    private Expression regex;
    private Expression flags;
    private Expression matching;
    private Expression nonMatching;
    private Pattern pattern;

    public AnalyzeString(Expression expression, Expression expression2, Expression expression3, Expression expression4, Expression expression5, Pattern pattern) {
        this.select = expression;
        this.regex = expression2;
        this.flags = expression3;
        this.matching = expression4;
        this.nonMatching = expression5;
        this.pattern = pattern;
    }

    public int getInstructionNameCode() {
        return 128;
    }

    public Expression getMatchingExpression() {
        return this.matching;
    }

    public Expression getNonMatchingExpression() {
        return this.nonMatching;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        this.regex = this.regex.simplify(staticContext);
        this.flags = this.flags.simplify(staticContext);
        if (this.matching != null) {
            this.matching = this.matching.simplify(staticContext);
        }
        if (this.nonMatching != null) {
            this.nonMatching = this.nonMatching.simplify(staticContext);
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.select = this.select.analyze(staticContext, itemType);
        this.regex = this.regex.analyze(staticContext, itemType);
        this.flags = this.flags.analyze(staticContext, itemType);
        if (this.matching != null) {
            this.matching = this.matching.analyze(staticContext, Type.STRING_TYPE);
        }
        if (this.nonMatching != null) {
            this.nonMatching = this.nonMatching.analyze(staticContext, Type.STRING_TYPE);
        }
        RoleLocator roleLocator = new RoleLocator(4, "analyze-string/select", 0, null);
        roleLocator.setSourceLocator(this);
        this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        roleLocator = new RoleLocator(4, "analyze-string/regex", 0, null);
        roleLocator.setSourceLocator(this);
        this.regex = TypeChecker.staticTypeCheck(this.regex, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        roleLocator = new RoleLocator(4, "analyze-string/flags", 0, null);
        roleLocator.setSourceLocator(this);
        this.flags = TypeChecker.staticTypeCheck(this.flags, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        return this;
    }

    public ItemType getItemType() {
        if (this.matching != null) {
            if (this.nonMatching != null) {
                return Type.getCommonSuperType(this.matching.getItemType(), this.nonMatching.getItemType());
            }
            return this.matching.getItemType();
        }
        if (this.nonMatching != null) {
            return this.nonMatching.getItemType();
        }
        return NoNodeTest.getInstance();
    }

    public int computeDependencies() {
        int n = 0;
        n |= this.select.getDependencies();
        n |= this.regex.getDependencies();
        n |= this.flags.getDependencies();
        if (this.matching != null) {
            n |= this.matching.getDependencies() & 0xFFFFFFA1;
        }
        if (this.nonMatching != null) {
            n |= this.nonMatching.getDependencies() & 0xFFFFFFA1;
        }
        return n;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.select = this.select.promote(promotionOffer);
        this.regex = this.regex.promote(promotionOffer);
        this.flags = this.flags.promote(promotionOffer);
        if (this.matching != null) {
            this.matching = this.matching.promote(promotionOffer);
        }
        if (this.nonMatching != null) {
            this.nonMatching = this.nonMatching.promote(promotionOffer);
        }
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(5);
        arrayList.add(this.select);
        arrayList.add(this.regex);
        arrayList.add(this.flags);
        if (this.matching != null) {
            arrayList.add(this.matching);
        }
        if (this.nonMatching != null) {
            arrayList.add(this.nonMatching);
        }
        return arrayList.iterator();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Item item;
        RegexIterator regexIterator = this.getRegexIterator(xPathContext);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCurrentIterator(regexIterator);
        xPathContextMajor.setCurrentRegexIterator(regexIterator);
        while ((item = regexIterator.next()) != null) {
            if (regexIterator.isMatching()) {
                if (this.matching == null) continue;
                this.matching.process(xPathContextMajor);
                continue;
            }
            if (this.nonMatching == null) continue;
            this.nonMatching.process(xPathContextMajor);
        }
        return null;
    }

    private RegexIterator getRegexIterator(XPathContext xPathContext) throws XPathException {
        String string = this.select.evaluateAsString(xPathContext);
        Pattern pattern = this.pattern;
        if (pattern == null) {
            int n = Matches.setFlags(this.flags.evaluateAsString(xPathContext));
            try {
                String string2 = RegexTranslator.translate(this.regex.evaluateAsString(xPathContext), true);
                pattern = Pattern.compile(string2, n);
            }
            catch (RegexTranslator.RegexSyntaxException regexSyntaxException) {
                throw new DynamicError(regexSyntaxException);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new DynamicError(patternSyntaxException);
            }
        }
        RegexIterator regexIterator = new RegexIterator(string, pattern);
        return regexIterator;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "analyze-string");
        printStream.println(ExpressionTool.indent(n) + "select = ");
        this.select.display(n + 1, namePool, printStream);
        printStream.println(ExpressionTool.indent(n) + "regex = ");
        this.regex.display(n + 1, namePool, printStream);
        printStream.println(ExpressionTool.indent(n) + "flags = ");
        this.flags.display(n + 1, namePool, printStream);
        if (this.matching != null) {
            printStream.println(ExpressionTool.indent(n) + "matching = ");
            this.matching.display(n + 1, namePool, printStream);
        }
        if (this.nonMatching != null) {
            printStream.println(ExpressionTool.indent(n) + "non-matching = ");
            this.nonMatching.display(n + 1, namePool, printStream);
        }
    }
}

